/*
    w32loader
    copyright (c) 1998-2010 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "winmm.h"
#include "advapi32.h"
#include "kernel32.h"
#include "tchar.h"
#include <time.h>


#ifdef W32LDR_HEADER
#define DRV_LOAD            0x0001
#define DRV_ENABLE          0x0002
#define DRV_OPEN            0x0003
#define DRV_CLOSE           0x0004
#define DRV_DISABLE         0x0005
#define DRV_FREE            0x0006
#define DRV_CONFIGURE       0x0007
#define DRV_QUERYCONFIGURE  0x0008
#define DRV_INSTALL         0x0009
#define DRV_REMOVE          0x000a
#define DRV_EXITSESSION     0x000b
#define DRV_EXITAPPLICATION 0x000c
#define DRV_POWER           0x000f
#define DRV_RESERVED        0x0800
#define DRV_USER            0x4000
#define DRV_CANCEL          0x0000
#define DRV_OK              0x0001
#define DRV_RESTART         0x0002
#define DRVCNF_CANCEL       0x0000
#define DRVCNF_OK           0x0001
#define DRVCNF_RESTART      0x0002
#define DRVEA_NORMALEXIT    0x0001
#define DRVEA_ABNORMALEXIT  0x0002
#define DRV_SUCCESS         0x0001
#define DRV_FAILURE         0x0000
typedef struct _HDRVR *HDRVR;

#define SND_SYNC      0x0000
#define SND_ASYNC     0x0001
#define SND_NODEFAULT 0x0002
#define SND_MEMORY    0x0004
#define SND_LOOP      0x0008
#define SND_NOSTOP    0x0010

#define TIMERR_BASE    96
#define TIMERR_NOERROR 0
#define TIMERR_NOCANDO (TIMERR_BASE+1)
#define TIMERR_STRUCT  (TIMERR_BASE+33)
typedef UINT MMRESULT;
#endif /* W32LDR_HEADER */


struct _HDRVR
{
  HMODULE hModule;
  LONG lOpenID;
  DWORD dwDriverId;
  LONG CALLBACK (*DriverProc)(DWORD, HDRVR, UINT, LONG, LONG);
};


/* CloseDriver ordinal = 3, argument = 12 */
LRESULT WINAPI CloseDriver (HDRVR hDrvr, LONG lParam1, LONG lParam2)
{
  if (hDrvr)
    {
      hDrvr->DriverProc (hDrvr->dwDriverId, hDrvr, DRV_CLOSE, 0, 0);
      hDrvr->DriverProc (hDrvr->lOpenID, hDrvr, DRV_CLOSE, 0, 0);
      hDrvr->DriverProc (0, hDrvr, DRV_DISABLE, 0, 0);
      hDrvr->DriverProc (0, hDrvr, DRV_FREE, 0, 0);
      FreeLibrary (hDrvr->hModule);
      g_free (hDrvr);
    }
  return TRUE;
}


/* DefDriverProc ordinal = 4, argument = 20 */
LONG WINAPI DefDriverProc (DWORD dwDriverId, HDRVR hDrvr, UINT msg, LONG lParam1, LONG lParam2)
{
  switch (msg)
    {
      case DRV_LOAD:
      case DRV_FREE:
      case DRV_ENABLE:
      case DRV_DISABLE:
        return 1;
      case DRV_OPEN:
      case DRV_CLOSE:
      case DRV_QUERYCONFIGURE:
      case DRV_CONFIGURE:
        return 0;
      case DRV_INSTALL:
      case DRV_REMOVE:
        return DRV_SUCCESS;
    }
  return 0;
}


/* DriverCallback ordinal = 5, argument = 28 temporary */
static DWORD WINAPI DriverCallback (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* DrvGetModuleHandle ordinal = 6, argument = 4 temporary */
static DWORD WINAPI DrvGetModuleHandle (DWORD dwArgv0)
{
  return 0;
}


/* GetDriverModuleHandle ordinal = 7, argument = 4 */
HMODULE WINAPI GetDriverModuleHandle (HDRVR hDrvr)
{
  return hDrvr ? hDrvr->hModule : NULL;
}


/* MigrateAllDrivers ordinal = 8, argument = 0 temporary */
static DWORD WINAPI MigrateAllDrivers (VOID)
{
  return 0;
}


/* MigrateMidiUser ordinal = 9, argument = 0 temporary */
static DWORD WINAPI MigrateMidiUser (VOID)
{
  return 0;
}


/* MigrateSoundEvents ordinal = 10, argument = 0 temporary */
static DWORD WINAPI MigrateSoundEvents (VOID)
{
  return 0;
}


/* NotifyCallbackData ordinal = 11, argument = 20 temporary */
static DWORD WINAPI NotifyCallbackData (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* OpenDriver ordinal = 12, argument = 12 */
HDRVR WINAPI OpenDriver (LPCWSTR lpDriverName, LPCWSTR lpSectionName, LONG lParam)
{
  HDRVR hDrvr;
  HKEY hKey;

  hDrvr = g_malloc (sizeof (struct _HDRVR));
  hDrvr->hModule = LoadLibraryW (lpDriverName);
  if (!hDrvr->hModule && RegOpenKeyEx (HKEY_LOCAL_MACHINE,
        _T("Software\\Microsoft\\Windows NT\\CurrentVersion\\Drivers32"), 0,
                                    KEY_QUERY_VALUE, &hKey) == ERROR_SUCCESS)
    {
      DWORD dwType, dwValue = MAX_PATH * sizeof (WCHAR);
      WCHAR szValue[MAX_PATH];

      if (RegQueryValueExW (hKey, lpDriverName, NULL, &dwType, (LPBYTE)szValue,
                                &dwValue) == ERROR_SUCCESS && dwType == REG_SZ)
        hDrvr->hModule = LoadLibraryW (szValue);
      RegCloseKey (hKey);
    }
  hDrvr->DriverProc = GetProcAddress (hDrvr->hModule, "DriverProc");
  if (hDrvr->DriverProc)
    {
      WCHAR wParam = '\0';

      hDrvr->DriverProc (0, hDrvr, DRV_LOAD, 0, 0);
      hDrvr->DriverProc (0, hDrvr, DRV_ENABLE, 0, 0);
      hDrvr->lOpenID = hDrvr->DriverProc (0, hDrvr, DRV_OPEN,
                                                GPOINTER_TO_INT (&wParam), 0);
      hDrvr->dwDriverId = hDrvr->DriverProc (0, hDrvr, DRV_OPEN, 0, lParam);
    }
  else
    {
      FreeLibrary (hDrvr->hModule);
      g_free (hDrvr);
      hDrvr = NULL;
    }
  return hDrvr;
}


/* PlaySound ordinal = 13, argument = 12 temporary */
/* DWORD WINAPI PlaySound (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2) */


/* PlaySoundA ordinal = 14, argument = 12 temporary */
static DWORD WINAPI PlaySoundA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* PlaySoundW ordinal = 15, argument = 12 temporary */
static DWORD WINAPI PlaySoundW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SendDriverMessage ordinal = 16, argument = 16 */
LRESULT WINAPI SendDriverMessage (HDRVR hdrvr, UINT msg, LONG lParam1, LONG lParam2)
{
  return hdrvr
    ? hdrvr->DriverProc (hdrvr->dwDriverId, hdrvr, msg, lParam1, lParam2) : 0;
}


/* WOW32DriverCallback ordinal = 17, argument = 28 temporary */
static DWORD WINAPI WOW32DriverCallback (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* WOW32ResolveMultiMediaHandle ordinal = 18, argument = 24 temporary */
static DWORD WINAPI WOW32ResolveMultiMediaHandle (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* WOWAppExit ordinal = 19, argument = 4 temporary */
static DWORD WINAPI WOWAppExit (DWORD dwArgv0)
{
  return 0;
}


/* WinmmLogoff ordinal = 20, argument = 0 temporary */
static DWORD WINAPI WinmmLogoff (VOID)
{
  return 0;
}


/* WinmmLogon ordinal = 21, argument = 4 temporary */
static DWORD WINAPI WinmmLogon (DWORD dwArgv0)
{
  return 0;
}


/* aux32Message ordinal = 22, argument = 20 temporary */
static DWORD WINAPI aux32Message (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* auxGetDevCapsA ordinal = 23, argument = 12 temporary */
static DWORD WINAPI auxGetDevCapsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* auxGetDevCapsW ordinal = 24, argument = 12 temporary */
static DWORD WINAPI auxGetDevCapsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* auxGetNumDevs ordinal = 25, argument = 0 temporary */
static DWORD WINAPI auxGetNumDevs (VOID)
{
  return 0;
}


/* auxGetVolume ordinal = 26, argument = 8 temporary */
static DWORD WINAPI auxGetVolume (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* auxOutMessage ordinal = 27, argument = 16 temporary */
static DWORD WINAPI auxOutMessage (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* auxSetVolume ordinal = 28, argument = 8 temporary */
static DWORD WINAPI auxSetVolume (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* joy32Message ordinal = 29, argument = 20 temporary */
static DWORD WINAPI joy32Message (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* joyConfigChanged ordinal = 30, argument = 4 temporary */
static DWORD WINAPI joyConfigChanged (DWORD dwArgv0)
{
  return 0;
}


/* joyGetDevCapsA ordinal = 31, argument = 12 temporary */
static DWORD WINAPI joyGetDevCapsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* joyGetDevCapsW ordinal = 32, argument = 12 temporary */
static DWORD WINAPI joyGetDevCapsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* joyGetNumDevs ordinal = 33, argument = 0 temporary */
static DWORD WINAPI joyGetNumDevs (VOID)
{
  return 0;
}


/* joyGetPos ordinal = 34, argument = 8 temporary */
static DWORD WINAPI joyGetPos (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* joyGetPosEx ordinal = 35, argument = 8 temporary */
static DWORD WINAPI joyGetPosEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* joyGetThreshold ordinal = 36, argument = 8 temporary */
static DWORD WINAPI joyGetThreshold (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* joyReleaseCapture ordinal = 37, argument = 4 temporary */
static DWORD WINAPI joyReleaseCapture (DWORD dwArgv0)
{
  return 0;
}


/* joySetCapture ordinal = 38, argument = 16 temporary */
static DWORD WINAPI joySetCapture (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* joySetThreshold ordinal = 39, argument = 8 temporary */
static DWORD WINAPI joySetThreshold (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* mci32Message ordinal = 40, argument = 20 temporary */
static DWORD WINAPI mci32Message (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* mciDriverNotify ordinal = 41, argument = 12 temporary */
static DWORD WINAPI mciDriverNotify (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mciDriverYield ordinal = 42, argument = 4 temporary */
static DWORD WINAPI mciDriverYield (DWORD dwArgv0)
{
  return 0;
}


/* mciExecute ordinal = 43, argument = 4 temporary */
static DWORD WINAPI mciExecute (DWORD dwArgv0)
{
  return 0;
}


/* mciFreeCommandResource ordinal = 44, argument = 4 temporary */
static DWORD WINAPI mciFreeCommandResource (DWORD dwArgv0)
{
  return 0;
}


/* mciGetCreatorTask ordinal = 45, argument = 4 temporary */
static DWORD WINAPI mciGetCreatorTask (DWORD dwArgv0)
{
  return 0;
}


/* mciGetDeviceIDA ordinal = 46, argument = 4 temporary */
static DWORD WINAPI mciGetDeviceIDA (DWORD dwArgv0)
{
  return 0;
}


/* mciGetDeviceIDFromElementIDA ordinal = 47, argument = 8 temporary */
static DWORD WINAPI mciGetDeviceIDFromElementIDA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* mciGetDeviceIDFromElementIDW ordinal = 48, argument = 8 temporary */
static DWORD WINAPI mciGetDeviceIDFromElementIDW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* mciGetDeviceIDW ordinal = 49, argument = 4 temporary */
static DWORD WINAPI mciGetDeviceIDW (DWORD dwArgv0)
{
  return 0;
}


/* mciGetDriverData ordinal = 50, argument = 4 temporary */
static DWORD WINAPI mciGetDriverData (DWORD dwArgv0)
{
  return 0;
}


/* mciGetErrorStringA ordinal = 51, argument = 12 temporary */
static DWORD WINAPI mciGetErrorStringA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mciGetErrorStringW ordinal = 52, argument = 12 temporary */
static DWORD WINAPI mciGetErrorStringW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mciGetYieldProc ordinal = 53, argument = 8 temporary */
static DWORD WINAPI mciGetYieldProc (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* mciLoadCommandResource ordinal = 54, argument = 12 temporary */
static DWORD WINAPI mciLoadCommandResource (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mciSendCommandA ordinal = 55, argument = 16 temporary */
static DWORD WINAPI mciSendCommandA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* mciSendCommandW ordinal = 56, argument = 16 temporary */
static DWORD WINAPI mciSendCommandW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* mciSendStringA ordinal = 57, argument = 16 temporary */
static DWORD WINAPI mciSendStringA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* mciSendStringW ordinal = 58, argument = 16 temporary */
static DWORD WINAPI mciSendStringW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* mciSetDriverData ordinal = 59, argument = 8 temporary */
static DWORD WINAPI mciSetDriverData (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* mciSetYieldProc ordinal = 60, argument = 12 temporary */
static DWORD WINAPI mciSetYieldProc (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mid32Message ordinal = 61, argument = 20 temporary */
static DWORD WINAPI mid32Message (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* midiConnect ordinal = 62, argument = 12 temporary */
static DWORD WINAPI midiConnect (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiDisconnect ordinal = 63, argument = 12 temporary */
static DWORD WINAPI midiDisconnect (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiInAddBuffer ordinal = 64, argument = 12 temporary */
static DWORD WINAPI midiInAddBuffer (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiInClose ordinal = 65, argument = 4 temporary */
static DWORD WINAPI midiInClose (DWORD dwArgv0)
{
  return 0;
}


/* midiInGetDevCapsA ordinal = 66, argument = 12 temporary */
static DWORD WINAPI midiInGetDevCapsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiInGetDevCapsW ordinal = 67, argument = 12 temporary */
static DWORD WINAPI midiInGetDevCapsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiInGetErrorTextA ordinal = 68, argument = 12 temporary */
static DWORD WINAPI midiInGetErrorTextA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiInGetErrorTextW ordinal = 69, argument = 12 temporary */
static DWORD WINAPI midiInGetErrorTextW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiInGetID ordinal = 70, argument = 8 temporary */
static DWORD WINAPI midiInGetID (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* midiInGetNumDevs ordinal = 71, argument = 0 temporary */
static DWORD WINAPI midiInGetNumDevs (VOID)
{
  return 0;
}


/* midiInMessage ordinal = 72, argument = 16 temporary */
static DWORD WINAPI midiInMessage (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* midiInOpen ordinal = 73, argument = 20 temporary */
static DWORD WINAPI midiInOpen (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* midiInPrepareHeader ordinal = 74, argument = 12 temporary */
static DWORD WINAPI midiInPrepareHeader (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiInReset ordinal = 75, argument = 4 temporary */
static DWORD WINAPI midiInReset (DWORD dwArgv0)
{
  return 0;
}


/* midiInStart ordinal = 76, argument = 4 temporary */
static DWORD WINAPI midiInStart (DWORD dwArgv0)
{
  return 0;
}


/* midiInStop ordinal = 77, argument = 4 temporary */
static DWORD WINAPI midiInStop (DWORD dwArgv0)
{
  return 0;
}


/* midiInUnprepareHeader ordinal = 78, argument = 12 temporary */
static DWORD WINAPI midiInUnprepareHeader (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiOutCacheDrumPatches ordinal = 79, argument = 16 temporary */
static DWORD WINAPI midiOutCacheDrumPatches (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* midiOutCachePatches ordinal = 80, argument = 16 temporary */
static DWORD WINAPI midiOutCachePatches (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* midiOutClose ordinal = 81, argument = 4 temporary */
static DWORD WINAPI midiOutClose (DWORD dwArgv0)
{
  return 0;
}


/* midiOutGetDevCapsA ordinal = 82, argument = 12 temporary */
static DWORD WINAPI midiOutGetDevCapsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiOutGetDevCapsW ordinal = 83, argument = 12 temporary */
static DWORD WINAPI midiOutGetDevCapsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiOutGetErrorTextA ordinal = 84, argument = 12 temporary */
static DWORD WINAPI midiOutGetErrorTextA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiOutGetErrorTextW ordinal = 85, argument = 12 temporary */
static DWORD WINAPI midiOutGetErrorTextW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiOutGetID ordinal = 86, argument = 8 temporary */
static DWORD WINAPI midiOutGetID (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* midiOutGetNumDevs ordinal = 87, argument = 0 temporary */
static DWORD WINAPI midiOutGetNumDevs (VOID)
{
  return 0;
}


/* midiOutGetVolume ordinal = 88, argument = 8 temporary */
static DWORD WINAPI midiOutGetVolume (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* midiOutLongMsg ordinal = 89, argument = 12 temporary */
static DWORD WINAPI midiOutLongMsg (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiOutMessage ordinal = 90, argument = 16 temporary */
static DWORD WINAPI midiOutMessage (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* midiOutOpen ordinal = 91, argument = 20 temporary */
static DWORD WINAPI midiOutOpen (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* midiOutPrepareHeader ordinal = 92, argument = 12 temporary */
static DWORD WINAPI midiOutPrepareHeader (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiOutReset ordinal = 93, argument = 4 temporary */
static DWORD WINAPI midiOutReset (DWORD dwArgv0)
{
  return 0;
}


/* midiOutSetVolume ordinal = 94, argument = 8 temporary */
static DWORD WINAPI midiOutSetVolume (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* midiOutShortMsg ordinal = 95, argument = 8 temporary */
static DWORD WINAPI midiOutShortMsg (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* midiOutUnprepareHeader ordinal = 96, argument = 12 temporary */
static DWORD WINAPI midiOutUnprepareHeader (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiStreamClose ordinal = 97, argument = 4 temporary */
static DWORD WINAPI midiStreamClose (DWORD dwArgv0)
{
  return 0;
}


/* midiStreamOpen ordinal = 98, argument = 24 temporary */
static DWORD WINAPI midiStreamOpen (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* midiStreamOut ordinal = 99, argument = 12 temporary */
static DWORD WINAPI midiStreamOut (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiStreamPause ordinal = 100, argument = 4 temporary */
static DWORD WINAPI midiStreamPause (DWORD dwArgv0)
{
  return 0;
}


/* midiStreamPosition ordinal = 101, argument = 12 temporary */
static DWORD WINAPI midiStreamPosition (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiStreamProperty ordinal = 102, argument = 12 temporary */
static DWORD WINAPI midiStreamProperty (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiStreamRestart ordinal = 103, argument = 4 temporary */
static DWORD WINAPI midiStreamRestart (DWORD dwArgv0)
{
  return 0;
}


/* midiStreamStop ordinal = 104, argument = 4 temporary */
static DWORD WINAPI midiStreamStop (DWORD dwArgv0)
{
  return 0;
}


/* mixerClose ordinal = 105, argument = 4 temporary */
static DWORD WINAPI mixerClose (DWORD dwArgv0)
{
  return 0;
}


/* mixerGetControlDetailsA ordinal = 106, argument = 12 temporary */
static DWORD WINAPI mixerGetControlDetailsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mixerGetControlDetailsW ordinal = 107, argument = 12 temporary */
static DWORD WINAPI mixerGetControlDetailsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mixerGetDevCapsA ordinal = 108, argument = 12 temporary */
static DWORD WINAPI mixerGetDevCapsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mixerGetDevCapsW ordinal = 109, argument = 12 temporary */
static DWORD WINAPI mixerGetDevCapsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mixerGetID ordinal = 110, argument = 12 temporary */
static DWORD WINAPI mixerGetID (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mixerGetLineControlsA ordinal = 111, argument = 12 temporary */
static DWORD WINAPI mixerGetLineControlsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mixerGetLineControlsW ordinal = 112, argument = 12 temporary */
static DWORD WINAPI mixerGetLineControlsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mixerGetLineInfoA ordinal = 113, argument = 12 temporary */
static DWORD WINAPI mixerGetLineInfoA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mixerGetLineInfoW ordinal = 114, argument = 12 temporary */
static DWORD WINAPI mixerGetLineInfoW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mixerGetNumDevs ordinal = 115, argument = 0 temporary */
static DWORD WINAPI mixerGetNumDevs (VOID)
{
  return 0;
}


/* mixerMessage ordinal = 116, argument = 16 temporary */
static DWORD WINAPI mixerMessage (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* mixerOpen ordinal = 117, argument = 20 temporary */
static DWORD WINAPI mixerOpen (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* mixerSetControlDetails ordinal = 118, argument = 12 temporary */
static DWORD WINAPI mixerSetControlDetails (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mmDrvInstall ordinal = 119, argument = 16 temporary */
static DWORD WINAPI mmDrvInstall (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* mmGetCurrentTask ordinal = 120, argument = 0 temporary */
static DWORD WINAPI mmGetCurrentTask (VOID)
{
  return 0;
}


/* mmTaskBlock ordinal = 121, argument = 4 temporary */
static DWORD WINAPI mmTaskBlock (DWORD dwArgv0)
{
  return 0;
}


/* mmTaskCreate ordinal = 122, argument = 12 temporary */
static DWORD WINAPI mmTaskCreate (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mmTaskSignal ordinal = 123, argument = 4 temporary */
static DWORD WINAPI mmTaskSignal (DWORD dwArgv0)
{
  return 0;
}


/* mmTaskYield ordinal = 124, argument = 0 temporary */
static DWORD WINAPI mmTaskYield (VOID)
{
  return 0;
}


/* mmioAdvance ordinal = 125, argument = 12 temporary */
static DWORD WINAPI mmioAdvance (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mmioAscend ordinal = 126, argument = 12 temporary */
static DWORD WINAPI mmioAscend (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mmioClose ordinal = 127, argument = 8 temporary */
static DWORD WINAPI mmioClose (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* mmioCreateChunk ordinal = 128, argument = 12 temporary */
static DWORD WINAPI mmioCreateChunk (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mmioDescend ordinal = 129, argument = 16 temporary */
static DWORD WINAPI mmioDescend (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* mmioFlush ordinal = 130, argument = 8 temporary */
static DWORD WINAPI mmioFlush (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* mmioGetInfo ordinal = 131, argument = 12 temporary */
static DWORD WINAPI mmioGetInfo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mmioInstallIOProcA ordinal = 132, argument = 12 temporary */
static DWORD WINAPI mmioInstallIOProcA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mmioInstallIOProcW ordinal = 133, argument = 12 temporary */
static DWORD WINAPI mmioInstallIOProcW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mmioOpenA ordinal = 134, argument = 12 temporary */
static DWORD WINAPI mmioOpenA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mmioOpenW ordinal = 135, argument = 12 temporary */
static DWORD WINAPI mmioOpenW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mmioRead ordinal = 136, argument = 12 temporary */
static DWORD WINAPI mmioRead (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mmioRenameA ordinal = 137, argument = 16 temporary */
static DWORD WINAPI mmioRenameA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* mmioRenameW ordinal = 138, argument = 16 temporary */
static DWORD WINAPI mmioRenameW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* mmioSeek ordinal = 139, argument = 12 temporary */
static DWORD WINAPI mmioSeek (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mmioSendMessage ordinal = 140, argument = 16 temporary */
static DWORD WINAPI mmioSendMessage (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* mmioSetBuffer ordinal = 141, argument = 16 temporary */
static DWORD WINAPI mmioSetBuffer (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* mmioSetInfo ordinal = 142, argument = 12 temporary */
static DWORD WINAPI mmioSetInfo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mmioStringToFOURCCA ordinal = 143, argument = 8 temporary */
static DWORD WINAPI mmioStringToFOURCCA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* mmioStringToFOURCCW ordinal = 144, argument = 8 temporary */
static DWORD WINAPI mmioStringToFOURCCW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* mmioWrite ordinal = 145, argument = 12 temporary */
static DWORD WINAPI mmioWrite (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mmsystemGetVersion ordinal = 146, argument = 0 temporary */
static DWORD WINAPI mmsystemGetVersion (VOID)
{
  return 0;
}


/* mod32Message ordinal = 147, argument = 20 temporary */
static DWORD WINAPI mod32Message (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* mxd32Message ordinal = 148, argument = 20 temporary */
static DWORD WINAPI mxd32Message (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* sndPlaySoundA ordinal = 149, argument = 8 */
BOOL WINAPI sndPlaySoundA (LPCSTR lpszSound, UINT fuSound)
{
  return FALSE;
}


/* sndPlaySoundW ordinal = 150, argument = 8 */
BOOL WINAPI sndPlaySoundW (LPCSTR lpszSound, UINT fuSound)
{
  return FALSE;
}


/* tid32Message ordinal = 151, argument = 20 temporary */
static DWORD WINAPI tid32Message (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* timeBeginPeriod ordinal = 152, argument = 4 */
MMRESULT WINAPI timeBeginPeriod (UINT uPeriod)
{
  return TIMERR_NOERROR;
}


/* timeEndPeriod ordinal = 153, argument = 4 */
MMRESULT WINAPI timeEndPeriod (UINT uPeriod)
{
  return TIMERR_NOERROR;
}


/* timeGetDevCaps ordinal = 154, argument = 8 temporary */
static DWORD WINAPI timeGetDevCaps (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* timeGetSystemTime ordinal = 155, argument = 8 temporary */
static DWORD WINAPI timeGetSystemTime (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* timeGetTime ordinal = 156, argument = 0 */
DWORD WINAPI timeGetTime (VOID)
{
  return time (NULL) * 1000;
}


/* timeKillEvent ordinal = 157, argument = 4 temporary */
static DWORD WINAPI timeKillEvent (DWORD dwArgv0)
{
  return 0;
}


/* timeSetEvent ordinal = 158, argument = 20 temporary */
static DWORD WINAPI timeSetEvent (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* waveInAddBuffer ordinal = 159, argument = 12 temporary */
static DWORD WINAPI waveInAddBuffer (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveInClose ordinal = 160, argument = 4 temporary */
static DWORD WINAPI waveInClose (DWORD dwArgv0)
{
  return 0;
}


/* waveInGetDevCapsA ordinal = 161, argument = 12 temporary */
static DWORD WINAPI waveInGetDevCapsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveInGetDevCapsW ordinal = 162, argument = 12 temporary */
static DWORD WINAPI waveInGetDevCapsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveInGetErrorTextA ordinal = 163, argument = 12 temporary */
static DWORD WINAPI waveInGetErrorTextA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveInGetErrorTextW ordinal = 164, argument = 12 temporary */
static DWORD WINAPI waveInGetErrorTextW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveInGetID ordinal = 165, argument = 8 temporary */
static DWORD WINAPI waveInGetID (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* waveInGetNumDevs ordinal = 166, argument = 0 temporary */
static DWORD WINAPI waveInGetNumDevs (VOID)
{
  return 0;
}


/* waveInGetPosition ordinal = 167, argument = 12 temporary */
static DWORD WINAPI waveInGetPosition (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveInMessage ordinal = 168, argument = 16 temporary */
static DWORD WINAPI waveInMessage (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* waveInOpen ordinal = 169, argument = 24 temporary */
static DWORD WINAPI waveInOpen (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* waveInPrepareHeader ordinal = 170, argument = 12 temporary */
static DWORD WINAPI waveInPrepareHeader (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveInReset ordinal = 171, argument = 4 temporary */
static DWORD WINAPI waveInReset (DWORD dwArgv0)
{
  return 0;
}


/* waveInStart ordinal = 172, argument = 4 temporary */
static DWORD WINAPI waveInStart (DWORD dwArgv0)
{
  return 0;
}


/* waveInStop ordinal = 173, argument = 4 temporary */
static DWORD WINAPI waveInStop (DWORD dwArgv0)
{
  return 0;
}


/* waveInUnprepareHeader ordinal = 174, argument = 12 temporary */
static DWORD WINAPI waveInUnprepareHeader (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveOutBreakLoop ordinal = 175, argument = 4 temporary */
static DWORD WINAPI waveOutBreakLoop (DWORD dwArgv0)
{
  return 0;
}


/* waveOutClose ordinal = 176, argument = 4 temporary */
static DWORD WINAPI waveOutClose (DWORD dwArgv0)
{
  return 0;
}


/* waveOutGetDevCapsA ordinal = 177, argument = 12 temporary */
static DWORD WINAPI waveOutGetDevCapsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveOutGetDevCapsW ordinal = 178, argument = 12 temporary */
static DWORD WINAPI waveOutGetDevCapsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveOutGetErrorTextA ordinal = 179, argument = 12 temporary */
static DWORD WINAPI waveOutGetErrorTextA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveOutGetErrorTextW ordinal = 180, argument = 12 temporary */
static DWORD WINAPI waveOutGetErrorTextW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveOutGetID ordinal = 181, argument = 8 temporary */
static DWORD WINAPI waveOutGetID (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* waveOutGetNumDevs ordinal = 182, argument = 0 temporary */
static DWORD WINAPI waveOutGetNumDevs (VOID)
{
  return 0;
}


/* waveOutGetPitch ordinal = 183, argument = 8 temporary */
static DWORD WINAPI waveOutGetPitch (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* waveOutGetPlaybackRate ordinal = 184, argument = 8 temporary */
static DWORD WINAPI waveOutGetPlaybackRate (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* waveOutGetPosition ordinal = 185, argument = 12 temporary */
static DWORD WINAPI waveOutGetPosition (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveOutGetVolume ordinal = 186, argument = 8 temporary */
static DWORD WINAPI waveOutGetVolume (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* waveOutMessage ordinal = 187, argument = 16 temporary */
static DWORD WINAPI waveOutMessage (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* waveOutOpen ordinal = 188, argument = 24 temporary */
static DWORD WINAPI waveOutOpen (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* waveOutPause ordinal = 189, argument = 4 temporary */
static DWORD WINAPI waveOutPause (DWORD dwArgv0)
{
  return 0;
}


/* waveOutPrepareHeader ordinal = 190, argument = 12 temporary */
static DWORD WINAPI waveOutPrepareHeader (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveOutReset ordinal = 191, argument = 4 temporary */
static DWORD WINAPI waveOutReset (DWORD dwArgv0)
{
  return 0;
}


/* waveOutRestart ordinal = 192, argument = 4 temporary */
static DWORD WINAPI waveOutRestart (DWORD dwArgv0)
{
  return 0;
}


/* waveOutSetPitch ordinal = 193, argument = 8 temporary */
static DWORD WINAPI waveOutSetPitch (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* waveOutSetPlaybackRate ordinal = 194, argument = 8 temporary */
static DWORD WINAPI waveOutSetPlaybackRate (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* waveOutSetVolume ordinal = 195, argument = 8 temporary */
static DWORD WINAPI waveOutSetVolume (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* waveOutUnprepareHeader ordinal = 196, argument = 12 temporary */
static DWORD WINAPI waveOutUnprepareHeader (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveOutWrite ordinal = 197, argument = 12 temporary */
static DWORD WINAPI waveOutWrite (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* wid32Message ordinal = 198, argument = 20 temporary */
static DWORD WINAPI wid32Message (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* winmmDbgOut ordinal = 199, argument = 0 temporary */
static DWORD WINAPI winmmDbgOut (VOID)
{
  return 0;
}


/* winmmSetDebugLevel ordinal = 200, argument = 4 temporary */
static DWORD WINAPI winmmSetDebugLevel (DWORD dwArgv0)
{
  return 0;
}


/* wod32Message ordinal = 201, argument = 20 temporary */
static DWORD WINAPI wod32Message (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


W32LdrExport w32ldr_winmm_exports[] = {
{ 0,   3, "CloseDriver",                  CloseDriver},
{ 0,   4, "DefDriverProc",                DefDriverProc},
{-1,   5, "DriverCallback",               DriverCallback},
{-1,   6, "DrvGetModuleHandle",           DrvGetModuleHandle},
{ 0,   7, "GetDriverModuleHandle",        GetDriverModuleHandle},
{-1,   8, "MigrateAllDrivers",            MigrateAllDrivers},
{-1,   9, "MigrateMidiUser",              MigrateMidiUser},
{-1,  10, "MigrateSoundEvents",           MigrateSoundEvents},
{-1,  11, "NotifyCallbackData",           NotifyCallbackData},
{ 0,  12, "OpenDriver",                   OpenDriver},
{-1,  13, "PlaySound",                    PlaySoundA},
{-1,  14, "PlaySoundA",                   PlaySoundA},
{-1,  15, "PlaySoundW",                   PlaySoundW},
{ 0,  16, "SendDriverMessage",            SendDriverMessage},
{-1,  17, "WOW32DriverCallback",          WOW32DriverCallback},
{-1,  18, "WOW32ResolveMultiMediaHandle", WOW32ResolveMultiMediaHandle},
{-1,  19, "WOWAppExit",                   WOWAppExit},
{-1,  20, "WinmmLogoff",                  WinmmLogoff},
{-1,  21, "WinmmLogon",                   WinmmLogon},
{-1,  22, "aux32Message",                 aux32Message},
{-1,  23, "auxGetDevCapsA",               auxGetDevCapsA},
{-1,  24, "auxGetDevCapsW",               auxGetDevCapsW},
{-1,  25, "auxGetNumDevs",                auxGetNumDevs},
{-1,  26, "auxGetVolume",                 auxGetVolume},
{-1,  27, "auxOutMessage",                auxOutMessage},
{-1,  28, "auxSetVolume",                 auxSetVolume},
{-1,  29, "joy32Message",                 joy32Message},
{-1,  30, "joyConfigChanged",             joyConfigChanged},
{-1,  31, "joyGetDevCapsA",               joyGetDevCapsA},
{-1,  32, "joyGetDevCapsW",               joyGetDevCapsW},
{-1,  33, "joyGetNumDevs",                joyGetNumDevs},
{-1,  34, "joyGetPos",                    joyGetPos},
{-1,  35, "joyGetPosEx",                  joyGetPosEx},
{-1,  36, "joyGetThreshold",              joyGetThreshold},
{-1,  37, "joyReleaseCapture",            joyReleaseCapture},
{-1,  38, "joySetCapture",                joySetCapture},
{-1,  39, "joySetThreshold",              joySetThreshold},
{-1,  40, "mci32Message",                 mci32Message},
{-1,  41, "mciDriverNotify",              mciDriverNotify},
{-1,  42, "mciDriverYield",               mciDriverYield},
{-1,  43, "mciExecute",                   mciExecute},
{-1,  44, "mciFreeCommandResource",       mciFreeCommandResource},
{-1,  45, "mciGetCreatorTask",            mciGetCreatorTask},
{-1,  46, "mciGetDeviceIDA",              mciGetDeviceIDA},
{-1,  47, "mciGetDeviceIDFromElementIDA", mciGetDeviceIDFromElementIDA},
{-1,  48, "mciGetDeviceIDFromElementIDW", mciGetDeviceIDFromElementIDW},
{-1,  49, "mciGetDeviceIDW",              mciGetDeviceIDW},
{-1,  50, "mciGetDriverData",             mciGetDriverData},
{-1,  51, "mciGetErrorStringA",           mciGetErrorStringA},
{-1,  52, "mciGetErrorStringW",           mciGetErrorStringW},
{-1,  53, "mciGetYieldProc",              mciGetYieldProc},
{-1,  54, "mciLoadCommandResource",       mciLoadCommandResource},
{-1,  55, "mciSendCommandA",              mciSendCommandA},
{-1,  56, "mciSendCommandW",              mciSendCommandW},
{-1,  57, "mciSendStringA",               mciSendStringA},
{-1,  58, "mciSendStringW",               mciSendStringW},
{-1,  59, "mciSetDriverData",             mciSetDriverData},
{-1,  60, "mciSetYieldProc",              mciSetYieldProc},
{-1,  61, "mid32Message",                 mid32Message},
{-1,  62, "midiConnect",                  midiConnect},
{-1,  63, "midiDisconnect",               midiDisconnect},
{-1,  64, "midiInAddBuffer",              midiInAddBuffer},
{-1,  65, "midiInClose",                  midiInClose},
{-1,  66, "midiInGetDevCapsA",            midiInGetDevCapsA},
{-1,  67, "midiInGetDevCapsW",            midiInGetDevCapsW},
{-1,  68, "midiInGetErrorTextA",          midiInGetErrorTextA},
{-1,  69, "midiInGetErrorTextW",          midiInGetErrorTextW},
{-1,  70, "midiInGetID",                  midiInGetID},
{-1,  71, "midiInGetNumDevs",             midiInGetNumDevs},
{-1,  72, "midiInMessage",                midiInMessage},
{-1,  73, "midiInOpen",                   midiInOpen},
{-1,  74, "midiInPrepareHeader",          midiInPrepareHeader},
{-1,  75, "midiInReset",                  midiInReset},
{-1,  76, "midiInStart",                  midiInStart},
{-1,  77, "midiInStop",                   midiInStop},
{-1,  78, "midiInUnprepareHeader",        midiInUnprepareHeader},
{-1,  79, "midiOutCacheDrumPatches",      midiOutCacheDrumPatches},
{-1,  80, "midiOutCachePatches",          midiOutCachePatches},
{-1,  81, "midiOutClose",                 midiOutClose},
{-1,  82, "midiOutGetDevCapsA",           midiOutGetDevCapsA},
{-1,  83, "midiOutGetDevCapsW",           midiOutGetDevCapsW},
{-1,  84, "midiOutGetErrorTextA",         midiOutGetErrorTextA},
{-1,  85, "midiOutGetErrorTextW",         midiOutGetErrorTextW},
{-1,  86, "midiOutGetID",                 midiOutGetID},
{-1,  87, "midiOutGetNumDevs",            midiOutGetNumDevs},
{-1,  88, "midiOutGetVolume",             midiOutGetVolume},
{-1,  89, "midiOutLongMsg",               midiOutLongMsg},
{-1,  90, "midiOutMessage",               midiOutMessage},
{-1,  91, "midiOutOpen",                  midiOutOpen},
{-1,  92, "midiOutPrepareHeader",         midiOutPrepareHeader},
{-1,  93, "midiOutReset",                 midiOutReset},
{-1,  94, "midiOutSetVolume",             midiOutSetVolume},
{-1,  95, "midiOutShortMsg",              midiOutShortMsg},
{-1,  96, "midiOutUnprepareHeader",       midiOutUnprepareHeader},
{-1,  97, "midiStreamClose",              midiStreamClose},
{-1,  98, "midiStreamOpen",               midiStreamOpen},
{-1,  99, "midiStreamOut",                midiStreamOut},
{-1, 100, "midiStreamPause",              midiStreamPause},
{-1, 101, "midiStreamPosition",           midiStreamPosition},
{-1, 102, "midiStreamProperty",           midiStreamProperty},
{-1, 103, "midiStreamRestart",            midiStreamRestart},
{-1, 104, "midiStreamStop",               midiStreamStop},
{-1, 105, "mixerClose",                   mixerClose},
{-1, 106, "mixerGetControlDetailsA",      mixerGetControlDetailsA},
{-1, 107, "mixerGetControlDetailsW",      mixerGetControlDetailsW},
{-1, 108, "mixerGetDevCapsA",             mixerGetDevCapsA},
{-1, 109, "mixerGetDevCapsW",             mixerGetDevCapsW},
{-1, 110, "mixerGetID",                   mixerGetID},
{-1, 111, "mixerGetLineControlsA",        mixerGetLineControlsA},
{-1, 112, "mixerGetLineControlsW",        mixerGetLineControlsW},
{-1, 113, "mixerGetLineInfoA",            mixerGetLineInfoA},
{-1, 114, "mixerGetLineInfoW",            mixerGetLineInfoW},
{-1, 115, "mixerGetNumDevs",              mixerGetNumDevs},
{-1, 116, "mixerMessage",                 mixerMessage},
{-1, 117, "mixerOpen",                    mixerOpen},
{-1, 118, "mixerSetControlDetails",       mixerSetControlDetails},
{-1, 119, "mmDrvInstall",                 mmDrvInstall},
{-1, 120, "mmGetCurrentTask",             mmGetCurrentTask},
{-1, 121, "mmTaskBlock",                  mmTaskBlock},
{-1, 122, "mmTaskCreate",                 mmTaskCreate},
{-1, 123, "mmTaskSignal",                 mmTaskSignal},
{-1, 124, "mmTaskYield",                  mmTaskYield},
{-1, 125, "mmioAdvance",                  mmioAdvance},
{-1, 126, "mmioAscend",                   mmioAscend},
{-1, 127, "mmioClose",                    mmioClose},
{-1, 128, "mmioCreateChunk",              mmioCreateChunk},
{-1, 129, "mmioDescend",                  mmioDescend},
{-1, 130, "mmioFlush",                    mmioFlush},
{-1, 131, "mmioGetInfo",                  mmioGetInfo},
{-1, 132, "mmioInstallIOProcA",           mmioInstallIOProcA},
{-1, 133, "mmioInstallIOProcW",           mmioInstallIOProcW},
{-1, 134, "mmioOpenA",                    mmioOpenA},
{-1, 135, "mmioOpenW",                    mmioOpenW},
{-1, 136, "mmioRead",                     mmioRead},
{-1, 137, "mmioRenameA",                  mmioRenameA},
{-1, 138, "mmioRenameW",                  mmioRenameW},
{-1, 139, "mmioSeek",                     mmioSeek},
{-1, 140, "mmioSendMessage",              mmioSendMessage},
{-1, 141, "mmioSetBuffer",                mmioSetBuffer},
{-1, 142, "mmioSetInfo",                  mmioSetInfo},
{-1, 143, "mmioStringToFOURCCA",          mmioStringToFOURCCA},
{-1, 144, "mmioStringToFOURCCW",          mmioStringToFOURCCW},
{-1, 145, "mmioWrite",                    mmioWrite},
{-1, 146, "mmsystemGetVersion",           mmsystemGetVersion},
{-1, 147, "mod32Message",                 mod32Message},
{-1, 148, "mxd32Message",                 mxd32Message},
{ 0, 149, "sndPlaySoundA",                sndPlaySoundA},
{ 0, 150, "sndPlaySoundW",                sndPlaySoundW},
{-1, 151, "tid32Message",                 tid32Message},
{ 0, 152, "timeBeginPeriod",              timeBeginPeriod},
{ 0, 153, "timeEndPeriod",                timeEndPeriod},
{-1, 154, "timeGetDevCaps",               timeGetDevCaps},
{-1, 155, "timeGetSystemTime",            timeGetSystemTime},
{ 0, 156, "timeGetTime",                  timeGetTime},
{-1, 157, "timeKillEvent",                timeKillEvent},
{-1, 158, "timeSetEvent",                 timeSetEvent},
{-1, 159, "waveInAddBuffer",              waveInAddBuffer},
{-1, 160, "waveInClose",                  waveInClose},
{-1, 161, "waveInGetDevCapsA",            waveInGetDevCapsA},
{-1, 162, "waveInGetDevCapsW",            waveInGetDevCapsW},
{-1, 163, "waveInGetErrorTextA",          waveInGetErrorTextA},
{-1, 164, "waveInGetErrorTextW",          waveInGetErrorTextW},
{-1, 165, "waveInGetID",                  waveInGetID},
{-1, 166, "waveInGetNumDevs",             waveInGetNumDevs},
{-1, 167, "waveInGetPosition",            waveInGetPosition},
{-1, 168, "waveInMessage",                waveInMessage},
{-1, 169, "waveInOpen",                   waveInOpen},
{-1, 170, "waveInPrepareHeader",          waveInPrepareHeader},
{-1, 171, "waveInReset",                  waveInReset},
{-1, 172, "waveInStart",                  waveInStart},
{-1, 173, "waveInStop",                   waveInStop},
{-1, 174, "waveInUnprepareHeader",        waveInUnprepareHeader},
{-1, 175, "waveOutBreakLoop",             waveOutBreakLoop},
{-1, 176, "waveOutClose",                 waveOutClose},
{-1, 177, "waveOutGetDevCapsA",           waveOutGetDevCapsA},
{-1, 178, "waveOutGetDevCapsW",           waveOutGetDevCapsW},
{-1, 179, "waveOutGetErrorTextA",         waveOutGetErrorTextA},
{-1, 180, "waveOutGetErrorTextW",         waveOutGetErrorTextW},
{-1, 181, "waveOutGetID",                 waveOutGetID},
{-1, 182, "waveOutGetNumDevs",            waveOutGetNumDevs},
{-1, 183, "waveOutGetPitch",              waveOutGetPitch},
{-1, 184, "waveOutGetPlaybackRate",       waveOutGetPlaybackRate},
{-1, 185, "waveOutGetPosition",           waveOutGetPosition},
{-1, 186, "waveOutGetVolume",             waveOutGetVolume},
{-1, 187, "waveOutMessage",               waveOutMessage},
{-1, 188, "waveOutOpen",                  waveOutOpen},
{-1, 189, "waveOutPause",                 waveOutPause},
{-1, 190, "waveOutPrepareHeader",         waveOutPrepareHeader},
{-1, 191, "waveOutReset",                 waveOutReset},
{-1, 192, "waveOutRestart",               waveOutRestart},
{-1, 193, "waveOutSetPitch",              waveOutSetPitch},
{-1, 194, "waveOutSetPlaybackRate",       waveOutSetPlaybackRate},
{-1, 195, "waveOutSetVolume",             waveOutSetVolume},
{-1, 196, "waveOutUnprepareHeader",       waveOutUnprepareHeader},
{-1, 197, "waveOutWrite",                 waveOutWrite},
{-1, 198, "wid32Message",                 wid32Message},
{-1, 199, "winmmDbgOut",                  winmmDbgOut},
{-1, 200, "winmmSetDebugLevel",           winmmSetDebugLevel},
{-1, 201, "wod32Message",                 wod32Message},
{-1,   0, NULL,                           NULL}};
