/*
    w32loader
    copyright (c) 1998-2009 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "w32private.h"
#include "commctrl.h"
#include "kernel32.h"


typedef struct _W32LdrToolData
{
  W32LdrWindowData wd;
  GList *glist_pixbuf;
  GList *glist_string;
} W32LdrToolData;


#if GTK_CHECK_VERSION(2,4,0)
static void
w32item_clicked (GtkToolButton *item,
                 gpointer       user_data)
{
  GtkWidget *widget;
  LPTBBUTTON lptbb;

  lptbb = g_object_get_data (G_OBJECT (item), "user_data");
  widget = gtk_widget_get_parent (GTK_WIDGET (item));
  if (widget)
    {
      W32LdrWindowData *wd;

      wd = g_object_get_data (G_OBJECT (widget), "user_data");
      if (wd && wd->hWndParent)
        SendMessage (wd->hWndParent, WM_COMMAND,
                                        MAKEWPARAM (lptbb->idCommand, wd->wID),
                                        GPOINTER_TO_INT (widget));
    }
}


/* ja:破棄 */
static void
w32item_destroy (GtkWidget *widget,
                 gpointer   user_data)
{
  g_free (g_object_get_data (G_OBJECT (widget), "user_data"));
}
#endif /* GTK_CHECK_VERSION(2,4,0) */


static LRESULT WINAPI
w32tool_DefWindowProc (HWND   hWnd,
                       UINT   Msg,
                       WPARAM wParam,
                       LPARAM lParam)
{
  W32LdrWindowData *wd;
  W32LdrToolData *td;

  td = g_object_get_data (G_OBJECT (hWnd), "user_data");
  if (!td)
    return 0;
  wd = &td->wd;
  switch (Msg)
    {
      case TB_ENABLEBUTTON:
#if GTK_CHECK_VERSION(2,4,0)
        {
          gint i;
          GtkToolItem *item;

          for (i = 0;
                (item = gtk_toolbar_get_nth_item (GTK_TOOLBAR (hWnd), i)); i++)
            {
              LPTBBUTTON lptbb;

              lptbb = g_object_get_data (G_OBJECT (item), "user_data");
              if (lptbb->idCommand == wParam)
                {
                  gtk_widget_set_sensitive (GTK_WIDGET (item), lParam);
                  return TRUE;
                }
            }
        }
#endif /* GTK_CHECK_VERSION(2,4,0) */
        return FALSE;
      case TB_CHECKBUTTON:
#if GTK_CHECK_VERSION(2,4,0)
        {
          gint i;
          GtkToolItem *item;

          for (i = 0;
                (item = gtk_toolbar_get_nth_item (GTK_TOOLBAR (hWnd), i)); i++)
            {
              LPTBBUTTON lptbb;

              lptbb = g_object_get_data (G_OBJECT (item), "user_data");
              if (GTK_IS_TOGGLE_TOOL_BUTTON (item)
                                                && lptbb->idCommand == wParam)
                {
                  gtk_toggle_tool_button_set_active
                                    (GTK_TOGGLE_TOOL_BUTTON (item), lParam);
                  return TRUE;
                }
            }
        }
#endif /* GTK_CHECK_VERSION(2,4,0) */
        return FALSE;
      case TB_PRESSBUTTON:
        return FALSE;
      case TB_HIDEBUTTON:
#if GTK_CHECK_VERSION(2,4,0)
        {
          gint i;
          GtkToolItem *item;

          for (i = 0;
                (item = gtk_toolbar_get_nth_item (GTK_TOOLBAR (hWnd), i)); i++)
            {
              LPTBBUTTON lptbb;

              lptbb = g_object_get_data (G_OBJECT (item), "user_data");
              if (lptbb->idCommand == wParam)
                {
                  if (lParam)
                    gtk_widget_hide (GTK_WIDGET (item));
                  else
                    gtk_widget_show (GTK_WIDGET (item));
                  return TRUE;
                }
            }
        }
#endif /* GTK_CHECK_VERSION(2,4,0) */
        return FALSE;
      case TB_INDETERMINATE:
        return FALSE;
      case TB_ISBUTTONENABLED:
#if GTK_CHECK_VERSION(2,4,0)
        {
          gint i;
          GtkToolItem *item;

          for (i = 0;
                (item = gtk_toolbar_get_nth_item (GTK_TOOLBAR (hWnd), i)); i++)
            {
              LPTBBUTTON lptbb;

              lptbb = g_object_get_data (G_OBJECT (item), "user_data");
              if (lptbb->idCommand == wParam)
                return GTK_WIDGET_SENSITIVE (item);
            }
        }
#endif /* GTK_CHECK_VERSION(2,4,0) */
        return FALSE;
      case TB_ISBUTTONCHECKED:
#if GTK_CHECK_VERSION(2,4,0)
        {
          gint i;
          GtkToolItem *item;

          for (i = 0;
                (item = gtk_toolbar_get_nth_item (GTK_TOOLBAR (hWnd), i)); i++)
            {
              LPTBBUTTON lptbb;

              lptbb = g_object_get_data (G_OBJECT (item), "user_data");
              if (GTK_IS_TOGGLE_TOOL_BUTTON (item)
                                                && lptbb->idCommand == wParam)
                return gtk_toggle_tool_button_get_active
                                            (GTK_TOGGLE_TOOL_BUTTON (item));
            }
        }
#endif /* GTK_CHECK_VERSION(2,4,0) */
        return FALSE;
      case TB_ISBUTTONPRESSED:
        return FALSE;
      case TB_ISBUTTONHIDDEN:
#if GTK_CHECK_VERSION(2,4,0)
        {
          gint i;
          GtkToolItem *item;

          for (i = 0;
                (item = gtk_toolbar_get_nth_item (GTK_TOOLBAR (hWnd), i)); i++)
            {
              LPTBBUTTON lptbb;

              lptbb = g_object_get_data (G_OBJECT (item), "user_data");
              if (lptbb->idCommand == wParam)
                return GTK_WIDGET_VISIBLE (item);
            }
        }
#endif /* GTK_CHECK_VERSION(2,4,0) */
        return FALSE;
      case TB_ISBUTTONINDETERMINATE:
        return FALSE;
      case TB_SETSTATE:
#if GTK_CHECK_VERSION(2,4,0)
        {
          gint i;
          GtkToolItem *item;

          for (i = 0;
                (item = gtk_toolbar_get_nth_item (GTK_TOOLBAR (hWnd), i)); i++)
            {
              LPTBBUTTON lptbb;

              lptbb = g_object_get_data (G_OBJECT (item), "user_data");
              if (lptbb->idCommand == wParam)
                {
                  if (GTK_IS_TOGGLE_TOOL_BUTTON (item))
                    gtk_toggle_tool_button_set_active
                                                (GTK_TOGGLE_TOOL_BUTTON (item),
                                                    lParam & TBSTATE_CHECKED);
                  gtk_widget_set_sensitive (GTK_WIDGET (item),
                                                    lParam & TBSTATE_ENABLED);
                  if (lParam & TBSTATE_HIDDEN)
                    gtk_widget_hide (GTK_WIDGET (item));
                  else
                    gtk_widget_show (GTK_WIDGET (item));
                  return TRUE;
                }
            }
        }
#endif /* GTK_CHECK_VERSION(2,4,0) */
        return FALSE;
      case TB_GETSTATE:
#if GTK_CHECK_VERSION(2,4,0)
        {
          gint i;
          GtkToolItem *item;

          for (i = 0;
                (item = gtk_toolbar_get_nth_item (GTK_TOOLBAR (hWnd), i)); i++)
            {
              LPTBBUTTON lptbb;

              lptbb = g_object_get_data (G_OBJECT (item), "user_data");
              if (lptbb->idCommand == wParam)
                {
                  LRESULT lResult;

                  lResult = GTK_IS_TOGGLE_TOOL_BUTTON (item)
                                        && gtk_toggle_tool_button_get_active
                        (GTK_TOGGLE_TOOL_BUTTON (item)) ? TBSTATE_CHECKED : 0;
                  if (GTK_WIDGET_SENSITIVE (item))
                    lResult |= TBSTATE_ENABLED;
                  if (GTK_WIDGET_VISIBLE (item))
                    lResult |= TBSTATE_HIDDEN;
                  return lResult;
                }
            }
        }
#endif /* GTK_CHECK_VERSION(2,4,0) */
        return -1;
      case TB_ADDBITMAP:
        if (wParam > 0 && lParam)
          {
            LPTBADDBITMAP lptbab;
            LRESULT lResult = -1;

            lptbab = GINT_TO_POINTER (lParam);
            if (lptbab->hInst == HINST_COMMCTRL)
              {
                gint i;
                GtkIconSize icon_size;
                GtkWidget *image;
                const gchar **stock_id;
                const gchar *idb_std[] = {GTK_STOCK_CUT,
                                          GTK_STOCK_COPY,
                                          GTK_STOCK_PASTE,
                                          GTK_STOCK_UNDO,
                                          GTK_STOCK_REDO,
                                          GTK_STOCK_DELETE,
                                          GTK_STOCK_NEW,
                                          GTK_STOCK_OPEN,
                                          GTK_STOCK_SAVE,
                                          GTK_STOCK_PRINT_PREVIEW,
                                          GTK_STOCK_PROPERTIES,
                                          GTK_STOCK_HELP,
                                          GTK_STOCK_FIND,
                                          GTK_STOCK_FIND_AND_REPLACE,
                                          GTK_STOCK_PRINT,
                                          NULL};
                const gchar *idb_view[] = {GTK_STOCK_MISSING_IMAGE
                                           GTK_STOCK_INDEX,
                                           GTK_STOCK_JUSTIFY_FILL,
                                           GTK_STOCK_DND,
                                           GTK_STOCK_SORT_ASCENDING,
                                           GTK_STOCK_SORT_DESCENDING,
                                           GTK_STOCK_GOTO_BOTTOM,
                                           GTK_STOCK_GO_DOWN,
                                           GTK_STOCK_OK,
#if GTK_CHECK_VERSION(2,6,0)
                                           GTK_STOCK_CONNECT,
                                           GTK_STOCK_DISCONNECT,
                                           GTK_STOCK_DIRECTORY,
#else /* not GTK_CHECK_VERSION(2,6,0) */
                                           GTK_STOCK_APPLY,
                                           GTK_STOCK_CANCEL,
                                           GTK_STOCK_OPEN,
#endif /* not GTK_CHECK_VERSION(2,6,0) */
                                           NULL};

                switch (lptbab->nID)
                  {
                    case IDB_STD_SMALL_COLOR:
                      stock_id = idb_std;
                      icon_size = GTK_ICON_SIZE_SMALL_TOOLBAR;
                      break;
                    case IDB_STD_LARGE_COLOR:
                      stock_id = idb_std;
                      icon_size = GTK_ICON_SIZE_LARGE_TOOLBAR;
                      break;
                    case IDB_VIEW_SMALL_COLOR:
                      stock_id = idb_view;
                      icon_size = GTK_ICON_SIZE_SMALL_TOOLBAR;
                      break;
                    case IDB_VIEW_LARGE_COLOR:
                      stock_id = idb_view;
                      icon_size = GTK_ICON_SIZE_LARGE_TOOLBAR;
                      break;
                    default:
                      return -1;
                  }
                lResult = g_list_length (td->glist_pixbuf);
                image = gtk_image_new ();
                for (i = 0; stock_id[i]; i++)
                  {
                    GdkPixbuf *pixbuf;

                    pixbuf = gtk_widget_render_icon (image,
                                                stock_id[i], icon_size, NULL);
                    if (pixbuf)
                      td->glist_pixbuf = g_list_append (td->glist_pixbuf,
                                                                    pixbuf);
                  }
                gtk_widget_destroy (image);
              }
            else
              {
                GdkPixbuf *pixbuf;

                pixbuf = lptbab->hInst ? LoadBitmap (lptbab->hInst,
                                                GUINT_TO_POINTER (lptbab->nID))
                                       : GUINT_TO_POINTER (lptbab->nID);
                if (pixbuf)
                  {
                    gint width;

                    width = gdk_pixbuf_get_width (pixbuf) / wParam;
                    if (width > 0)
                      {
                        gint i, height;

                        height = gdk_pixbuf_get_height (pixbuf);
                        lResult = g_list_length (td->glist_pixbuf);
                        for (i = 0; i < wParam; i++)
                          {
                            GdkPixbuf *subpixbuf;

                            subpixbuf = gdk_pixbuf_new_subpixbuf (pixbuf,
                                                width * i, 0, width, height);
                            if (subpixbuf)
                              td->glist_pixbuf = g_list_append
                                                (td->glist_pixbuf, subpixbuf);
                          }
                      }
                    if (lptbab->hInst)
                      g_object_unref (G_OBJECT (pixbuf));
                  }
              }
            return lResult;
          }
        return -1;
      case TB_ADDBUTTONSA:
      case TB_ADDBUTTONSW:
#if GTK_CHECK_VERSION(2,4,0)
        if (wParam > 0 && lParam)
          {
            gint i;
            GSList *group = NULL;
            LPTBBUTTON lptbb;

            lptbb = GINT_TO_POINTER (lParam);
            for (i = 0; i < wParam; i++)
              {
                GtkToolItem *item;

                if (lptbb[i].fsStyle & TBSTYLE_GROUP)
                  {
                    item = gtk_radio_tool_button_new (group);
                    group = gtk_radio_tool_button_get_group
                                                (GTK_RADIO_TOOL_BUTTON (item));
                  }
                else if (lptbb[i].fsStyle & TBSTYLE_CHECK)
                  {
                    item = gtk_toggle_tool_button_new ();
                  }
                else if (lptbb[i].fsStyle & TBSTYLE_SEP)
                  {
                    item = gtk_separator_tool_item_new ();
                  }
                else
                  {
                    item = gtk_tool_button_new (NULL, NULL);
                  }
                if (GTK_IS_TOOL_BUTTON (item))
                  {
                    gchar *utf8str;
                    GdkPixbuf *pixbuf;

                    pixbuf = g_list_nth_data (td->glist_pixbuf,
                                                            lptbb[i].iBitmap);
                    utf8str = g_list_nth_data (td->glist_string,
                                                            lptbb[i].iString);
                    if (!pixbuf)
                      break;
                    gtk_tool_button_set_icon_widget (GTK_TOOL_BUTTON (item),
                                        gtk_image_new_from_pixbuf (pixbuf));
                    gtk_tool_button_set_label (GTK_TOOL_BUTTON (item),
                                                                    utf8str);
                  }
                if (GTK_IS_TOGGLE_TOOL_BUTTON (item))
                  gtk_toggle_tool_button_set_active
                                        (GTK_TOGGLE_TOOL_BUTTON (item),
                                        lptbb[i].fsState & TBSTATE_CHECKED);
                gtk_widget_set_sensitive (GTK_WIDGET (item),
                                        lptbb[i].fsState & TBSTATE_ENABLED);
                if (lptbb[i].fsState & TBSTATE_HIDDEN)
                  gtk_widget_hide (GTK_WIDGET (item));
                else
                  gtk_widget_show (GTK_WIDGET (item));
                g_object_set_data (G_OBJECT (item), "user_data",
                                    g_memdup (lptbb + i, sizeof (TBBUTTON)));
                g_signal_connect (G_OBJECT (item), "clicked",
                                        G_CALLBACK (w32item_clicked), NULL);
                g_signal_connect (G_OBJECT (item), "destroy",
                                        G_CALLBACK (w32item_destroy), NULL);
                gtk_toolbar_insert (GTK_TOOLBAR (hWnd), item, -1);
              }
            return i >= wParam;
          }
#endif /* GTK_CHECK_VERSION(2,4,0) */
        return FALSE;
      case TB_INSERTBUTTONA:
      case TB_INSERTBUTTONW:
#if GTK_CHECK_VERSION(2,4,0)
        if (lParam)
          {
            GtkToolItem *item;
            LPTBBUTTON lptbb;

            lptbb = GINT_TO_POINTER (lParam);
            if (lptbb->fsStyle & TBSTYLE_GROUP)
              {
                item = gtk_radio_tool_button_new (NULL);
              }
            else if (lptbb->fsStyle & TBSTYLE_CHECK)
              {
                item = gtk_toggle_tool_button_new ();
              }
            else if (lptbb->fsStyle & TBSTYLE_SEP)
              {
                item = gtk_separator_tool_item_new ();
              }
            else
              {
                item = gtk_tool_button_new (NULL, NULL);
              }
            if (GTK_IS_TOOL_BUTTON (item))
              {
                gchar *utf8str;
                GdkPixbuf *pixbuf;

                pixbuf = g_list_nth_data (td->glist_pixbuf, lptbb->iBitmap);
                utf8str = g_list_nth_data (td->glist_string, lptbb->iString);
                gtk_tool_button_set_icon_widget (GTK_TOOL_BUTTON (item),
                                        gtk_image_new_from_pixbuf (pixbuf));
                gtk_tool_button_set_label (GTK_TOOL_BUTTON (item), utf8str);
              }
            if (GTK_IS_TOGGLE_TOOL_BUTTON (item))
              gtk_toggle_tool_button_set_active (GTK_TOGGLE_TOOL_BUTTON (item),
                                            lptbb->fsState & TBSTATE_CHECKED);
            gtk_widget_set_sensitive (GTK_WIDGET (item),
                                            lptbb->fsState & TBSTATE_ENABLED);
            if (lptbb->fsState & TBSTATE_HIDDEN)
              gtk_widget_hide (GTK_WIDGET (item));
            else
              gtk_widget_show (GTK_WIDGET (item));
            g_object_set_data (G_OBJECT (item), "user_data",
                                        g_memdup (lptbb, sizeof (TBBUTTON)));
            g_signal_connect (G_OBJECT (item), "destroy",
                                        G_CALLBACK (w32item_destroy), NULL);
            gtk_toolbar_insert (GTK_TOOLBAR (hWnd), item, wParam);
            return TRUE;
          }
#endif /* GTK_CHECK_VERSION(2,4,0) */
        return FALSE;
      case TB_DELETEBUTTON:
#if GTK_CHECK_VERSION(2,4,0)
        {
          GtkToolItem *item;

          item = gtk_toolbar_get_nth_item (GTK_TOOLBAR (hWnd), wParam);
          if (item)
            {
              gtk_container_remove (GTK_CONTAINER (hWnd), GTK_WIDGET (item));
              return TRUE;
            }
        }
#endif /* GTK_CHECK_VERSION(2,4,0) */
        return FALSE;
      case TB_GETBUTTON:
#if GTK_CHECK_VERSION(2,4,0)
        if (lParam)
          {
            GtkToolItem *item;

            item = gtk_toolbar_get_nth_item (GTK_TOOLBAR (hWnd), wParam);
            if (item)
              {
                LPTBBUTTON lptbb;

                lptbb = GINT_TO_POINTER (lParam);
                *lptbb = *(LPTBBUTTON)g_object_get_data (G_OBJECT (item),
                                                                "user_data");
                lptbb->fsState = GTK_IS_TOGGLE_TOOL_BUTTON (item)
                                        && gtk_toggle_tool_button_get_active
                        (GTK_TOGGLE_TOOL_BUTTON (item)) ? TBSTATE_CHECKED : 0;
                if (GTK_WIDGET_SENSITIVE (item))
                  lptbb->fsState |= TBSTATE_ENABLED;
                if (GTK_WIDGET_VISIBLE (item))
                  lptbb->fsState |= TBSTATE_HIDDEN;
                return TRUE;
              }
          }
#endif /* GTK_CHECK_VERSION(2,4,0) */
        return FALSE;
      case TB_BUTTONCOUNT:
#if GTK_CHECK_VERSION(2,4,0)
        return gtk_toolbar_get_n_items (GTK_TOOLBAR (hWnd));
#else /* not GTK_CHECK_VERSION(2,4,0) */
        {
          GList *glist;
          LRESULT lResult;

          glist = gtk_container_get_children (GTK_CONTAINER (hWnd));
          lResult = g_list_length (glist);
          g_list_free (glist);
          return lResult;
        }
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      case TB_COMMANDTOINDEX:
#if GTK_CHECK_VERSION(2,4,0)
        {
          gint i;
          GtkToolItem *item;

          for (i = 0;
                (item = gtk_toolbar_get_nth_item (GTK_TOOLBAR (hWnd), i)); i++)
            {
              LPTBBUTTON lptbb;

              lptbb = g_object_get_data (G_OBJECT (item), "user_data");
              if (lptbb->idCommand == wParam)
                return i;
            }
        }
#endif /* GTK_CHECK_VERSION(2,4,0) */
        return -1;
      case TB_SAVERESTOREA:
      case TB_SAVERESTOREW:
        return FALSE;
      case TB_CUSTOMIZE:
        return 0;
      case TB_ADDSTRINGA:
        if (wParam)
          {
            CHAR szText[256];

            if (LoadStringA (GINT_TO_POINTER (wParam), lParam,
                                        szText, G_N_ELEMENTS (szText) - 1) > 0)
              {
                gchar *utf8str;

                utf8str = w32ldr_utf8_from_mb (szText);
                if (utf8str)
                  {
                    td->glist_string = g_list_append (td->glist_string,
                                                                    utf8str);
                    return g_list_length (td->glist_string) - 1;
                  }
              }
          }
        else if (lParam)
          {
            const gchar *mb;
            LRESULT lResult = -1;

            lResult = g_list_length (td->glist_string);
            for (mb = GINT_TO_POINTER (lParam); *mb != '\0';
                                                    mb += g_strlen (mb) + 1)
              {
                gchar *utf8str;

                utf8str = w32ldr_utf8_from_mb (mb);
                if (utf8str)
                  td->glist_string = g_list_append (td->glist_string, utf8str);
              }
            return lResult;
          }
        return -1;
      case TB_ADDSTRINGW:
        if (wParam)
          {
            WCHAR szText[256];

            if (LoadStringW (GINT_TO_POINTER (wParam), lParam,
                                        szText, G_N_ELEMENTS (szText) - 1) > 0)
              {
                gchar *utf8str;

                utf8str = g_utf16_to_utf8 (szText, -1, NULL, NULL, NULL);
                if (utf8str)
                  {
                    td->glist_string = g_list_append (td->glist_string,
                                                                    utf8str);
                    return g_list_length (td->glist_string) - 1;
                  }
              }
          }
        else if (lParam)
          {
            const gunichar2 *wc;
            LRESULT lResult = -1;

            lResult = g_list_length (td->glist_string);
            for (wc = GINT_TO_POINTER (lParam); *wc != '\0';
                                                    wc += lstrlenW (wc) + 1)
              {
                gchar *utf8str;

                utf8str = g_utf16_to_utf8 (wc, -1, NULL, NULL, NULL);
                if (utf8str)
                  td->glist_string = g_list_append (td->glist_string, utf8str);
              }
            return lResult;
          }
        return -1;
      case TB_GETITEMRECT:
        return FALSE;
      case TB_BUTTONSTRUCTSIZE:
        return 0;
      case TB_SETBUTTONSIZE:
        return FALSE;
      case TB_SETBITMAPSIZE:
        return FALSE;
      case TB_AUTOSIZE:
        return 0;
      case TB_GETTOOLTIPS:
        return GPOINTER_TO_INT (NULL);
      case TB_SETTOOLTIPS:
        return GPOINTER_TO_INT (NULL);
      case TB_SETPARENT:
        return GPOINTER_TO_INT (NULL);
      case TB_SETROWS:
        return 0;
      case TB_GETROWS:
        return 1;
      case TB_GETBITMAPFLAGS:
        return 0;
      case TB_SETCMDID:
#if GTK_CHECK_VERSION(2,4,0)
        {
          GtkToolItem *item;

          item = gtk_toolbar_get_nth_item (GTK_TOOLBAR (hWnd), wParam);
          if (item)
            {
              LPTBBUTTON lptbb;

              lptbb = g_object_get_data (G_OBJECT (item), "user_data");
              lptbb->idCommand = lParam;
              return TRUE;
            }
        }
#endif /* GTK_CHECK_VERSION(2,4,0) */
        return FALSE;
      case TB_CHANGEBITMAP:
#if GTK_CHECK_VERSION(2,4,0)
        {
          GdkPixbuf *pixbuf;

          pixbuf = g_list_nth_data (td->glist_pixbuf, lParam);
          if (pixbuf)
            {
              gint i;
              GtkToolItem *item;

              for (i = 0;
                (item = gtk_toolbar_get_nth_item (GTK_TOOLBAR (hWnd), i)); i++)
                {
                  LPTBBUTTON lptbb;

                  lptbb = g_object_get_data (G_OBJECT (item), "user_data");
                  if (lptbb->idCommand == wParam)
                    {
                      gtk_tool_button_set_icon_widget (GTK_TOOL_BUTTON (item),
                                        gtk_image_new_from_pixbuf (pixbuf));
                      lptbb->iBitmap = lParam;
                      return TRUE;
                    }
                }
            }
        }
#endif /* GTK_CHECK_VERSION(2,4,0) */
        return FALSE;
      case TB_GETBITMAP:
#if GTK_CHECK_VERSION(2,4,0)
        {
          gint i;
          GtkToolItem *item;

          for (i = 0;
                (item = gtk_toolbar_get_nth_item (GTK_TOOLBAR (hWnd), i)); i++)
            {
              LPTBBUTTON lptbb;

              lptbb = g_object_get_data (G_OBJECT (item), "user_data");
              if (lptbb->idCommand == wParam)
                return lptbb->iBitmap;
            }
        }
#endif /* GTK_CHECK_VERSION(2,4,0) */
        return 0;
      case TB_GETBUTTONTEXTA:
      case TB_GETBUTTONTEXTW:
#if GTK_CHECK_VERSION(2,4,0)
        if (lParam)
          {
            gint i;
            GtkToolItem *item;

            for (i = 0;
                (item = gtk_toolbar_get_nth_item (GTK_TOOLBAR (hWnd), i)); i++)
              {
                LPTBBUTTON lptbb;

                lptbb = g_object_get_data (G_OBJECT (item), "user_data");
                if (lptbb->idCommand == wParam)
                  {
                    const gchar *utf8str;

                    utf8str = gtk_tool_button_get_label
                                                    (GTK_TOOL_BUTTON (item));
                    if (Msg == TB_GETBUTTONTEXTW)
                      {
                        gunichar2 *wc;

                        if (utf8str)
                          {
                            wc = g_utf8_to_utf16 (utf8str, -1,
                                                            NULL, NULL, NULL);
                            lstrcpyW (GINT_TO_POINTER (lParam), wc);
                            g_free (wc);
                          }
                        else
                          {
                            wc = GINT_TO_POINTER (lParam);
                            *wc = '\0';
                          }
                        return lstrlenW (GINT_TO_POINTER (lParam));
                      }
                    else
                      {
                        gchar *mb;

                        if (utf8str)
                          {
                            mb = w32ldr_utf8_to_mb (utf8str);
                            g_strcpy (GINT_TO_POINTER (lParam), mb);
                            g_free (mb);
                          }
                        else
                          {
                            mb = GINT_TO_POINTER (lParam);
                            *mb = '\0';
                          }
                        return g_strlen (GINT_TO_POINTER (lParam));
                      }
                  }
              }
          }
#endif /* GTK_CHECK_VERSION(2,4,0) */
        return -1;
    }
  return wd->widechar ? DefWindowProcW (hWnd, Msg, wParam, lParam)
                       : DefWindowProcA (hWnd, Msg, wParam, lParam);
}


/* ja:破棄 */
static void
w32tool_destroy (GtkWidget *widget,
                 gpointer   user_data)
{
  W32LdrToolData *td;

  td = g_object_get_data (G_OBJECT (widget), "user_data");
  g_list_foreach (td->glist_pixbuf, (GFunc)g_object_unref, NULL);
  g_list_free (td->glist_pixbuf);
  g_list_foreach (td->glist_string, (GFunc)g_free, NULL);
  g_list_free (td->glist_string);
}


GtkWidget *
w32ldr_control_create_tool (const gchar    *windowname,
                            const guint32   style,
                            const guint32   exstyle,
                            const gint      width,
                            const gint      height,
                            const guint16   id,
                            HWND            hWndParent,
                            HINSTANCE       hInstance,
                            const gboolean  widechar)
{
  GtkWidget *tool;
  W32LdrWindowData *wd;
  W32LdrToolData *td;

  tool = gtk_toolbar_new ();
  g_signal_connect (G_OBJECT (tool), "destroy",
                                        G_CALLBACK (w32tool_destroy), NULL);
  td = g_malloc (sizeof (W32LdrToolData));
  wd = &td->wd;
  wd->dwStyle = style;
  wd->dwExStyle = exstyle;
  wd->hInstance = hInstance;
  wd->lpfnWndProc = w32tool_DefWindowProc;
  wd->hWndParent = hWndParent;
  wd->wID = id;
  wd->dwUserData = 0;
  wd->lpDialogFunc = NULL;
  wd->lResult = -1;
  wd->dwUser = 0;
  wd->csa = NULL;
  wd->csw = NULL;
  wd->dwInitParam = 0;
  wd->widechar = widechar;
  wd->resizable = FALSE;
  wd->classname = g_strdup ("ToolbarWindow32");
  wd->focus = NULL;
  wd->child = NULL;
  td->glist_pixbuf = NULL;
  td->glist_string = NULL;
  g_object_set_data (G_OBJECT (tool), "user_data", wd);
  return tool;
}
