/*
    w32loader
    copyright (c) 1998-2010 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __W32LDR_BRUSH_H__
#define __W32LDR_BRUSH_H__


#include "misc/gcommon.h"


G_BEGIN_DECLS


#define W32LDR_TYPE_BRUSH            (w32ldr_brush_get_type ())
#define W32LDR_BRUSH(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), W32LDR_TYPE_BRUSH, W32LdrBrush))
#define W32LDR_BRUSH_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), W32LDR_TYPE_BRUSH, W32LdrBrushClass))
#define W32LDR_IS_BRUSH(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), W32LDR_TYPE_BRUSH))
#define W32LDR_IS_BRUSH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), W32LDR_TYPE_BRUSH))
#define W32LDR_BRUSH_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), W32LDR_TYPE_BRUSH, W32LdrBrushClass))


typedef struct _W32LdrBrush      W32LdrBrush;
typedef struct _W32LdrBrushClass W32LdrBrushClass;


struct _W32LdrBrush
{
  /*< private >*/
  GObject  parent;
  GdkColor color;
};
struct _W32LdrBrushClass
{
  GObjectClass parent_class;
};


/******************************************************************************
*                                                                             *
******************************************************************************/
GType
w32ldr_brush_get_type (void) G_GNUC_CONST;


/******************************************************************************
*                                                                             *
* ja:ブラシ関数群                                                             *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    RET,オブジェクト                                                        */
W32LdrBrush *
w32ldr_brush_new (void);


/*  ja:新規作成
    color,色
      RET,オブジェクト                                                      */
W32LdrBrush *
w32ldr_brush_new_with_color (GdkColor *color);


/*  ja:ブラシをコピーする
    w32brush,オブジェクト
         RET,オブジェクト                                                   */
W32LdrBrush *
w32ldr_brush_copy (W32LdrBrush *w32brush);


/*  ja:ブラシの色を取得する
    w32brush,オブジェクト
       color,色                                                             */
void
w32ldr_brush_get_color (W32LdrBrush *w32brush,
                        GdkColor    *color);


/*  ja:ブラシの色を設定する
    w32brush,オブジェクト
       color,色                                                             */
void
w32ldr_brush_set_color (W32LdrBrush *w32brush,
                        GdkColor    *color);


G_END_DECLS


#endif /* __W32LDR_BRUSH_H__ */
