/*
    w32loader
    copyright (c) 1998-2010 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "msvcrt.h"
#include "kernel32.h"
#include <stdarg.h>
#if GLIB_CHECK_VERSION(2,2,0)
# include <glib/gprintf.h>
#endif /* GLIB_CHECK_VERSION(2,2,0) */
#if GLIB_CHECK_VERSION(2,6,0)
# include <glib/gstdio.h>
#endif /* GLIB_CHECK_VERSION(2,6,0) */


#ifdef W32LDR_HEADER
#ifndef _BSD_SOURCE
# define _BSD_SOURCE
#endif /* not _BSD_SOURCE */
#ifndef _GNU_SOURCE
# define _GNU_SOURCE
#endif /* not _GNU_SOURCE */
#ifndef _XOPEN_SOURCE
# define _XOPEN_SOURCE
#endif /* not _XOPEN_SOURCE */
#include <ctype.h>
#include <math.h>
#include <stdlib.h>
#ifdef HAVE_ALLOCA_H
# include <alloca.h>
#endif /* HAVE_ALLOCA_H */
#ifdef HAVE_COMPLEX_H
# include <complex.h>
#endif /* HAVE_COMPLEX_H */
#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif /* HAVE_FCNTL_H */
#ifdef HAVE_SYS_STAT_H
# include <sys/stat.h>
#endif /* HAVE_SYS_STAT_H */
#ifdef HAVE_SYS_TIMEB_H
# include <sys/timeb.h>
#endif /* HAVE_SYS_TIMEB_H */
#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif /* HAVE_SYS_TYPES_H */
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif /* HAVE_UNISTD_H */
#ifdef HAVE_UTIME_H
# include <utime.h>
#endif /* HAVE_UTIME_H */

#ifndef _alloca
# define _alloca alloca
#endif /* not _alloca */
#ifndef _cabs
# define _cabs cabs
#endif /* not _cabs */
#ifndef _close
# define _close close
#endif /* not _close */
#ifndef _copysign
# define _copysign copysign
#endif /* not _copysign */
#ifndef _dup
# define _dup dup
#endif /* not _dup */
#ifndef _dup2
# define _dup2 dup2
#endif /* not _dup2 */
#ifndef _ecvt
# define _ecvt ecvt
#endif /* not _ecvt */
#ifndef _fcloseall
# define _fcloseall fcloseall
#endif /* not _fcloseall */
#ifndef _fcvt
# define _fcvt fcvt
#endif /* not _fcvt */
#ifndef _fileno
# define _fileno fileno
#endif /* not _fileno */
#ifndef _finite
# define _finite finite
#endif /* not _finite */
#ifndef _ftime
# define _ftime ftime
#endif /* not _ftime */
#ifndef _gcvt
# define _gcvt gcvt
#endif /* not _gcvt */
#ifndef _getpid
# define _getpid getpid
#endif /* not _getpid */
#ifndef _getw
# define _getw getw
#endif /* not _getw */
#ifndef _hypot
# define _hypot hypot
#endif /* not _hypot */
#ifndef __isascii
# define __isascii isascii
#endif /* not __isascii */
#ifndef _isascii
# define _isascii isascii
#endif /* not _isascii */
#ifndef _isnan
# define _isnan isnan
#endif /* not _isnan */
#ifndef _lfind
# define _lfind lfind
#endif /* not _lfind */
#ifndef _lsearch
# define _lsearch lsearch
#endif /* not _lsearch */
#ifndef _lseek
# define _lseek lseek
#endif /* not _lseek */
#ifndef _lseek64
# define _lseek64 lseek64
#endif /* not _lseek64 */
#ifndef __max
# define __max max
#endif /* not __max */
#ifndef _max
# define _max max
#endif /* not _max */
#ifndef __min
# define __min min
#endif /* not _min */
#ifndef _min
# define _min min
#endif /* not _min */
#ifndef _nextafter
# define _nextafter nextafter
#endif /* not _nextafter */
#ifndef __pclose
# define __pclose pclose
#endif /* not __pclose */
#ifndef _pclose
# define _pclose pclose
#endif /* not _pclose */
#ifndef _pipe
# define _pipe pipe
#endif /* not _pipe */
#ifndef _isatty
# define _isatty isatty
#endif /* not _isatty */
#ifndef _read
# define _read read
#endif /* not _read */
#ifndef _snprintf
# define _snprintf snprintf
#endif /* not _snprintf */
#ifndef _strdup
# define _strdup strdup
#endif /* not _strdup */
#ifndef _swab
# define _swab swab
#endif /* not _swab */
#ifndef __toascii
# define __toascii toascii
#endif /* not __toascii */
#ifndef _toascii
# define _toascii toascii
#endif /* not __toascii */
#ifndef _tolower
# define _tolower tolower
#endif /* not _tolower */
#ifndef _toupper
# define _toupper toupper
#endif /* not _toupper */
#ifndef _tzset
# define _tzset tzset
#endif /* not _tzset */
#ifndef _umask
# define _umask umask
#endif /* not _umask */
#ifndef _vsnprintf
# define _vsnprintf vsnprintf
#endif /* not _vsnprintf */
#ifndef _write
# define _write write
#endif /* not _write */

#define atoi64 _atoi64
#define beginthread _beginthread
#define beginthreadex _beginthreadex
#define c_exit _c_exit
#define cexit _cexit
#define cgets _cgets
#define chdrive _chdrive
#define chgsign _chgsign
#define chsize _chsize
#define clearfp _clearfp
#define commit _commit
#define control87 _control87
#define controlfp _controlfp
#define cprintf _cprintf
#define cputs _cputs
#define cscanf _cscanf
#define cwait _cwait
#define endthread _endthread
#define endthreadex _endthreadex
#define eof _eof
#define expand _expand
#define fgetchar _fgetchar
#define fgetwchar _fgetwchar
#define filelength _filelength
#define filelengthi64 _filelengthi64
#define findclose _findclose
#define findfirst _findfirst
#define findfirsti64 _findfirsti64
#define findnext _findnext
#define findnexti64 _findnexti64
#define flushall _flushall
#define fpclass _fpclass
#define fpieee_flt _fpieee_flt
#define fpreset _fpreset
#define fputchar _fputchar
#define fputwchar _fputwchar
#define fsopen _fsopen
#define fstat64 _fstat64
#define fstati64 _fstati64
#define fullpath _fullpath
#define futime _futime
#define futime64 _futime64
#define get_osfhandle _get_osfhandle
#define get_sbh_threshold _get_sbh_threshold
#define getch _getch
#define getche _getche
#define getdcwd _getdcwd
#define getdrive _getdrive
#define getmbcp _getmbcp
#define heapadd _heapadd
#define heapchk _heapchk
#define heapmin _heapmin
#define heapset _heapset
#define heapwalk _heapwalk
#define i64toa _i64toa
#define i64tow _i64tow
#define inp _inp
#define inpw _inpw
#define inpd _inpd
#define iscsym __iscsym
#define _iscsym __iscsym
#define iscsymf __iscsymf
#define _iscsymf __iscsymf
#define ismbbalnum _ismbbalnum
#define ismbbalpha _ismbbalpha
#define ismbbgraph _ismbbgraph
#define ismbbkalnum _ismbbkalnum
#define ismbbkana _ismbbkana
#define ismbbkprint _ismbbkprint
#define ismbbkpunct _ismbbkpunct
#define ismbblead _ismbblead
#define ismbbprint _ismbbprint
#define ismbbpunct _ismbbpunct
#define ismbbtrail _ismbbtrail
#define ismbcalnum _ismbcalnum
#define ismbcalpha _ismbcalpha
#define ismbcdigit _ismbcdigit
#define ismbcgraph _ismbcgraph
#define ismbchira _ismbchira
#define ismbckata _ismbckata
#define ismbcl0 _ismbcl0
#define ismbcl1 _ismbcl1
#define ismbcl2 _ismbcl2
#define ismbclegal _ismbclegal
#define ismbclower _ismbclower
#define ismbcprint _ismbcprint
#define ismbcpunct _ismbcpunct
#define ismbcspace _ismbcspace
#define ismbcsymbol _ismbcsymbol
#define ismbcupper _ismbcupper
#define ismbslead _ismbslead
#define ismbstrail _ismbstrail
#define itoa _itoa
#define itow _itow
#define kbhit _kbhit
#define locking _locking
#define lrotl _lrotl
#define lrotr _lrotr
#define ltoa _ltoa
#define ltow _ltow
#define makepath _makepath
#define mbbtombc _mbbtombc
#define mbbtype _mbbtype
#define mbccpy _mbccpy
#define mbcjistojms _mbcjistojms
#define mbcjmstojis _mbcjmstojis
#define mbclen _mbclen
#define mbctohira _mbctohira
#define mbctokata _mbctokata
#define mbctolower _mbctolower
#define mbctombb _mbctombb
#define mbctoupper _mbctoupper
#define mbsbtype msvcrt_mbsbtype
#define mbscat _mbscat
#define mbschr _mbschr
#define mbscmp _mbscmp
#define mbscoll _mbscoll
#define mbscpy _mbscpy
#define mbscspn _mbscspn
#define mbsdec _mbsdec
#define mbsdup _mbsdup
#define mbsicmp _mbsicmp
#define mbsicoll _mbsicoll
#define mbsinc _mbsinc
#define mbslen _mbslen
#define mbslwr _mbslwr
#define mbsnbcat _mbsnbcat
#define mbsnbcmp _mbsnbcmp
#define mbsnbcnt _mbsnbcnt
#define mbsnbcoll _mbsnbcoll
#define mbsnbcpy _mbsnbcpy
#define mbsnbicoll _mbsnbicoll
#define mbsnbicmp _mbsnbicmp
#define mbsnbset _mbsnbset
#define mbsncat _mbsncat
#define mbsnccnt _mbsnccnt
#define mbsncmp _mbsncmp
#define mbsncoll _mbsncoll
#define mbsncpy _mbsncpy
#define mbsnextc _mbsnextc
#define mbsnicmp _mbsnicmp
#define mbsnicoll _mbsnicoll
#define mbsninc _mbsninc
#define mbsnset _mbsnset
#define mbspbrk _mbspbrk
#define mbsrchr _mbsrchr
#define mbsrev _mbsrev
#define mbsset _mbsset
#define mbsspn _mbsspn
#define mbsspnp _mbsspnp
#define mbsstr _mbsstr
#define mbstok _mbstok
#define mbstrlen _mbstrlen
#define mbsupr _mbsupr
#define memicmp _memicmp
#define msize _msize
#define open_osfhandle _open_osfhandle
#define outp _outp
#define outpd _outpd
#define outpw _outpw
#define putch _putch
#define putw _putw
#define putws _putws
#define rmtmp _rmtmp
#define rotl _rotl
#define rotr _rotr
#define scalb _scalb
#define searchenv _searchenv
#define set_sbh_threshold _set_sbh_threshold
#define setmaxstdio _setmaxstdio
#define setmbcp _setmbcp
#define setmode _setmode
#define snwprintf _snwprintf
#define sopen _sopen
#define spawnl _spawnl
#define spawnle _spawnle
#define spawnlp _spawnlp
#define spawnlpe _spawnlpe
#define spawnv _spawnv
#define spawnve _spawnve
#define spawnvp _spawnvp
#define spawnvpe _spawnvpe
#define splitpath _splitpath
#define stati64 _stati64
#define statusfp _statusfp
#define strdate _strdate
#define stricmp _stricmp
#define stricoll _stricoll
#define strlwr _strlwr
#define strncoll _strncoll
#define strnicmp _strnicmp
#define strnicoll _strnicoll
#define strnset _strnset
#define strrev _strrev
#define strset _strset
#define strtime _strtime
#define strupr _strupr
#define tell _tell
#define telli64 _telli64
#define tempnam _tempnam
#define ui64toa _ui64toa
#define ui64tow _ui64tow
#define ultoa _ultoa
#define ultow _ultow
#define ungetch _ungetch
#define vsnwprintf _vsnwprintf
#define waccess _waccess
#define wasctime _wasctime
#define wchdir _wchdir
#define wchmod _wchmod
#define wcreat _wcreat
#define wcsdup _wcsdup
#define wcsicmp _wcsicmp
#define wcsicoll _wcsicoll
#define wcslwr _wcslwr
#define wcsncoll _wcsncoll
#define wcsnicmp _wcsnicmp
#define wcsnicoll _wcsnicoll
#define wcsnset _wcsnset
#define wcsrev _wcsrev
#define wcsset _wcsset
#define wcsupr _wcsupr
#define wexec _wexec
#define wexecl _wexecl
#define wexecle _wexecle
#define wexeclp _wexeclp
#define wexeclpe _wexeclpe
#define wexecv _wexecv
#define wexecve _wexecve
#define wexecvp _wexecvp
#define wexecvpe _wexecvpe
#define wfdopen _wfdopen
#define wfindfirst _wfindfirst
#define wfindfirsti64 _wfindfirsti64
#define wfindnext _wfindnext
#define wfindnexti64 _wfindnexti64
#define wfopen _wfopen
#define wfreopen _wfreopen
#define wfsopen _wfsopen
#define wfullpath _wfullpath
#define wgetcwd _wgetcwd
#define wgetdcwd _wgetdcwd
#define wgetenv _wgetenv
#define wmakepath _wmakepath
#define wmkdir _wmkdir
#define wmktemp _wmktemp
#define wopen _wopen
#define wperror _wperror
#define wpopen _wpopen
#define wputenv _wputenv
#define wremove _wremove
#define wrename _wrename
#define wrmdir _wrmdir
#define wscanf _wscanf
#define wsearchenv _wsearchenv
#define wsetlocale _wsetlocale
#define wsopen _wsopen
#define wspawnl _wspawnl
#define wspawnle _wspawnle
#define wspawnlp _wspawnlp
#define wspawnlpe _wspawnlpe
#define wspawnv _wspawnv
#define wspawnve _wspawnve
#define wspawnvp _wspawnvp
#define wspawnvpe _wspawnvpe
#define wsplitpath _wsplitpath
#define wstat _wstat
#define wstati64 _wstati64
#define wstrdate _wstrdate
#define wstrtime _wstrtime
#define wsystem _wsystem
#define wtempnam _wtempnam
#define wtmpnam _wtmpnam
#define wtoi _wtoi
#define wtol _wtol
#define wunlink _wunlink
#define wutime _wutime

#ifndef HAVE_STRCOLL
# define strcoll msvcrt_strcoll
#endif  /* not HAVE_STRCOLL */
#ifndef HAVE_STRFTIME
# define strftime msvcrt_strftime
#endif /* not HAVE_STRFTIME */
#ifndef HAVE_UTIME
# define utime _utime
#endif /* not HAVE_UTIME */
#ifndef HAVE_VPRINTF
# define vfprintf msvcrt_vfprintf
# define vprintf msvcrt_vprintf
# define vsprintf msvcrt_vsprintf
#endif /* not HAVE_VPRINTF */

#ifndef WEOF
# define WEOF (gunichar2)(0xffff)
#endif /* not WEOF */
#ifndef _S_IFMT
# define _S_IFMT 0xf000
#endif /* not _S_IFMT */
#ifndef _S_IFDIR
# define _S_IFDIR 0x4000
#endif /* not _S_IFDIR */
#ifndef _S_IFCHR
# define _S_IFCHR 0x2000
#endif /* not _S_IFCHR */
#ifndef _S_IFIFO
# define _S_IFIFO 0x1000
#endif /* not _S_IFIFO */
#ifndef _S_IFREG
# define _S_IFREG 0x8000
#endif /* not _S_IFREG */
#ifndef _S_IREAD
# define _S_IREAD 0x0100
#endif /* not _S_IREAD */
#ifndef _S_IWRITE
# define _S_IWRITE 0x0080
#endif /* not _S_IWRITE */
#ifndef _S_IEXEC
# define _S_IEXEC 0x0040
#endif /* not _S_IEXEC */
#ifndef _S_IFMT
# define S_IFMT _S_IFMT
#endif /* not S_IFMT */
#ifndef S_IFDIR
# define S_IFDIR _S_IFDIR
#endif /* not S_IFDIR */
#ifndef S_IFCHR
# define S_IFCHR _S_IFCHR
#endif /* not S_IFCHR */
#ifndef S_IFIFO
# define S_IFIFO _S_IFIFO
#endif /* not S_IFIFO */
#ifndef S_IFREG
# define S_IFREG _S_IFREG
#endif /* not S_IFREG */
#ifndef S_IREAD
# define S_IREAD _S_IREAD
#endif /* not S_IREAD */
#ifndef S_IWRITE
# define S_IWRITE _S_IWRITE
#endif /* not S_IWRITE */
#ifndef S_IEXEC
# define S_IEXEC _S_IEXEC
#endif /* not S_IEXEC */
#include "pshpack8.h"
struct _stat
{
  guint32 st_dev;
  guint16 st_ino;
  guint16 st_mode;
  gint16  st_nlink;
  gint16  st_uid;
  gint16  st_gid;
  guint32 st_rdev;
  gint32  st_size;
  gint32  st_atm;
  gint32  st_mtm;
  gint32  st_ctm;
};
struct _stati64
{
  guint32 st_dev;
  guint16 st_ino;
  guint16 st_mode;
  gint16  st_nlink;
  gint16  st_uid;
  gint16  st_gid;
  guint32 st_rdev;
  gint64  st_size;
  gint32  st_atm;
  gint32  st_mtm;
  gint32  st_ctm;
};
struct _timeb
{
  gint32 time;
  guint16 millitm;
  gint16 timezone;
  gint16 dstflag;
};
#include "poppack.h"
#define _timeb timeb
#endif /* W32LDR_HEADER */


/* ??2@YAPAXI@Z ordinal = 15, argument = 0 */
static void CDECL *msvcrt_new (size_t size)
{
  return g_malloc (size);
}


/* ??3@YAXPAX@Z ordinal = 16, argument = 0 */
static void CDECL msvcrt_delete (void *memblock)
{
  g_free (memblock);
}


/* _CIacos ordinal = 52, argument = 0 temporary */
static DWORD WINAPI msvcrt_CIacos (VOID)
{
  return 0;
}


/* _CIasin ordinal = 53, argument = 0 temporary */
static DWORD WINAPI msvcrt_CIasin (VOID)
{
  return 0;
}


/* _CIatan ordinal = 54, argument = 0 temporary */
static DWORD WINAPI msvcrt_CIatan (VOID)
{
  return 0;
}


/* _CIatan2 ordinal = 55, argument = 0 temporary */
static DWORD WINAPI msvcrt_CIatan2 (VOID)
{
  return 0;
}


/* _CIcos ordinal = 56, argument = 0 temporary */
static DWORD WINAPI msvcrt_CIcos (VOID)
{
  return 0;
}


/* _CIcosh ordinal = 57, argument = 0 temporary */
static DWORD WINAPI msvcrt_CIcosh (VOID)
{
  return 0;
}


/* _CIexp ordinal = 58, argument = 0 temporary */
static DWORD WINAPI msvcrt_CIexp (VOID)
{
  return 0;
}


/* _CIfmod ordinal = 59, argument = 0 temporary */
static DWORD WINAPI msvcrt_CIfmod (VOID)
{
  return 0;
}


/* _CIlog ordinal = 60, argument = 0 temporary */
static DWORD WINAPI msvcrt_CIlog (VOID)
{
  return 0;
}


/* _CIlog10 ordinal = 61, argument = 0 temporary */
static DWORD WINAPI msvcrt_CIlog10 (VOID)
{
  return 0;
}


/* _CIpow ordinal = 62, argument = 0 temporary */
static DWORD WINAPI msvcrt_CIpow (VOID)
{
  return 0;
}


/* _CIsin ordinal = 63, argument = 0 temporary */
static DWORD WINAPI msvcrt_CIsin (VOID)
{
  return 0;
}


/* _CIsinh ordinal = 64, argument = 0 temporary */
static DWORD WINAPI msvcrt_CIsinh (VOID)
{
  return 0;
}


/* _CIsqrt ordinal = 65, argument = 0 temporary */
static DWORD WINAPI msvcrt_CIsqrt (VOID)
{
  return 0;
}


/* _CItan ordinal = 66, argument = 0 temporary */
static DWORD WINAPI msvcrt_CItan (VOID)
{
  return 0;
}


/* _CItanh ordinal = 67, argument = 0 temporary */
static DWORD WINAPI msvcrt_CItanh (VOID)
{
  return 0;
}


/* _CxxThrowException ordinal = 68, argument = 8 temporary */
static DWORD WINAPI msvcrt_CxxThrowException (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* _EH_prolog ordinal = 69, argument = 0 */
static guint8 msvcrt_EH_prolog[] = {
  0x6a, 0xff,                               /* push 0FFFFFFFFh */
  0x50,                                     /* push eax */
  0x64, 0xff, 0x35, 0x00, 0x00, 0x00, 0x00, /* push dword ptr fs:[0] */
  0x64, 0x89, 0x25, 0x00, 0x00, 0x00, 0x00, /* mov  dword ptr fs:[0], esp */
  0x8b, 0x44, 0x24, 0x0c,                   /* mov  eax, esp[0Ch] */
  0x89, 0x6c, 0x24, 0x0c,                   /* mov  esp[0Ch], ebp */
  0x8d, 0x6c, 0x24, 0x0c,                   /* lea  ebp, esp[0Ch] */
  0x50,                                     /* push eax */
  0xc3};                                    /* ret */


/* _Getdays ordinal = 70, argument = 0 temporary */
static DWORD WINAPI msvcrt_Getdays (VOID)
{
  return 0;
}


/* _Getmonths ordinal = 71, argument = 0 temporary */
static DWORD WINAPI msvcrt_Getmonths (VOID)
{
  return 0;
}


/* _Gettnames ordinal = 72, argument = 0 temporary */
static DWORD WINAPI msvcrt_Gettnames (VOID)
{
  return 0;
}


/* _HUGE ordinal = 73, argument = 0 temporary */
static DWORD WINAPI msvcrt_HUGE (VOID)
{
  return 0;
}


/* _Strftime ordinal = 74, argument = 0 temporary */
static DWORD WINAPI msvcrt_Strftime (VOID)
{
  return 0;
}


/* _XcptFilter ordinal = 75, argument = 0 temporary */
static DWORD WINAPI msvcrt_XcptFilter (VOID)
{
  return 0;
}


/* __CxxFrameHandler ordinal = 76, argument = 0 */
static void msvcrt_CxxFrameHandler (PEXCEPTION_RECORD rec, EXCEPTION_FRAME* frame, PCONTEXT exc_context, EXCEPTION_FRAME** dispatch, CONTEXT86 *context)
{
}


/* __CxxLongjmpUnwind ordinal = 77, argument = 4 temporary */
static DWORD WINAPI msvcrt_CxxLongjmpUnwind (DWORD dwArgv0)
{
  return 0;
}


/* __RTCastToVoid ordinal = 78, argument = 0 temporary */
static DWORD WINAPI msvcrt_RTCastToVoid (VOID)
{
  return 0;
}


/* __RTDynamicCast ordinal = 79, argument = 0 temporary */
static DWORD WINAPI msvcrt_RTDynamicCast (VOID)
{
  return 0;
}


/* __RTtypeid ordinal = 80, argument = 0 temporary */
static DWORD WINAPI msvcrt_RTtypeid (VOID)
{
  return 0;
}


/* __STRINGTOLD ordinal = 81, argument = 0 temporary */
static DWORD WINAPI msvcrt_STRINGTOLD (VOID)
{
  return 0;
}


/* __argc ordinal = 82, argument = 0 temporary */
static DWORD WINAPI msvcrt_argc (VOID)
{
  return 0;
}


/* __argv ordinal = 83, argument = 0 temporary */
static DWORD WINAPI msvcrt_argv (VOID)
{
  return 0;
}


/* __badioinfo ordinal = 84, argument = 0 temporary */
static DWORD WINAPI msvcrt_badioinfo (VOID)
{
  return 0;
}


/* __crtCompareStringA ordinal = 85, argument = 0 temporary */
static DWORD WINAPI msvcrt_crtCompareStringA (VOID)
{
  return 0;
}


/* __crtGetLocaleInfoW ordinal = 86, argument = 0 temporary */
static DWORD WINAPI msvcrt_crtGetLocaleInfoW (VOID)
{
  return 0;
}


/* __crtLCMapStringA ordinal = 87, argument = 0 temporary */
static DWORD WINAPI msvcrt_crtLCMapStringA (VOID)
{
  return 0;
}


/* __dllonexit ordinal = 88, argument = 0 */
static void CDECL *msvcrt_dllonexit (void *arg1, void *arg2, void *arg3)
{
  return NULL;
}


/* __doserrno ordinal = 89, argument = 0 temporary */
static DWORD WINAPI msvcrt_doserrno (VOID)
{
  return 0;
}


/* __fpecode ordinal = 90, argument = 0 temporary */
static DWORD WINAPI msvcrt_fpecode (VOID)
{
  return 0;
}


/* __getmainargs ordinal = 91, argument = 0 temporary */
static DWORD WINAPI msvcrt_getmainargs (VOID)
{
  return 0;
}


/* __initenv ordinal = 92, argument = 0 temporary */
static DWORD WINAPI msvcrt_initenv (VOID)
{
  return 0;
}


/* __isascii ordinal = 93, argument = 0 temporary */
static DWORD WINAPI msvcrt_isascii (VOID)
{
  return 0;
}


/* __iscsym ordinal = 94, argument = 0 temporary */
static DWORD WINAPI __iscsym (VOID)
{
  return 0;
}


/* __iscsymf ordinal = 95, argument = 0 temporary */
static DWORD WINAPI __iscsymf (VOID)
{
  return 0;
}


/* __lc_codepage ordinal = 96, argument = 0 temporary */
static DWORD WINAPI msvcrt_lc_codepage (VOID)
{
  return 0;
}


/* __lc_collate_cp ordinal = 97, argument = 0 temporary */
static DWORD WINAPI msvcrt_lc_collate_cp (VOID)
{
  return 0;
}


/* __lc_handle ordinal = 98, argument = 0 temporary */
static DWORD WINAPI msvcrt_lc_handle (VOID)
{
  return 0;
}


/* __lconv_init ordinal = 99, argument = 0 temporary */
static DWORD WINAPI msvcrt_lconv_init (VOID)
{
  return 0;
}


/* __mb_cur_max ordinal = 100, argument = 0 temporary */
static DWORD WINAPI msvcrt_mb_cur_max (VOID)
{
  return 0;
}


/* __p___argc ordinal = 101, argument = 0 temporary */
static DWORD WINAPI msvcrt_p___argc (VOID)
{
  return 0;
}


/* __p___argv ordinal = 102, argument = 0 temporary */
static DWORD WINAPI msvcrt_p___argv (VOID)
{
  return 0;
}


/* __p___initenv ordinal = 103, argument = 0 temporary */
static DWORD WINAPI msvcrt_p___initenv (VOID)
{
  return 0;
}


/* __p___mb_cur_max ordinal = 104, argument = 0 temporary */
static DWORD WINAPI msvcrt_p___mb_cur_max (VOID)
{
  return 0;
}


/* __p___wargv ordinal = 105, argument = 0 temporary */
static DWORD WINAPI msvcrt_p___wargv (VOID)
{
  return 0;
}


/* __p___winitenv ordinal = 106, argument = 0 temporary */
static DWORD WINAPI msvcrt_p___winitenv (VOID)
{
  return 0;
}


/* __p__acmdln ordinal = 107, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__acmdln (VOID)
{
  return 0;
}


/* __p__amblksiz ordinal = 108, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__amblksiz (VOID)
{
  return 0;
}


/* __p__commode ordinal = 109, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__commode (VOID)
{
  return 0;
}


/* __p__daylight ordinal = 110, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__daylight (VOID)
{
  return 0;
}


/* __p__dstbias ordinal = 111, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__dstbias (VOID)
{
  return 0;
}


/* __p__environ ordinal = 112, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__environ (VOID)
{
  return 0;
}


/* __p__fileinfo ordinal = 113, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__fileinfo (VOID)
{
  return 0;
}


/* __p__fmode ordinal = 114, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__fmode (VOID)
{
  return 0;
}


/* __p__iob ordinal = 115, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__iob (VOID)
{
  return 0;
}


/* __p__mbcasemap ordinal = 116, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__mbcasemap (VOID)
{
  return 0;
}


/* __p__mbctype ordinal = 117, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__mbctype (VOID)
{
  return 0;
}


/* __p__osver ordinal = 118, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__osver (VOID)
{
  return 0;
}


/* __p__pctype ordinal = 119, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__pctype (VOID)
{
  return 0;
}


/* __p__pgmptr ordinal = 120, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__pgmptr (VOID)
{
  return 0;
}


/* __p__pwctype ordinal = 121, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__pwctype (VOID)
{
  return 0;
}


/* __p__timezone ordinal = 122, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__timezone (VOID)
{
  return 0;
}


/* __p__tzname ordinal = 123, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__tzname (VOID)
{
  return 0;
}


/* __p__wcmdln ordinal = 124, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__wcmdln (VOID)
{
  return 0;
}


/* __p__wenviron ordinal = 125, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__wenviron (VOID)
{
  return 0;
}


/* __p__winmajor ordinal = 126, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__winmajor (VOID)
{
  return 0;
}


/* __p__winminor ordinal = 127, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__winminor (VOID)
{
  return 0;
}


/* __p__winver ordinal = 128, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__winver (VOID)
{
  return 0;
}


/* __p__wpgmptr ordinal = 129, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__wpgmptr (VOID)
{
  return 0;
}


/* __pioinfo ordinal = 130, argument = 0 temporary */
static DWORD WINAPI msvcrt_pioinfo (VOID)
{
  return 0;
}


/* __pxcptinfoptrs ordinal = 131, argument = 0 temporary */
static DWORD WINAPI msvcrt_pxcptinfoptrs (VOID)
{
  return 0;
}


/* __set_app_type ordinal = 132, argument = 0 temporary */
static DWORD WINAPI msvcrt_set_app_type (VOID)
{
  return 0;
}


/* __setlc_active ordinal = 133, argument = 0 temporary */
static DWORD WINAPI msvcrt_setlc_active (VOID)
{
  return 0;
}


/* __setusermatherr ordinal = 134, argument = 0 temporary */
static DWORD WINAPI msvcrt_setusermatherr (VOID)
{
  return 0;
}


/* __threadhandle ordinal = 135, argument = 0 temporary */
static DWORD WINAPI msvcrt_threadhandle (VOID)
{
  return 0;
}


/* __threadid ordinal = 136, argument = 0 temporary */
static DWORD WINAPI msvcrt_threadid (VOID)
{
  return 0;
}


/* __toascii ordinal = 137, argument = 0 temporary */
static DWORD WINAPI msvcrt__toascii (VOID)
{
  return 0;
}


/* __unDName ordinal = 138, argument = 0 temporary */
static DWORD WINAPI msvcrt_unDName (VOID)
{
  return 0;
}


/* __unDNameEx ordinal = 139, argument = 0 temporary */
static DWORD WINAPI msvcrt_unDNameEx (VOID)
{
  return 0;
}


/* __unguarded_readlc_active ordinal = 140, argument = 0 temporary */
static DWORD WINAPI msvcrt_unguarded_readlc_active (VOID)
{
  return 0;
}


/* __wargv ordinal = 141, argument = 0 temporary */
static DWORD WINAPI msvcrt_wargv (VOID)
{
  return 0;
}


/* __wgetmainargs ordinal = 142, argument = 0 temporary */
static DWORD WINAPI msvcrt_wgetmainargs (VOID)
{
  return 0;
}


/* __winitenv ordinal = 143, argument = 0 temporary */
static DWORD WINAPI msvcrt_winitenv (VOID)
{
  return 0;
}


/* _abnormal_termination ordinal = 144, argument = 0 temporary */
static DWORD WINAPI msvcrt_abnormal_termination (VOID)
{
  return 0;
}


/* _access ordinal = 145, argument = 0 */
gint CDECL _access (const gchar *path, gint mode)
{
  gchar *file;
  int m, result;

  switch (mode)
    {
      case 0: m = F_OK; break;
      case 2: m = W_OK; break;
      case 4: m = R_OK; break;
      case 6: m = R_OK | W_OK; break;
      default: return -1;
    }
  file = w32ldr_filename_from_mb (path);
#if GLIB_CHECK_VERSION(2,8,0)
  result = g_access (file, m);
#else /* not GLIB_CHECK_VERSION(2,8,0) */
  result = access (file, m);
#endif /* not GLIB_CHECK_VERSION(2,8,0) */
  g_free (file);
  return result;
}


/* _acmdln ordinal = 146, argument = 0 temporary */
static DWORD WINAPI msvcrt_acmdln (VOID)
{
  return 0;
}


/* _adj_fdiv_m16i ordinal = 147, argument = 0 temporary */
static DWORD WINAPI msvcrt_adj_fdiv_m16i (VOID)
{
  return 0;
}


/* _adj_fdiv_m32 ordinal = 148, argument = 0 temporary */
static DWORD WINAPI msvcrt_adj_fdiv_m32 (VOID)
{
  return 0;
}


/* _adj_fdiv_m32i ordinal = 149, argument = 0 temporary */
static DWORD WINAPI msvcrt_adj_fdiv_m32i (VOID)
{
  return 0;
}


/* _adj_fdiv_m64 ordinal = 150, argument = 0 temporary */
static DWORD WINAPI msvcrt_adj_fdiv_m64 (VOID)
{
  return 0;
}


/* _adj_fdiv_r ordinal = 151, argument = 0 temporary */
static DWORD WINAPI msvcrt_adj_fdiv_r (VOID)
{
  return 0;
}


/* _adj_fdivr_m16i ordinal = 152, argument = 0 temporary */
static DWORD WINAPI msvcrt_adj_fdivr_m16i (VOID)
{
  return 0;
}


/* _adj_fdivr_m32 ordinal = 153, argument = 0 temporary */
static DWORD WINAPI msvcrt_adj_fdivr_m32 (VOID)
{
  return 0;
}


/* _adj_fdivr_m32i ordinal = 154, argument = 0 temporary */
static DWORD WINAPI msvcrt_adj_fdivr_m32i (VOID)
{
  return 0;
}


/* _adj_fdivr_m64 ordinal = 155, argument = 0 temporary */
static DWORD WINAPI msvcrt_adj_fdivr_m64 (VOID)
{
  return 0;
}


/* _adj_fpatan ordinal = 156, argument = 0 temporary */
static DWORD WINAPI msvcrt_adj_fpatan (VOID)
{
  return 0;
}


/* _adj_fprem ordinal = 157, argument = 0 temporary */
static DWORD WINAPI msvcrt_adj_fprem (VOID)
{
  return 0;
}


/* _adj_fprem1 ordinal = 158, argument = 0 temporary */
static DWORD WINAPI msvcrt_adj_fprem1 (VOID)
{
  return 0;
}


/* _adj_fptan ordinal = 159, argument = 0 temporary */
static DWORD WINAPI msvcrt_adj_fptan (VOID)
{
  return 0;
}


/* _adjust_fdiv ordinal = 160, argument = 0 */
static int msvcrt_adjust_fdiv = 0;


/* _aexit_rtn ordinal = 161, argument = 0 temporary */
static DWORD WINAPI msvcrt_aexit_rtn (VOID)
{
  return 0;
}


/* _amsg_exit ordinal = 162, argument = 0 temporary */
static DWORD WINAPI msvcrt_amsg_exit (VOID)
{
  return 0;
}


/* _assert ordinal = 163, argument = 0 temporary */
static DWORD WINAPI msvcrt_assert (VOID)
{
  return 0;
}


/* _atodbl ordinal = 164, argument = 0 temporary */
static DWORD WINAPI msvcrt_atodbl (VOID)
{
  return 0;
}


/* _atoi64 ordinal = 165, argument = 0 */
gint64 CDECL _atoi64 (const char *string)
{
  gchar *endptr;

  return g_ascii_strtoll (string, &endptr, 0);
}


/* _atoldbl ordinal = 166, argument = 0 temporary */
static DWORD WINAPI msvcrt_atoldbl (VOID)
{
  return 0;
}


/* _beep ordinal = 167, argument = 0 temporary */
static DWORD WINAPI msvcrt_beep (VOID)
{
  return 0;
}


#ifdef USE_THREAD
typedef struct _W32LdrMsvcrtThread
{
  void (CDECL *start_address)(void *);
  void *arglist;
} W32LdrMsvcrtThread;


static gpointer
msvcrt_start_address (W32LdrMsvcrtThread *w32thread)
{
  w32thread->start_address (w32thread->arglist);
  g_free (w32thread);
  ExitThread (0);
  return NULL;
}
#endif /* USE_THREAD */


/* _beginthread ordinal = 168, argument = 0 */
unsigned long CDECL _beginthread (void (CDECL *start_address)(void *), unsigned stack_size, void *arglist)
{
#ifdef USE_THREAD
  W32LdrMsvcrtThread *w32thread;

  w32thread = g_malloc (sizeof (W32LdrMsvcrtThread));
  w32thread->start_address = start_address;
  w32thread->arglist = arglist;
  return GPOINTER_TO_UINT (g_thread_create ((GThreadFunc)msvcrt_start_address,
                                                    w32thread, TRUE, NULL));
#else /* not USE_THREAD */
  start_address (arglist);
  return 1;
#endif /* not USE_THREAD */
}


/* _beginthreadex ordinal = 169, argument = 0 */
unsigned long CDECL _beginthreadex (void *security, unsigned stack_size, unsigned (WINAPI *start_address)(void *), void *arglist, unsigned initflag, unsigned *thrdaddr)
{
#ifdef USE_THREAD
  return GPOINTER_TO_UINT (CreateThread (security, stack_size,
                                start_address, arglist, initflag, thrdaddr));
#else /* not USE_THREAD */
  start_address (arglist);
  return 1;
#endif /* not USE_THREAD */
}


/* _c_exit ordinal = 170, argument = 0 */
void CDECL _c_exit (void)
{
  _cexit ();
}


/* _cabs ordinal = 171, argument = 0 temporary */
static DWORD WINAPI msvcrt_cabs (VOID)
{
  return 0;
}


/* _callnewh ordinal = 172, argument = 0 temporary */
static DWORD WINAPI msvcrt_callnewh (VOID)
{
  return 0;
}


/* _cexit ordinal = 173, argument = 0 */
void CDECL _cexit (void)
{
}


/* _cgets ordinal = 174, argument = 0 */
char CDECL *_cgets (char *buffer)
{
  if (buffer && buffer[0] > 0 && fgets (buffer + 2, buffer[0], stdin))
    buffer[1] = g_strlen (buffer + 2);
  return buffer + 2;
}


/* _chdir ordinal = 175, argument = 0 */
int CDECL _chdir (const char *dirname)
{
  gchar *path;
  int result;

  path = w32ldr_filename_from_mb (dirname);
#if GLIB_CHECK_VERSION(2,8,0)
  result = g_chdir (path);
#else /* not GLIB_CHECK_VERSION(2,8,0) */
  result = chdir (path);
#endif /* not GLIB_CHECK_VERSION(2,8,0) */
  g_free (path);
  return result;
}


/* _chdrive ordinal = 176, argument = 0 */
int CDECL _chdrive (int drive)
{
  return drive == 3 ? 0 : -1;
}


/* _chgsign ordinal = 177, argument = 0 */
double CDECL _chgsign (double x)
{
  return -x;
}


/* _chkesp ordinal = 178, argument = 0 temporary */
static DWORD WINAPI msvcrt_chkesp (VOID)
{
  return 0;
}


/* _chmod ordinal = 179, argument = 0 */
int CDECL _chmod (const char *filename, int pmode)
{
  gchar *file;
  int result;
  struct stat buf;

  file = w32ldr_filename_from_mb (filename);
#if GLIB_CHECK_VERSION(2,8,0)
  result = g_stat (file, &buf);
#else /* not GLIB_CHECK_VERSION(2,8,0) */
  result = stat (file, &buf);
#endif /* not GLIB_CHECK_VERSION(2,8,0) */
  if (result == 0)
    {
      mode_t m;

      m = buf.st_mode;
      if (pmode & _S_IREAD)
        m |= S_IRUSR;
      else
        m &= ~(S_IRUSR | S_IRGRP | S_IROTH);
      if (pmode & _S_IWRITE)
        m |= S_IWUSR;
      else
        m &= ~(S_IWUSR | S_IWGRP | S_IWOTH);
#if GLIB_CHECK_VERSION(2,8,0)
      result = g_chmod (file, m);
#else /* not GLIB_CHECK_VERSION(2,8,0) */
      result = chmod (file, m);
#endif /* not GLIB_CHECK_VERSION(2,8,0) */
    }
  g_free (file);
  return result;
}


/* _chsize ordinal = 180, argument = 0 */
int CDECL _chsize (int handle, long size)
{
#ifdef HAVE_FTRUNCATE
  return ftruncate (handle, size);
#else /* not HAVE_FTRUNCATE */
  return -1;
#endif /* not HAVE_FTRUNCATE */
}


/* _clearfp ordinal = 181, argument = 0 */
unsigned int CDECL _clearfp (void)
{
  return 0;
}


/* _close ordinal = 182, argument = 0 */
static int CDECL msvcrt_close (int handle)
{
  return close (handle);
}


/* _commit ordinal = 183, argument = 0 */
int CDECL _commit (int handle)
{
  return 0;
}


/* _commode ordinal = 184, argument = 0 temporary */
static DWORD WINAPI msvcrt_commode (VOID)
{
  return 0;
}


/* _control87 ordinal = 185, argument = 0 */
unsigned int CDECL _control87 (unsigned int n, unsigned int mask)
{
  return 0;
}


/* _controlfp ordinal = 186, argument = 0 */
unsigned int CDECL _controlfp (unsigned int n, unsigned int mask)
{
  return 0;
}


/* _copysign ordinal = 187, argument = 0 */
static double CDECL msvcrt_copysign (double x, double y)
{
  return copysign (x, y);
}


/* _cprintf ordinal = 188, argument = 0 */
int CDECL _cprintf (const char *format, ...)
{
#if GLIB_CHECK_VERSION(2,2,0) || defined (HAVE_VPRINTF)
  gint result;
  va_list arglist;

  va_start (arglist, format);
# if GLIB_CHECK_VERSION(2,2,0)
  result = g_vprintf (format, arglist);
# else /* not GLIB_CHECK_VERSION(2,2,0) */
  result = vprintf (format, arglist);
# endif /* not GLIB_CHECK_VERSION(2,2,0) */
  va_end (arglist);
  return result;
#else /* not GLIB_CHECK_VERSION(2,2,0) || defined (HAVE_VPRINTF) */
  return 0;
#endif /* not GLIB_CHECK_VERSION(2,2,0) || defined (HAVE_VPRINTF) */
}


/* _cputs ordinal = 189, argument = 0 */
int CDECL _cputs (const char *string)
{
  fputs (string, stdout);
  return 0;
}


/* _creat ordinal = 190, argument = 0 */
int CDECL _creat (const char *filename, int pmode)
{
  gchar *file;
  int result;
  mode_t m = 0;

  m = pmode & _S_IREAD ? S_IRUSR | S_IRGRP | S_IROTH : 0;
  if (pmode & _S_IWRITE)
    m |= S_IWUSR;
  file = w32ldr_filename_from_mb (filename);
#if GLIB_CHECK_VERSION(2,8,0)
  result = g_creat (file, m);
#else /* not GLIB_CHECK_VERSION(2,8,0) */
  result = creat (file, m);
#endif /* not GLIB_CHECK_VERSION(2,8,0) */
  g_free (file);
  return result;
}


/* _cscanf ordinal = 191, argument = 0 */
int CDECL _cscanf (const char *format, ...)
{
  return 0;
}


/* _ctime64 ordinal = 192, argument = 0 temporary */
static DWORD WINAPI msvcrt_ctime64 (VOID)
{
  return 0;
}


/* _ctype ordinal = 193, argument = 0 temporary */
static DWORD WINAPI msvcrt_ctype (VOID)
{
  return 0;
}


/* _cwait ordinal = 194, argument = 0 */
int CDECL _cwait (int *termstat, int procHandle, int action)
{
  return -1;
}


/* _daylight ordinal = 195, argument = 0 temporary */
static DWORD WINAPI msvcrt_daylight (VOID)
{
  return 0;
}


/* _dstbias ordinal = 196, argument = 0 temporary */
static DWORD WINAPI msvcrt_dstbias (VOID)
{
  return 0;
}


/* _dup ordinal = 197, argument = 0 */
static int CDECL msvcrt_dup (int handle)
{
  return dup (handle);
}


/* _dup2 ordinal = 198, argument = 0 */
static int CDECL msvcrt_dup2 (int handle1, int handle2)
{
  return dup2 (handle1, handle2);
}


/* _ecvt ordinal = 199, argument = 0 */
static char CDECL *msvcrt_ecvt (double value, int count, int *dec, int *sign)
{
  return ecvt (value, count, dec, sign);
}


/* _endthread ordinal = 200, argument = 0 */
void CDECL _endthread (void)
{
  ExitThread (0);
}


/* _endthreadex ordinal = 201, argument = 0 */
void CDECL _endthreadex (unsigned retval)
{
  ExitThread (retval);
}


/* _environ ordinal = 202, argument = 0 temporary */
static DWORD WINAPI msvcrt_environ (VOID)
{
  return 0;
}


/* _eof ordinal = 203, argument = 0 temporary */
static int CDECL _eof (int handle)
{
  return 0;
}


/* _errno ordinal = 204, argument = 0 temporary */
static DWORD WINAPI msvcrt_errno (VOID)
{
  return 0;
}


/* _except_handler2 ordinal = 205, argument = 0 temporary */
static DWORD WINAPI msvcrt_except_handler2 (VOID)
{
  return 0;
}


/* _except_handler3 ordinal = 206, argument = 0 */
static int CDECL msvcrt_except_handler3 (PEXCEPTION_RECORD rec, EXCEPTION_FRAME *frame, PCONTEXT context, void *dispatcher)
{
  return 0;
}


/* _execl ordinal = 207, argument = 0 */
int CDECL _execl (const char *cmdname, const char *arg0, ...)
{
  return -1;
}


/* _execle ordinal = 208, argument = 0 */
int CDECL _execle (const char *cmdname, const char *arg0, ...)
{
  return -1;
}


/* _execlp ordinal = 209, argument = 0 */
int CDECL _execlp (const char *cmdname, const char *arg0, ...)
{
  return -1;
}


/* _execlpe ordinal = 210, argument = 0 */
int CDECL _execlpe (const char *cmdname, const char *arg0, ...)
{
  return -1;
}


/* _execv ordinal = 211, argument = 0 */
int CDECL _execv (const char *cmdname, const char * const *argv)
{
  return -1;
}


/* _execve ordinal = 212, argument = 0 */
int CDECL _execve (const char *cmdname, const char *const *argv, const char * const *envp)
{
  return -1;
}


/* _execvp ordinal = 213, argument = 0 */
int CDECL _execvp (const char *cmdname, const char * const *argv)
{
  return -1;
}


/* _execvpe ordinal = 214, argument = 0 */
int CDECL _execvpe (const char *cmdname, const char * const *argv, const char * const *envp)
{
  return -1;
}


/* _exit ordinal = 215, argument = 0 */
static void CDECL msvcrt__exit (int status)
{
  exit (status);
}


/* _expand ordinal = 216, argument = 0 temporary */
static DWORD WINAPI _expand (VOID)
{
  return 0;
}


/* _fcloseall ordinal = 217, argument = 0 */
static int CDECL msvcrt_fcloseall (void)
{
  return 0;
}


/* _fcvt ordinal = 218, argument = 0 */
static char CDECL *msvcrt_fcvt (double value, int count, int *dec, int *sign)
{
  return fcvt (value, count, dec, sign);
}


/* _fdopen ordinal = 219, argument = 0 */
FILE CDECL *_fdopen (int handle, const char *mode)
{
  gchar *utf8str;
  FILE *fp = NULL;

  utf8str = w32ldr_utf8_from_mb (mode);
  if (utf8str)
    {
      gchar *locale;

      locale = g_locale_from_utf8 (utf8str, -1, NULL, NULL, NULL);
      if (locale)
        {
          fp = fdopen (handle, locale);
          g_free (locale);
        }
      g_free (utf8str);
    }
  return fp;
}


/* _fgetchar ordinal = 220, argument = 0 */
int CDECL _fgetchar (void)
{
  return fgetc (stdin);
}


/* _fgetwchar ordinal = 221, argument = 0 */
gunichar2 CDECL _fgetwchar (void)
{
  gunichar2 c;

  return  fread (&c, sizeof (gunichar2), 1, stdin) == 1 ? c : WEOF;
}


/* _filbuf ordinal = 222, argument = 0 temporary */
static DWORD WINAPI msvcrt_filbuf (VOID)
{
  return 0;
}


/* _fileinfo ordinal = 223, argument = 0 temporary */
static DWORD WINAPI msvcrt_fileinfo (VOID)
{
  return 0;
}


/* _filelength ordinal = 224, argument = 0 */
long CDECL _filelength (int handle)
{
  struct stat buf;

  return fstat (handle, &buf) == 0 ? buf.st_size : -1;
}


/* _filelengthi64 ordinal = 225, argument = 0 */
gint64 CDECL _filelengthi64 (int handle)
{
  return _filelength (handle);
}


/* _fileno ordinal = 226, argument = 0 */
static int CDECL msvcrt_fileno (FILE *stream)
{
  return fileno (stream);
}


/* _findclose ordinal = 227, argument = 0 temporary */
static DWORD WINAPI _findclose (VOID)
{
  return 0;
}


/* _findfirst ordinal = 228, argument = 0 temporary */
static DWORD WINAPI _findfirst (VOID)
{
  return 0;
}


/* _findfirst64 ordinal = 229, argument = 0 temporary */
static DWORD WINAPI _findfirst64 (VOID)
{
  return 0;
}


/* _findfirsti64 ordinal = 230, argument = 0 temporary */
static DWORD WINAPI _findfirsti64 (VOID)
{
  return 0;
}


/* _findnext ordinal = 231, argument = 0 temporary */
static DWORD WINAPI _findnext (VOID)
{
  return 0;
}


/* _findnext64 ordinal = 232, argument = 0 temporary */
static DWORD WINAPI _findnext64 (VOID)
{
  return 0;
}


/* _findnexti64 ordinal = 233, argument = 0 temporary */
static DWORD WINAPI _findnexti64 (VOID)
{
  return 0;
}


/* _finite ordinal = 234, argument = 0 */
static int CDECL msvcrt_finite (double x)
{
  return finite (x);
}


/* _flsbuf ordinal = 235, argument = 0 temporary */
static DWORD WINAPI msvcrt_flsbuf (VOID)
{
  return 0;
}


/* _flushall ordinal = 236, argument = 0 */
int CDECL _flushall (void)
{
  return 0;
}


/* _fmode ordinal = 237, argument = 0 temporary */
static DWORD WINAPI msvcrt_fmode (VOID)
{
  return 0;
}


/* _fpclass ordinal = 238, argument = 0 temporary */
static DWORD WINAPI _fpclass (VOID)
{
  return 0;
}


/* _fpieee_flt ordinal = 239, argument = 0 temporary */
static DWORD WINAPI _fpieee_flt (VOID)
{
  return 0;
}


/* _fpreset ordinal = 240, argument = 0 temporary */
static DWORD WINAPI _fpreset (VOID)
{
  return 0;
}


/* _fputchar ordinal = 241, argument = 0 */
int CDECL _fputchar (int c)
{
  return fputc (c, stdout);
}


/* _fputwchar ordinal = 242, argument = 0 */
gunichar2 CDECL _fputwchar (gunichar2 c)
{
  return fwrite (&c, sizeof (gunichar2), 1, stdout) == 1 ? 1 : WEOF;
}


static FILE CDECL *msvcrt_fopen (const char *, const char *);
/* _fsopen ordinal = 243, argument = 0 */
FILE CDECL *_fsopen (const char *filename, const char *mode, int shflag)
{
  return msvcrt_fopen (filename, mode);
}


/* _fstat ordinal = 244, argument = 0 */
int CDECL _fstat (int handle, struct _stat *buffer)
{
  struct stat buf;

  if (buffer && fstat (handle, &buf) == 0)
    {
      buffer->st_dev = buf.st_dev;
      buffer->st_ino = buf.st_ino;
      buffer->st_mode = (S_ISDIR (buf.st_mode) ? _S_IFDIR : 0)
                | (S_ISCHR (buf.st_mode) ? _S_IFCHR : 0)
                | (S_ISREG (buf.st_mode) ? _S_IFREG : 0)
                | (buf.st_mode & (S_IRUSR | S_IRGRP | S_IROTH) ? _S_IREAD : 0)
                | (buf.st_mode & (S_IWUSR | S_IWGRP | S_IWOTH) ? _S_IWRITE : 0)
                | (buf.st_mode & (S_IXUSR | S_IXGRP | S_IXOTH) ? _S_IEXEC : 0);
      buffer->st_nlink = buf.st_nlink;
      buffer->st_uid = buf.st_uid;
      buffer->st_gid = buf.st_gid;
      buffer->st_rdev = buf.st_rdev;
      buffer->st_size = buf.st_size;
      buffer->st_atm = buf.st_atime;
      buffer->st_mtm = buf.st_mtime;
      buffer->st_ctm = buf.st_ctime;
      return 0;
    }
  return -1;
}


/* _fstat64 ordinal = 245, argument = 0 */
gint64 CDECL _fstat64 (int handle, struct _stati64 *buffer)
{
  return _fstati64 (handle, buffer);
}


/* _fstati64 ordinal = 246, argument = 0 */
gint64 CDECL _fstati64 (int handle, struct _stati64 *buffer)
{
  struct stat buf;

  if (buffer && fstat (handle, &buf) == 0)
    {
      buffer->st_dev = buf.st_dev;
      buffer->st_ino = buf.st_ino;
      buffer->st_mode = (S_ISDIR (buf.st_mode) ? _S_IFDIR : 0)
                | (S_ISCHR (buf.st_mode) ? _S_IFCHR : 0)
                | (S_ISREG (buf.st_mode) ? _S_IFREG : 0)
                | (buf.st_mode & (S_IRUSR | S_IRGRP | S_IROTH) ? _S_IREAD : 0)
                | (buf.st_mode & (S_IWUSR | S_IWGRP | S_IWOTH) ? _S_IWRITE : 0)
                | (buf.st_mode & (S_IXUSR | S_IXGRP | S_IXOTH) ? _S_IEXEC : 0);
      buffer->st_nlink = buf.st_nlink;
      buffer->st_uid = buf.st_uid;
      buffer->st_gid = buf.st_gid;
      buffer->st_rdev = buf.st_rdev;
      buffer->st_size = buf.st_size;
      buffer->st_atm = buf.st_atime;
      buffer->st_mtm = buf.st_mtime;
      buffer->st_ctm = buf.st_ctime;
      return 0;
    }
  return -1;
}


#ifdef _timeb
# undef _timeb
#endif /* _timeb */
/* _ftime ordinal = 247, argument = 0 */
static void CDECL msvcrt_ftime (struct _timeb *timeptr)
{
  if (timeptr)
    {
      struct timeb tp;

      ftime (&tp);
      timeptr->time = tp.time;
      timeptr->millitm = tp.millitm;
      timeptr->timezone = tp.timezone;
      timeptr->dstflag = tp.dstflag;
    }
}


/* _ftime64 ordinal = 248, argument = 0 temporary */
static DWORD WINAPI msvcrt_ftime64 (VOID)
{
  return 0;
}


/* _ftol ordinal = 249, argument = 0 */
static LONG CDECL msvcrt_ftol (void)
{
  double fl;

  __asm__ __volatile__( "fstpl" " %0;fwait" : "=m" (fl) : );
  return (LONG)fl;
}


/* _fullpath ordinal = 250, argument = 0 temporary */
static DWORD WINAPI _fullpath (VOID)
{
  return 0;
}


/* _futime ordinal = 251, argument = 0 temporary */
static DWORD WINAPI _futime (VOID)
{
  return 0;
}


/* _futime64 ordinal = 252, argument = 0 temporary */
static DWORD WINAPI _futime64 (VOID)
{
  return 0;
}


/* _gcvt ordinal = 253, argument = 0 temporary */
static DWORD WINAPI msvcrt_gcvt (VOID)
{
  return 0;
}


/* _get_heap_handle ordinal = 254, argument = 0 temporary */
static DWORD WINAPI msvcrt_get_heap_handle (VOID)
{
  return 0;
}


/* _get_osfhandle ordinal = 255, argument = 0 temporary */
static DWORD WINAPI _get_osfhandle (VOID)
{
  return 0;
}


/* _get_sbh_threshold ordinal = 256, argument = 0 temporary */
static DWORD WINAPI _get_sbh_threshold (VOID)
{
  return 0;
}


/* _getch ordinal = 257, argument = 0 temporary */
static DWORD WINAPI _getch (VOID)
{
  return 0;
}


/* _getche ordinal = 258, argument = 0 temporary */
static DWORD WINAPI _getche (VOID)
{
  return 0;
}


/* _getcwd ordinal = 259, argument = 0 temporary */
static DWORD WINAPI _getcwd (VOID)
{
  return 0;
}


/* _getdcwd ordinal = 260, argument = 0 temporary */
static DWORD WINAPI _getdcwd (VOID)
{
  return 0;
}


/* _getdiskfree ordinal = 261, argument = 0 temporary */
static DWORD WINAPI msvcrt_getdiskfree (VOID)
{
  return 0;
}


/* _getdllprocaddr ordinal = 262, argument = 0 temporary */
static DWORD WINAPI msvcrt_getdllprocaddr (VOID)
{
  return 0;
}


/* _getdrive ordinal = 263, argument = 0 temporary */
static DWORD WINAPI _getdrive (VOID)
{
  return 0;
}


/* _getdrives ordinal = 264, argument = 0 temporary */
static DWORD WINAPI msvcrt_getdrives (VOID)
{
  return 0;
}


/* _getmaxstdio ordinal = 265, argument = 0 temporary */
static DWORD WINAPI msvcrt_getmaxstdio (VOID)
{
  return 0;
}


/* _getmbcp ordinal = 266, argument = 0 temporary */
static DWORD WINAPI _getmbcp (VOID)
{
  return 0;
}


/* _getpid ordinal = 267, argument = 0 temporary */
static DWORD WINAPI msvcrt_getpid (VOID)
{
  return 0;
}


/* _getsystime ordinal = 268, argument = 0 temporary */
static DWORD WINAPI msvcrt_getsystime (VOID)
{
  return 0;
}


/* _getw ordinal = 269, argument = 0 temporary */
static DWORD WINAPI msvcrt_getw (VOID)
{
  return 0;
}


/* _getws ordinal = 270, argument = 0 temporary */
static DWORD WINAPI msvcrt_getws (VOID)
{
  return 0;
}


/* _global_unwind2 ordinal = 271, argument = 0 temporary */
static DWORD WINAPI msvcrt_global_unwind2 (VOID)
{
  return 0;
}


/* _gmtime64 ordinal = 272, argument = 0 temporary */
static DWORD WINAPI msvcrt_gmtime64 (VOID)
{
  return 0;
}


/* _heapadd ordinal = 273, argument = 0 temporary */
static DWORD WINAPI _heapadd (VOID)
{
  return 0;
}


/* _heapchk ordinal = 274, argument = 0 temporary */
static DWORD WINAPI _heapchk (VOID)
{
  return 0;
}


/* _heapmin ordinal = 275, argument = 0 temporary */
static DWORD WINAPI _heapmin (VOID)
{
  return 0;
}


/* _heapset ordinal = 276, argument = 0 temporary */
static DWORD WINAPI _heapset (VOID)
{
  return 0;
}


/* _heapused ordinal = 277, argument = 0 temporary */
static DWORD WINAPI _heapused (VOID)
{
  return 0;
}


/* _heapwalk ordinal = 278, argument = 0 temporary */
static DWORD WINAPI _heapwalk (VOID)
{
  return 0;
}


/* _hypot ordinal = 279, argument = 0 temporary */
static DWORD WINAPI msvcrt_hypot (VOID)
{
  return 0;
}


/* _i64toa ordinal = 280, argument = 0 */
char CDECL *_i64toa (gint64 value, char *string, int radix)
{
  gchar *p;

  p = string;
  if (2 <= radix && radix <= 36)
    {
      gint64 s;

      s = value;
      do
        {
          gint t;

          t = s % radix;
          s /= radix;
          if (t < 10)
            *p = t + '0';
          else
            *p = t + 'a';
          p++;
        }
      while (s != 0);
      if (value < 0)
        *p++ = '-';
    }
  *p = '\0';
  return g_strreverse (string);
}


/* _i64tow ordinal = 281, argument = 0 temporary */
static DWORD WINAPI _i64tow (VOID)
{
  return 0;
}


/* _initterm ordinal = 282, argument = 0 */
static int CDECL msvcrt_initterm (void **arg1, void **arg2)
{
  BOOL (*initterm_func)(void);

  while (arg1 < arg2)
    {
      if ((initterm_func = (BOOL(*)(void))*arg1))
        initterm_func ();
      arg1++;
    }
  return 0;
}


/* _inp ordinal = 283, argument = 0 temporary */
static DWORD WINAPI _inp (VOID)
{
  return 0;
}


/* _inpd ordinal = 284, argument = 0 temporary */
static DWORD WINAPI _inpd (VOID)
{
  return 0;
}


/* _inpw ordinal = 285, argument = 0 temporary */
static DWORD WINAPI _inpw (VOID)
{
  return 0;
}


/* _iob ordinal = 286, argument = 0 temporary */
static DWORD WINAPI msvcrt_iob (VOID)
{
  return 0;
}


/* _isatty ordinal = 287, argument = 0 temporary */
static DWORD WINAPI msvcrt_isatty (VOID)
{
  return 0;
}


/* _isctype ordinal = 288, argument = 0 temporary */
static DWORD WINAPI msvcrt_isctype (VOID)
{
  return 0;
}


/* _ismbbalnum ordinal = 289, argument = 0 temporary */
static DWORD WINAPI _ismbbalnum (VOID)
{
  return 0;
}


/* _ismbbalpha ordinal = 290, argument = 0 temporary */
static DWORD WINAPI _ismbbalpha (VOID)
{
  return 0;
}


/* _ismbbgraph ordinal = 291, argument = 0 temporary */
static DWORD WINAPI _ismbbgraph (VOID)
{
  return 0;
}


/* _ismbbkalnum ordinal = 292, argument = 0 temporary */
static DWORD WINAPI _ismbbkalnum (VOID)
{
  return 0;
}


/* _ismbbkana ordinal = 293, argument = 0 temporary */
static DWORD WINAPI _ismbbkana (VOID)
{
  return 0;
}


/* _ismbbkprint ordinal = 294, argument = 0 temporary */
static DWORD WINAPI _ismbbkprint (VOID)
{
  return 0;
}


/* _ismbbkpunct ordinal = 295, argument = 0 temporary */
static DWORD WINAPI _ismbbkpunct (VOID)
{
  return 0;
}


/* _ismbblead ordinal = 296, argument = 0 temporary */
static DWORD WINAPI _ismbblead (VOID)
{
  return 0;
}


/* _ismbbprint ordinal = 297, argument = 0 temporary */
static DWORD WINAPI _ismbbprint (VOID)
{
  return 0;
}


/* _ismbbpunct ordinal = 298, argument = 0 temporary */
static DWORD WINAPI _ismbbpunct (VOID)
{
  return 0;
}


/* _ismbbtrail ordinal = 299, argument = 0 temporary */
static DWORD WINAPI _ismbbtrail (VOID)
{
  return 0;
}


/* _ismbcalnum ordinal = 300, argument = 0 temporary */
static DWORD WINAPI _ismbcalnum (VOID)
{
  return 0;
}


/* _ismbcalpha ordinal = 301, argument = 0 temporary */
static DWORD WINAPI _ismbcalpha (VOID)
{
  return 0;
}


/* _ismbcdigit ordinal = 302, argument = 0 temporary */
static DWORD WINAPI _ismbcdigit (VOID)
{
  return 0;
}


/* _ismbcgraph ordinal = 303, argument = 0 temporary */
static DWORD WINAPI _ismbcgraph (VOID)
{
  return 0;
}


/* _ismbchira ordinal = 304, argument = 0 temporary */
static DWORD WINAPI _ismbchira (VOID)
{
  return 0;
}


/* _ismbckata ordinal = 305, argument = 0 temporary */
static DWORD WINAPI _ismbckata (VOID)
{
  return 0;
}


/* _ismbcl0 ordinal = 306, argument = 0 temporary */
static DWORD WINAPI _ismbcl0 (VOID)
{
  return 0;
}


/* _ismbcl1 ordinal = 307, argument = 0 temporary */
static DWORD WINAPI _ismbcl1 (VOID)
{
  return 0;
}


/* _ismbcl2 ordinal = 308, argument = 0 temporary */
static DWORD WINAPI _ismbcl2 (VOID)
{
  return 0;
}


/* _ismbclegal ordinal = 309, argument = 0 temporary */
static DWORD WINAPI _ismbclegal (VOID)
{
  return 0;
}


/* _ismbclower ordinal = 310, argument = 0 temporary */
static DWORD WINAPI _ismbclower (VOID)
{
  return 0;
}


/* _ismbcprint ordinal = 311, argument = 0 temporary */
static DWORD WINAPI _ismbcprint (VOID)
{
  return 0;
}


/* _ismbcpunct ordinal = 312, argument = 0 temporary */
static DWORD WINAPI _ismbcpunct (VOID)
{
  return 0;
}


/* _ismbcspace ordinal = 313, argument = 0 temporary */
static DWORD WINAPI _ismbcspace (VOID)
{
  return 0;
}


/* _ismbcsymbol ordinal = 314, argument = 0 temporary */
static DWORD WINAPI _ismbcsymbol (VOID)
{
  return 0;
}


/* _ismbcupper ordinal = 315, argument = 0 temporary */
static DWORD WINAPI _ismbcupper (VOID)
{
  return 0;
}


/* _ismbslead ordinal = 316, argument = 0 */
int CDECL _ismbslead (const unsigned char *string, const unsigned char *current)
{
  if (string && string < current)
    {
      const unsigned char *p;

      for (p = string; *p != '\0'; p += isleadbyte (*p) ? 2 : 1)
        if (p == current)
          return -1;
        else if (p > current)
          break;
    }
  return 0;
}


/* _ismbstrail ordinal = 317, argument = 0 */
int CDECL _ismbstrail (const unsigned char *string, const unsigned char *current)
{
  if (string && string < current)
    {
      const unsigned char *p;

      for (p = string; *p != '\0'; p += isleadbyte (*p) ? 2 : 1)
        if (p == current)
          break;
        else if (p > current)
          return -1;
    }
  return 0;
}


/* _isnan ordinal = 318, argument = 0 temporary */
static DWORD WINAPI msvcrt_isnan (VOID)
{
  return 0;
}


/* _itoa ordinal = 319, argument = 0 temporary */
static DWORD WINAPI _itoa (VOID)
{
  return 0;
}


/* _itow ordinal = 320, argument = 0 temporary */
static DWORD WINAPI _itow (VOID)
{
  return 0;
}


/* _j0 ordinal = 321, argument = 0 temporary */
static DWORD WINAPI msvcrt_j0 (VOID)
{
  return 0;
}


/* _j1 ordinal = 322, argument = 0 temporary */
static DWORD WINAPI msvcrt_j1 (VOID)
{
  return 0;
}


/* _jn ordinal = 323, argument = 0 temporary */
static DWORD WINAPI msvcrt_jn (VOID)
{
  return 0;
}


/* _kbhit ordinal = 324, argument = 0 temporary */
static DWORD WINAPI _kbhit (VOID)
{
  return 0;
}


/* _lfind ordinal = 325, argument = 0 temporary */
static DWORD WINAPI msvcrt_lfind (VOID)
{
  return 0;
}


/* _loaddll ordinal = 326, argument = 0 temporary */
static DWORD WINAPI msvcrt_loaddll (VOID)
{
  return 0;
}


/* _local_unwind2 ordinal = 327, argument = 0 temporary */
static DWORD WINAPI msvcrt_local_unwind2 (VOID)
{
  return 0;
}


/* _localtime64 ordinal = 328, argument = 0 temporary */
static DWORD WINAPI msvcrt_localtime64 (VOID)
{
  return 0;
}


/* _lock ordinal = 329, argument = 0 temporary */
static DWORD WINAPI msvcrt_lock (VOID)
{
  return 0;
}


/* _locking ordinal = 330, argument = 0 temporary */
static DWORD WINAPI _locking (VOID)
{
  return 0;
}


/* _logb ordinal = 331, argument = 0 temporary */
static DWORD WINAPI msvcrt_logb (VOID)
{
  return 0;
}


/* _longjmpex ordinal = 332, argument = 0 temporary */
static DWORD WINAPI msvcrt_longjmpex (VOID)
{
  return 0;
}


/* _lrotl ordinal = 333, argument = 0 temporary */
static DWORD WINAPI _lrotl (VOID)
{
  return 0;
}


/* _lrotr ordinal = 334, argument = 0 temporary */
static DWORD WINAPI _lrotr (VOID)
{
  return 0;
}


/* _lsearch ordinal = 335, argument = 0 temporary */
static DWORD WINAPI msvcrt_lsearch (VOID)
{
  return 0;
}


/* _lseek ordinal = 336, argument = 0 temporary */
static DWORD WINAPI msvcrt_lseek (VOID)
{
  return 0;
}


/* _lseeki64 ordinal = 337, argument = 0 temporary */
static DWORD WINAPI msvcrt_lseeki64 (VOID)
{
  return 0;
}


/* _ltoa ordinal = 338, argument = 0 temporary */
static DWORD WINAPI _ltoa (VOID)
{
  return 0;
}


/* _ltow ordinal = 339, argument = 0 temporary */
static DWORD WINAPI _ltow (VOID)
{
  return 0;
}


/* _makepath ordinal = 340, argument = 0 temporary */
static DWORD WINAPI _makepath (VOID)
{
  return 0;
}


/* _mbbtombc ordinal = 341, argument = 0 temporary */
static DWORD WINAPI _mbbtombc (VOID)
{
  return 0;
}


/* _mbbtype ordinal = 342, argument = 0 temporary */
static DWORD WINAPI _mbbtype (VOID)
{
  return 0;
}


/* _mbcasemap ordinal = 343, argument = 0 temporary */
static DWORD WINAPI _mbcasemap (VOID)
{
  return 0;
}


/* _mbccpy ordinal = 344, argument = 0 temporary */
static DWORD WINAPI _mbccpy (VOID)
{
  return 0;
}


/* _mbcjistojms ordinal = 345, argument = 0 */
unsigned int CDECL _mbcjistojms (unsigned int c)
{
  guint8 c1, c2;

  c1 = c >> 8;
  c2 = c;
  c2 += c1 & 1 ? 0x1f : 0x7d;
  if (c2 >= 0x7f)
    c2++;
  c1 = ((c1 - 0x21) >> 1) + 0x81;
  if (c1 > 0x9f)
    c1 += 0x40;
  return c1 << 8 | c2;
}


/* _mbcjmstojis ordinal = 346, argument = 0 */
unsigned int CDECL _mbcjmstojis (unsigned int c)
{
  guint8 c1, c2;

  c1 = c >> 8;
  c2 = c;
  c1 -= c1 >= 0xe0 ? 0xc1 : 0x81;
  c1 <<= 1;
  if (c2 >= 0x9f)
    {
      c1 += 0x22;
      c2 -= 0x7e;
    }
  else
    {
      c1 += 0x21;
      c2 -= c2 >= 0x80 ? 0x20 : 0x1f;
    }
  return c1 << 8 | c2;
}


/* _mbclen ordinal = 347, argument = 0 temporary */
static DWORD WINAPI _mbclen (VOID)
{
  return 0;
}


/* _mbctohira ordinal = 348, argument = 0 temporary */
static DWORD WINAPI _mbctohira (VOID)
{
  return 0;
}


/* _mbctokata ordinal = 349, argument = 0 temporary */
static DWORD WINAPI _mbctokata (VOID)
{
  return 0;
}


/* _mbctolower ordinal = 350, argument = 0 temporary */
static DWORD WINAPI _mbctolower (VOID)
{
  return 0;
}


/* _mbctombb ordinal = 351, argument = 0 temporary */
static DWORD WINAPI _mbctombb (VOID)
{
  return 0;
}


/* _mbctoupper ordinal = 352, argument = 0 temporary */
static DWORD WINAPI _mbctoupper (VOID)
{
  return 0;
}


/* _mbctype ordinal = 353, argument = 0 temporary */
static DWORD WINAPI _mbctype (VOID)
{
  return 0;
}


/* _mbsbtype ordinal = 354, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsbtype (VOID)
{
  return 0;
}


/* _mbscat ordinal = 355, argument = 0 temporary */
static DWORD WINAPI _mbscat (VOID)
{
  return 0;
}


/* _mbschr ordinal = 356, argument = 0 */
unsigned char CDECL *_mbschr (const unsigned char *string, unsigned int c)
{
  guchar s[3];

  s[0] = c >> 8;
  s[1] = c;
  s[2] = '\0';
  return _mbsstr (string, s);
}


/* _mbscmp ordinal = 357, argument = 0 */
int CDECL _mbscmp (const unsigned char *string1, const unsigned char *string2)
{
  return g_strcmp ((const gchar *)string1, (const gchar *)string2);
}


/* _mbscoll ordinal = 358, argument = 0 temporary */
static DWORD WINAPI _mbscoll (VOID)
{
  return 0;
}


/* _mbscpy ordinal = 359, argument = 0 temporary */
static DWORD WINAPI _mbscpy (VOID)
{
  return 0;
}


/* _mbscspn ordinal = 360, argument = 0 temporary */
static DWORD WINAPI _mbscspn (VOID)
{
  return 0;
}


/* _mbsdec ordinal = 361, argument = 0 */
unsigned char CDECL *_mbsdec (const unsigned char *start, const unsigned char *current)
{
  return start && start < current
        ? (unsigned char *)current - (_ismbstrail (start, current - 1) ? 2 : 1)
        : NULL;
}


/* _mbsdup ordinal = 362, argument = 0 temporary */
static DWORD WINAPI _mbsdup (VOID)
{
  return 0;
}


/* _mbsicmp ordinal = 363, argument = 0 */
int CDECL _mbsicmp (const unsigned char *string1, const unsigned char *string2)
{
  return lstrcmpiA ((LPCSTR)string1, (LPCSTR)string2);
}


/* _mbsicoll ordinal = 364, argument = 0 temporary */
static DWORD WINAPI _mbsicoll (VOID)
{
  return 0;
}


/* _mbsinc ordinal = 365, argument = 0 */
unsigned char CDECL *_mbsinc (const unsigned char *current)
{
  return current ? (unsigned char *)current + (isleadbyte (*current) ? 2 : 1)
                 : NULL;
}


/* _mbslen ordinal = 366, argument = 0 */
size_t CDECL _mbslen (const unsigned char *string)
{
  const unsigned char *str;
  gsize len = 0;

  if (string)
    for (str = string; *str != '\0'; str += isleadbyte (*str) ? 2 : 1)
      len++;
  return len;
}


/* _mbslwr ordinal = 367, argument = 0 */
unsigned char CDECL *_mbslwr (unsigned char *string)
{
  gboolean copyed = FALSE;
  gchar *utf8str;

  utf8str = w32ldr_utf8_from_mb ((const gchar *)string);
  if (utf8str)
    {
      gchar *utf8lwr;

      utf8lwr = g_utf8_strdown (utf8str, -1);
      if (utf8lwr && g_strlen ((const gchar *)string) == g_strlen (utf8lwr))
        {
          g_strcpy ((gchar *)string, utf8lwr);
          copyed = TRUE;
        }
      g_free (utf8lwr);
      g_free (utf8str);
    }
  return copyed ? string : (unsigned char *)_strlwr ((char *)string);
}


/* _mbsnbcat ordinal = 368, argument = 0 temporary */
static DWORD WINAPI _mbsnbcat (VOID)
{
  return 0;
}


/* _mbsnbcmp ordinal = 369, argument = 0 temporary */
static DWORD WINAPI _mbsnbcmp (VOID)
{
  return 0;
}


/* _mbsnbcnt ordinal = 370, argument = 0 temporary */
static DWORD WINAPI _mbsnbcnt (VOID)
{
  return 0;
}


/* _mbsnbcoll ordinal = 371, argument = 0 temporary */
static DWORD WINAPI _mbsnbcoll (VOID)
{
  return 0;
}


/* _mbsnbcpy ordinal = 372, argument = 0 temporary */
static DWORD WINAPI _mbsnbcpy (VOID)
{
  return 0;
}


/* _mbsnbicmp ordinal = 373, argument = 0 temporary */
static DWORD WINAPI _mbsnbicmp (VOID)
{
  return 0;
}


/* _mbsnbicoll ordinal = 374, argument = 0 temporary */
static DWORD WINAPI _mbsnbicoll (VOID)
{
  return 0;
}


/* _mbsnbset ordinal = 375, argument = 0 temporary */
static DWORD WINAPI _mbsnbset (VOID)
{
  return 0;
}


/* _mbsncat ordinal = 376, argument = 0 temporary */
static DWORD WINAPI _mbsncat (VOID)
{
  return 0;
}


/* _mbsnccnt ordinal = 377, argument = 0 temporary */
static DWORD WINAPI _mbsnccnt (VOID)
{
  return 0;
}


/* _mbsncmp ordinal = 378, argument = 0 */
int CDECL _mbsncmp (const unsigned char *string1, const unsigned char *string2, size_t count)
{
  gchar *p1, *p2, *utf8str1, *utf8str2;
  gint i, result = 0;

  utf8str1 = w32ldr_utf8_from_mb ((const gchar *)string1);
  utf8str2 = w32ldr_utf8_from_mb ((const gchar *)string2);
  if (utf8str1 && utf8str2)
    for (i = 0, p1 = utf8str1, p2 = utf8str2;
                i < count && *p1 != '\0' && *p2 != '\0';
                i++, p1 = g_utf8_next_char (p1), p2 = g_utf8_next_char (p2))
      {
        gunichar c1, c2;

        c1 = g_utf8_get_char (p1);
        c2 = g_utf8_get_char (p2);
        if (c1 != c2)
          result = c1 - c2;
      }
  g_free (utf8str1);
  g_free (utf8str2);
  return result;
}


/* _mbsncoll ordinal = 379, argument = 0 temporary */
static DWORD WINAPI _mbsncoll (VOID)
{
  return 0;
}


/* _mbsncpy ordinal = 380, argument = 0 temporary */
static DWORD WINAPI _mbsncpy (VOID)
{
  return 0;
}


/* _mbsnextc ordinal = 381, argument = 0 temporary */
static DWORD WINAPI _mbsnextc (VOID)
{
  return 0;
}


/* _mbsnicmp ordinal = 382, argument = 0 temporary */
static DWORD WINAPI _mbsnicmp (VOID)
{
  return 0;
}


/* _mbsnicoll ordinal = 383, argument = 0 temporary */
static DWORD WINAPI _mbsnicoll (VOID)
{
  return 0;
}


/* _mbsninc ordinal = 384, argument = 0 */
unsigned char CDECL *_mbsninc (const unsigned char *string, size_t count)
{
  const unsigned char *str = NULL;

  if (string)
    {
      size_t i;

      str = string;
      for (i = 0; i < count; i++)
        str += isleadbyte (*str) ? 2 : 1;
    }
  return (unsigned char *)str;
}


/* _mbsnset ordinal = 385, argument = 0 temporary */
static DWORD WINAPI _mbsnset (VOID)
{
  return 0;
}


/* _mbspbrk ordinal = 386, argument = 0 temporary */
static DWORD WINAPI _mbspbrk (VOID)
{
  return 0;
}


/* _mbsrchr ordinal = 387, argument = 0 */
unsigned char CDECL *_mbsrchr (const unsigned char *string, unsigned int c)
{
  if (string)
    {
      const unsigned char *p;

      for (p = string; *p != '\0'; p += isleadbyte (*p) ? 2 : 1)
        if ((p[0] << 8 | p[1]) == c)
          return (unsigned char *)p;
    }
  return NULL;
}


/* _mbsrev ordinal = 388, argument = 0 temporary */
static DWORD WINAPI _mbsrev (VOID)
{
  return 0;
}


/* _mbsset ordinal = 389, argument = 0 temporary */
static DWORD WINAPI _mbsset (VOID)
{
  return 0;
}


/* _mbsspn ordinal = 390, argument = 0 temporary */
static DWORD WINAPI _mbsspn (VOID)
{
  return 0;
}


/* _mbsspnp ordinal = 391, argument = 0 temporary */
static DWORD WINAPI _mbsspnp (VOID)
{
  return 0;
}


/* _mbsstr ordinal = 392, argument = 0 */
unsigned char CDECL *_mbsstr (const unsigned char *string1, const unsigned char *string2)
{

  if (string1 && string2)
    {
      const unsigned char *p;
      gsize len;

      len = g_strlen ((const gchar *)string2);
      for (p = string1; *p != '\0'; p += isleadbyte (*p) ? 2 : 1)
        if (g_strncmp ((const gchar *)p, (const gchar *)string2, len) == 0)
          return (unsigned char *)p;
    }
  return NULL;
}


/* _mbstok ordinal = 393, argument = 0 temporary */
static DWORD WINAPI _mbstok (VOID)
{
  return 0;
}


/* _mbstrlen ordinal = 394, argument = 0 temporary */
static DWORD WINAPI _mbstrlen (VOID)
{
  return 0;
}


/* _mbsupr ordinal = 395, argument = 0 */
unsigned char CDECL *_mbsupr (unsigned char *string)
{
  gboolean copyed = FALSE;
  gchar *utf8str;

  utf8str = w32ldr_utf8_from_mb ((const gchar *)string);
  if (utf8str)
    {
      gchar *utf8upr;

      utf8upr = g_utf8_strup (utf8str, -1);
      if (utf8upr && g_strlen ((const gchar *)string) == g_strlen (utf8upr))
        {
          g_strcpy ((gchar *)string, utf8upr);
          copyed = TRUE;
        }
      g_free (utf8upr);
      g_free (utf8str);
    }
  return copyed ? string : (unsigned char *)_strupr ((char *)string);
}


/* _memccpy ordinal = 396, argument = 0 temporary */
static DWORD WINAPI msvcrt_memccpy (VOID)
{
  return 0;
}


/* _memicmp ordinal = 397, argument = 0 temporary */
static DWORD WINAPI _memicmp (VOID)
{
  return 0;
}


/* _mkdir ordinal = 398, argument = 0 */
int CDECL _mkdir (const char *dirname)
{
  return CreateDirectoryA (dirname, NULL) ? 0 : -1;
}


/* _mktemp ordinal = 399, argument = 0 temporary */
static DWORD WINAPI _mktemp (VOID)
{
  return 0;
}


/* _mktime64 ordinal = 400, argument = 0 temporary */
static DWORD WINAPI msvcrt_mktime64 (VOID)
{
  return 0;
}


/* _msize ordinal = 401, argument = 0 temporary */
static DWORD WINAPI _msize (VOID)
{
  return 0;
}


/* _nextafter ordinal = 402, argument = 0 temporary */
static DWORD WINAPI msvcrt_nextafter (VOID)
{
  return 0;
}


/* _onexit ordinal = 403, argument = 0 */
void CDECL *_onexit (void *arg1)
{
  return NULL;
}


/* _open ordinal = 404, argument = 0 temporary */
static DWORD WINAPI _open (VOID)
{
  return 0;
}


/* _open_osfhandle ordinal = 405, argument = 0 temporary */
static DWORD WINAPI _open_osfhandle (VOID)
{
  return 0;
}


/* _osplatform ordinal = 406, argument = 0 temporary */
static DWORD WINAPI msvcrt_osplatform (VOID)
{
  return 0;
}


/* _osver ordinal = 407, argument = 0 temporary */
static DWORD WINAPI msvcrt_osver (VOID)
{
  return 0;
}


/* _outp ordinal = 408, argument = 0 temporary */
static DWORD WINAPI _outp (VOID)
{
  return 0;
}


/* _outpd ordinal = 409, argument = 0 temporary */
static DWORD WINAPI _outpd (VOID)
{
  return 0;
}


/* _outpw ordinal = 410, argument = 0 temporary */
static DWORD WINAPI _outpw (VOID)
{
  return 0;
}


/* _pclose ordinal = 411, argument = 0 temporary */
static DWORD WINAPI msvcrt_pclose (VOID)
{
  return 0;
}


/* _pctype ordinal = 412, argument = 0 temporary */
static DWORD WINAPI msvcrt_pctype (VOID)
{
  return 0;
}


/* _pgmptr ordinal = 413, argument = 0 temporary */
static DWORD WINAPI msvcrt_pgmptr (VOID)
{
  return 0;
}


/* _pipe ordinal = 414, argument = 0 temporary */
static DWORD WINAPI msvcrt_pipe (VOID)
{
  return 0;
}


/* _popen ordinal = 415, argument = 0 temporary */
static DWORD WINAPI _popen (VOID)
{
  return 0;
}


/* _purecall ordinal = 416, argument = 0 temporary */
static DWORD WINAPI msvcrt_purecall (VOID)
{
  return 0;
}


/* _putch ordinal = 417, argument = 0 temporary */
static DWORD WINAPI _putch (VOID)
{
  return 0;
}


/* _putenv ordinal = 418, argument = 0 temporary */
static DWORD WINAPI _putenv (VOID)
{
  return 0;
}


/* _putw ordinal = 419, argument = 0 temporary */
static DWORD WINAPI _putw (VOID)
{
  return 0;
}


/* _putws ordinal = 420, argument = 0 temporary */
static DWORD WINAPI _putws (VOID)
{
  return 0;
}


/* _pwctype ordinal = 421, argument = 0 temporary */
static DWORD WINAPI msvcrt_pwctype (VOID)
{
  return 0;
}


/* _read ordinal = 422, argument = 0 temporary */
static DWORD WINAPI msvcrt_read (VOID)
{
  return 0;
}


/* _rmdir ordinal = 423, argument = 0 temporary */
static DWORD WINAPI _rmdir (VOID)
{
  return 0;
}


/* _rmtmp ordinal = 424, argument = 0 temporary */
static DWORD WINAPI _rmtmp (VOID)
{
  return 0;
}


/* _rotl ordinal = 425, argument = 0 temporary */
static DWORD WINAPI _rotl (VOID)
{
  return 0;
}


/* _rotr ordinal = 426, argument = 0 temporary */
static DWORD WINAPI _rotr (VOID)
{
  return 0;
}


/* _safe_fdiv ordinal = 427, argument = 0 temporary */
static DWORD WINAPI msvcrt_safe_fdiv (VOID)
{
  return 0;
}


/* _safe_fdivr ordinal = 428, argument = 0 temporary */
static DWORD WINAPI msvcrt_safe_fdivr (VOID)
{
  return 0;
}


/* _safe_fprem ordinal = 429, argument = 0 temporary */
static DWORD WINAPI msvcrt_safe_fprem (VOID)
{
  return 0;
}


/* _safe_fprem1 ordinal = 430, argument = 0 temporary */
static DWORD WINAPI msvcrt_safe_fprem1 (VOID)
{
  return 0;
}


/* _scalb ordinal = 431, argument = 0 temporary */
static DWORD WINAPI msvcrt_scalb (VOID)
{
  return 0;
}


/* _searchenv ordinal = 432, argument = 0 temporary */
static DWORD WINAPI _searchenv (VOID)
{
  return 0;
}


/* _seh_longjmp_unwind ordinal = 433, argument = 4 temporary */
static DWORD WINAPI msvcrt_seh_longjmp_unwind (DWORD dwArgv0)
{
  return 0;
}


/* _set_error_mode ordinal = 434, argument = 0 temporary */
static DWORD WINAPI msvcrt_set_error_mode (VOID)
{
  return 0;
}


/* _set_sbh_threshold ordinal = 435, argument = 0 temporary */
static DWORD WINAPI _set_sbh_threshold (VOID)
{
  return 0;
}


/* _seterrormode ordinal = 436, argument = 0 temporary */
static DWORD WINAPI msvcrt_seterrormode (VOID)
{
  return 0;
}


/* _setjmp ordinal = 437, argument = 0 temporary */
static DWORD WINAPI msvcrt_setjmp (VOID)
{
  return 0;
}


/* _setjmp3 ordinal = 438, argument = 0 temporary */
static DWORD WINAPI msvcrt_setjmp3 (VOID)
{
  return 0;
}


/* _setmaxstdio ordinal = 439, argument = 0 temporary */
static DWORD WINAPI _setmaxstdio (VOID)
{
  return 0;
}


/* _setmbcp ordinal = 440, argument = 0 temporary */
static DWORD WINAPI _setmbcp (VOID)
{
  return 0;
}


/* _setmode ordinal = 441, argument = 0 temporary */
static DWORD WINAPI _setmode (VOID)
{
  return 0;
}


/* _setsystime ordinal = 442, argument = 0 temporary */
static DWORD WINAPI msvcrt_setsystime (VOID)
{
  return 0;
}


/* _sleep ordinal = 443, argument = 0 temporary */
static DWORD WINAPI msvcrt_sleep (VOID)
{
  return 0;
}


/* _snprintf ordinal = 444, argument = 0 temporary */
static DWORD WINAPI msvcrt_snprintf (VOID)
{
  return 0;
}


/* _snwprintf ordinal = 445, argument = 0 temporary */
static DWORD WINAPI _snwprintf (VOID)
{
  return 0;
}


/* _sopen ordinal = 446, argument = 0 temporary */
static DWORD WINAPI _sopen (VOID)
{
  return 0;
}


/* _spawnl ordinal = 447, argument = 0 temporary */
static DWORD WINAPI _spawnl (VOID)
{
  return 0;
}


/* _spawnle ordinal = 448, argument = 0 temporary */
static DWORD WINAPI _spawnle (VOID)
{
  return 0;
}


/* _spawnlp ordinal = 449, argument = 0 temporary */
static DWORD WINAPI _spawnlp (VOID)
{
  return 0;
}


/* _spawnlpe ordinal = 450, argument = 0 temporary */
static DWORD WINAPI _spawnlpe (VOID)
{
  return 0;
}


/* _spawnv ordinal = 451, argument = 0 temporary */
static DWORD WINAPI _spawnv (VOID)
{
  return 0;
}


/* _spawnve ordinal = 452, argument = 0 temporary */
static DWORD WINAPI _spawnve (VOID)
{
  return 0;
}


/* _spawnvp ordinal = 453, argument = 0 temporary */
static DWORD WINAPI _spawnvp (VOID)
{
  return 0;
}


/* _spawnvpe ordinal = 454, argument = 0 temporary */
static DWORD WINAPI _spawnvpe (VOID)
{
  return 0;
}


/* _splitpath ordinal = 455, argument = 0 temporary */
static DWORD WINAPI _splitpath (VOID)
{
  return 0;
}


/* _stat ordinal = 456, argument = 0 temporary */
static DWORD WINAPI _stat (VOID)
{
  return 0;
}


/* _stat64 ordinal = 457, argument = 0 temporary */
static DWORD WINAPI msvcrt_stat64 (VOID)
{
  return 0;
}


/* _stati64 ordinal = 458, argument = 0 temporary */
static DWORD WINAPI _stati64 (VOID)
{
  return 0;
}


/* _statusfp ordinal = 459, argument = 0 temporary */
static DWORD WINAPI _statusfp (VOID)
{
  return 0;
}


/* _strcmpi ordinal = 460, argument = 0 */
static int CDECL msvcrt_strcmpi (const char *string1, const char *string2)
{
  gchar *str1, *str2;
  gint result;

  str1 = w32ldr_utf8_from_mb (string1);
  str2 = w32ldr_utf8_from_mb (string2);
  result = g_ascii_strcasecmp (str1, str2);
  g_free (str1);
  g_free (str2);
  return result;
}


/* _strdate ordinal = 461, argument = 0 temporary */
static DWORD WINAPI _strdate (VOID)
{
  return 0;
}


/* _strdup ordinal = 462, argument = 0 temporary */
static DWORD WINAPI msvcrt_strdup (VOID)
{
  return 0;
}


/* _strerror ordinal = 463, argument = 0 temporary */
static DWORD WINAPI _strerror (VOID)
{
  return 0;
}


/* _stricmp ordinal = 464, argument = 0 */
int CDECL _stricmp (const char *string1, const char *string2)
{
  return g_ascii_strcasecmp (string1, string2);
}


/* _stricoll ordinal = 465, argument = 0 temporary */
static DWORD WINAPI _stricoll (VOID)
{
  return 0;
}


/* _strlwr ordinal = 466, argument = 0 */
char CDECL *_strlwr (char *string)
{
  gchar *p;

  if (string)
    for (p = string; *p != '\0'; p++)
      *p = g_ascii_tolower (*p);
  return string;
}


/* _strncoll ordinal = 467, argument = 0 temporary */
static DWORD WINAPI _strncoll (VOID)
{
  return 0;
}


/* _strnicmp ordinal = 468, argument = 0 */
int CDECL _strnicmp (const char *string1, const char *string2, size_t count)
{
  return g_ascii_strncasecmp (string1, string2, count);
}


/* _strnicoll ordinal = 469, argument = 0 temporary */
static DWORD WINAPI _strnicoll (VOID)
{
  return 0;
}


/* _strnset ordinal = 470, argument = 0 temporary */
static DWORD WINAPI _strnset (VOID)
{
  return 0;
}


/* _strrev ordinal = 471, argument = 0 */
char CDECL *_strrev (char *string)
{
  return  g_strreverse (string);
}


/* _strset ordinal = 472, argument = 0 temporary */
static DWORD WINAPI _strset (VOID)
{
  return 0;
}


/* _strtime ordinal = 473, argument = 0 temporary */
static DWORD WINAPI _strtime (VOID)
{
  return 0;
}


/* _strupr ordinal = 474, argument = 0 */
char CDECL *_strupr (char *string)
{
  gchar *p;

  if (string)
    for (p = string; *p != '\0'; p++)
      *p = g_ascii_toupper (*p);
  return string;
}


/* _swab ordinal = 475, argument = 0 temporary */
static DWORD WINAPI msvcrt_swab (VOID)
{
  return 0;
}


/* _sys_errlist ordinal = 476, argument = 0 temporary */
static DWORD WINAPI msvcrt_sys_errlist (VOID)
{
  return 0;
}


/* _sys_nerr ordinal = 477, argument = 0 temporary */
static DWORD WINAPI msvcrt_sys_nerr (VOID)
{
  return 0;
}


/* _tell ordinal = 478, argument = 0 temporary */
static DWORD WINAPI _tell (VOID)
{
  return 0;
}


/* _telli64 ordinal = 479, argument = 0 temporary */
static DWORD WINAPI _telli64 (VOID)
{
  return 0;
}


/* _tempnam ordinal = 480, argument = 0 temporary */
static DWORD WINAPI _tempnam (VOID)
{
  return 0;
}


/* _time64 ordinal = 481, argument = 0 temporary */
static DWORD WINAPI msvcrt_time64 (VOID)
{
  return 0;
}


/* _timezone ordinal = 482, argument = 0 temporary */
static DWORD WINAPI msvcrt_timezone (VOID)
{
  return 0;
}


/* _tolower ordinal = 483, argument = 0 temporary */
static DWORD WINAPI msvcrt__tolower (VOID)
{
  return 0;
}


/* _toupper ordinal = 484, argument = 0 temporary */
static DWORD WINAPI msvcrt__toupper (VOID)
{
  return 0;
}


/* _tzname ordinal = 485, argument = 0 temporary */
static DWORD WINAPI msvcrt_tzname (VOID)
{
  return 0;
}


/* _tzset ordinal = 486, argument = 0 temporary */
static DWORD WINAPI msvcrt_tzset (VOID)
{
  return 0;
}


/* _ui64toa ordinal = 487, argument = 0 */
char CDECL *_ui64toa (guint64 value, char *string, int radix)
{
  gchar *p;

  p = string;
  if (2 <= radix && radix <= 36)
    {
      guint64 s;

      s = value;
      do
        {
          gint t;

          t = s % radix;
          s /= radix;
          if (t < 10)
            *p = t + '0';
          else
            *p = t + 'a';
          p++;
        }
      while (s != 0);
    }
  *p = '\0';
  return g_strreverse (string);
}


/* _ui64tow ordinal = 488, argument = 0 temporary */
static DWORD WINAPI _ui64tow (VOID)
{
  return 0;
}


/* _ultoa ordinal = 489, argument = 0 temporary */
static DWORD WINAPI _ultoa (VOID)
{
  return 0;
}


/* _ultow ordinal = 490, argument = 0 temporary */
static DWORD WINAPI _ultow (VOID)
{
  return 0;
}


/* _umask ordinal = 491, argument = 0 temporary */
static DWORD WINAPI msvcrt_umask (VOID)
{
  return 0;
}


/* _ungetch ordinal = 492, argument = 0 temporary */
static DWORD WINAPI _ungetch (VOID)
{
  return 0;
}


/* _unlink ordinal = 493, argument = 0 */
int CDECL _unlink (const char *filename)
{
  return DeleteFileA (filename) ? 0 : -1;
}


/* _unloaddll ordinal = 494, argument = 0 temporary */
static DWORD WINAPI msvcrt_unloaddll (VOID)
{
  return 0;
}


/* _unlock ordinal = 495, argument = 0 temporary */
static DWORD WINAPI msvcrt_unlock (VOID)
{
  return 0;
}


/* _utime ordinal = 496, argument = 0 temporary */
static DWORD WINAPI _utime (VOID)
{
#ifdef HAVE_UTIME
#else /* not HAVE_UTIME */
#endif /* not HAVE_UTIME */
  return 0;
}


/* _utime64 ordinal = 497, argument = 0 temporary */
static DWORD WINAPI msvcrt_utime64 (VOID)
{
  return 0;
}


/* _vsnprintf ordinal = 498, argument = 0 temporary */
static DWORD WINAPI msvcrt_vsnprintf (VOID)
{
  return 0;
}


/* _vsnwprintf ordinal = 499, argument = 0 temporary */
static DWORD WINAPI _vsnwprintf (VOID)
{
  return 0;
}


/* _waccess ordinal = 500, argument = 0 */
gint CDECL _waccess (const gunichar2 *path, gint mode)
{
  gchar *file;
  int m, result;

  switch (mode)
    {
      case 0: m = F_OK; break;
      case 2: m = W_OK; break;
      case 4: m = R_OK; break;
      case 6: m = R_OK | W_OK; break;
      default: return -1;
    }
  file = w32ldr_filename_from_wc (path);
#if GLIB_CHECK_VERSION(2,8,0)
  result = g_access (file, m);
#else /* not GLIB_CHECK_VERSION(2,8,0) */
  result = access (file, m);
#endif /* not GLIB_CHECK_VERSION(2,8,0) */
  g_free (file);
  return result;
}


/* _wasctime ordinal = 501, argument = 0 temporary */
static DWORD WINAPI _wasctime (VOID)
{
  return 0;
}


/* _wchdir ordinal = 502, argument = 0 */
int CDECL _wchdir (const gunichar2 *dirname)
{
  gchar *path;
  int result;

  path = w32ldr_filename_from_wc (dirname);
#if GLIB_CHECK_VERSION(2,8,0)
  result = g_chdir (path);
#else /* not GLIB_CHECK_VERSION(2,8,0) */
  result = chdir (path);
#endif /* not GLIB_CHECK_VERSION(2,8,0) */
  g_free (path);
  return result;
}


/* _wchmod ordinal = 503, argument = 0 */
int CDECL _wchmod (const gunichar2 *filename, int pmode)
{
  gchar *file;
  int result;
  struct stat buf;

  file = w32ldr_filename_from_wc (filename);
#if GLIB_CHECK_VERSION(2,8,0)
  result = g_stat (file, &buf);
#else /* not GLIB_CHECK_VERSION(2,8,0) */
  result = stat (file, &buf);
#endif /* not GLIB_CHECK_VERSION(2,8,0) */
  if (result == 0)
    {
      mode_t m;

      m = buf.st_mode;
      if (pmode & _S_IREAD)
        m |= S_IRUSR;
      else
        m &= ~(S_IRUSR | S_IRGRP | S_IROTH);
      if (pmode & _S_IWRITE)
        m |= S_IWUSR;
      else
        m &= ~(S_IWUSR | S_IWGRP | S_IWOTH);
#if GLIB_CHECK_VERSION(2,8,0)
      result = g_chmod (file, m);
#else /* not GLIB_CHECK_VERSION(2,8,0) */
      result = chmod (file, m);
#endif /* not GLIB_CHECK_VERSION(2,8,0) */
    }
  g_free (file);
  return result;
}


/* _wcmdln ordinal = 504, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcmdln (VOID)
{
  return 0;
}


/* _wcreat ordinal = 505, argument = 0 */
int CDECL _wcreat (const gunichar2 *filename, int pmode)
{
  gchar *file;
  int result;
  mode_t m = 0;

  m = pmode & _S_IREAD ? S_IRUSR | S_IRGRP | S_IROTH : 0;
  if (pmode & _S_IWRITE)
    m |= S_IWUSR;
  file = w32ldr_filename_from_wc (filename);
#if GLIB_CHECK_VERSION(2,8,0)
  result = g_creat (file, m);
#else /* not GLIB_CHECK_VERSION(2,8,0) */
  result = creat (file, m);
#endif /* not GLIB_CHECK_VERSION(2,8,0) */
  g_free (file);
  return result;
}


/* _wcsdup ordinal = 506, argument = 0 temporary */
static DWORD WINAPI _wcsdup (VOID)
{
  return 0;
}


/* _wcsicmp ordinal = 507, argument = 0 temporary */
static DWORD WINAPI _wcsicmp (VOID)
{
  return 0;
}


/* _wcsicoll ordinal = 508, argument = 0 temporary */
static DWORD WINAPI _wcsicoll (VOID)
{
  return 0;
}


/* _wcslwr ordinal = 509, argument = 0 temporary */
static DWORD WINAPI _wcslwr (VOID)
{
  return 0;
}


/* _wcsncoll ordinal = 510, argument = 0 temporary */
static DWORD WINAPI _wcsncoll (VOID)
{
  return 0;
}


/* _wcsnicmp ordinal = 511, argument = 0 temporary */
static DWORD WINAPI _wcsnicmp (VOID)
{
  return 0;
}


/* _wcsnicoll ordinal = 512, argument = 0 temporary */
static DWORD WINAPI _wcsnicoll (VOID)
{
  return 0;
}


/* _wcsnset ordinal = 513, argument = 0 temporary */
static DWORD WINAPI _wcsnset (VOID)
{
  return 0;
}


/* _wcsrev ordinal = 514, argument = 0 */
gunichar2 CDECL *_wcsrev (gunichar2 *string)
{
  if (string)
    {
      gunichar2 *p, *q;

      p = string;
      q = p + lstrlenW (p) - 1;
      while (p < q)
        {
          gunichar2 c;

          c = *p;
          *p = *q;
          *q = c;
          p++;
          q--;
        }
    }
  return string;
}


/* _wcsset ordinal = 515, argument = 0 temporary */
static DWORD WINAPI _wcsset (VOID)
{
  return 0;
}


/* _wcsupr ordinal = 516, argument = 0 temporary */
static DWORD WINAPI _wcsupr (VOID)
{
  return 0;
}


/* _wctime ordinal = 517, argument = 0 temporary */
static DWORD WINAPI msvcrt_wctime (VOID)
{
  return 0;
}


/* _wctime64 ordinal = 518, argument = 0 temporary */
static DWORD WINAPI msvcrt_wctime64 (VOID)
{
  return 0;
}


/* _wenviron ordinal = 519, argument = 0 temporary */
static DWORD WINAPI msvcrt_wenviron (VOID)
{
  return 0;
}


/* _wexecl ordinal = 520, argument = 0 */
int CDECL _wexecl (const gunichar2 *cmdname, const gunichar2 *arg0, ...)
{
  return -1;
}


/* _wexecle ordinal = 521, argument = 0 */
int CDECL _wexecle (const gunichar2 *cmdname, const gunichar2 *arg0, ...)
{
  return -1;
}


/* _wexeclp ordinal = 522, argument = 0 */
int CDECL _wexeclp (const gunichar2 *cmdname, const gunichar2 *arg0, ...)
{
  return -1;
}


/* _wexeclpe ordinal = 523, argument = 0 */
int CDECL _wexeclpe (const gunichar2 *cmdname, const gunichar2 *arg0, ...)
{
  return -1;
}


/* _wexecv ordinal = 524, argument = 0 */
int CDECL _wexecv (const gunichar2 *cmdname, const gunichar2 * const *argv)
{
  return -1;
}


/* _wexecve ordinal = 525, argument = 0 */
int CDECL _wexecve (const gunichar2 *cmdname, const gunichar2 *const *argv, const gunichar2 * const *envp)
{
  return -1;
}


/* _wexecvp ordinal = 526, argument = 0 */
int CDECL _wexecvp (const gunichar2 *cmdname, const gunichar2 * const *argv)
{
  return -1;
}


/* _wexecvpe ordinal = 527, argument = 0 */
int CDECL _wexecvpe (const gunichar2 *cmdname, const gunichar2 * const *argv, const gunichar2 * const *envp)
{
  return -1;
}


/* _wfdopen ordinal = 528, argument = 0 */
FILE CDECL *_wfdopen (int handle, const gunichar2 *mode)
{
  FILE *fp = NULL;

  if (mode)
    {
      gchar *utf8str;

      utf8str = g_utf16_to_utf8 (mode, -1, NULL, NULL, NULL);
      if (utf8str)
        {
          gchar *locale;

          locale = g_locale_from_utf8 (utf8str, -1, NULL, NULL, NULL);
          if (locale)
            {
              fp = fdopen (handle, locale);
              g_free (locale);
            }
          g_free (utf8str);
        }
    }
  return fp;
}


/* _wfindfirst ordinal = 529, argument = 0 temporary */
static DWORD WINAPI _wfindfirst (VOID)
{
  return 0;
}


/* _wfindfirst64 ordinal = 530, argument = 0 temporary */
static DWORD WINAPI _wfindfirst64 (VOID)
{
  return 0;
}


/* _wfindfirsti64 ordinal = 531, argument = 0 temporary */
static DWORD WINAPI _wfindfirsti64 (VOID)
{
  return 0;
}


/* _wfindnext ordinal = 532, argument = 0 temporary */
static DWORD WINAPI _wfindnext (VOID)
{
  return 0;
}


/* _wfindnext64 ordinal = 533, argument = 0 temporary */
static DWORD WINAPI _wfindnext64 (VOID)
{
  return 0;
}


/* _wfindnexti64 ordinal = 534, argument = 0 temporary */
static DWORD WINAPI _wfindnexti64 (VOID)
{
  return 0;
}


/* _wfopen ordinal = 535, argument = 0 */
FILE CDECL *_wfopen (const gunichar2 *filename, const gunichar2 *mode)
{
  FILE *fp = NULL;

  if (mode)
    {
      gchar *utf8str;

      utf8str = g_utf16_to_utf8 (mode, -1, NULL, NULL, NULL);
      if (utf8str)
        {
          gchar *locale;

          locale = g_locale_from_utf8 (utf8str, -1, NULL, NULL, NULL);
          if (locale)
            {
              gchar *file;

              file = w32ldr_filename_from_wc (filename);
              if (file)
                {
#if GLIB_CHECK_VERSION(2,6,0)
                  fp = g_fopen (file, locale);
#else /* not GLIB_CHECK_VERSION(2,6,0) */
                  fp = fopen (file, locale);
#endif /* not GLIB_CHECK_VERSION(2,6,0) */
                  g_free (file);
                }
              g_free (locale);
            }
          g_free (utf8str);
        }
    }
  return fp;
}


/* _wfreopen ordinal = 536, argument = 0 */
FILE CDECL *_wfreopen (const gunichar2 *filename, const gunichar2 *mode, FILE *stream)
{
  FILE *fp = NULL;

  if (mode)
    {
      gchar *utf8str;

      utf8str = g_utf16_to_utf8 (mode, -1, NULL, NULL, NULL);
      if (utf8str)
        {
          gchar *locale;

          locale = g_locale_from_utf8 (utf8str, -1, NULL, NULL, NULL);
          if (locale)
            {
              gchar *file;

              file = w32ldr_filename_from_wc (filename);
              if (file)
                {
#if GLIB_CHECK_VERSION(2,6,0)
                  fp = g_freopen (file, locale, stream);
#else /* not GLIB_CHECK_VERSION(2,6,0) */
                  fp = freopen (file, locale, stream);
#endif /* not GLIB_CHECK_VERSION(2,6,0) */
                  g_free (file);
                }
              g_free (locale);
            }
          g_free (utf8str);
        }
    }
  return fp;
}


/* _wfsopen ordinal = 537, argument = 0 */
FILE CDECL *_wfsopen (const gunichar2 *filename, const gunichar2 *mode, int shflag)
{
  return _wfopen (filename, mode);
}


/* _wfullpath ordinal = 538, argument = 0 temporary */
static DWORD WINAPI _wfullpath (VOID)
{
  return 0;
}


/* _wgetcwd ordinal = 539, argument = 0 temporary */
static DWORD WINAPI _wgetcwd (VOID)
{
  return 0;
}


/* _wgetdcwd ordinal = 540, argument = 0 temporary */
static DWORD WINAPI _wgetdcwd (VOID)
{
  return 0;
}


/* _wgetenv ordinal = 541, argument = 0 temporary */
static DWORD WINAPI _wgetenv (VOID)
{
  return 0;
}


/* _winmajor ordinal = 542, argument = 0 temporary */
static DWORD WINAPI msvcrt_winmajor (VOID)
{
  return 0;
}


/* _winminor ordinal = 543, argument = 0 temporary */
static DWORD WINAPI msvcrt_winminor (VOID)
{
  return 0;
}


/* _winver ordinal = 544, argument = 0 temporary */
static DWORD WINAPI msvcrt_winver (VOID)
{
  return 0;
}


/* _wmakepath ordinal = 545, argument = 0 temporary */
static DWORD WINAPI _wmakepath (VOID)
{
  return 0;
}


/* _wmkdir ordinal = 546, argument = 0 */
int CDECL _wmkdir (const gunichar2 *dirname)
{
  return CreateDirectoryW (dirname, NULL) ? 0 : -1;
}


/* _wmktemp ordinal = 547, argument = 0 temporary */
static DWORD WINAPI _wmktemp (VOID)
{
  return 0;
}


/* _wopen ordinal = 548, argument = 0 temporary */
static DWORD WINAPI _wopen (VOID)
{
  return 0;
}


/* _wperror ordinal = 549, argument = 0 temporary */
static DWORD WINAPI _wperror (VOID)
{
  return 0;
}


/* _wpgmptr ordinal = 550, argument = 0 temporary */
static DWORD WINAPI msvcrt_wpgmptr (VOID)
{
  return 0;
}


/* _wpopen ordinal = 551, argument = 0 temporary */
static DWORD WINAPI _wpopen (VOID)
{
  return 0;
}


/* _wputenv ordinal = 552, argument = 0 temporary */
static DWORD WINAPI _wputenv (VOID)
{
  return 0;
}


/* _wremove ordinal = 553, argument = 0 temporary */
static DWORD WINAPI _wremove (VOID)
{
  return 0;
}


/* _wrename ordinal = 554, argument = 0 temporary */
static DWORD WINAPI _wrename (VOID)
{
  return 0;
}


/* _write ordinal = 555, argument = 0 temporary */
static DWORD WINAPI msvcrt_write (VOID)
{
  return 0;
}


/* _wrmdir ordinal = 556, argument = 0 temporary */
static DWORD WINAPI _wrmdir (VOID)
{
  return 0;
}


/* _wsearchenv ordinal = 557, argument = 0 temporary */
static DWORD WINAPI _wsearchenv (VOID)
{
  return 0;
}


/* _wsetlocale ordinal = 558, argument = 0 temporary */
static DWORD WINAPI _wsetlocale (VOID)
{
  return 0;
}


/* _wsopen ordinal = 559, argument = 0 temporary */
static DWORD WINAPI _wsopen (VOID)
{
  return 0;
}


/* _wspawnl ordinal = 560, argument = 0 temporary */
static DWORD WINAPI _wspawnl (VOID)
{
  return 0;
}


/* _wspawnle ordinal = 561, argument = 0 temporary */
static DWORD WINAPI _wspawnle (VOID)
{
  return 0;
}


/* _wspawnlp ordinal = 562, argument = 0 temporary */
static DWORD WINAPI _wspawnlp (VOID)
{
  return 0;
}


/* _wspawnlpe ordinal = 563, argument = 0 temporary */
static DWORD WINAPI _wspawnlpe (VOID)
{
  return 0;
}


/* _wspawnv ordinal = 564, argument = 0 temporary */
static DWORD WINAPI _wspawnv (VOID)
{
  return 0;
}


/* _wspawnve ordinal = 565, argument = 0 temporary */
static DWORD WINAPI _wspawnve (VOID)
{
  return 0;
}


/* _wspawnvp ordinal = 566, argument = 0 temporary */
static DWORD WINAPI _wspawnvp (VOID)
{
  return 0;
}


/* _wspawnvpe ordinal = 567, argument = 0 temporary */
static DWORD WINAPI _wspawnvpe (VOID)
{
  return 0;
}


/* _wsplitpath ordinal = 568, argument = 0 temporary */
static DWORD WINAPI _wsplitpath (VOID)
{
  return 0;
}


/* _wstat ordinal = 569, argument = 0 temporary */
static DWORD WINAPI _wstat (VOID)
{
  return 0;
}


/* _wstat64 ordinal = 570, argument = 0 temporary */
static DWORD WINAPI msvcrt_wstat64 (VOID)
{
  return 0;
}


/* _wstati64 ordinal = 571, argument = 0 temporary */
static DWORD WINAPI _wstati64 (VOID)
{
  return 0;
}


/* _wstrdate ordinal = 572, argument = 0 temporary */
static DWORD WINAPI _wstrdate (VOID)
{
  return 0;
}


/* _wstrtime ordinal = 573, argument = 0 temporary */
static DWORD WINAPI _wstrtime (VOID)
{
  return 0;
}


/* _wsystem ordinal = 574, argument = 0 temporary */
static DWORD WINAPI _wsystem (VOID)
{
  return 0;
}


/* _wtempnam ordinal = 575, argument = 0 temporary */
static DWORD WINAPI _wtempnam (VOID)
{
  return 0;
}


/* _wtmpnam ordinal = 576, argument = 0 temporary */
static DWORD WINAPI _wtmpnam (VOID)
{
  return 0;
}


/* _wtoi ordinal = 577, argument = 0 temporary */
static DWORD WINAPI _wtoi (VOID)
{
  return 0;
}


/* _wtoi64 ordinal = 578, argument = 0 temporary */
static DWORD WINAPI msvcrt_wtoi64 (VOID)
{
  return 0;
}


/* _wtol ordinal = 579, argument = 0 temporary */
static DWORD WINAPI _wtol (VOID)
{
  return 0;
}


/* _wunlink ordinal = 580, argument = 0 */
int CDECL _wunlink (const gunichar2 *filename)
{
  return DeleteFileW (filename) ? 0 : -1;
}


/* _wutime ordinal = 581, argument = 0 temporary */
static DWORD WINAPI _wutime (VOID)
{
  return 0;
}


/* _wutime64 ordinal = 582, argument = 0 temporary */
static DWORD WINAPI msvcrt_wutime64 (VOID)
{
  return 0;
}


/* _y0 ordinal = 583, argument = 0 temporary */
static DWORD WINAPI msvcrt_y0 (VOID)
{
  return 0;
}


/* _y1 ordinal = 584, argument = 0 temporary */
static DWORD WINAPI msvcrt_y1 (VOID)
{
  return 0;
}


/* _yn ordinal = 585, argument = 0 temporary */
static DWORD WINAPI msvcrt_yn (VOID)
{
  return 0;
}


/* abort ordinal = 586, argument = 0 temporary */
static DWORD WINAPI msvcrt_abort (VOID)
{
  return 0;
}


/* abs ordinal = 587, argument = 0 temporary */
static DWORD WINAPI msvcrt_abs (VOID)
{
  return 0;
}


/* acos ordinal = 588, argument = 0 temporary */
static DWORD WINAPI msvcrt_acos (VOID)
{
  return 0;
}


/* asctime ordinal = 589, argument = 0 temporary */
static DWORD WINAPI msvcrt_asctime (VOID)
{
  return 0;
}


/* asin ordinal = 590, argument = 0 temporary */
static DWORD WINAPI msvcrt_asin (VOID)
{
  return 0;
}


/* atan ordinal = 591, argument = 0 temporary */
static DWORD WINAPI msvcrt_atan (VOID)
{
  return 0;
}


/* atan2 ordinal = 592, argument = 0 temporary */
static DWORD WINAPI msvcrt_atan2 (VOID)
{
  return 0;
}


/* atexit ordinal = 593, argument = 0 temporary */
static DWORD WINAPI msvcrt_atexit (VOID)
{
  return 0;
}


/* atof ordinal = 594, argument = 0 */
static CDECL double msvcrt_atof (const char *string)
{
  return g_strtod (string, NULL);
}


/* atoi ordinal = 595, argument = 0 temporary */
static DWORD WINAPI msvcrt_atoi (VOID)
{
  return 0;
}


/* atol ordinal = 596, argument = 0 temporary */
static DWORD WINAPI msvcrt_atol (VOID)
{
  return 0;
}


/* bsearch ordinal = 597, argument = 0 temporary */
static DWORD WINAPI msvcrt_bsearch (VOID)
{
  return 0;
}


/* calloc ordinal = 598, argument = 0 temporary */
static DWORD WINAPI msvcrt_calloc (VOID)
{
  return 0;
}


/* ceil ordinal = 599, argument = 0 temporary */
static DWORD WINAPI msvcrt_ceil (VOID)
{
  return 0;
}


/* clearerr ordinal = 600, argument = 0 temporary */
static DWORD WINAPI msvcrt_clearerr (VOID)
{
  return 0;
}


/* clock ordinal = 601, argument = 0 temporary */
static DWORD WINAPI msvcrt_clock (VOID)
{
  return 0;
}


/* cos ordinal = 602, argument = 0 temporary */
static DWORD WINAPI msvcrt_cos (VOID)
{
  return 0;
}


/* cosh ordinal = 603, argument = 0 temporary */
static DWORD WINAPI msvcrt_cosh (VOID)
{
  return 0;
}


/* ctime ordinal = 604, argument = 0 temporary */
static DWORD WINAPI msvcrt_ctime (VOID)
{
  return 0;
}


/* difftime ordinal = 605, argument = 0 temporary */
static DWORD WINAPI msvcrt_difftime (VOID)
{
  return 0;
}


/* div ordinal = 606, argument = 0 temporary */
static DWORD WINAPI msvcrt_div (VOID)
{
  return 0;
}


/* exit ordinal = 607, argument = 0 */
static void CDECL msvcrt_exit (int status)
{
  exit (status);
}


/* exp ordinal = 608, argument = 0 temporary */
static DWORD WINAPI msvcrt_exp (VOID)
{
  return 0;
}


/* fabs ordinal = 609, argument = 0 temporary */
static DWORD WINAPI msvcrt_fabs (VOID)
{
  return 0;
}


/* fclose ordinal = 610, argument = 0 temporary */
static DWORD WINAPI msvcrt_fclose (VOID)
{
  return 0;
}


/* feof ordinal = 611, argument = 0 temporary */
static DWORD WINAPI msvcrt_feof (VOID)
{
  return 0;
}


/* ferror ordinal = 612, argument = 0 temporary */
static DWORD WINAPI msvcrt_ferror (VOID)
{
  return 0;
}


/* fflush ordinal = 613, argument = 0 temporary */
static DWORD WINAPI msvcrt_fflush (VOID)
{
  return 0;
}


/* fgetc ordinal = 614, argument = 0 temporary */
static DWORD WINAPI msvcrt_fgetc (VOID)
{
  return 0;
}


/* fgetpos ordinal = 615, argument = 0 temporary */
static DWORD WINAPI msvcrt_fgetpos (VOID)
{
  return 0;
}


/* fgets ordinal = 616, argument = 0 temporary */
static DWORD WINAPI msvcrt_fgets (VOID)
{
  return 0;
}


/* fgetwc ordinal = 617, argument = 0 temporary */
static DWORD WINAPI msvcrt_fgetwc (VOID)
{
  return 0;
}


/* fgetws ordinal = 618, argument = 0 temporary */
static DWORD WINAPI msvcrt_fgetws (VOID)
{
  return 0;
}


/* floor ordinal = 619, argument = 0 temporary */
static DWORD WINAPI msvcrt_floor (VOID)
{
  return 0;
}


/* fmod ordinal = 620, argument = 0 temporary */
static DWORD WINAPI msvcrt_fmod (VOID)
{
  return 0;
}


/* fopen ordinal = 621, argument = 0 */
static FILE CDECL *msvcrt_fopen (const char *filename, const char *mode)
{
  gchar *utf8str;
  FILE *fp = NULL;

  utf8str = w32ldr_utf8_from_mb (mode);
  if (utf8str)
    {
      gchar *locale;

      locale = g_locale_from_utf8 (utf8str, -1, NULL, NULL, NULL);
      if (locale)
        {
          gchar *file;

          file = w32ldr_filename_from_mb (filename);
          if (file)
            {
#if GLIB_CHECK_VERSION(2,6,0)
              fp = g_fopen (file, locale);
#else /* not GLIB_CHECK_VERSION(2,6,0) */
              fp = fopen (file, locale);
#endif /* not GLIB_CHECK_VERSION(2,6,0) */
              g_free (file);
            }
          g_free (locale);
        }
      g_free (utf8str);
    }
  return fp;
}


/* fprintf ordinal = 622, argument = 0 temporary */
static DWORD WINAPI msvcrt_fprintf (VOID)
{
  return 0;
}


/* fputc ordinal = 623, argument = 0 temporary */
static DWORD WINAPI msvcrt_fputc (VOID)
{
  return 0;
}


/* fputs ordinal = 624, argument = 0 temporary */
static DWORD WINAPI msvcrt_fputs (VOID)
{
  return 0;
}


/* fputwc ordinal = 625, argument = 0 temporary */
static DWORD WINAPI msvcrt_fputwc (VOID)
{
  return 0;
}


/* fputws ordinal = 626, argument = 0 temporary */
static DWORD WINAPI msvcrt_fputws (VOID)
{
  return 0;
}


/* fread ordinal = 627, argument = 0 temporary */
static DWORD WINAPI msvcrt_fread (VOID)
{
  return 0;
}


/* free ordinal = 628, argument = 0 */
static void msvcrt_free (void *memblock)
{
  g_free (memblock);
}


/* freopen ordinal = 629, argument = 0 */
static FILE CDECL *msvcrt_freopen (const char *filename, const char *mode, FILE *stream)
{
  gchar *utf8str;
  FILE *fp = NULL;

  utf8str = w32ldr_utf8_from_mb (mode);
  if (utf8str)
    {
      gchar *locale;

      locale = g_locale_from_utf8 (utf8str, -1, NULL, NULL, NULL);
      if (locale)
        {
          gchar *file;

          file = w32ldr_filename_from_mb (filename);
          if (file)
            {
#if GLIB_CHECK_VERSION(2,6,0)
              fp = g_freopen (file, locale, stream);
#else /* not GLIB_CHECK_VERSION(2,6,0) */
              fp = freopen (file, locale, stream);
#endif /* not GLIB_CHECK_VERSION(2,6,0) */
              g_free (file);
            }
          g_free (locale);
        }
      g_free (utf8str);
    }
  return fp;
}


/* frexp ordinal = 630, argument = 0 temporary */
static DWORD WINAPI msvcrt_frexp (VOID)
{
  return 0;
}


/* fscanf ordinal = 631, argument = 0 */
static int CDECL msvcrt_fscanf (FILE *stream, const char *format, ...)
{
  return 0;
}


/* fseek ordinal = 632, argument = 0 temporary */
static DWORD WINAPI msvcrt_fseek (VOID)
{
  return 0;
}


/* fsetpos ordinal = 633, argument = 0 temporary */
static DWORD WINAPI msvcrt_fsetpos (VOID)
{
  return 0;
}


/* ftell ordinal = 634, argument = 0 temporary */
static DWORD WINAPI msvcrt_ftell (VOID)
{
  return 0;
}


/* fwprintf ordinal = 635, argument = 0 temporary */
static DWORD WINAPI msvcrt_fwprintf (VOID)
{
  return 0;
}


/* fwrite ordinal = 636, argument = 0 temporary */
static DWORD WINAPI msvcrt_fwrite (VOID)
{
  return 0;
}


/* fwscanf ordinal = 637, argument = 0 */
int CDECL fwscanf (FILE *stream, const gunichar2 *format, ...)
{
  return 0;
}


/* getc ordinal = 638, argument = 0 temporary */
static DWORD WINAPI msvcrt_getc (VOID)
{
  return 0;
}


/* getchar ordinal = 639, argument = 0 temporary */
static DWORD WINAPI msvcrt_getchar (VOID)
{
  return 0;
}


/* getenv ordinal = 640, argument = 0 temporary */
static DWORD WINAPI msvcrt_getenv (VOID)
{
  return 0;
}


/* gets ordinal = 641, argument = 0 temporary */
static DWORD WINAPI msvcrt_gets (VOID)
{
  return 0;
}


/* getwc ordinal = 642, argument = 0 temporary */
static DWORD WINAPI msvcrt_getwc (VOID)
{
  return 0;
}


/* getwchar ordinal = 643, argument = 0 temporary */
static DWORD WINAPI msvcrt_getwchar (VOID)
{
  return 0;
}


/* gmtime ordinal = 644, argument = 0 temporary */
static DWORD WINAPI msvcrt_gmtime (VOID)
{
  return 0;
}


/* is_wctype ordinal = 645, argument = 0 temporary */
static DWORD WINAPI msvcrt_is_wctype (VOID)
{
  return 0;
}


/* isalnum ordinal = 646, argument = 0 */
static int CDECL msvcrt_isalnum (int c)
{
  return g_ascii_isalnum (c);
}


/* isalpha ordinal = 647, argument = 0 temporary */
static DWORD WINAPI msvcrt_isalpha (VOID)
{
  return 0;
}


/* iscntrl ordinal = 648, argument = 0 temporary */
static DWORD WINAPI msvcrt_iscntrl (VOID)
{
  return 0;
}


/* isdigit ordinal = 649, argument = 0 temporary */
static DWORD WINAPI msvcrt_isdigit (VOID)
{
  return 0;
}


/* isgraph ordinal = 650, argument = 0 temporary */
static DWORD WINAPI msvcrt_isgraph (VOID)
{
  return 0;
}


/* isleadbyte ordinal = 651, argument = 0 */
int CDECL isleadbyte (int c)
{
  return 0 <= c && c <= 256 ? IsDBCSLeadByte ((BYTE)c) : 0;
}


/* islower ordinal = 652, argument = 0 temporary */
static DWORD WINAPI msvcrt_islower (VOID)
{
  return 0;
}


/* isprint ordinal = 653, argument = 0 temporary */
static DWORD WINAPI msvcrt_isprint (VOID)
{
  return 0;
}


/* ispunct ordinal = 654, argument = 0 temporary */
static DWORD WINAPI msvcrt_ispunct (VOID)
{
  return 0;
}


/* isspace ordinal = 655, argument = 0 temporary */
static DWORD WINAPI msvcrt_isspace (VOID)
{
  return 0;
}


/* isupper ordinal = 656, argument = 0 temporary */
static DWORD WINAPI msvcrt_isupper (VOID)
{
  return 0;
}


/* iswalnum ordinal = 657, argument = 0 temporary */
static DWORD WINAPI msvcrt_iswalnum (VOID)
{
  return 0;
}


/* iswalpha ordinal = 658, argument = 0 temporary */
static DWORD WINAPI msvcrt_iswalpha (VOID)
{
  return 0;
}


/* iswascii ordinal = 659, argument = 0 temporary */
static DWORD WINAPI iswascii (VOID)
{
  return 0;
}


/* iswcntrl ordinal = 660, argument = 0 temporary */
static DWORD WINAPI msvcrt_iswcntrl (VOID)
{
  return 0;
}


/* iswctype ordinal = 661, argument = 0 temporary */
static DWORD WINAPI msvcrt_iswctype (VOID)
{
  return 0;
}


/* iswdigit ordinal = 662, argument = 0 temporary */
static DWORD WINAPI msvcrt_iswdigit (VOID)
{
  return 0;
}


/* iswgraph ordinal = 663, argument = 0 temporary */
static DWORD WINAPI msvcrt_iswgraph (VOID)
{
  return 0;
}


/* iswlower ordinal = 664, argument = 0 temporary */
static DWORD WINAPI msvcrt_iswlower (VOID)
{
  return 0;
}


/* iswprint ordinal = 665, argument = 0 temporary */
static DWORD WINAPI msvcrt_iswprint (VOID)
{
  return 0;
}


/* iswpunct ordinal = 666, argument = 0 temporary */
static DWORD WINAPI msvcrt_iswpunct (VOID)
{
  return 0;
}


/* iswspace ordinal = 667, argument = 0 temporary */
static DWORD WINAPI msvcrt_iswspace (VOID)
{
  return 0;
}


/* iswupper ordinal = 668, argument = 0 temporary */
static DWORD WINAPI msvcrt_iswupper (VOID)
{
  return 0;
}


/* iswxdigit ordinal = 669, argument = 0 temporary */
static DWORD WINAPI msvcrt_iswxdigit (VOID)
{
  return 0;
}


/* isxdigit ordinal = 670, argument = 0 temporary */
static DWORD WINAPI msvcrt_isxdigit (VOID)
{
  return 0;
}


/* labs ordinal = 671, argument = 0 temporary */
static DWORD WINAPI msvcrt_labs (VOID)
{
  return 0;
}


/* ldexp ordinal = 672, argument = 0 temporary */
static DWORD WINAPI msvcrt_ldexp (VOID)
{
  return 0;
}


/* ldiv ordinal = 673, argument = 0 temporary */
static DWORD WINAPI msvcrt_ldiv (VOID)
{
  return 0;
}


/* localeconv ordinal = 674, argument = 0 temporary */
static DWORD WINAPI msvcrt_localeconv (VOID)
{
  return 0;
}


/* localtime ordinal = 675, argument = 0 temporary */
static DWORD WINAPI msvcrt_localtime (VOID)
{
  return 0;
}


/* log ordinal = 676, argument = 0 temporary */
static DWORD WINAPI msvcrt_log (VOID)
{
  return 0;
}


/* log10 ordinal = 677, argument = 0 temporary */
static DWORD WINAPI msvcrt_log10 (VOID)
{
  return 0;
}


/* longjmp ordinal = 678, argument = 0 temporary */
static DWORD WINAPI msvcrt_longjmp (VOID)
{
  return 0;
}


/* malloc ordinal = 679, argument = 0 */
static void CDECL *msvcrt_malloc (size_t size)
{
  return g_malloc (size);
}


/* mblen ordinal = 680, argument = 0 temporary */
static DWORD WINAPI msvcrt_mblen (VOID)
{
  return 0;
}


/* mbstowcs ordinal = 681, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbstowcs (VOID)
{
  return 0;
}


/* mbtowc ordinal = 682, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbtowc (VOID)
{
  return 0;
}


/* memchr ordinal = 683, argument = 0 temporary */
static DWORD WINAPI msvcrt_memchr (VOID)
{
  return 0;
}


/* memcmp ordinal = 684, argument = 0 temporary */
static DWORD WINAPI msvcrt_memcmp (VOID)
{
  return 0;
}


/* memcpy ordinal = 685, argument = 0 */
static void CDECL *msvcrt_memcpy (void *dst, const void *src, size_t n)
{
  g_memmove (dst, src, n);
  return dst;
}


/* memmove ordinal = 686, argument = 0 */
static void CDECL *msvcrt_memmove (void *dst, const void *src, size_t n)
{
  g_memmove (dst, src, n);
  return dst;
}


/* memset ordinal = 687, argument = 0 temporary */
static DWORD WINAPI msvcrt_memset (VOID)
{
  return 0;
}


/* mktime ordinal = 688, argument = 0 temporary */
static DWORD WINAPI msvcrt_mktime (VOID)
{
  return 0;
}


/* modf ordinal = 689, argument = 0 temporary */
static DWORD WINAPI msvcrt_modf (VOID)
{
  return 0;
}


/* perror ordinal = 690, argument = 0 temporary */
static DWORD WINAPI msvcrt_perror (VOID)
{
  return 0;
}


/* pow ordinal = 691, argument = 0 temporary */
static DWORD WINAPI msvcrt_pow (VOID)
{
  return 0;
}


/* printf ordinal = 692, argument = 0 temporary */
static DWORD WINAPI msvcrt_printf (VOID)
{
  return 0;
}


/* putc ordinal = 693, argument = 0 temporary */
static DWORD WINAPI msvcrt_putc (VOID)
{
  return 0;
}


/* putchar ordinal = 694, argument = 0 temporary */
static DWORD WINAPI msvcrt_putchar (VOID)
{
  return 0;
}


/* puts ordinal = 695, argument = 0 temporary */
static DWORD WINAPI msvcrt_puts (VOID)
{
  return 0;
}


/* putwc ordinal = 696, argument = 0 temporary */
static DWORD WINAPI msvcrt_putwc (VOID)
{
  return 0;
}


/* putwchar ordinal = 697, argument = 0 temporary */
static DWORD WINAPI msvcrt_putwchar (VOID)
{
  return 0;
}


/* qsort ordinal = 698, argument = 0 temporary */
static DWORD WINAPI msvcrt_qsort (VOID)
{
  return 0;
}


/* raise ordinal = 699, argument = 0 temporary */
static DWORD WINAPI msvcrt_raise (VOID)
{
  return 0;
}


/* rand ordinal = 700, argument = 0 */
static int CDECL msvcrt_rand (void)
{
  return rand ();
}


/* realloc ordinal = 701, argument = 0 temporary */
static DWORD WINAPI msvcrt_realloc (VOID)
{
  return 0;
}


/* remove ordinal = 702, argument = 0 temporary */
static DWORD WINAPI msvcrt_remove (VOID)
{
  return 0;
}


/* rename ordinal = 703, argument = 0 temporary */
static DWORD WINAPI msvcrt_rename (VOID)
{
  return 0;
}


/* rewind ordinal = 704, argument = 0 temporary */
static DWORD WINAPI msvcrt_rewind (VOID)
{
  return 0;
}


/* scanf ordinal = 705, argument = 0 */
static int CDECL msvcrt_scanf (const char *format, ...)
{
  return 0;
}


/* setbuf ordinal = 706, argument = 0 temporary */
static DWORD WINAPI msvcrt_setbuf (VOID)
{
  return 0;
}


/* setlocale ordinal = 707, argument = 0 temporary */
static DWORD WINAPI msvcrt_setlocale (VOID)
{
  return 0;
}


/* setvbuf ordinal = 708, argument = 0 temporary */
static DWORD WINAPI msvcrt_setvbuf (VOID)
{
#ifdef SETVBUF_REVERSED
#else /* not SETVBUF_REVERSED */
#endif /* not SETVBUF_REVERSED */
  return 0;
}


/* signal ordinal = 709, argument = 0 temporary */
static DWORD WINAPI msvcrt_signal (VOID)
{
  return 0;
}


/* sin ordinal = 710, argument = 0 temporary */
static DWORD WINAPI msvcrt_sin (VOID)
{
  return 0;
}


/* sinh ordinal = 711, argument = 0 temporary */
static DWORD WINAPI msvcrt_sinh (VOID)
{
  return 0;
}


/* sprintf ordinal = 712, argument = 0 temporary */
static DWORD WINAPI msvcrt_sprintf (VOID)
{
  return 0;
}


/* sqrt ordinal = 713, argument = 0 temporary */
static DWORD WINAPI msvcrt_sqrt (VOID)
{
  return 0;
}


/* srand ordinal = 714, argument = 0 */
static void CDECL msvcrt_srand (unsigned int seed)
{
  return srand (seed);
}


/* sscanf ordinal = 715, argument = 0 */
static int CDECL msvcrt_sscanf (const char *buffer, const char *format, ...)
{
  return 0;
}


/* strcat ordinal = 716, argument = 0 temporary */
static DWORD WINAPI msvcrt_strcat (VOID)
{
  return 0;
}


/* strchr ordinal = 717, argument = 0 */
static char CDECL *msvcrt_strchr (const char *string, int c)
{
  return g_strchr (string, c);
}


/* strcmp ordinal = 718, argument = 0 temporary */
static DWORD WINAPI msvcrt_strcmp (VOID)
{
  return 0;
}


/* strcoll ordinal = 719, argument = 0 temporary */
static DWORD WINAPI msvcrt_strcoll (VOID)
{
#ifdef HAVE_STRCOLL
#else /* not HAVE_STRCOLL */
#endif  /* not HAVE_STRCOLL */
  return 0;
}


/* strcpy ordinal = 720, argument = 0 temporary */
static DWORD WINAPI msvcrt_strcpy (VOID)
{
  return 0;
}


/* strcspn ordinal = 721, argument = 0 temporary */
static DWORD WINAPI msvcrt_strcspn (VOID)
{
  return 0;
}


/* strerror ordinal = 722, argument = 0 temporary */
static DWORD WINAPI msvcrt_strerror (VOID)
{
  return 0;
}


/* strftime ordinal = 723, argument = 0 temporary */
static DWORD WINAPI msvcrt_strftime (VOID)
{
#ifdef HAVE_STRFTIME
#else /* not HAVE_STRFTIME */
#endif /* not HAVE_STRFTIME */
  return 0;
}


/* strlen ordinal = 724, argument = 0 temporary */
static DWORD WINAPI msvcrt_strlen (VOID)
{
  return 0;
}


/* strncat ordinal = 725, argument = 0 temporary */
static DWORD WINAPI msvcrt_strncat (VOID)
{
  return 0;
}


/* strncmp ordinal = 726, argument = 0 temporary */
static DWORD WINAPI msvcrt_strncmp (VOID)
{
  return 0;
}


/* strncpy ordinal = 727, argument = 0 temporary */
static DWORD WINAPI msvcrt_strncpy (VOID)
{
  return 0;
}


/* strpbrk ordinal = 728, argument = 0 temporary */
static DWORD WINAPI msvcrt_strpbrk (VOID)
{
  return 0;
}


/* strrchr ordinal = 729, argument = 0 */
static char CDECL *msvcrt_strrchr (const char *string, int c)
{
  return g_strrchr (string, c);
}


/* strspn ordinal = 730, argument = 0 temporary */
static DWORD WINAPI msvcrt_strspn (VOID)
{
  return 0;
}


/* strstr ordinal = 731, argument = 0 temporary */
static DWORD WINAPI msvcrt_strstr (VOID)
{
  return 0;
}


/* strtod ordinal = 732, argument = 0 temporary */
static DWORD WINAPI msvcrt_strtod (VOID)
{
  return 0;
}


/* strtok ordinal = 733, argument = 0 temporary */
static DWORD WINAPI msvcrt_strtok (VOID)
{
  return 0;
}


/* strtol ordinal = 734, argument = 0 temporary */
static DWORD WINAPI msvcrt_strtol (VOID)
{
  return 0;
}


/* strtoul ordinal = 735, argument = 0 temporary */
static DWORD WINAPI msvcrt_strtoul (VOID)
{
  return 0;
}


/* strxfrm ordinal = 736, argument = 0 temporary */
static DWORD WINAPI msvcrt_strxfrm (VOID)
{
  return 0;
}


/* swprintf ordinal = 737, argument = 0 temporary */
static DWORD WINAPI msvcrt_swprintf (VOID)
{
  return 0;
}


/* swscanf ordinal = 738, argument = 0 */
int CDECL swscanf (const gunichar2 *buffer, const gunichar2 *format, ...)
{
  return 0;
}


/* system ordinal = 739, argument = 0 temporary */
static DWORD WINAPI msvcrt_system (VOID)
{
  return 0;
}


/* tan ordinal = 740, argument = 0 temporary */
static DWORD WINAPI msvcrt_tan (VOID)
{
  return 0;
}


/* tanh ordinal = 741, argument = 0 temporary */
static DWORD WINAPI msvcrt_tanh (VOID)
{
  return 0;
}


/* time ordinal = 742, argument = 0 temporary */
static DWORD WINAPI msvcrt_time (VOID)
{
  return 0;
}


/* tmpfile ordinal = 743, argument = 0 temporary */
static DWORD WINAPI msvcrt_tmpfile (VOID)
{
  return 0;
}


/* tmpnam ordinal = 744, argument = 0 temporary */
static DWORD WINAPI msvcrt_tmpnam (VOID)
{
  return 0;
}


/* tolower ordinal = 745, argument = 0 temporary */
static DWORD WINAPI msvcrt_tolower (VOID)
{
  return 0;
}


/* toupper ordinal = 746, argument = 0 */
static int CDECL msvcrt_toupper (int c)
{
  return g_ascii_toupper (c);
}


/* towlower ordinal = 747, argument = 0 temporary */
static DWORD WINAPI msvcrt_towlower (VOID)
{
  return 0;
}


/* towupper ordinal = 748, argument = 0 temporary */
static DWORD WINAPI msvcrt_towupper (VOID)
{
  return 0;
}


/* ungetc ordinal = 749, argument = 0 temporary */
static DWORD WINAPI msvcrt_ungetc (VOID)
{
  return 0;
}


/* ungetwc ordinal = 750, argument = 0 temporary */
static DWORD WINAPI msvcrt_ungetwc (VOID)
{
  return 0;
}


/* vfprintf ordinal = 751, argument = 0 temporary */
static DWORD WINAPI msvcrt_vfprintf (VOID)
{
#ifdef HAVE_VPRINTF
#else /* not HAVE_VPRINTF */
#endif /* not HAVE_VPRINTF */
  return 0;
}


/* vfwprintf ordinal = 752, argument = 0 temporary */
static DWORD WINAPI msvcrt_vfwprintf (VOID)
{
  return 0;
}


/* vprintf ordinal = 753, argument = 0 temporary */
static DWORD WINAPI msvcrt_vprintf (VOID)
{
#ifdef HAVE_VPRINTF
#else /* not HAVE_VPRINTF */
#endif /* not HAVE_VPRINTF */
  return 0;
}


/* vsprintf ordinal = 754, argument = 0 temporary */
static DWORD WINAPI msvcrt_vsprintf (VOID)
{
#ifdef HAVE_VPRINTF
#else /* not HAVE_VPRINTF */
#endif /* not HAVE_VPRINTF */
  return 0;
}


/* vswprintf ordinal = 755, argument = 0 temporary */
static DWORD WINAPI msvcrt_vswprintf (VOID)
{
  return 0;
}


/* vwprintf ordinal = 756, argument = 0 temporary */
static DWORD WINAPI msvcrt_vwprintf (VOID)
{
  return 0;
}


/* wcscat ordinal = 757, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcscat (VOID)
{
  return 0;
}


/* wcschr ordinal = 758, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcschr (VOID)
{
  return 0;
}


/* wcscmp ordinal = 759, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcscmp (VOID)
{
  return 0;
}


/* wcscoll ordinal = 760, argument = 0 temporary */
static DWORD WINAPI wcscoll (VOID)
{
  return 0;
}


/* wcscpy ordinal = 761, argument = 0 */
static gunichar2 CDECL *msvcrt_wcscpy (gunichar2 *string1, const gunichar2 *string2)
{
  return lstrcpyW (string1, string2);
}


/* wcscspn ordinal = 762, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcscspn (VOID)
{
  return 0;
}


/* wcsftime ordinal = 763, argument = 0 temporary */
static DWORD WINAPI wcsftime (VOID)
{
  return 0;
}


/* wcslen ordinal = 764, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcslen (VOID)
{
  return 0;
}


/* wcsncat ordinal = 765, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcsncat (VOID)
{
  return 0;
}


/* wcsncmp ordinal = 766, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcsncmp (VOID)
{
  return 0;
}


/* wcsncpy ordinal = 767, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcsncpy (VOID)
{
  return 0;
}


/* wcspbrk ordinal = 768, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcspbrk (VOID)
{
  return 0;
}


/* wcsrchr ordinal = 769, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcsrchr (VOID)
{
  return 0;
}


/* wcsspn ordinal = 770, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcsspn (VOID)
{
  return 0;
}


/* wcsstr ordinal = 771, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcsstr (VOID)
{
  return 0;
}


/* wcstod ordinal = 772, argument = 0 temporary */
static DWORD WINAPI wcstod (VOID)
{
  return 0;
}


/* wcstok ordinal = 773, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcstok (VOID)
{
  return 0;
}


/* wcstol ordinal = 774, argument = 0 temporary */
static DWORD WINAPI wcstol (VOID)
{
  return 0;
}


/* wcstombs ordinal = 775, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcstombs (VOID)
{
  return 0;
}


/* wcstoul ordinal = 776, argument = 0 temporary */
static DWORD WINAPI wcstoul (VOID)
{
  return 0;
}


/* wcsxfrm ordinal = 777, argument = 0 temporary */
static DWORD WINAPI wcsxfrm (VOID)
{
  return 0;
}


/* wctomb ordinal = 778, argument = 0 temporary */
static DWORD WINAPI msvcrt_wctomb (VOID)
{
  return 0;
}


/* wprintf ordinal = 779, argument = 0 temporary */
static DWORD WINAPI msvcrt_wprintf (VOID)
{
  return 0;
}


/* wscanf ordinal = 780, argument = 0 */
int CDECL wscanf (const gunichar2 *format, ...)
{
  return 0;
}


W32LdrExport w32ldr_msvcrt_exports[] = {
{ 0,  15, "??2@YAPAXI@Z",              msvcrt_new},
{ 0,  16, "??3@YAXPAX@Z",              msvcrt_delete},
{-1,  52, "_CIacos",                   msvcrt_CIacos},
{-1,  53, "_CIasin",                   msvcrt_CIasin},
{-1,  54, "_CIatan",                   msvcrt_CIatan},
{-1,  55, "_CIatan2",                  msvcrt_CIatan2},
{-1,  56, "_CIcos",                    msvcrt_CIcos},
{-1,  57, "_CIcosh",                   msvcrt_CIcosh},
{-1,  58, "_CIexp",                    msvcrt_CIexp},
{-1,  59, "_CIfmod",                   msvcrt_CIfmod},
{-1,  60, "_CIlog",                    msvcrt_CIlog},
{-1,  61, "_CIlog10",                  msvcrt_CIlog10},
{-1,  62, "_CIpow",                    msvcrt_CIpow},
{-1,  63, "_CIsin",                    msvcrt_CIsin},
{-1,  64, "_CIsinh",                   msvcrt_CIsinh},
{-1,  65, "_CIsqrt",                   msvcrt_CIsqrt},
{-1,  66, "_CItan",                    msvcrt_CItan},
{-1,  67, "_CItanh",                   msvcrt_CItanh},
{-1,  68, "_CxxThrowException",        msvcrt_CxxThrowException},
{ 0,  69, "_EH_prolog",                msvcrt_EH_prolog},
{-1,  70, "_Getdays",                  msvcrt_Getdays},
{-1,  71, "_Getmonths",                msvcrt_Getmonths},
{-1,  72, "_Gettnames",                msvcrt_Gettnames},
{-1,  73, "_HUGE",                     msvcrt_HUGE},
{-1,  74, "_Strftime",                 msvcrt_Strftime},
{-1,  75, "_XcptFilter",               msvcrt_XcptFilter},
{ 0,  76, "__CxxFrameHandler",         msvcrt_CxxFrameHandler},
{-1,  77, "__CxxLongjmpUnwind",        msvcrt_CxxLongjmpUnwind},
{-1,  78, "__RTCastToVoid",            msvcrt_RTCastToVoid},
{-1,  79, "__RTDynamicCast",           msvcrt_RTDynamicCast},
{-1,  80, "__RTtypeid",                msvcrt_RTtypeid},
{-1,  81, "__STRINGTOLD",              msvcrt_STRINGTOLD},
{-1,  82, "__argc",                    msvcrt_argc},
{-1,  83, "__argv",                    msvcrt_argv},
{-1,  84, "__badioinfo",               msvcrt_badioinfo},
{-1,  85, "__crtCompareStringA",       msvcrt_crtCompareStringA},
{-1,  86, "__crtGetLocaleInfoW",       msvcrt_crtGetLocaleInfoW},
{-1,  87, "__crtLCMapStringA",         msvcrt_crtLCMapStringA},
{ 0,  88, "__dllonexit",               msvcrt_dllonexit},
{-1,  89, "__doserrno",                msvcrt_doserrno},
{-1,  90, "__fpecode",                 msvcrt_fpecode},
{-1,  91, "__getmainargs",             msvcrt_getmainargs},
{-1,  92, "__initenv",                 msvcrt_initenv},
{-1,  93, "__isascii",                 msvcrt_isascii},
{-1,  94, "__iscsym",                  __iscsym},
{-1,  95, "__iscsymf",                 __iscsymf},
{-1,  96, "__lc_codepage",             msvcrt_lc_codepage},
{-1,  97, "__lc_collate_cp",           msvcrt_lc_collate_cp},
{-1,  98, "__lc_handle",               msvcrt_lc_handle},
{-1,  99, "__lconv_init",              msvcrt_lconv_init},
{-1, 100, "__mb_cur_max",              msvcrt_mb_cur_max},
{-1, 101, "__p___argc",                msvcrt_p___argc},
{-1, 102, "__p___argv",                msvcrt_p___argv},
{-1, 103, "__p___initenv",             msvcrt_p___initenv},
{-1, 104, "__p___mb_cur_max",          msvcrt_p___mb_cur_max},
{-1, 105, "__p___wargv",               msvcrt_p___wargv},
{-1, 106, "__p___winitenv",            msvcrt_p___winitenv},
{-1, 107, "__p__acmdln",               msvcrt_p__acmdln},
{-1, 108, "__p__amblksiz",             msvcrt_p__amblksiz},
{-1, 109, "__p__commode",              msvcrt_p__commode},
{-1, 110, "__p__daylight",             msvcrt_p__daylight},
{-1, 111, "__p__dstbias",              msvcrt_p__dstbias},
{-1, 112, "__p__environ",              msvcrt_p__environ},
{-1, 113, "__p__fileinfo",             msvcrt_p__fileinfo},
{-1, 114, "__p__fmode",                msvcrt_p__fmode},
{-1, 115, "__p__iob",                  msvcrt_p__iob},
{-1, 116, "__p__mbcasemap",            msvcrt_p__mbcasemap},
{-1, 117, "__p__mbctype",              msvcrt_p__mbctype},
{-1, 118, "__p__osver",                msvcrt_p__osver},
{-1, 119, "__p__pctype",               msvcrt_p__pctype},
{-1, 120, "__p__pgmptr",               msvcrt_p__pgmptr},
{-1, 121, "__p__pwctype",              msvcrt_p__pwctype},
{-1, 122, "__p__timezone",             msvcrt_p__timezone},
{-1, 123, "__p__tzname",               msvcrt_p__tzname},
{-1, 124, "__p__wcmdln",               msvcrt_p__wcmdln},
{-1, 125, "__p__wenviron",             msvcrt_p__wenviron},
{-1, 126, "__p__winmajor",             msvcrt_p__winmajor},
{-1, 127, "__p__winminor",             msvcrt_p__winminor},
{-1, 128, "__p__winver",               msvcrt_p__winver},
{-1, 129, "__p__wpgmptr",              msvcrt_p__wpgmptr},
{-1, 130, "__pioinfo",                 msvcrt_pioinfo},
{-1, 131, "__pxcptinfoptrs",           msvcrt_pxcptinfoptrs},
{-1, 132, "__set_app_type",            msvcrt_set_app_type},
{-1, 133, "__setlc_active",            msvcrt_setlc_active},
{-1, 134, "__setusermatherr",          msvcrt_setusermatherr},
{-1, 135, "__threadhandle",            msvcrt_threadhandle},
{-1, 136, "__threadid",                msvcrt_threadid},
{-1, 137, "__toascii",                 msvcrt__toascii},
{-1, 138, "__unDName",                 msvcrt_unDName},
{-1, 139, "__unDNameEx",               msvcrt_unDNameEx},
{-1, 140, "__unguarded_readlc_active", msvcrt_unguarded_readlc_active},
{-1, 141, "__wargv",                   msvcrt_wargv},
{-1, 142, "__wgetmainargs",            msvcrt_wgetmainargs},
{-1, 143, "__winitenv",                msvcrt_winitenv},
{-1, 144, "_abnormal_termination",     msvcrt_abnormal_termination},
{ 0, 145, "_access",                   _access},
{-1, 146, "_acmdln",                   msvcrt_acmdln},
{-1, 147, "_adj_fdiv_m16i",            msvcrt_adj_fdiv_m16i},
{-1, 148, "_adj_fdiv_m32",             msvcrt_adj_fdiv_m32},
{-1, 149, "_adj_fdiv_m32i",            msvcrt_adj_fdiv_m32i},
{-1, 150, "_adj_fdiv_m64",             msvcrt_adj_fdiv_m64},
{-1, 151, "_adj_fdiv_r",               msvcrt_adj_fdiv_r},
{-1, 152, "_adj_fdivr_m16i",           msvcrt_adj_fdivr_m16i},
{-1, 153, "_adj_fdivr_m32",            msvcrt_adj_fdivr_m32},
{-1, 154, "_adj_fdivr_m32i",           msvcrt_adj_fdivr_m32i},
{-1, 155, "_adj_fdivr_m64",            msvcrt_adj_fdivr_m64},
{-1, 156, "_adj_fpatan",               msvcrt_adj_fpatan},
{-1, 157, "_adj_fprem",                msvcrt_adj_fprem},
{-1, 158, "_adj_fprem1",               msvcrt_adj_fprem1},
{-1, 159, "_adj_fptan",                msvcrt_adj_fptan},
{ 4, 160, "_adjust_fdiv",              &msvcrt_adjust_fdiv},
{-1, 161, "_aexit_rtn",                msvcrt_aexit_rtn},
{-1, 162, "_amsg_exit",                msvcrt_amsg_exit},
{-1, 163, "_assert",                   msvcrt_assert},
{-1, 164, "_atodbl",                   msvcrt_atodbl},
{ 0, 165, "_atoi64",                   _atoi64},
{-1, 166, "_atoldbl",                  msvcrt_atoldbl},
{-1, 167, "_beep",                     msvcrt_beep},
{ 0, 168, "_beginthread",              _beginthread},
{ 0, 169, "_beginthreadex",            _beginthreadex},
{-1, 170, "_c_exit",                   _c_exit},
{-1, 171, "_cabs",                     msvcrt_cabs},
{-1, 172, "_callnewh",                 msvcrt_callnewh},
{-1, 173, "_cexit",                    _cexit},
{ 0, 174, "_cgets",                    _cgets},
{ 0, 175, "_chdir",                    _chdir},
{ 0, 176, "_chdrive",                  _chdrive},
{ 0, 177, "_chgsign",                  _chgsign},
{-1, 178, "_chkesp",                   msvcrt_chkesp},
{ 0, 179, "_chmod",                    _chmod},
{ 0, 180, "_chsize",                   _chsize},
{ 0, 181, "_clearfp",                  _clearfp},
{ 0, 182, "_close",                    msvcrt_close},
{ 0, 183, "_commit",                   _commit},
{-1, 184, "_commode",                  msvcrt_commode},
{ 0, 185, "_control87",                _control87},
{ 0, 186, "_controlfp",                _controlfp},
{ 0, 187, "_copysign",                 msvcrt_copysign},
{ 0, 188, "_cprintf",                  _cprintf},
{ 0, 189, "_cputs",                    _cputs},
{ 0, 190, "_creat",                    _creat},
{ 0, 191, "_cscanf",                   _cscanf},
{-1, 192, "_ctime64",                  msvcrt_ctime64},
{-1, 193, "_ctype",                    msvcrt_ctype},
{ 0, 194, "_cwait",                    _cwait},
{-1, 195, "_daylight",                 msvcrt_daylight},
{-1, 196, "_dstbias",                  msvcrt_dstbias},
{ 0, 197, "_dup",                      msvcrt_dup},
{ 0, 198, "_dup2",                     msvcrt_dup2},
{ 0, 199, "_ecvt",                     msvcrt_ecvt},
{ 0, 200, "_endthread",                _endthread},
{ 0, 201, "_endthreadex",              _endthreadex},
{-1, 202, "_environ",                  msvcrt_environ},
{-1, 203, "_eof",                      _eof},
{-1, 204, "_errno",                    msvcrt_errno},
{-1, 205, "_except_handler2",          msvcrt_except_handler2},
{ 0, 206, "_except_handler3",          msvcrt_except_handler3},
{ 0, 207, "_execl",                    _execl},
{ 0, 208, "_execle",                   _execle},
{ 0, 209, "_execlp",                   _execlp},
{ 0, 210, "_execlpe",                  _execlpe},
{ 0, 211, "_execv",                    _execv},
{ 0, 212, "_execve",                   _execve},
{ 0, 213, "_execvp",                   _execvp},
{ 0, 214, "_execvpe",                  _execvpe},
{ 0, 215, "_exit",                     msvcrt__exit},
{-1, 216, "_expand",                   _expand},
{ 0, 217, "_fcloseall",                msvcrt_fcloseall},
{ 0, 218, "_fcvt",                     msvcrt_fcvt},
{ 0, 219, "_fdopen",                   _fdopen},
{ 0, 220, "_fgetchar",                 _fgetchar},
{ 0, 221, "_fgetwchar",                _fgetwchar},
{-1, 222, "_filbuf",                   msvcrt_filbuf},
{-1, 223, "_fileinfo",                 msvcrt_fileinfo},
{ 0, 224, "_filelength",               _filelength},
{ 0, 225, "_filelengthi64",            _filelengthi64},
{ 0, 226, "_fileno",                   msvcrt_fileno},
{-1, 227, "_findclose",                _findclose},
{-1, 228, "_findfirst",                _findfirst},
{-1, 229, "_findfirst64",              _findfirst64},
{-1, 230, "_findfirsti64",             _findfirsti64},
{-1, 231, "_findnext",                 _findnext},
{-1, 232, "_findnext64",               _findnext64},
{-1, 233, "_findnexti64",              _findnexti64},
{ 0, 234, "_finite",                   msvcrt_finite},
{-1, 235, "_flsbuf",                   msvcrt_flsbuf},
{-1, 236, "_flushall",                 _flushall},
{-1, 237, "_fmode",                    msvcrt_fmode},
{-1, 238, "_fpclass",                  _fpclass},
{-1, 239, "_fpieee_flt",               _fpieee_flt},
{-1, 240, "_fpreset",                  _fpreset},
{ 0, 241, "_fputchar",                 _fputchar},
{ 0, 242, "_fputwchar",                _fputwchar},
{ 0, 243, "_fsopen",                   _fsopen},
{ 0, 244, "_fstat",                    _fstat},
{ 0, 245, "_fstat64",                  _fstat64},
{ 0, 246, "_fstati64",                 _fstati64},
{ 0, 247, "_ftime",                    msvcrt_ftime},
{-1, 248, "_ftime64",                  msvcrt_ftime64},
{ 0, 249, "_ftol",                     msvcrt_ftol},
{-1, 250, "_fullpath",                 _fullpath},
{-1, 251, "_futime",                   _futime},
{-1, 252, "_futime64",                 _futime64},
{-1, 253, "_gcvt",                     msvcrt_gcvt},
{-1, 254, "_get_heap_handle",          msvcrt_get_heap_handle},
{-1, 255, "_get_osfhandle",            _get_osfhandle},
{-1, 256, "_get_sbh_threshold",        _get_sbh_threshold},
{-1, 257, "_getch",                    _getch},
{-1, 258, "_getche",                   _getche},
{-1, 259, "_getcwd",                   _getcwd},
{-1, 260, "_getdcwd",                  _getdcwd},
{-1, 261, "_getdiskfree",              msvcrt_getdiskfree},
{-1, 262, "_getdllprocaddr",           msvcrt_getdllprocaddr},
{-1, 263, "_getdrive",                 _getdrive},
{-1, 264, "_getdrives",                msvcrt_getdrives},
{-1, 265, "_getmaxstdio",              msvcrt_getmaxstdio},
{-1, 266, "_getmbcp",                  _getmbcp},
{-1, 267, "_getpid",                   msvcrt_getpid},
{-1, 268, "_getsystime",               msvcrt_getsystime},
{-1, 269, "_getw",                     msvcrt_getw},
{-1, 270, "_getws",                    msvcrt_getws},
{-1, 271, "_global_unwind2",           msvcrt_global_unwind2},
{-1, 272, "_gmtime64",                 msvcrt_gmtime64},
{-1, 273, "_heapadd",                  _heapadd},
{-1, 274, "_heapchk",                  _heapchk},
{-1, 275, "_heapmin",                  _heapmin},
{-1, 276, "_heapset",                  _heapset},
{-1, 277, "_heapused",                 _heapused},
{-1, 278, "_heapwalk",                 _heapwalk},
{-1, 279, "_hypot",                    msvcrt_hypot},
{ 0, 280, "_i64toa",                   _i64toa},
{-1, 281, "_i64tow",                   _i64tow},
{ 0, 282, "_initterm",                 msvcrt_initterm},
{-1, 283, "_inp",                      _inp},
{-1, 284, "_inpd",                     _inpd},
{-1, 285, "_inpw",                     _inpw},
{-1, 286, "_iob",                      msvcrt_iob},
{-1, 287, "_isatty",                   msvcrt_isatty},
{-1, 288, "_isctype",                  msvcrt_isctype},
{-1, 289, "_ismbbalnum",               _ismbbalnum},
{-1, 290, "_ismbbalpha",               _ismbbalpha},
{-1, 291, "_ismbbgraph",               _ismbbgraph},
{-1, 292, "_ismbbkalnum",              _ismbbkalnum},
{-1, 293, "_ismbbkana",                _ismbbkana},
{-1, 294, "_ismbbkprint",              _ismbbkprint},
{-1, 295, "_ismbbkpunct",              _ismbbkpunct},
{-1, 296, "_ismbblead",                _ismbblead},
{-1, 297, "_ismbbprint",               _ismbbprint},
{-1, 298, "_ismbbpunct",               _ismbbpunct},
{-1, 299, "_ismbbtrail",               _ismbbtrail},
{-1, 300, "_ismbcalnum",               _ismbcalnum},
{-1, 301, "_ismbcalpha",               _ismbcalpha},
{-1, 302, "_ismbcdigit",               _ismbcdigit},
{-1, 303, "_ismbcgraph",               _ismbcgraph},
{-1, 304, "_ismbchira",                _ismbchira},
{-1, 305, "_ismbckata",                _ismbckata},
{-1, 306, "_ismbcl0",                  _ismbcl0},
{-1, 307, "_ismbcl1",                  _ismbcl1},
{-1, 308, "_ismbcl2",                  _ismbcl2},
{-1, 309, "_ismbclegal",               _ismbclegal},
{-1, 310, "_ismbclower",               _ismbclower},
{-1, 311, "_ismbcprint",               _ismbcprint},
{-1, 312, "_ismbcpunct",               _ismbcpunct},
{-1, 313, "_ismbcspace",               _ismbcspace},
{-1, 314, "_ismbcsymbol",              _ismbcsymbol},
{-1, 315, "_ismbcupper",               _ismbcupper},
{ 0, 316, "_ismbslead",                _ismbslead},
{ 0, 317, "_ismbstrail",               _ismbstrail},
{-1, 318, "_isnan",                    msvcrt_isnan},
{-1, 319, "_itoa",                     _itoa},
{-1, 320, "_itow",                     _itow},
{-1, 321, "_j0",                       msvcrt_j0},
{-1, 322, "_j1",                       msvcrt_j1},
{-1, 323, "_jn",                       msvcrt_jn},
{-1, 324, "_kbhit",                    _kbhit},
{-1, 325, "_lfind",                    msvcrt_lfind},
{-1, 326, "_loaddll",                  msvcrt_loaddll},
{-1, 327, "_local_unwind2",            msvcrt_local_unwind2},
{-1, 328, "_localtime64",              msvcrt_localtime64},
{-1, 329, "_lock",                     msvcrt_lock},
{-1, 330, "_locking",                  _locking},
{-1, 331, "_logb",                     msvcrt_logb},
{-1, 332, "_longjmpex",                msvcrt_longjmpex},
{-1, 333, "_lrotl",                    _lrotl},
{-1, 334, "_lrotr",                    _lrotr},
{-1, 335, "_lsearch",                  msvcrt_lsearch},
{-1, 336, "_lseek",                    msvcrt_lseek},
{-1, 337, "_lseeki64",                 msvcrt_lseeki64},
{-1, 338, "_ltoa",                     _ltoa},
{-1, 339, "_ltow",                     _ltow},
{-1, 340, "_makepath",                 _makepath},
{-1, 341, "_mbbtombc",                 _mbbtombc},
{-1, 342, "_mbbtype",                  _mbbtype},
{-1, 343, "_mbcasemap",                _mbcasemap},
{-1, 344, "_mbccpy",                   _mbccpy},
{ 0, 345, "_mbcjistojms",              _mbcjistojms},
{ 0, 346, "_mbcjmstojis",              _mbcjmstojis},
{-1, 347, "_mbclen",                   _mbclen},
{-1, 348, "_mbctohira",                _mbctohira},
{-1, 349, "_mbctokata",                _mbctokata},
{-1, 350, "_mbctolower",               _mbctolower},
{-1, 351, "_mbctombb",                 _mbctombb},
{-1, 352, "_mbctoupper",               _mbctoupper},
{-1, 353, "_mbctype",                  _mbctype},
{-1, 354, "_mbsbtype",                 msvcrt_mbsbtype},
{-1, 355, "_mbscat",                   _mbscat},
{ 0, 356, "_mbschr",                   _mbschr},
{ 0, 357, "_mbscmp",                   _mbscmp},
{-1, 358, "_mbscoll",                  _mbscoll},
{-1, 359, "_mbscpy",                   _mbscpy},
{-1, 360, "_mbscspn",                  _mbscspn},
{ 0, 361, "_mbsdec",                   _mbsdec},
{-1, 362, "_mbsdup",                   _mbsdup},
{ 0, 363, "_mbsicmp",                  _mbsicmp},
{-1, 364, "_mbsicoll",                 _mbsicoll},
{ 0, 365, "_mbsinc",                   _mbsinc},
{ 0, 366, "_mbslen",                   _mbslen},
{ 0, 367, "_mbslwr",                   _mbslwr},
{-1, 368, "_mbsnbcat",                 _mbsnbcat},
{-1, 369, "_mbsnbcmp",                 _mbsnbcmp},
{-1, 370, "_mbsnbcnt",                 _mbsnbcnt},
{-1, 371, "_mbsnbcoll",                _mbsnbcoll},
{-1, 372, "_mbsnbcpy",                 _mbsnbcpy},
{-1, 373, "_mbsnbicmp",                _mbsnbicmp},
{-1, 374, "_mbsnbicoll",               _mbsnbicoll},
{-1, 375, "_mbsnbset",                 _mbsnbset},
{-1, 376, "_mbsncat",                  _mbsncat},
{-1, 377, "_mbsnccnt",                 _mbsnccnt},
{ 0, 378, "_mbsncmp",                  _mbsncmp},
{-1, 379, "_mbsncoll",                 _mbsncoll},
{-1, 380, "_mbsncpy",                  _mbsncpy},
{-1, 381, "_mbsnextc",                 _mbsnextc},
{-1, 382, "_mbsnicmp",                 _mbsnicmp},
{-1, 383, "_mbsnicoll",                _mbsnicoll},
{ 0, 384, "_mbsninc",                  _mbsninc},
{-1, 385, "_mbsnset",                  _mbsnset},
{-1, 386, "_mbspbrk",                  _mbspbrk},
{ 0, 387, "_mbsrchr",                  _mbsrchr},
{-1, 388, "_mbsrev",                   _mbsrev},
{-1, 389, "_mbsset",                   _mbsset},
{-1, 390, "_mbsspn",                   _mbsspn},
{-1, 391, "_mbsspnp",                  _mbsspnp},
{ 0, 392, "_mbsstr",                   _mbsstr},
{-1, 393, "_mbstok",                   _mbstok},
{-1, 394, "_mbstrlen",                 _mbstrlen},
{ 0, 395, "_mbsupr",                   _mbsupr},
{-1, 396, "_memccpy",                  msvcrt_memccpy},
{-1, 397, "_memicmp",                  _memicmp},
{ 0, 398, "_mkdir",                    _mkdir},
{-1, 399, "_mktemp",                   _mktemp},
{-1, 400, "_mktime64",                 msvcrt_mktime64},
{-1, 401, "_msize",                    _msize},
{-1, 402, "_nextafter",                msvcrt_nextafter},
{ 0, 403, "_onexit",                   _onexit},
{-1, 404, "_open",                     _open},
{-1, 405, "_open_osfhandle",           _open_osfhandle},
{-1, 406, "_osplatform",               msvcrt_osplatform},
{-1, 407, "_osver",                    msvcrt_osver},
{-1, 408, "_outp",                     _outp},
{-1, 409, "_outpd",                    _outpd},
{-1, 410, "_outpw",                    _outpw},
{-1, 411, "_pclose",                   msvcrt_pclose},
{-1, 412, "_pctype",                   msvcrt_pctype},
{-1, 413, "_pgmptr",                   msvcrt_pgmptr},
{-1, 414, "_pipe",                     msvcrt_pipe},
{-1, 415, "_popen",                    _popen},
{-1, 416, "_purecall",                 msvcrt_purecall},
{-1, 417, "_putch",                    _putch},
{-1, 418, "_putenv",                   _putenv},
{-1, 419, "_putw",                     _putw},
{-1, 420, "_putws",                    _putws},
{-1, 421, "_pwctype",                  msvcrt_pwctype},
{-1, 422, "_read",                     msvcrt_read},
{-1, 423, "_rmdir",                    _rmdir},
{-1, 424, "_rmtmp",                    _rmtmp},
{-1, 425, "_rotl",                     _rotl},
{-1, 426, "_rotr",                     _rotr},
{-1, 427, "_safe_fdiv",                msvcrt_safe_fdiv},
{-1, 428, "_safe_fdivr",               msvcrt_safe_fdivr},
{-1, 429, "_safe_fprem",               msvcrt_safe_fprem},
{-1, 430, "_safe_fprem1",              msvcrt_safe_fprem1},
{-1, 431, "_scalb",                    msvcrt_scalb},
{-1, 432, "_searchenv",                _searchenv},
{-1, 433, "_seh_longjmp_unwind",       msvcrt_seh_longjmp_unwind},
{-1, 434, "_set_error_mode",           msvcrt_set_error_mode},
{-1, 435, "_set_sbh_threshold",        _set_sbh_threshold},
{-1, 436, "_seterrormode",             msvcrt_seterrormode},
{-1, 437, "_setjmp",                   msvcrt_setjmp},
{-1, 438, "_setjmp3",                  msvcrt_setjmp3},
{-1, 439, "_setmaxstdio",              _setmaxstdio},
{-1, 440, "_setmbcp",                  _setmbcp},
{-1, 441, "_setmode",                  _setmode},
{-1, 442, "_setsystime",               msvcrt_setsystime},
{-1, 443, "_sleep",                    msvcrt_sleep},
{-1, 444, "_snprintf",                 msvcrt_snprintf},
{-1, 445, "_snwprintf",                _snwprintf},
{-1, 446, "_sopen",                    _sopen},
{-1, 447, "_spawnl",                   _spawnl},
{-1, 448, "_spawnle",                  _spawnle},
{-1, 449, "_spawnlp",                  _spawnlp},
{-1, 450, "_spawnlpe",                 _spawnlpe},
{-1, 451, "_spawnv",                   _spawnv},
{-1, 452, "_spawnve",                  _spawnve},
{-1, 453, "_spawnvp",                  _spawnvp},
{-1, 454, "_spawnvpe",                 _spawnvpe},
{-1, 455, "_splitpath",                _splitpath},
{-1, 456, "_stat",                     _stat},
{-1, 457, "_stat64",                   msvcrt_stat64},
{-1, 458, "_stati64",                  _stati64},
{-1, 459, "_statusfp",                 _statusfp},
{ 0, 460, "_strcmpi",                  msvcrt_strcmpi},
{-1, 461, "_strdate",                  _strdate},
{-1, 462, "_strdup",                   msvcrt_strdup},
{-1, 463, "_strerror",                 _strerror},
{ 0, 464, "_stricmp",                  _stricmp},
{-1, 465, "_stricoll",                 _stricoll},
{ 0, 466, "_strlwr",                   _strlwr},
{-1, 467, "_strncoll",                 _strncoll},
{ 0, 468, "_strnicmp",                 _strnicmp},
{-1, 469, "_strnicoll",                _strnicoll},
{-1, 470, "_strnset",                  _strnset},
{ 0, 471, "_strrev",                   _strrev},
{-1, 472, "_strset",                   _strset},
{-1, 473, "_strtime",                  _strtime},
{ 0, 474, "_strupr",                   _strupr},
{-1, 475, "_swab",                     msvcrt_swab},
{-1, 476, "_sys_errlist",              msvcrt_sys_errlist},
{-1, 477, "_sys_nerr",                 msvcrt_sys_nerr},
{-1, 478, "_tell",                     _tell},
{-1, 479, "_telli64",                  _telli64},
{-1, 480, "_tempnam",                  _tempnam},
{-1, 481, "_time64",                   msvcrt_time64},
{-1, 482, "_timezone",                 msvcrt_timezone},
{-1, 483, "_tolower",                  msvcrt__tolower},
{-1, 484, "_toupper",                  msvcrt__toupper},
{-1, 485, "_tzname",                   msvcrt_tzname},
{-1, 486, "_tzset",                    msvcrt_tzset},
{ 0, 487, "_ui64toa",                  _ui64toa},
{-1, 488, "_ui64tow",                  _ui64tow},
{-1, 489, "_ultoa",                    _ultoa},
{-1, 490, "_ultow",                    _ultow},
{-1, 491, "_umask",                    msvcrt_umask},
{-1, 492, "_ungetch",                  _ungetch},
{ 0, 493, "_unlink",                   _unlink},
{-1, 494, "_unloaddll",                msvcrt_unloaddll},
{-1, 495, "_unlock",                   msvcrt_unlock},
{-1, 496, "_utime",                    _utime},
{-1, 497, "_utime64",                  msvcrt_utime64},
{-1, 498, "_vsnprintf",                msvcrt_vsnprintf},
{-1, 499, "_vsnwprintf",               _vsnwprintf},
{ 0, 500, "_waccess",                  _waccess},
{-1, 501, "_wasctime",                 _wasctime},
{ 0, 502, "_wchdir",                   _wchdir},
{ 0, 503, "_wchmod",                   _wchmod},
{-1, 504, "_wcmdln",                   msvcrt_wcmdln},
{ 0, 505, "_wcreat",                   _wcreat},
{-1, 506, "_wcsdup",                   _wcsdup},
{-1, 507, "_wcsicmp",                  _wcsicmp},
{-1, 508, "_wcsicoll",                 _wcsicoll},
{-1, 509, "_wcslwr",                   _wcslwr},
{-1, 510, "_wcsncoll",                 _wcsncoll},
{-1, 511, "_wcsnicmp",                 _wcsnicmp},
{-1, 512, "_wcsnicoll",                _wcsnicoll},
{-1, 513, "_wcsnset",                  _wcsnset},
{ 0, 514, "_wcsrev",                   _wcsrev},
{-1, 515, "_wcsset",                   _wcsset},
{-1, 516, "_wcsupr",                   _wcsupr},
{-1, 517, "_wctime",                   msvcrt_wctime},
{-1, 518, "_wctime64",                 msvcrt_wctime64},
{-1, 519, "_wenviron",                 msvcrt_wenviron},
{ 0, 520, "_wexecl",                   _wexecl},
{ 0, 521, "_wexecle",                  _wexecle},
{ 0, 522, "_wexeclp",                  _wexeclp},
{ 0, 523, "_wexeclpe",                 _wexeclpe},
{ 0, 524, "_wexecv",                   _wexecv},
{ 0, 525, "_wexecve",                  _wexecve},
{ 0, 526, "_wexecvp",                  _wexecvp},
{ 0, 527, "_wexecvpe",                 _wexecvpe},
{ 0, 528, "_wfdopen",                  _wfdopen},
{-1, 529, "_wfindfirst",               _wfindfirst},
{-1, 530, "_wfindfirst64",             _wfindfirst64},
{-1, 531, "_wfindfirsti64",            _wfindfirsti64},
{-1, 532, "_wfindnext",                _wfindnext},
{-1, 533, "_wfindnext64",              _wfindnext64},
{-1, 534, "_wfindnexti64",             _wfindnexti64},
{ 0, 535, "_wfopen",                   _wfopen},
{ 0, 536, "_wfreopen",                 _wfreopen},
{ 0, 537, "_wfsopen",                  _wfsopen},
{-1, 538, "_wfullpath",                _wfullpath},
{-1, 539, "_wgetcwd",                  _wgetcwd},
{-1, 540, "_wgetdcwd",                 _wgetdcwd},
{-1, 541, "_wgetenv",                  _wgetenv},
{-1, 542, "_winmajor",                 msvcrt_winmajor},
{-1, 543, "_winminor",                 msvcrt_winminor},
{-1, 544, "_winver",                   msvcrt_winver},
{-1, 545, "_wmakepath",                _wmakepath},
{ 0, 546, "_wmkdir",                   _wmkdir},
{-1, 547, "_wmktemp",                  _wmktemp},
{-1, 548, "_wopen",                    _wopen},
{-1, 549, "_wperror",                  _wperror},
{-1, 550, "_wpgmptr",                  msvcrt_wpgmptr},
{-1, 551, "_wpopen",                   _wpopen},
{-1, 552, "_wputenv",                  _wputenv},
{-1, 553, "_wremove",                  _wremove},
{-1, 554, "_wrename",                  _wrename},
{-1, 555, "_write",                    msvcrt_write},
{-1, 556, "_wrmdir",                   _wrmdir},
{-1, 557, "_wsearchenv",               _wsearchenv},
{-1, 558, "_wsetlocale",               _wsetlocale},
{-1, 559, "_wsopen",                   _wsopen},
{-1, 560, "_wspawnl",                  _wspawnl},
{-1, 561, "_wspawnle",                 _wspawnle},
{-1, 562, "_wspawnlp",                 _wspawnlp},
{-1, 563, "_wspawnlpe",                _wspawnlpe},
{-1, 564, "_wspawnv",                  _wspawnv},
{-1, 565, "_wspawnve",                 _wspawnve},
{-1, 566, "_wspawnvp",                 _wspawnvp},
{-1, 567, "_wspawnvpe",                _wspawnvpe},
{-1, 568, "_wsplitpath",               _wsplitpath},
{-1, 569, "_wstat",                    _wstat},
{-1, 570, "_wstat64",                  msvcrt_wstat64},
{-1, 571, "_wstati64",                 _wstati64},
{-1, 572, "_wstrdate",                 _wstrdate},
{-1, 573, "_wstrtime",                 _wstrtime},
{-1, 574, "_wsystem",                  _wsystem},
{-1, 575, "_wtempnam",                 _wtempnam},
{-1, 576, "_wtmpnam",                  _wtmpnam},
{-1, 577, "_wtoi",                     _wtoi},
{-1, 578, "_wtoi64",                   msvcrt_wtoi64},
{-1, 579, "_wtol",                     _wtol},
{ 0, 580, "_wunlink",                  _wunlink},
{-1, 581, "_wutime",                   _wutime},
{-1, 582, "_wutime64",                 msvcrt_wutime64},
{-1, 583, "_y0",                       msvcrt_y0},
{-1, 584, "_y1",                       msvcrt_y1},
{-1, 585, "_yn",                       msvcrt_yn},
{-1, 586, "abort",                     msvcrt_abort},
{-1, 587, "abs",                       msvcrt_abs},
{-1, 588, "acos",                      msvcrt_acos},
{-1, 589, "asctime",                   msvcrt_asctime},
{-1, 590, "asin",                      msvcrt_asin},
{-1, 591, "atan",                      msvcrt_atan},
{-1, 592, "atan2",                     msvcrt_atan2},
{-1, 593, "atexit",                    msvcrt_atexit},
{ 0, 594, "atof",                      msvcrt_atof},
{-1, 595, "atoi",                      msvcrt_atoi},
{-1, 596, "atol",                      msvcrt_atol},
{-1, 597, "bsearch",                   msvcrt_bsearch},
{-1, 598, "calloc",                    msvcrt_calloc},
{-1, 599, "ceil",                      msvcrt_ceil},
{-1, 600, "clearerr",                  msvcrt_clearerr},
{-1, 601, "clock",                     msvcrt_clock},
{-1, 602, "cos",                       msvcrt_cos},
{-1, 603, "cosh",                      msvcrt_cosh},
{-1, 604, "ctime",                     msvcrt_ctime},
{-1, 605, "difftime",                  msvcrt_difftime},
{-1, 606, "div",                       msvcrt_div},
{ 0, 607, "exit",                      msvcrt_exit},
{-1, 608, "exp",                       msvcrt_exp},
{-1, 609, "fabs",                      msvcrt_fabs},
{-1, 610, "fclose",                    msvcrt_fclose},
{-1, 611, "feof",                      msvcrt_feof},
{-1, 612, "ferror",                    msvcrt_ferror},
{-1, 613, "fflush",                    msvcrt_fflush},
{-1, 614, "fgetc",                     msvcrt_fgetc},
{-1, 615, "fgetpos",                   msvcrt_fgetpos},
{-1, 616, "fgets",                     msvcrt_fgets},
{-1, 617, "fgetwc",                    msvcrt_fgetwc},
{-1, 618, "fgetws",                    msvcrt_fgetws},
{-1, 619, "floor",                     msvcrt_floor},
{-1, 620, "fmod",                      msvcrt_fmod},
{ 0, 621, "fopen",                     msvcrt_fopen},
{-1, 622, "fprintf",                   msvcrt_fprintf},
{-1, 623, "fputc",                     msvcrt_fputc},
{-1, 624, "fputs",                     msvcrt_fputs},
{-1, 625, "fputwc",                    msvcrt_fputwc},
{-1, 626, "fputws",                    msvcrt_fputws},
{-1, 627, "fread",                     msvcrt_fread},
{ 0, 628, "free",                      msvcrt_free},
{ 0, 629, "freopen",                   msvcrt_freopen},
{-1, 630, "frexp",                     msvcrt_frexp},
{ 0, 631, "fscanf",                    msvcrt_fscanf},
{-1, 632, "fseek",                     msvcrt_fseek},
{-1, 633, "fsetpos",                   msvcrt_fsetpos},
{-1, 634, "ftell",                     msvcrt_ftell},
{-1, 635, "fwprintf",                  msvcrt_fwprintf},
{-1, 636, "fwrite",                    msvcrt_fwrite},
{ 0, 637, "fwscanf",                   fwscanf},
{-1, 638, "getc",                      msvcrt_getc},
{-1, 639, "getchar",                   msvcrt_getchar},
{-1, 640, "getenv",                    msvcrt_getenv},
{-1, 641, "gets",                      msvcrt_gets},
{-1, 642, "getwc",                     msvcrt_getwc},
{-1, 643, "getwchar",                  msvcrt_getwchar},
{-1, 644, "gmtime",                    msvcrt_gmtime},
{-1, 645, "is_wctype",                 msvcrt_is_wctype},
{ 0, 646, "isalnum",                   msvcrt_isalnum},
{-1, 647, "isalpha",                   msvcrt_isalpha},
{-1, 648, "iscntrl",                   msvcrt_iscntrl},
{-1, 649, "isdigit",                   msvcrt_isdigit},
{-1, 650, "isgraph",                   msvcrt_isgraph},
{ 0, 651, "isleadbyte",                isleadbyte},
{-1, 652, "islower",                   msvcrt_islower},
{-1, 653, "isprint",                   msvcrt_isprint},
{-1, 654, "ispunct",                   msvcrt_ispunct},
{-1, 655, "isspace",                   msvcrt_isspace},
{-1, 656, "isupper",                   msvcrt_isupper},
{-1, 657, "iswalnum",                  msvcrt_iswalnum},
{-1, 658, "iswalpha",                  msvcrt_iswalpha},
{-1, 659, "iswascii",                  iswascii},
{-1, 660, "iswcntrl",                  msvcrt_iswcntrl},
{-1, 661, "iswctype",                  msvcrt_iswctype},
{-1, 662, "iswdigit",                  msvcrt_iswdigit},
{-1, 663, "iswgraph",                  msvcrt_iswgraph},
{-1, 664, "iswlower",                  msvcrt_iswlower},
{-1, 665, "iswprint",                  msvcrt_iswprint},
{-1, 666, "iswpunct",                  msvcrt_iswpunct},
{-1, 667, "iswspace",                  msvcrt_iswspace},
{-1, 668, "iswupper",                  msvcrt_iswupper},
{-1, 669, "iswxdigit",                 msvcrt_iswxdigit},
{-1, 670, "isxdigit",                  msvcrt_isxdigit},
{-1, 671, "labs",                      msvcrt_labs},
{-1, 672, "ldexp",                     msvcrt_ldexp},
{-1, 673, "ldiv",                      msvcrt_ldiv},
{-1, 674, "localeconv",                msvcrt_localeconv},
{-1, 675, "localtime",                 msvcrt_localtime},
{-1, 676, "log",                       msvcrt_log},
{-1, 677, "log10",                     msvcrt_log10},
{-1, 678, "longjmp",                   msvcrt_longjmp},
{ 0, 679, "malloc",                    msvcrt_malloc},
{-1, 680, "mblen",                     msvcrt_mblen},
{-1, 681, "mbstowcs",                  msvcrt_mbstowcs},
{-1, 682, "mbtowc",                    msvcrt_mbtowc},
{-1, 683, "memchr",                    msvcrt_memchr},
{-1, 684, "memcmp",                    msvcrt_memcmp},
{ 0, 685, "memcpy",                    msvcrt_memcpy},
{ 0, 686, "memmove",                   msvcrt_memmove},
{-1, 687, "memset",                    msvcrt_memset},
{-1, 688, "mktime",                    msvcrt_mktime},
{-1, 689, "modf",                      msvcrt_modf},
{-1, 690, "perror",                    msvcrt_perror},
{-1, 691, "pow",                       msvcrt_pow},
{-1, 692, "printf",                    msvcrt_printf},
{-1, 693, "putc",                      msvcrt_putc},
{-1, 694, "putchar",                   msvcrt_putchar},
{-1, 695, "puts",                      msvcrt_puts},
{-1, 696, "putwc",                     msvcrt_putwc},
{-1, 697, "putwchar",                  msvcrt_putwchar},
{-1, 698, "qsort",                     msvcrt_qsort},
{-1, 699, "raise",                     msvcrt_raise},
{ 0, 700, "rand",                      msvcrt_rand},
{-1, 701, "realloc",                   msvcrt_realloc},
{-1, 702, "remove",                    msvcrt_remove},
{-1, 703, "rename",                    msvcrt_rename},
{-1, 704, "rewind",                    msvcrt_rewind},
{ 0, 705, "scanf",                     msvcrt_scanf},
{-1, 706, "setbuf",                    msvcrt_setbuf},
{-1, 707, "setlocale",                 msvcrt_setlocale},
{-1, 708, "setvbuf",                   msvcrt_setvbuf},
{-1, 709, "signal",                    msvcrt_signal},
{-1, 710, "sin",                       msvcrt_sin},
{-1, 711, "sinh",                      msvcrt_sinh},
{-1, 712, "sprintf",                   msvcrt_sprintf},
{-1, 713, "sqrt",                      msvcrt_sqrt},
{ 0, 714, "srand",                     msvcrt_srand},
{ 0, 715, "sscanf",                    msvcrt_sscanf},
{-1, 716, "strcat",                    msvcrt_strcat},
{ 0, 717, "strchr",                    msvcrt_strchr},
{-1, 718, "strcmp",                    msvcrt_strcmp},
{-1, 719, "strcoll",                   msvcrt_strcoll},
{-1, 720, "strcpy",                    msvcrt_strcpy},
{-1, 721, "strcspn",                   msvcrt_strcspn},
{-1, 722, "strerror",                  msvcrt_strerror},
{-1, 723, "strftime",                  msvcrt_strftime},
{-1, 724, "strlen",                    msvcrt_strlen},
{-1, 725, "strncat",                   msvcrt_strncat},
{-1, 726, "strncmp",                   msvcrt_strncmp},
{-1, 727, "strncpy",                   msvcrt_strncpy},
{-1, 728, "strpbrk",                   msvcrt_strpbrk},
{ 0, 729, "strrchr",                   msvcrt_strrchr},
{-1, 730, "strspn",                    msvcrt_strspn},
{-1, 731, "strstr",                    msvcrt_strstr},
{-1, 732, "strtod",                    msvcrt_strtod},
{-1, 733, "strtok",                    msvcrt_strtok},
{-1, 734, "strtol",                    msvcrt_strtol},
{-1, 735, "strtoul",                   msvcrt_strtoul},
{-1, 736, "strxfrm",                   msvcrt_strxfrm},
{-1, 737, "swprintf",                  msvcrt_swprintf},
{ 0, 738, "swscanf",                   swscanf},
{-1, 739, "system",                    msvcrt_system},
{-1, 740, "tan",                       msvcrt_tan},
{-1, 741, "tanh",                      msvcrt_tanh},
{-1, 742, "time",                      msvcrt_time},
{-1, 743, "tmpfile",                   msvcrt_tmpfile},
{-1, 744, "tmpnam",                    msvcrt_tmpnam},
{-1, 745, "tolower",                   msvcrt_tolower},
{ 0, 746, "toupper",                   msvcrt_toupper},
{-1, 747, "towlower",                  msvcrt_towlower},
{-1, 748, "towupper",                  msvcrt_towupper},
{-1, 749, "ungetc",                    msvcrt_ungetc},
{-1, 750, "ungetwc",                   msvcrt_ungetwc},
{-1, 751, "vfprintf",                  msvcrt_vfprintf},
{-1, 752, "vfwprintf",                 msvcrt_vfwprintf},
{-1, 753, "vprintf",                   msvcrt_vprintf},
{-1, 754, "vsprintf",                  msvcrt_vsprintf},
{-1, 755, "vswprintf",                 msvcrt_vswprintf},
{-1, 756, "vwprintf",                  msvcrt_vwprintf},
{-1, 757, "wcscat",                    msvcrt_wcscat},
{-1, 758, "wcschr",                    msvcrt_wcschr},
{-1, 759, "wcscmp",                    msvcrt_wcscmp},
{-1, 760, "wcscoll",                   wcscoll},
{ 0, 761, "wcscpy",                    msvcrt_wcscpy},
{-1, 762, "wcscspn",                   msvcrt_wcscspn},
{-1, 763, "wcsftime",                  wcsftime},
{-1, 764, "wcslen",                    msvcrt_wcslen},
{-1, 765, "wcsncat",                   msvcrt_wcsncat},
{-1, 766, "wcsncmp",                   msvcrt_wcsncmp},
{-1, 767, "wcsncpy",                   msvcrt_wcsncpy},
{-1, 768, "wcspbrk",                   msvcrt_wcspbrk},
{-1, 769, "wcsrchr",                   msvcrt_wcsrchr},
{-1, 770, "wcsspn",                    msvcrt_wcsspn},
{-1, 771, "wcsstr",                    msvcrt_wcsstr},
{-1, 772, "wcstod",                    wcstod},
{-1, 773, "wcstok",                    msvcrt_wcstok},
{-1, 774, "wcstol",                    wcstol},
{-1, 775, "wcstombs",                  msvcrt_wcstombs},
{-1, 776, "wcstoul",                   wcstoul},
{-1, 777, "wcsxfrm",                   wcsxfrm},
{-1, 778, "wctomb",                    msvcrt_wctomb},
{-1, 779, "wprintf",                   msvcrt_wprintf},
{ 0, 780, "wscanf",                    wscanf},
{-1,   0, NULL,                        NULL}};
