/*
    w32loader
    copyright (c) 1998-2010 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "commdlg.h"
#include "kernel32.h"
#include "misc/misc.h"


#ifdef W32LDR_HEADER
#include "gdi32.h"

#define CF_SCREENFONTS          0x00000001
#define CF_PRINTERFONTS         0x00000002
#define CF_BOTH                 (CF_SCREENFONTS|CF_PRINTERFONTS)
#define CF_SHOWHELP             0x00000004
#define CF_ENABLEHOOK           0x00000008
#define CF_ENABLETEMPLATE       0x00000010
#define CF_ENABLETEMPLATEHANDLE 0x00000020
#define CF_INITTOLOGFONTSTRUCT  0x00000040
#define CF_USESTYLE             0x00000080
#define CF_EFFECTS              0x00000100
#define CF_APPLY                0x00000200
#define CF_ANSIONLY             0x00000400
#define CF_SCRIPTSONLY          CF_ANSIONLY
#define CF_NOVECTORFONTS        0x00000800
#define CF_NOOEMFONTS           CF_NOVECTORFONTS
#define CF_NOSIMULATIONS        0x00001000
#define CF_LIMITSIZE            0x00002000
#define CF_FIXEDPITCHONLY       0x00004000
#define CF_WYSIWYG              0x00008000
#define CF_FORCEFONTEXIST       0x00010000
#define CF_SCALABLEONLY         0x00020000
#define CF_TTONLY               0x00040000
#define CF_NOFACESEL            0x00080000
#define CF_NOSTYLESEL           0x00100000
#define CF_NOSIZESEL            0x00200000
#define CF_SELECTSCRIPT         0x00400000
#define CF_NOSCRIPTSEL          0x00800000
#define CF_NOVERTFONTS          0x01000000
#define SIMULATED_FONTTYPE 0x8000
#define PRINTER_FONTTYPE   0x4000
#define SCREEN_FONTTYPE    0x2000
typedef UINT (CALLBACK *LPCFHOOKPROC)(HWND, UINT, WPARAM, LPARAM);
#include "pshpack1.h"
typedef struct _CHOOSEFONTA
{
  UINT lStructSize;
  HWND hwndOwner;
  HDC hDC;
  LPLOGFONTA lpLogFont;
  INT iPointSize;
  DWORD Flags;
  COLORREF rgbColors;
  LPARAM lCustData;
  LPCFHOOKPROC lpfnHook;
  LPCSTR lpTemplateName;
  HINSTANCE hInstance;
  LPSTR lpszStyle;
  WORD nFontType;
  WORD ___MISSING_ALIGNMENT__;
  INT nSizeMin;
  INT nSizeMax;
} CHOOSEFONTA, *PCHOOSEFONTA, *LPCHOOSEFONTA;
typedef struct _CHOOSEFONTW
{
  UINT lStructSize;
  HWND hwndOwner;
  HDC hDC;
  LPLOGFONTW lpLogFont;
  INT iPointSize;
  DWORD Flags;
  COLORREF rgbColors;
  LPARAM lCustData;
  LPCFHOOKPROC lpfnHook;
  LPCWSTR lpTemplateName;
  HINSTANCE hInstance;
  LPWSTR lpszStyle;
  WORD nFontType;
  WORD ___MISSING_ALIGNMENT__;
  INT nSizeMin;
  INT nSizeMax;
} CHOOSEFONTW, *PCHOOSEFONTW, *LPCHOOSEFONTW;
#include "poppack.h"
#ifdef UNICODE
# define CHOOSEFONT CHOOSEFONTW
# define PCHOOSEFONT PCHOOSEFONTW
# define LPCHOOSEFONT LPCHOOSEFONTW
#else /* not UNICODE */
# define CHOOSEFONT CHOOSEFONTA
# define PCHOOSEFONT PCHOOSEFONTA
# define LPCHOOSEFONT LPCHOOSEFONTA
#endif /* not UNICODE */

#define OFN_READONLY             0x00000001
#define OFN_OVERWRITEPROMPT      0x00000002
#define OFN_HIDEREADONLY         0x00000004
#define OFN_NOCHANGEDIR          0x00000008
#define OFN_SHOWHELP             0x00000010
#define OFN_ENABLEHOOK           0x00000020
#define OFN_ENABLETEMPLATE       0x00000040
#define OFN_ENABLETEMPLATEHANDLE 0x00000080
#define OFN_NOVALIDATE           0x00000100
#define OFN_ALLOWMULTISELECT     0x00000200
#define OFN_EXTENSIONDIFFERENT   0x00000400
#define OFN_PATHMUSTEXIST        0x00000800
#define OFN_FILEMUSTEXIST        0x00001000
#define OFN_CREATEPROMPT         0x00002000
#define OFN_SHAREAWARE           0x00004000
#define OFN_NOREADONLYRETURN     0x00008000
#define OFN_NOTESTFILECREATE     0x00010000
#define OFN_NONETWORKBUTTON      0x00020000
#define OFN_NOLONGNAMES          0x00040000
#define OFN_SHAREFALLTHROUGH     2
#define OFN_SHARENOWARN          1
#define OFN_SHAREWARN            0
typedef UINT (CALLBACK *LPOFNHOOKPROC)(HWND, UINT, WPARAM, LPARAM);
typedef struct _OPENFILENAMEA
{
  DWORD lStructSize;
  HWND hwndOwner;
  HINSTANCE hInstance;
  LPCSTR lpstrFilter;
  LPSTR lpstrCustomFilter;
  DWORD nMaxCustFilter;
  DWORD nFilterIndex;
  LPSTR lpstrFile;
  DWORD nMaxFile;
  LPSTR lpstrFileTitle;
  DWORD nMaxFileTitle;
  LPCSTR lpstrInitialDir;
  LPCSTR lpstrTitle;
  DWORD Flags;
  WORD nFileOffset;
  WORD nFileExtension;
  LPCSTR lpstrDefExt;
  LPARAM lCustData;
  LPOFNHOOKPROC lpfnHook;
  LPCSTR lpTemplateName;
} OPENFILENAMEA, *POPENFILENAMEA, *LPOPENFILENAMEA;
typedef struct _OPENFILENAMEW
{
  DWORD lStructSize;
  HWND hwndOwner;
  HINSTANCE hInstance;
  LPCWSTR lpstrFilter;
  LPWSTR lpstrCustomFilter;
  DWORD nMaxCustFilter;
  DWORD nFilterIndex;
  LPWSTR lpstrFile;
  DWORD nMaxFile;
  LPWSTR lpstrFileTitle;
  DWORD nMaxFileTitle;
  LPCWSTR lpstrInitialDir;
  LPCWSTR lpstrTitle;
  DWORD Flags;
  WORD nFileOffset;
  WORD nFileExtension;
  LPCWSTR lpstrDefExt;
  LPARAM lCustData;
  LPOFNHOOKPROC lpfnHook;
  LPCWSTR lpTemplateName;
} OPENFILENAMEW, *POPENFILENAMEW, *LPOPENFILENAMEW;
#ifdef UNICODE
# define OPENFILENAME OPENFILENAMEW
# define POPENFILENAME POPENFILENAMEW
# define LPOPENFILENAME LPOPENFILENAMEW
#else /* not UNICODE */
# define OPENFILENAME OPENFILENAMEA
# define POPENFILENAME POPENFILENAMEA
# define LPOPENFILENAME LPOPENFILENAMEA
#endif /* not UNICODE */
#endif /* W32LDR_HEADER */


#ifndef PANGO_VERSION_CHECK
# define PANGO_VERSION_CHECK(major,minor,micro) 0
#endif /* not PANGO_VERSION_CHECK */


/* ChooseColorA ordinal = 101, argument = 4 temporary */
static DWORD WINAPI ChooseColorA (DWORD dwArgv0)
{
  return 0;
}


/* ChooseColorW ordinal = 102, argument = 4 temporary */
static DWORD WINAPI ChooseColorW (DWORD dwArgv0)
{
  return 0;
}


/* ChooseFontA ordinal = 103, argument = 4 */
BOOL WINAPI ChooseFontA (LPCHOOSEFONTA lpcf)
{
  CHOOSEFONTW cf;
  LOGFONTW lf;

  if (!lpcf || !lpcf->lpLogFont)
    return FALSE;
  if (lpcf->Flags & CF_INITTOLOGFONTSTRUCT)
    {
      gchar *utf8str;

      lf.lfHeight = lpcf->lpLogFont->lfHeight;
      lf.lfWidth = lpcf->lpLogFont->lfWidth;
      lf.lfEscapement = lpcf->lpLogFont->lfEscapement;
      lf.lfOrientation = lpcf->lpLogFont->lfOrientation;
      lf.lfWeight = lpcf->lpLogFont->lfWeight;
      lf.lfItalic = lpcf->lpLogFont->lfItalic;
      lf.lfUnderline = lpcf->lpLogFont->lfUnderline;
      lf.lfStrikeOut = lpcf->lpLogFont->lfStrikeOut;
      lf.lfCharSet = lpcf->lpLogFont->lfCharSet;
      lf.lfOutPrecision = lpcf->lpLogFont->lfOutPrecision;
      lf.lfClipPrecision = lpcf->lpLogFont->lfClipPrecision;
      lf.lfQuality = lpcf->lpLogFont->lfQuality;
      lf.lfPitchAndFamily = lpcf->lpLogFont->lfPitchAndFamily;
      lf.lfFaceName[0] = '\0';
      utf8str = w32ldr_utf8_from_mb (lpcf->lpLogFont->lfFaceName);
      if (utf8str)
        {
          gunichar2 *wc;

          wc = g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL);
          g_free (utf8str);
          if (wc)
            {
              lstrcpynW (lf.lfFaceName, wc, LF_FACESIZE);
              g_free (wc);
            }
        }
    }
  cf.lStructSize = sizeof (CHOOSEFONTW);
  cf.hwndOwner = lpcf->hwndOwner;
  cf.hDC = NULL;
  cf.lpLogFont = &lf;
  cf.Flags = lpcf->Flags;
  cf.rgbColors = lpcf->rgbColors;
  cf.lCustData = 0;
  cf.lpfnHook = NULL;
  cf.lpTemplateName = NULL;
  cf.hInstance = NULL;
  cf.lpszStyle = NULL;
  cf.___MISSING_ALIGNMENT__ = 0;
  cf.nSizeMin = 0;
  cf.nSizeMax = 0;
  if (ChooseFontW (&cf))
    {
      gchar *utf8str;

      lpcf->iPointSize = cf.iPointSize;
      lpcf->rgbColors = cf.rgbColors;
      lpcf->nFontType = cf.nFontType;
      lpcf->lpLogFont->lfHeight = lf.lfHeight;
      lpcf->lpLogFont->lfWidth = lf.lfWidth;
      lpcf->lpLogFont->lfEscapement = lf.lfEscapement;
      lpcf->lpLogFont->lfOrientation = lf.lfOrientation;
      lpcf->lpLogFont->lfWeight = lf.lfWeight;
      lpcf->lpLogFont->lfItalic = lf.lfItalic;
      lpcf->lpLogFont->lfUnderline = lf.lfUnderline;
      lpcf->lpLogFont->lfStrikeOut = lf.lfStrikeOut;
      lpcf->lpLogFont->lfCharSet = lf.lfCharSet;
      lpcf->lpLogFont->lfOutPrecision = lf.lfOutPrecision;
      lpcf->lpLogFont->lfClipPrecision = lf.lfClipPrecision;
      lpcf->lpLogFont->lfQuality = lf.lfQuality;
      lpcf->lpLogFont->lfPitchAndFamily = lf.lfPitchAndFamily;
      lpcf->lpLogFont->lfFaceName[0] = '\0';
      utf8str = g_utf16_to_utf8 (lf.lfFaceName, -1, NULL, NULL, NULL);
      if (utf8str)
        {
          gchar *mb;

          mb = w32ldr_utf8_to_mb (utf8str);
          g_free (utf8str);
          if (mb)
            {
              g_strncpy (lpcf->lpLogFont->lfFaceName, mb, LF_FACESIZE);
              g_free (mb);
            }
        }
      return TRUE;
    }
  return FALSE;
}


#if ! GTK_CHECK_VERSION(2,4,0)
static void
commdlg_clicked (GtkWidget *widget,
                 GdkColor  *color)
{
  GtkWidget *dialog;

  dialog = gtk_color_selection_dialog_new ("Color");
  gtk_color_selection_set_current_color (GTK_COLOR_SELECTION
                    (GTK_COLOR_SELECTION_DIALOG (dialog)->colorsel), color);
  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK)
    gtk_color_selection_get_current_color (GTK_COLOR_SELECTION
                    (GTK_COLOR_SELECTION_DIALOG (dialog)->colorsel), color);
  gtk_widget_destroy (dialog);
}
#endif /* not GTK_CHECK_VERSION(2,4,0) */


/* ChooseFontW ordinal = 104, argument = 4 */
BOOL WINAPI ChooseFontW (LPCHOOSEFONTW lpcf)
{
  GdkColor color;
  GtkWidget *dialog, *parent, *button, *check_strike, *check_under;
  BOOL fResult = FALSE;

  if (!lpcf || !lpcf->lpLogFont || lpcf->lStructSize < sizeof (CHOOSEFONTW))
    return FALSE;
  color.pixel = 0;
  color.red = GetRValue (lpcf->rgbColors) * 256;
  color.green = GetGValue (lpcf->rgbColors) * 256;
  color.blue = GetBValue (lpcf->rgbColors) * 256;
  dialog = gtk_font_selection_dialog_new ("Font");

  for (parent = lpcf->hwndOwner; parent;
                                    parent = gtk_widget_get_parent (parent))
    if (GTK_IS_WINDOW (parent))
      {
        gtk_window_set_transient_for (GTK_WINDOW (dialog),
                                                        GTK_WINDOW (parent));
        break;
      }
  if (lpcf->Flags & CF_EFFECTS)
    {
      GtkWidget *hbox;

      check_strike = gtk_check_button_new_with_mnemonic ("_Strike Out");
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check_strike),
                                                lpcf->lpLogFont->lfStrikeOut);
      check_under = gtk_check_button_new_with_mnemonic ("_Under Line");
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check_under),
                                                lpcf->lpLogFont->lfUnderline);
#if GTK_CHECK_VERSION(2,4,0)
      button = gtk_color_button_new_with_color (&color);
#else /* not GTK_CHECK_VERSION(2,4,0) */
      button = gtk_button_new_with_mnemonic ("_Color");
      g_signal_connect (G_OBJECT (button), "clicked",
                                        G_CALLBACK (commdlg_clicked), &color);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      hbox = gtk_hbox_new (FALSE, SPACING);
      gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), check_strike, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), check_under, FALSE, FALSE, 0);
      gtk_box_pack_end (GTK_BOX (GTK_DIALOG (dialog)->vbox),
                                                        hbox, FALSE, FALSE, 0);
      gtk_widget_show_all (hbox);
    }
  else
    {
      button = check_strike = check_under = NULL;
    }
  if (lpcf->Flags & CF_INITTOLOGFONTSTRUCT)
    {
      gchar *name;
      PangoFontDescription *desc;

      desc = pango_font_description_new ();
      name = g_utf16_to_utf8 (lpcf->lpLogFont->lfFaceName, -1,
                                                            NULL, NULL, NULL);
      if (name)
        {
          pango_font_description_set_family (desc, name);
          g_free (name);
        }
      pango_font_description_set_style (desc, lpcf->lpLogFont->lfItalic
                                    ? PANGO_STYLE_NORMAL : PANGO_STYLE_ITALIC);
      pango_font_description_set_variant (desc, PANGO_VARIANT_NORMAL);
      pango_font_description_set_weight (desc,
                                    (PangoWeight)lpcf->lpLogFont->lfWeight);
      pango_font_description_set_stretch (desc, PANGO_STRETCH_NORMAL);
#if PANGO_VERSION_CHECK(1,8,0)
      if (lpcf->lpLogFont->lfHeight >= 0)
        pango_font_description_set_size (desc,
                                    lpcf->lpLogFont->lfHeight * PANGO_SCALE);
      else
        pango_font_description_set_absolute_size (desc,
                                    -lpcf->lpLogFont->lfHeight * PANGO_SCALE);
#else /* not PANGO_VERSION_CHECK(1,8,0) */
      pango_font_description_set_size (desc,
                                ABS (lpcf->lpLogFont->lfHeight) * PANGO_SCALE);
#endif /* not PANGO_VERSION_CHECK(1,8,0) */
#if PANGO_VERSION_CHECK(1,16,0)
      pango_font_description_set_gravity (desc, PANGO_GRAVITY_AUTO);
#endif /* PANGO_VERSION_CHECK(1,16,0) */
      name = pango_font_description_to_string (desc);
      pango_font_description_free (desc);
      if (name)
        {
          gtk_font_selection_set_font_name (GTK_FONT_SELECTION (dialog), name);
          g_free (name);
        }
    }
  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK)
    {
      gchar *name;
      PangoFontDescription *desc;

      if (lpcf->Flags & CF_EFFECTS)
        {
          lpcf->lpLogFont->lfStrikeOut = gtk_toggle_button_get_active
                                            (GTK_TOGGLE_BUTTON (check_strike));
          lpcf->lpLogFont->lfUnderline = gtk_toggle_button_get_active
                                            (GTK_TOGGLE_BUTTON (check_under));
#if GTK_CHECK_VERSION(2,4,0)
          if (button)
            gtk_color_button_get_color (GTK_COLOR_BUTTON (button), &color);
#endif /* GTK_CHECK_VERSION(2,4,0) */
          lpcf->rgbColors = RGB (color.red / 256,
                                 color.green / 256,
                                 color.blue / 256);
        }
      else
        {
          lpcf->lpLogFont->lfStrikeOut = lpcf->lpLogFont->lfUnderline = FALSE;
        }
      lpcf->nFontType = SIMULATED_FONTTYPE;
      name = gtk_font_selection_get_font_name (GTK_FONT_SELECTION (dialog));
      desc = name ? pango_font_description_from_string (name) : NULL;
      g_free (name);
      lpcf->lpLogFont->lfWidth = 0;
      lpcf->lpLogFont->lfEscapement = 0;
      lpcf->lpLogFont->lfOrientation = 0;
      lpcf->lpLogFont->lfCharSet = ANSI_CHARSET;
      lpcf->lpLogFont->lfOutPrecision = OUT_DEFAULT_PRECIS;
      lpcf->lpLogFont->lfClipPrecision = CLIP_DEFAULT_PRECIS;
      lpcf->lpLogFont->lfQuality = DEFAULT_QUALITY;
      lpcf->lpLogFont->lfPitchAndFamily = DEFAULT_PITCH | FF_DONTCARE;
      lpcf->lpLogFont->lfFaceName[0] = '\0';
      if (desc)
        {
          const gchar *family;
          gunichar2 *wc;

#if PANGO_VERSION_CHECK(1,8,0)
          lpcf->lpLogFont->lfHeight = pango_font_description_get_size (desc)
                * (pango_font_description_get_size_is_absolute (desc) ? -1 : 1)
                                                                / PANGO_SCALE;
#else /* not PANGO_VERSION_CHECK(1,8,0) */
          lpcf->lpLogFont->lfHeight
                        = pango_font_description_get_size (desc) / PANGO_SCALE;
#endif /* not PANGO_VERSION_CHECK(1,8,0) */
          lpcf->lpLogFont->lfWeight
                            = (LONG)pango_font_description_get_weight (desc);
          lpcf->lpLogFont->lfItalic = pango_font_description_get_style
                                                (desc) != PANGO_STYLE_NORMAL;
          family = pango_font_description_get_family (desc);
          wc = family ? g_utf8_to_utf16 (family, -1, NULL, NULL, NULL) : NULL;
          if (wc)
            {
              lstrcpynW (lpcf->lpLogFont->lfFaceName, wc, LF_FACESIZE);
              g_free (wc);
            }
          pango_font_description_free (desc);
        }
      else
        {
          lpcf->lpLogFont->lfHeight = 0;
          lpcf->lpLogFont->lfWeight = (LONG)PANGO_WEIGHT_NORMAL;
          lpcf->lpLogFont->lfItalic = FALSE;
        }
      lpcf->iPointSize = ABS (lpcf->lpLogFont->lfHeight) * 10;
      fResult = TRUE;
    }
  gtk_widget_destroy (dialog);
  return fResult;
}


/* CommDlgExtendedError ordinal = 105, argument = 0 temporary */
static DWORD WINAPI CommDlgExtendedError (VOID)
{
  return 0;
}


/* FindTextA ordinal = 106, argument = 4 temporary */
static DWORD WINAPI FindTextA (DWORD dwArgv0)
{
  return 0;
}


/* FindTextW ordinal = 107, argument = 4 temporary */
static DWORD WINAPI FindTextW (DWORD dwArgv0)
{
  return 0;
}


/* GetFileTitleA ordinal = 108, argument = 12 temporary */
static DWORD WINAPI GetFileTitleA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetFileTitleW ordinal = 109, argument = 12 temporary */
static DWORD WINAPI GetFileTitleW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


static BOOL
commdlg_GetFileNameA (LPOPENFILENAMEA lpofn,
                      const gboolean  opendlg)
{
  gchar *title;
  GtkWidget *dialog, *check = NULL;
#if GTK_CHECK_VERSION(2,4,0)
  GtkWidget *parent;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  BOOL fResult = FALSE;

  if (!lpofn || !lpofn->lpstrFile)
    return FALSE;
  title = w32ldr_utf8_from_mb (lpofn->lpstrTitle);
  if (!title)
    {
      GtkStockItem stock_item;

      gtk_stock_lookup (opendlg ? GTK_STOCK_OPEN : GTK_STOCK_SAVE_AS,
                                                                &stock_item);
      title = misc_mnemonic_to_text (stock_item.label);
    }
  if (!(lpofn->Flags & OFN_HIDEREADONLY))
    {
      check = gtk_check_button_new_with_mnemonic ("_Read Only");
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check),
                                                lpofn->Flags & OFN_READONLY);
    }
#if GTK_CHECK_VERSION(2,4,0)
  for (parent = lpofn->hwndOwner; parent;
                                    parent = gtk_widget_get_parent (parent))
    if (GTK_IS_WINDOW (parent))
      break;
  dialog = gtk_file_chooser_dialog_new (title,
        parent ? GTK_WINDOW (parent) : NULL,
        opendlg ? GTK_FILE_CHOOSER_ACTION_OPEN : GTK_FILE_CHOOSER_ACTION_SAVE,
        GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
        opendlg ? GTK_STOCK_OPEN : GTK_STOCK_SAVE_AS, GTK_RESPONSE_ACCEPT,
        NULL);
  if (lpofn->lpstrFilter)
    {
      const gchar *mb;
      gint i = 1;

      mb = lpofn->lpstrFilter;
      while (*mb != '\0')
        {
          gchar *text, **ext;
          gint j;
          GtkFileFilter *filter;

          filter = gtk_file_filter_new ();
          text = w32ldr_utf8_from_mb (mb);
          mb += g_strlen (mb) + 1;
          gtk_file_filter_set_name (filter, text);
          g_free (text);
          text = w32ldr_filename_from_mb (mb);
          mb += g_strlen (mb) + 1;
          ext = g_strsplit (text, ";", 0);
          g_free (text);
          for (j = 0; ext[j]; j++)
            gtk_file_filter_add_pattern (filter, ext[j]);
          g_strfreev (ext);
          gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (dialog), filter);
          if (i == lpofn->nFilterIndex)
            gtk_file_chooser_set_filter (GTK_FILE_CHOOSER (dialog), filter);
          g_object_set_data (G_OBJECT (filter), "user_data",
                                                        GINT_TO_POINTER (i));
          i++;
        }
    }
  if (lpofn->lpstrFile[0] != '\0')
    {
      gchar *file;

      file = w32ldr_filename_from_mb (lpofn->lpstrFile);
      gtk_file_chooser_set_filename (GTK_FILE_CHOOSER (dialog), file);
      g_free (file);
    }
  if (lpofn->lpstrInitialDir && lpofn->lpstrInitialDir[0] != '\0')
    {
      gchar *path;

      path = w32ldr_filename_from_mb (lpofn->lpstrInitialDir);
      gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (dialog), path);
      g_free (path);
    }
  gtk_file_chooser_set_select_multiple (GTK_FILE_CHOOSER (dialog),
                                        lpofn->Flags & OFN_ALLOWMULTISELECT);
  if (check)
    gtk_file_chooser_set_extra_widget (GTK_FILE_CHOOSER (dialog), check);
  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
    {
      gchar *mb = NULL;

      if (lpofn->lpstrFilter)
        {
          GtkFileFilter *filter;

          filter = gtk_file_chooser_get_filter (GTK_FILE_CHOOSER (dialog));
          lpofn->nFilterIndex = GPOINTER_TO_INT
                        (g_object_get_data (G_OBJECT (filter), "user_data"));
        }
      if (lpofn->Flags & OFN_ALLOWMULTISELECT)
        {
          GSList *gslist;

          gslist = gtk_file_chooser_get_filenames (GTK_FILE_CHOOSER (dialog));
          if (gslist)
            {
              if (g_slist_length (gslist) == 1)
                {
                  mb = w32ldr_filename_to_mb (gslist->data);
                  g_free (gslist->data);
                  g_slist_free (gslist);
                }
              else
                {
                  gchar *file;

                  file = g_path_get_dirname (gslist->data);
                  mb = w32ldr_filename_to_mb (file);
                  g_free (file);
                  while (gslist)
                    {
                      gchar *tmp;
                      gsize leng;

                      file = g_path_get_basename (gslist->data);
                      tmp = w32ldr_filename_to_mb (file);
                      g_free (file);
                      leng = g_strlen (mb);
                      mb = g_realloc (mb,
                                (leng + g_strlen (tmp) + 2) * sizeof (gchar));
                      mb[leng] = ' ';
                      g_strcpy (mb + leng + 1, tmp);
                      g_free (tmp);
                      g_free (gslist->data);
                      gslist = g_slist_delete_link (gslist, gslist);
                    }
                }
            }
        }
      else
        {
          gchar *file;

          file = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
          mb = w32ldr_filename_to_mb (file);
          g_free (file);
        }
#else /* not GTK_CHECK_VERSION(2,4,0) */
  dialog = gtk_file_selection_new (title);
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (dialog));
  if (lpofn->lpstrFile[0] != '\0')
    {
      gchar *file;

      file = w32ldr_filename_from_mb (lpofn->lpstrFile);
      gtk_file_selection_set_filename (GTK_FILE_SELECTION (dialog), file);
      g_free (file);
    }
  gtk_file_selection_set_select_multiple (GTK_FILE_SELECTION (dialog),
                                        lpofn->Flags & OFN_ALLOWMULTISELECT);
  if (check)
    gtk_box_pack_end (GTK_BOX (GTK_FILE_SELECTION (dialog)->main_vbox),
                                                    check, FALSE, FALSE, 0);
  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK)
    {
      gchar *mb = NULL;

      if (lpofn->Flags & OFN_ALLOWMULTISELECT)
        {
          gchar **files;

          files = gtk_file_selection_get_selections
                                                (GTK_FILE_SELECTION (dialog));
          if (files && files[0])
            {
              if (!files[1])
                {
                  mb = w32ldr_filename_to_mb (files[1]);
                }
              else
                {
                  gchar *file;
                  gint i;

                  file = g_path_get_dirname (files[0]);
                  mb = w32ldr_filename_to_mb (file);
                  g_free (file);
                  for (i = 0; files[i]; i++)
                    {
                      gchar *tmp;
                      gsize leng;

                      file = g_path_get_basename (files[i]);
                      tmp = w32ldr_filename_to_mb (file);
                      g_free (file);
                      leng = g_strlen (mb);
                      mb = g_realloc (mb,
                                (leng + g_strlen (tmp) + 2) * sizeof (gchar));
                      mb[leng] = ' ';
                      g_strcpy (mb + leng + 1, tmp);
                      g_free (tmp);
                    }
                }
            }
          g_strfreev (files);
        }
      else
        {
          mb = w32ldr_filename_from_utf8 (gtk_file_selection_get_filename
                                                (GTK_FILE_SELECTION (dialog)));
        }
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      if (mb && lpofn->nMaxFile < g_strlen (mb))
        {
          g_strcpy (lpofn->lpstrFile, mb);
          fResult = TRUE;
        }
      g_free (mb);
      if (check)
        {
          if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (check)))
            lpofn->Flags |= OFN_READONLY;
          else
            lpofn->Flags &= ~OFN_READONLY;
        }
    }
  gtk_widget_destroy (dialog);
  g_free (title);
  return fResult;
}


static BOOL
commdlg_GetFileNameW (LPOPENFILENAMEW lpofn,
                      const gboolean  opendlg)
{
  gchar *title;
  GtkWidget *dialog, *check = NULL;
#if GTK_CHECK_VERSION(2,4,0)
  GtkWidget *parent;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  BOOL fResult = FALSE;

  if (!lpofn || !lpofn->lpstrFile)
    return FALSE;
  title = lpofn->lpstrTitle ? g_utf16_to_utf8 (lpofn->lpstrTitle, -1,
                                                    NULL, NULL, NULL) : NULL;
  if (!title)
    {
      GtkStockItem stock_item;

      gtk_stock_lookup (opendlg ? GTK_STOCK_OPEN : GTK_STOCK_SAVE_AS,
                                                                &stock_item);
      title = misc_mnemonic_to_text (stock_item.label);
    }
  if (!(lpofn->Flags & OFN_HIDEREADONLY))
    {
      check = gtk_check_button_new_with_mnemonic ("_Read Only");
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check),
                                                lpofn->Flags & OFN_READONLY);
    }
#if GTK_CHECK_VERSION(2,4,0)
  for (parent = lpofn->hwndOwner; parent;
                                    parent = gtk_widget_get_parent (parent))
    if (GTK_IS_WINDOW (parent))
      break;
  dialog = gtk_file_chooser_dialog_new (title,
        parent ? GTK_WINDOW (parent) : NULL,
        opendlg ? GTK_FILE_CHOOSER_ACTION_OPEN : GTK_FILE_CHOOSER_ACTION_SAVE,
        GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
        opendlg ? GTK_STOCK_OPEN : GTK_STOCK_SAVE_AS, GTK_RESPONSE_ACCEPT,
        NULL);
  if (lpofn->lpstrFilter)
    {
      const gunichar2 *wc;
      gint i = 1;

      wc = lpofn->lpstrFilter;
      while (*wc != '\0')
        {
          gchar *text, **ext;
          gint j;
          GtkFileFilter *filter;

          filter = gtk_file_filter_new ();
          text = g_utf16_to_utf8 (wc, -1, NULL, NULL, NULL);
          wc += lstrlenW (wc) + 1;
          gtk_file_filter_set_name (filter, text);
          g_free (text);
          text = g_utf16_to_utf8 (wc, -1, NULL, NULL, NULL);
          wc += lstrlenW (wc) + 1;
          ext = g_strsplit (text, ";", 0);
          g_free (text);
          for (j = 0; ext[j]; j++)
            gtk_file_filter_add_pattern (filter, ext[j]);
          g_strfreev (ext);
          gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (dialog), filter);
          if (i == lpofn->nFilterIndex)
            gtk_file_chooser_set_filter (GTK_FILE_CHOOSER (dialog), filter);
          g_object_set_data (G_OBJECT (filter), "user_data",
                                                        GINT_TO_POINTER (i));
          i++;
        }
    }
  if (lpofn->lpstrFile[0] != '\0')
    {
      gchar *file;

      file = w32ldr_filename_from_wc (lpofn->lpstrFile);
      gtk_file_chooser_set_filename (GTK_FILE_CHOOSER (dialog), file);
      g_free (file);
    }
  if (lpofn->lpstrInitialDir && lpofn->lpstrInitialDir[0] != '\0')
    {
      gchar *path;

      path = w32ldr_filename_from_wc (lpofn->lpstrInitialDir);
      gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (dialog), path);
      g_free (path);
    }
  gtk_file_chooser_set_select_multiple (GTK_FILE_CHOOSER (dialog),
                                        lpofn->Flags & OFN_ALLOWMULTISELECT);
  if (check)
    gtk_file_chooser_set_extra_widget (GTK_FILE_CHOOSER (dialog), check);
  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
    {
      gunichar2 *wc = NULL;

      if (lpofn->lpstrFilter)
        {
          GtkFileFilter *filter;

          filter = gtk_file_chooser_get_filter (GTK_FILE_CHOOSER (dialog));
          lpofn->nFilterIndex = GPOINTER_TO_INT
                        (g_object_get_data (G_OBJECT (filter), "user_data"));
        }
      if (lpofn->Flags & OFN_ALLOWMULTISELECT)
        {
          GSList *gslist;

          gslist = gtk_file_chooser_get_filenames (GTK_FILE_CHOOSER (dialog));
          if (gslist)
            {
              if (g_slist_length (gslist) == 1)
                {
                  wc = w32ldr_filename_to_wc (gslist->data);
                  g_free (gslist->data);
                  g_slist_free (gslist);
                }
              else
                {
                  gchar *file;

                  file = g_path_get_dirname (gslist->data);
                  wc = w32ldr_filename_to_wc (file);
                  g_free (file);
                  while (gslist)
                    {
                      gunichar2 *tmp;
                      gsize leng;

                      file = g_path_get_basename (gslist->data);
                      tmp = w32ldr_filename_to_wc (file);
                      g_free (file);
                      leng = lstrlenW (wc);
                      wc = g_realloc (wc,
                            (leng + lstrlenW (tmp) + 2) * sizeof (gunichar2));
                      wc[leng] = ' ';
                      lstrcpyW (wc + leng + 1, tmp);
                      g_free (tmp);
                      g_free (gslist->data);
                      gslist = g_slist_delete_link (gslist, gslist);
                    }
                }
            }
        }
      else
        {
          gchar *file;

          file = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
          wc = w32ldr_filename_to_wc (file);
          g_free (file);
        }
#else /* not GTK_CHECK_VERSION(2,4,0) */
  dialog = gtk_file_selection_new (title);
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (dialog));
  if (lpofn->lpstrFile[0] != '\0')
    {
      gchar *file;

      file = w32ldr_filename_from_wc (lpofn->lpstrFile);
      gtk_file_selection_set_filename (GTK_FILE_SELECTION (dialog), file);
      g_free (file);
    }
  gtk_file_selection_set_select_multiple (GTK_FILE_SELECTION (dialog),
                                        lpofn->Flags & OFN_ALLOWMULTISELECT);
  if (check)
    gtk_box_pack_end (GTK_BOX (GTK_FILE_SELECTION (dialog)->main_vbox),
                                                    check, FALSE, FALSE, 0);
  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK)
    {
      gunichar2 *wc = NULL;

      if (lpofn->Flags & OFN_ALLOWMULTISELECT)
        {
          gchar **files;

          files = gtk_file_selection_get_selections
                                                (GTK_FILE_SELECTION (dialog));
          if (files && files[0])
            {
              if (!files[1])
                {
                  wc = w32ldr_filename_to_wc (files[1]);
                }
              else
                {
                  gchar *file;
                  gint i;

                  file = g_path_get_dirname (files[0]);
                  wc = w32ldr_filename_to_wc (file);
                  g_free (file);
                  for (i = 0; files[i]; i++)
                    {
                      gunichar2 *tmp;
                      gsize leng;

                      file = g_path_get_basename (files[i]);
                      tmp = w32ldr_filename_to_wc (file);
                      g_free (file);
                      leng = lstrlenW (wc);
                      wc = g_realloc (wc,
                            (leng + lstrlenW (tmp) + 2) * sizeof (gunichar2));
                      wc[leng] = ' ';
                      lstrcpyW (wc + leng + 1, tmp);
                      g_free (tmp);
                    }
                }
            }
          g_strfreev (files);
        }
      else
        {
          wc = w32ldr_filename_to_wc (gtk_file_selection_get_filename
                                                (GTK_FILE_SELECTION (dialog)));
        }
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      if (wc && lpofn->nMaxFile < lstrlenW (wc))
        {
          lstrcpyW (lpofn->lpstrFile, wc);
          fResult = TRUE;
        }
      g_free (wc);
      if (check)
        {
          if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (check)))
            lpofn->Flags |= OFN_READONLY;
          else
            lpofn->Flags &= ~OFN_READONLY;
        }
    }
  gtk_widget_destroy (dialog);
  g_free (title);
  return fResult;
}


/* GetOpenFileNameA ordinal = 110, argument = 4 */
BOOL WINAPI GetOpenFileNameA (LPOPENFILENAMEA lpofn)
{
  return commdlg_GetFileNameA (lpofn, TRUE);
}


/* GetOpenFileNameW ordinal = 111, argument = 4 */
BOOL WINAPI GetOpenFileNameW (LPOPENFILENAMEW lpofn)
{
  return commdlg_GetFileNameW (lpofn, TRUE);
}


/* GetSaveFileNameA ordinal = 112, argument = 4 */
BOOL WINAPI GetSaveFileNameA (LPOPENFILENAMEA lpofn)
{
  return commdlg_GetFileNameA (lpofn, FALSE);
}


/* GetSaveFileNameW ordinal = 113, argument = 4 */
BOOL WINAPI GetSaveFileNameW (LPOPENFILENAMEW lpofn)
{
  return commdlg_GetFileNameW (lpofn, FALSE);
}


/* LoadAlterBitmap ordinal = 114, argument = 12 temporary */
static DWORD WINAPI LoadAlterBitmap (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* PageSetupDlgA ordinal = 115, argument = 4 temporary */
static DWORD WINAPI PageSetupDlgA (DWORD dwArgv0)
{
  return 0;
}


/* PageSetupDlgW ordinal = 116, argument = 4 temporary */
static DWORD WINAPI PageSetupDlgW (DWORD dwArgv0)
{
  return 0;
}


/* PrintDlgA ordinal = 117, argument = 4 temporary */
static DWORD WINAPI PrintDlgA (DWORD dwArgv0)
{
  return 0;
}


/* PrintDlgExA ordinal = 118, argument = 4 temporary */
static DWORD WINAPI PrintDlgExA (DWORD dwArgv0)
{
  return 0;
}


/* PrintDlgExW ordinal = 119, argument = 4 temporary */
static DWORD WINAPI PrintDlgExW (DWORD dwArgv0)
{
  return 0;
}


/* PrintDlgW ordinal = 120, argument = 4 temporary */
static DWORD WINAPI PrintDlgW (DWORD dwArgv0)
{
  return 0;
}


/* ReplaceTextA ordinal = 121, argument = 4 temporary */
static DWORD WINAPI ReplaceTextA (DWORD dwArgv0)
{
  return 0;
}


/* ReplaceTextW ordinal = 122, argument = 4 temporary */
static DWORD WINAPI ReplaceTextW (DWORD dwArgv0)
{
  return 0;
}


/* Ssync_ANSI_UNICODE_Struct_For_WOW ordinal = 123, argument = 12 temporary */
static DWORD WINAPI Ssync_ANSI_UNICODE_Struct_For_WOW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* WantArrows ordinal = 124, argument = 16 temporary */
static DWORD WINAPI WantArrows (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* dwLBSubclass ordinal = 125, argument = 16 temporary */
static DWORD WINAPI dwLBSubclass (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* dwOKSubclass ordinal = 126, argument = 16 temporary */
static DWORD WINAPI dwOKSubclass (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


W32LdrExport w32ldr_commdlg_exports[] = {
{-1, 101, "ChooseColorA",                      ChooseColorA},
{-1, 102, "ChooseColorW",                      ChooseColorW},
{ 0, 103, "ChooseFontA",                       ChooseFontA},
{ 0, 104, "ChooseFontW",                       ChooseFontW},
{-1, 105, "CommDlgExtendedError",              CommDlgExtendedError},
{-1, 106, "FindTextA",                         FindTextA},
{-1, 107, "FindTextW",                         FindTextW},
{-1, 108, "GetFileTitleA",                     GetFileTitleA},
{-1, 109, "GetFileTitleW",                     GetFileTitleW},
{ 0, 110, "GetOpenFileNameA",                  GetOpenFileNameA},
{ 0, 111, "GetOpenFileNameW",                  GetOpenFileNameW},
{ 0, 112, "GetSaveFileNameA",                  GetSaveFileNameA},
{ 0, 113, "GetSaveFileNameW",                  GetSaveFileNameW},
{-1, 114, "LoadAlterBitmap",                   LoadAlterBitmap},
{-1, 115, "PageSetupDlgA",                     PageSetupDlgA},
{-1, 116, "PageSetupDlgW",                     PageSetupDlgW},
{-1, 117, "PrintDlgA",                         PrintDlgA},
{-1, 118, "PrintDlgExA",                       PrintDlgExA},
{-1, 119, "PrintDlgExW",                       PrintDlgExW},
{-1, 120, "PrintDlgW",                         PrintDlgW},
{-1, 121, "ReplaceTextA",                      ReplaceTextA},
{-1, 122, "ReplaceTextW",                      ReplaceTextW},
{-1, 123, "Ssync_ANSI_UNICODE_Struct_For_WOW", Ssync_ANSI_UNICODE_Struct_For_WOW},
{-1, 124, "WantArrows",                        WantArrows},
{-1, 125, "dwLBSubclass",                      dwLBSubclass},
{-1, 126, "dwOKSubclass",                      dwOKSubclass},
{-1,   0, NULL,                                NULL}};
