/*
    w32loader
    copyright (c) 1998-2010 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "commctrl.h"
#include "kernel32.h"
#include "user32.h"
#include "tchar.h"
#include "w32private.h"


#ifdef W32LDR_HEADER
#include "user32.h"

/* ja:共通 */
#define CLR_NONE    0xffffffff
#define CLR_DEFAULT 0xff000000
#define CLR_HILIGHT CLR_DEFAULT
#define CCS_TOP              0x00000001
#define CCS_NOMOVEY          0x00000002
#define CCS_BOTTOM           0x00000003
#define CCS_NORESIZE         0x00000004
#define CCS_NOPARENTALIGN    0x00000008
#define CCS_ADJUSTABLE       0x00000020
#define CCS_NODIVIDER        0x00000040
#define CCS_VERT             0x00000080
#define CCS_LEFT             (CCS_VERT|CCS_TOP)
#define CCS_RIGHT            (CCS_VERT|CCS_BOTTOM)
#define CCS_NOMOVEX          (CCS_VERT|CCS_NOMOVEY)
#define CCM_FIRST            0x2000
#define CCM_SETBKCOLOR       (CCM_FIRST+1)
#define CCM_SETCOLORSCHEME   (CCM_FIRST+2)
#define CCM_GETCOLORSCHEME   (CCM_FIRST+3)
#define CCM_GETDROPTARGET    (CCM_FIRST+4)
#define CCM_SETUNICODEFORMAT (CCM_FIRST+5)
#define CCM_GETUNICODEFORMAT (CCM_FIRST+6)
#define CCM_SETVERSION       (CCM_FIRST+7)
#define CCM_GETVERSION       (CCM_FIRST+8)
#define CCM_SETNOTIFYWINDOW  (CCM_FIRST+9)
#define CCM_SETWINDOWTHEME   (CCM_FIRST+11)
#define CCM_DPISCALE         (CCM_FIRST+12)
#define NM_FIRST             (0)
#define NM_LAST              (-99)
#define NM_OUTOFMEMORY       (NM_FIRST-1)
#define NM_CLICK             (NM_FIRST-2)
#define NM_DBLCLK            (NM_FIRST-3)
#define NM_RETURN            (NM_FIRST-4)
#define NM_RCLICK            (NM_FIRST-5)
#define NM_RDBLCLK           (NM_FIRST-6)
#define NM_SETFOCUS          (NM_FIRST-7)
#define NM_KILLFOCUS         (NM_FIRST-8)
#include "pshpack1.h"
typedef struct _INITCOMMONCONTROLSEX
{
  DWORD dwSize;
  DWORD dwICC;
} INITCOMMONCONTROLSEX, *PINITCOMMONCONTROLSEX, *LPINITCOMMONCONTROLSEX;
typedef struct _NMHDR
{
  HWND hwndFrom;
  UINT_PTR idFrom;
  UINT code;
} NMHDR, *PNMHDR, *LPNMHDR;
#include "poppack.h"

/* ja:ツールバー */
/* ja:ツールチップ */
#include "w32tool.h"

/* ja:ステータスウインドウ */
#include "w32stat.h"

/* ja:プロパティシート */
#include "w32prsht.h"

/* ja:イメージリスト */
#define ILC_MASK     0x0001
#define ILC_COLOR    0x0000
#define ILC_COLORDDB 0x00fe
#define ILC_COLOR4   0x0004
#define ILC_COLOR8   0x0008
#define ILC_COLOR16  0x0010
#define ILC_COLOR24  0x0018
#define ILC_COLOR32  0x0020
#define ILC_PALETTE  0x0800
#define ILD_NORMAL        0x0000
#define ILD_TRANSPARENT   0x0001
#define ILD_BLEND25       0x0002
#define ILD_FOCUS         ILD_BLEND25
#define ILD_BLEND50       0x0004
#define ILD_BLEND         ILD_BLEND50
#define ILD_SELECTED      ILD_BLEND50
#define ILD_MASK          0x0010
#define ILD_IMAGE         0x0020
#define ILD_ROP           0x0040
#define ILD_OVERLAYMASK   0x0f00
#define ILD_PRESERVEALPHA 0x1000
#define ILD_SCALE         0x2000
#define ILD_DPISCALE      0x4000
#define ILD_ASYNC         0x8000
#define ILS_NORMAL   0x0000
#define ILS_GLOW     0x0001
#define ILS_SHADOW   0x0002
#define ILS_SATURATE 0x0004
#define ILS_ALPHA    0x0008
#define ImageList_ExtractIcon(hInstance,hImage,i) ImageList_GetIcon(hImage,i,0)
#define ImageList_LoadBitmap(hInstance,lpszBitmap,cx,cGrow,crMask) ImageList_LoadImage(hInstance,lpszBitmap,cx,cGrow,crMask,IMAGE_BITMAP,0)
#define ImageList_RemoveAll(hImage) ImageList_Remove(hImage,-1)
typedef LPVOID HIMAGELIST;
typedef LPVOID LPSTREAM;
#include "pshpack1.h"
typedef struct _IMAGELISTDRAWPARAMS
{
  DWORD cbSize;
  HIMAGELIST himl;
  INT i;
  HDC hdcDst;
  INT x;
  INT y;
  INT cx;
  INT cy;
  INT xBitmap;
  INT yBitmap;
  COLORREF rgbBk;
  COLORREF rgbFg;
  UINT fStyle;
  DWORD dwRop;
  DWORD fState;
  DWORD Frame;
  COLORREF crEffect;
} IMAGELISTDRAWPARAMS, *PIMAGELISTDRAWPARAMS, *LPIMAGELISTDRAWPARAMS;
typedef struct _IMAGEINFO
{
  HBITMAP hbmImage;
  HBITMAP hbmMask;
  INT Unused1;
  INT Unused2;
  RECT rcImage;
} IMAGEINFO, *PIMAGEINFO, *LPIMAGEINFO;
#include "poppack.h"

/* ja:リストビュー */
#include "w32lview.h"

/* ja:ツリービュー */
#include "w32tview.h"

/* ja:プログレスコントロール */
#include "w32prgrs.h"

/* ja:ヘッダコントロール */
#define WC_HEADERA "SysHeader32"
#define WC_HEADERW (w32ldr_tchar_to_wc("SysHeader32"))
#ifdef UNICODE
# define WC_HEADER WC_HEADERW
#else /* not UNICODE */
# define WC_HEADER WC_HEADERA
#endif /* not UNICODE */
#define HDS_HORZ       0x0000
#define HDS_BUTTONS    0x0002
#define HDS_HOTTRACK   0x0004
#define HDS_HIDDEN     0x0008
#define HDS_DRAGDROP   0x0040
#define HDS_FULLDRAG   0x0080
#define HDS_FILTERBAR  0x0100
#define HDS_FLAT       0x0200
#define HDS_CHECKBOXES 0x0400
#define HDM_FIRST        0x1200
#define HDM_GETITEMCOUNT (HDM_FIRST+0)
#define HDM_INSERTITEMA  (HDM_FIRST+1)
#define HDM_INSERTITEMW  (HDM_FIRST+10)
#define HDM_DELETEITEM   (HDM_FIRST+2)
#define HDM_GETITEMA     (HDM_FIRST+3)
#define HDM_GETITEMW     (HDM_FIRST+11)
#define HDM_SETITEMA     (HDM_FIRST+4)
#define HDM_SETITEMW     (HDM_FIRST+12)
#define HDM_LAYOUT       (HDM_FIRST+5)
#define HDM_HITTEST      (HDM_FIRST+6)
#ifdef UNICODE
# define HDM_INSERTITEM HDM_INSERTITEMW
# define HDM_GETITEM HDM_GETITEMW
# define HDM_SETITEM HDM_SETITEMW
#else /* not UNICODE */
# define HDM_INSERTITEM HDM_INSERTITEMA
# define HDM_GETITEM HDM_GETITEMA
# define HDM_SETITEM HDM_SETITEMA
#endif /* not UNICODE */
#define HDN_FIRST            (-300)
#define HDN_LAST             (-399)
#define HDN_ITEMCHANGINGA    (HDN_FIRST-0)
#define HDN_ITEMCHANGINGW    (HDN_FIRST-20)
#define HDN_ITEMCHANGEDA     (HDN_FIRST-1)
#define HDN_ITEMCHANGEDW     (HDN_FIRST-21)
#define HDN_ITEMCLICKA       (HDN_FIRST-2)
#define HDN_ITEMCLICKW       (HDN_FIRST-22)
#define HDN_ITEMDBLCLICKA    (HDN_FIRST-3)
#define HDN_ITEMDBLCLICKW    (HDN_FIRST-23)
#define HDN_DIVIDERDBLCLICKA (HDN_FIRST-5)
#define HDN_DIVIDERDBLCLICKW (HDN_FIRST-25)
#define HDN_BEGINTRACKA      (HDN_FIRST-6)
#define HDN_BEGINTRACKW      (HDN_FIRST-26)
#define HDN_ENDTRACKA        (HDN_FIRST-7)
#define HDN_ENDTRACKW        (HDN_FIRST-27)
#define HDN_TRACKA           (HDN_FIRST-8)
#define HDN_TRACKW           (HDN_FIRST-28)
#ifdef UNICODE
# define HDN_ITEMCHANGING HDN_ITEMCHANGINGW
# define HDN_ITEMCHANGED HDN_ITEMCHANGEDW
# define HDN_ITEMCLICK HDN_ITEMCLICKW
# define HDN_ITEMDBLCLICK HDN_ITEMDBLCLICKW
# define HDN_DIVIDERDBLCLICK HDN_DIVIDERDBLCLICKW
# define HDN_BEGINTRACK HDN_BEGINTRACKW
# define HDN_ENDTRACK HDN_ENDTRACKW
# define HDN_TRACK HDN_TRACKW
#else /* not UNICODE */
# define HDN_ITEMCHANGING HDN_ITEMCHANGINGA
# define HDN_ITEMCHANGED HDN_ITEMCHANGEDA
# define HDN_ITEMCLICK HDN_ITEMCLICKA
# define HDN_ITEMDBLCLICK HDN_ITEMDBLCLICKA
# define HDN_DIVIDERDBLCLICK HDN_DIVIDERDBLCLICKA
# define HDN_BEGINTRACK HDN_BEGINTRACKA
# define HDN_ENDTRACK HDN_ENDTRACKA
# define HDN_TRACK HDN_TRACKA
#endif /* not UNICODE */

#define HDI_WIDTH       0x0001
#define HDI_HEIGHT      HDI_WIDTH
#define HDI_TEXT        0x0002
#define HDI_FORMAT      0x0004
#define HDI_LPARAM      0x0008
#define HDI_BITMAP      0x0010
#define HDF_LEFT        0x0000
#define HDF_RIGHT       0x0001
#define HDF_CENTER      0x0002
#define HDF_JUSTIFYMASK 0x0003
#define HDF_RTLREADING  0x0004
#define HDF_BITMAP      0x2000
#define HDF_STRING      0x4000
#define HDF_OWNERDRAW   0x8000
#include "pshpack1.h"
typedef struct _HD_ITEMA
{
  UINT mask;
  INT cxy;
  LPSTR pszText;
  HBITMAP hbm;
  INT cchTextMax;
  INT fmt;
  LPARAM lParam;
} HD_ITEMA, *PHD_ITEMA, *LPHD_ITEMA;
typedef struct _HD_ITEMW
{
  UINT mask;
  INT cxy;
  LPWSTR pszText;
  HBITMAP hbm;
  INT cchTextMax;
  INT fmt;
  LPARAM lParam;
} HD_ITEMW, *PHD_ITEMW, *LPHD_ITEMW;
#include "poppack.h"
#ifdef UNICODE
# define HD_ITEM HD_ITEMW
# define PHD_ITEM PHD_ITEMW
# define LPHD_ITEM LPHD_ITEMW
#else /* not UNICODE */
# define HD_ITEM HD_ITEMA
# define PHD_ITEM PHD_ITEMA
# define LPHD_ITEM LPHD_ITEMA
#endif /* not UNICODE */

#include "pshpack1.h"
typedef struct _HD_LAYOUT
{
  LPRECT prc;
  LPWINDOWPOS pwpos;
} HD_LAYOUT, *PHD_LAYOUT, *LPHD_LAYOUT;
#include "poppack.h"

#define HHT_NOWHERE   0x0001
#define HHT_ONHEADER  0x0002
#define HHT_ONDIVIDER 0x0004
#define HHT_ONDIVOPEN 0x0008
#define HHT_TORIGHT   0x0400
#define HHT_TOLEFT    0x0800

#include "pshpack1.h"
typedef struct _HD_NOTIFYA
{
  NMHDR hdr;
  INT iItem;
  INT iButton;
  HD_ITEMA *pitem;
} HD_NOTIFYA, *PHD_NOTIFYA, *LPHD_NOTIFYA;
typedef struct _HD_NOTIFYW
{
  NMHDR hdr;
  INT iItem;
  INT iButton;
  HD_ITEMW *pitem;
} HD_NOTIFYW, *PHD_NOTIFYW, *LPHD_NOTIFYW;
#include "poppack.h"
#ifdef UNICODE
# define HD_NOTIFY HD_NOTIFYW
# define PHD_NOTIFY PHD_NOTIFYW
# define LPHD_NOTIFY LPHD_NOTIFYW
#else /* not UNICODE */
# define HD_NOTIFY HD_NOTIFYA
# define PHD_NOTIFY PHD_NOTIFYA
# define LPHD_NOTIFY LPHD_NOTIFYA
#endif /* not UNICODE */

#define Header_DeleteItem(hWnd,index) SendMessageA(hWnd,HDM_DELETEITEM,index,0)
#define Header_GetItemA(hWnd,index,phdi) SendMessageA(hWnd,HDM_GETITEMA,index,GPOINTER_TO_INT(phdi))
#define Header_GetItemW(hWnd,index,phdi) SendMessageW(hWnd,HDM_GETITEMW,index,GPOINTER_TO_INT(phdi))
#define Header_GetItemCount(hWnd) SendMessageA(hWnd,HDM_GETITEMCOUNT,0,0)
#define Header_InsertItemA(hWnd,index,phdi) SendMessageA(hWnd,HDM_INSERTITEMA,index,GPOINTER_TO_INT(phdi))
#define Header_InsertItemW(hWnd,index,phdi) SendMessageW(hWnd,HDM_INSERTITEMW,index,GPOINTER_TO_INT(phdi))
#define Header_Layout(hWnd,playout) SendMessageA(hWnd,HDM_LAYOUT,0,GPOINTER_TO_INT(playout))
#define Header_SetItemA(hWnd,index,phdi) SendMessageA(hWnd,HDM_SETITEMA,index,GPOINTER_TO_INT(phdi))
#define Header_SetItemW(hWnd,index,phdi) SendMessageW(hWnd,HDM_SETITEMW,index,GPOINTER_TO_INT(phdi))
#ifdef UNICODE
# define Header_GetItem Header_GetItemW
# define Header_InsertItem Header_InsertItemW
# define Header_SetItem Header_SetItemW
#else /* not UNICODE */
# define Header_GetItem Header_GetItemA
# define Header_InsertItem Header_InsertItemA
# define Header_SetItem Header_SetItemA
#endif /* not UNICODE */

/* ja:スピンボタンコントロール */
#include "w32updwn.h"
#endif /* W32LDR_HEADER */


/* CreateMappedBitmap ordinal = 8, argument = 0 temporary */
static DWORD WINAPI CreateMappedBitmap (VOID)
{
  return 0;
}


/* ja:リアライズ */
static void
w32page_realize (GtkWidget *widget,
                 gpointer   user_data)
{
  W32LdrPageData *pd;

  g_signal_handlers_disconnect_by_func (G_OBJECT (widget),
                                                w32page_realize, user_data);
  pd = g_object_get_data (G_OBJECT (widget), "user_data");
  if (pd->lppspa && pd->lppspa->pfnCallback)
    pd->lppspa->pfnCallback (widget, PSPCB_CREATE, pd->lppspa);
  if (pd->lppspw && pd->lppspw->pfnCallback)
    pd->lppspw->pfnCallback (widget, PSPCB_CREATE, pd->lppspw);
}


/* ja:破棄 */
static void
w32page_destroy (GtkWidget *widget,
                 gpointer   user_data)
{
  W32LdrPageData *pd;

  pd = g_object_get_data (G_OBJECT (widget), "user_data");
  if (pd->lppspa)
    {
      if (pd->lppspa->pfnCallback)
        pd->lppspa->pfnCallback (widget, PSPCB_RELEASE, pd->lppspa);
      g_free ((gpointer)pd->lppspa->pResource);
      g_free ((gpointer)pd->lppspa->pszTitle);
      g_free (pd->lppspa);
    }
  if (pd->lppspw)
    {
      if (pd->lppspw->pfnCallback)
        pd->lppspw->pfnCallback (widget, PSPCB_RELEASE, pd->lppspw);
      g_free ((gpointer)pd->lppspw->pResource);
      g_free ((gpointer)pd->lppspw->pszTitle);
      g_free (pd->lppspw);
    }
  g_free (pd->title);
}


/* CreatePropertySheetPage ordinal = 12, argument = 4 */
/* HPROPSHEETPAGE WINAPI CreatePropertySheetPage (LPCPROPSHEETPAGEA lppsp) */


/* CreatePropertySheetPageA ordinal = 18, argument = 4 */
HPROPSHEETPAGE WINAPI CreatePropertySheetPageA (LPCPROPSHEETPAGEA lppsp)
{
  HWND hDlg;
  LPPROPSHEETPAGEA lppspa;

  if (!lppsp)
    return NULL;
  lppspa = g_malloc (sizeof (PROPSHEETPAGEA));
  lppspa->dwSize = sizeof (PROPSHEETPAGEA);
  lppspa->dwFlags = (lppsp->dwFlags | PSP_DLGINDIRECT)
                        & ~(PSP_USEHICON | PSP_USEICONID | PSP_USEREFPARENT);
  lppspa->hInstance = lppsp->hInstance;
  if (lppsp->dwFlags & PSP_DLGINDIRECT)
    {
      lppspa->pResource = w32ldr_dialog_dup_template (lppsp->pResource);
    }
  else
    {
      HRSRC hRsrc;

      lppspa->pResource = NULL;
      hRsrc = FindResourceA (lppsp->hInstance, lppsp->pszTemplate,
                                                MAKEINTRESOURCEA (RT_DIALOG));
      if (hRsrc)
        {
          LPCDLGTEMPLATE lpDialogTemplate;

          lpDialogTemplate = LoadResource (lppsp->hInstance, hRsrc);
          if (lpDialogTemplate)
            lppspa->pResource = w32ldr_dialog_dup_template (lpDialogTemplate);
        }
    }
  if (!lppspa->pResource)
    {
      g_free (lppspa);
      return NULL;
    }
  if (((LPCDLGTEMPLATEEX)lppspa->pResource)->dlgVer == 1
                && ((LPCDLGTEMPLATEEX)lppspa->pResource)->signature == 0xffff)
    {
      ((LPDLGTEMPLATEEX)lppspa->pResource)->style
                                &= ~(WS_OVERLAPPED | WS_POPUP | WS_DISABLED);
      ((LPDLGTEMPLATEEX)lppspa->pResource)->style |= WS_CHILD | WS_DLGFRAME;
    }
  else
    {
      ((LPDLGTEMPLATE)lppspa->pResource)->style
                                &= ~(WS_OVERLAPPED | WS_POPUP | WS_DISABLED);
      ((LPDLGTEMPLATE)lppspa->pResource)->style |= WS_CHILD | WS_DLGFRAME;
    }
  lppspa->hIcon = NULL;
  if ((lppsp->dwFlags & PSP_USETITLE) && lppsp->pszTitle)
    {
      lppspa->pszTitle = g_strdup (lppsp->pszTitle);
    }
  else
    {
      lppspa->pszTitle = NULL;
      lppspa->dwFlags &= ~PSP_USETITLE;
    }
  lppspa->pfnDlgProc = lppsp->pfnDlgProc;
  lppspa->lParam = lppsp->lParam;
  if ((lppsp->dwFlags & PSP_USECALLBACK) && lppsp->pfnCallback)
    {
      lppspa->pfnCallback = lppsp->pfnCallback;
    }
  else
    {
      lppspa->pfnCallback = NULL;
      lppspa->dwFlags &= ~PSP_USECALLBACK;
    }
  lppspa->pcRefParent = NULL;

  hDlg = CreateDialogIndirectParamA (lppspa->hInstance,
                                     lppspa->pResource,
                                     NULL,
                                     lppspa->pfnDlgProc,
                                     lppspa->lParam);
  if (hDlg)
    {
      W32LdrPageData *pd;

      pd = g_object_get_data (G_OBJECT (hDlg), "user_data");
      pd = g_realloc (pd, sizeof (W32LdrPageData));
      pd->edited = FALSE;
      pd->title = lppspa->pszTitle ? w32ldr_utf8_from_mb (lppspa->pszTitle)
                                : w32ldr_dialog_get_title (lppspa->pResource);
      pd->lppspa = lppspa;
      pd->lppspw = NULL;
      g_object_set_data (G_OBJECT (hDlg), "user_data", pd);
      g_signal_connect (G_OBJECT (hDlg), "realize",
                                        G_CALLBACK (w32page_realize), NULL);
      g_signal_connect (G_OBJECT (hDlg), "destroy",
                                        G_CALLBACK (w32page_destroy), NULL);
    }
  else
    {
      g_free ((gpointer)lppspa->pResource);
      g_free ((gpointer)lppspa->pszTitle);
      g_free (lppspa);
    }
  return hDlg;
}


/* CreatePropertySheetPageW ordinal = 19, argument = 4 */
HPROPSHEETPAGE WINAPI CreatePropertySheetPageW (LPCPROPSHEETPAGEW lppsp)
{
  HWND hDlg;
  LPPROPSHEETPAGEW lppspw;

  if (!lppsp)
    return NULL;
  lppspw = g_malloc (sizeof (PROPSHEETPAGEW));
  lppspw->dwSize = sizeof (PROPSHEETPAGEW);
  lppspw->dwFlags = (lppsp->dwFlags | PSP_DLGINDIRECT)
                        & ~(PSP_USEHICON | PSP_USEICONID | PSP_USEREFPARENT);
  lppspw->hInstance = lppsp->hInstance;
  if (lppsp->dwFlags & PSP_DLGINDIRECT)
    {
      lppspw->pResource = w32ldr_dialog_dup_template (lppsp->pResource);
    }
  else
    {
      HRSRC hRsrc;

      lppspw->pResource = NULL;
      hRsrc = FindResourceW (lppsp->hInstance, lppsp->pszTemplate,
                                                MAKEINTRESOURCEW (RT_DIALOG));
      if (hRsrc)
        {
          LPCDLGTEMPLATE lpDialogTemplate;

          lpDialogTemplate = LoadResource (lppsp->hInstance, hRsrc);
          if (lpDialogTemplate)
            lppspw->pResource = w32ldr_dialog_dup_template (lpDialogTemplate);
        }
    }
  if (!lppspw->pResource)
    {
      g_free (lppspw);
      return NULL;
    }
  if (((LPCDLGTEMPLATEEX)lppspw->pResource)->dlgVer == 1
                && ((LPCDLGTEMPLATEEX)lppspw->pResource)->signature == 0xffff)
    {
      ((LPDLGTEMPLATEEX)lppspw->pResource)->style
                                &= ~(WS_OVERLAPPED | WS_POPUP | WS_DISABLED);
      ((LPDLGTEMPLATEEX)lppspw->pResource)->style |= WS_CHILD | WS_DLGFRAME;
    }
  else
    {
      ((LPDLGTEMPLATE)lppspw->pResource)->style
                                &= ~(WS_OVERLAPPED | WS_POPUP | WS_DISABLED);
      ((LPDLGTEMPLATE)lppspw->pResource)->style |= WS_CHILD | WS_DLGFRAME;
    }
  lppspw->hIcon = NULL;
  if ((lppsp->dwFlags & PSP_USETITLE) && lppsp->pszTitle)
    {
      lppspw->pszTitle = g_memdup (lppsp->pszTitle,
                        (lstrlenW (lppsp->pszTitle) + 1) * sizeof (gunichar2));
    }
  else
    {
      lppspw->pszTitle = NULL;
      lppspw->dwFlags &= ~PSP_USETITLE;
    }
  lppspw->pfnDlgProc = lppsp->pfnDlgProc;
  lppspw->lParam = lppsp->lParam;
  if ((lppsp->dwFlags & PSP_USECALLBACK) && lppsp->pfnCallback)
    {
      lppspw->pfnCallback = lppsp->pfnCallback;
    }
  else
    {
      lppspw->pfnCallback = NULL;
      lppspw->dwFlags &= ~PSP_USECALLBACK;
    }
  lppspw->pcRefParent = NULL;

  hDlg = CreateDialogIndirectParamW (lppspw->hInstance,
                                     lppspw->pResource,
                                     NULL,
                                     lppspw->pfnDlgProc,
                                     lppspw->lParam);
  if (hDlg)
    {
      W32LdrPageData *pd;

      pd = g_object_get_data (G_OBJECT (hDlg), "user_data");
      pd = g_realloc (pd, sizeof (W32LdrPageData));
      pd->edited = FALSE;
      pd->title = lppspw->pszTitle
                    ? g_utf16_to_utf8 (lppspw->pszTitle, -1, NULL, NULL, NULL)
                    : w32ldr_dialog_get_title (lppspw->pResource);
      pd->lppspa = NULL;
      pd->lppspw = lppspw;
      g_object_set_data (G_OBJECT (hDlg), "user_data", pd);
      g_signal_connect (G_OBJECT (hDlg), "realize",
                                        G_CALLBACK (w32page_realize), NULL);
      g_signal_connect (G_OBJECT (hDlg), "destroy",
                                        G_CALLBACK (w32page_destroy), NULL);
    }
  else
    {
      g_free ((gpointer)lppspw->pResource);
      g_free ((gpointer)lppspw->pszTitle);
      g_free (lppspw);
    }
  return hDlg;
}


/* CreateStatusWindow ordinal = 20, argument = 16 */
/* HWND WINAPI CreateStatusWindow (LONG lStyle, LPCSTR lpszText, HWND hWndParent, UINT wID) */


/* CreateStatusWindowA ordinal = 6, argument = 0 */
HWND WINAPI CreateStatusWindowA (LONG lStyle, LPCSTR lpszText, HWND hWndParent, UINT wID)
{
  return CreateWindowExA (0,
                          STATUSCLASSNAMEA,
                          lpszText,
                          lStyle,
                          0,
                          0,
                          0,
                          0,
                          hWndParent,
                          GUINT_TO_POINTER (wID),
                          NULL,
                          NULL);
}


/* CreateStatusWindowW ordinal = 21, argument = 16 */
HWND WINAPI CreateStatusWindowW (LONG lStyle, LPCWSTR lpszText, HWND hWndParent, UINT wID)
{
  return CreateWindowExW (0,
                          STATUSCLASSNAMEW,
                          lpszText,
                          lStyle,
                          0,
                          0,
                          0,
                          0,
                          hWndParent,
                          GUINT_TO_POINTER (wID),
                          NULL,
                          NULL);
}


/* CreateToolbar ordinal = 7, argument = 0 temporary */
static DWORD WINAPI CreateToolbar (VOID)
{
  return 0;
}


/* CreateToolbarEx ordinal = 22, argument = 52 */
HWND WINAPI CreateToolbarEx (HWND hWndParent, DWORD dwStyle, UINT wID, INT nBitmaps, HINSTANCE hInstance, UINT wBMID, LPCTBBUTTON lpButtons, INT iNumButtons, INT dxButton, INT dyButton, INT dxBitmap, INT dyBitmap, UINT uStructSize)
{
  HWND hWnd;

  if (uStructSize != sizeof (TBBUTTON))
    return NULL;
  hWnd = CreateWindowEx (0,
                         TOOLBARCLASSNAME,
                         NULL,
                         dwStyle,
                         0,
                         0,
                         0,
                         0,
                         hWndParent,
                         GUINT_TO_POINTER (wID),
                         hInstance,
                         NULL);
  if (hWnd)
    {
      TBADDBITMAP tbab;

      tbab.hInst = hInstance;
      tbab.nID = wBMID;
      SendMessage (hWnd, TB_BUTTONSTRUCTSIZE, uStructSize, 0);
      SendMessage (hWnd, TB_ADDBITMAP, nBitmaps, GPOINTER_TO_INT (&tbab));
      SendMessage (hWnd, TB_ADDBUTTONS,
                                    iNumButtons, GPOINTER_TO_INT (lpButtons));
    }
  return hWnd;
}


/* CreateUpDownControl ordinal = 16, argument = 0 */
HWND WINAPI CreateUpDownControl (DWORD dwStyle, INT x, INT y, INT cx, INT cy, HWND hParent, INT nID, HINSTANCE hInst, HWND hBuddy, INT nUpper, INT nLower, INT nPos)
{
  HWND hWnd;

  hWnd = CreateWindowEx (0,
                         UPDOWN_CLASS,
                         NULL,
                         dwStyle,
                         x,
                         y,
                         cx,
                         cy,
                         hParent,
                         GINT_TO_POINTER (nID),
                         hInst,
                         NULL);
  if (hWnd)
    {
      SendMessage (hWnd, UDM_SETRANGE32, nLower, nUpper);
      SendMessage (hWnd, UDM_SETPOS32, 0, nPos);
      SendMessage (hWnd, UDM_SETBUDDY, GPOINTER_TO_INT (hBuddy), 0);
    }
  return hWnd;
}


/* DestroyPropertySheetPage ordinal = 23, argument = 4 */
BOOL WINAPI DestroyPropertySheetPage (HPROPSHEETPAGE hPage)
{
  return DestroyWindow (hPage);
}


/* DllGetVersion ordinal = 24, argument = 0 temporary,conflict */
static DWORD WINAPI commctrl_DllGetVersion (VOID)
{
  return 0;
}


/* DllInstall ordinal = 25, argument = 0 temporary,conflict */
static DWORD WINAPI commctrl_DllInstall (VOID)
{
  return 0;
}


/* DrawInsert ordinal = 15, argument = 0 temporary */
static DWORD WINAPI DrawInsert (VOID)
{
  return 0;
}


/* DrawStatusText ordinal = 26, argument = 16 temporary */
/* DWORD WINAPI DrawStatusText (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3) */


/* DrawStatusTextA ordinal = 5, argument = 0 temporary */
static DWORD WINAPI DrawStatusTextA (VOID)
{
  return 0;
}


/* DrawStatusTextW ordinal = 27, argument = 16 temporary */
static DWORD WINAPI DrawStatusTextW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* FlatSB_EnableScrollBar ordinal = 28, argument = 12 temporary */
static DWORD WINAPI FlatSB_EnableScrollBar (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* FlatSB_GetScrollInfo ordinal = 29, argument = 12 temporary */
static DWORD WINAPI FlatSB_GetScrollInfo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* FlatSB_GetScrollPos ordinal = 30, argument = 8 temporary */
static DWORD WINAPI FlatSB_GetScrollPos (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* FlatSB_GetScrollProp ordinal = 31, argument = 12 temporary */
static DWORD WINAPI FlatSB_GetScrollProp (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* FlatSB_GetScrollRange ordinal = 32, argument = 16 temporary */
static DWORD WINAPI FlatSB_GetScrollRange (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* FlatSB_SetScrollInfo ordinal = 33, argument = 16 temporary */
static DWORD WINAPI FlatSB_SetScrollInfo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* FlatSB_SetScrollPos ordinal = 34, argument = 16 temporary */
static DWORD WINAPI FlatSB_SetScrollPos (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* FlatSB_SetScrollProp ordinal = 35, argument = 16 temporary */
static DWORD WINAPI FlatSB_SetScrollProp (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* FlatSB_SetScrollRange ordinal = 36, argument = 20 temporary */
static DWORD WINAPI FlatSB_SetScrollRange (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* FlatSB_ShowScrollBar ordinal = 37, argument = 12 temporary */
static DWORD WINAPI FlatSB_ShowScrollBar (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetEffectiveClientRect ordinal = 4, argument = 0 temporary */
static DWORD WINAPI GetEffectiveClientRect (VOID)
{
  return 0;
}


/* GetMUILanguage ordinal = 38, argument = 0 temporary */
static DWORD WINAPI GetMUILanguage (VOID)
{
  return 0;
}


/* ImageList_Add ordinal = 39, argument = 12 */
INT WINAPI ImageList_Add (HIMAGELIST hImage, HBITMAP hBitmap, HBITMAP hBitmapMask)
{
  return -1;
}


/* ImageList_AddIcon ordinal = 40, argument = 8 */
INT WINAPI ImageList_AddIcon (HIMAGELIST hImage, HICON hIcon)
{
  return ImageList_ReplaceIcon (hImage, -1, hIcon);
}


/* ImageList_AddMasked ordinal = 41, argument = 12 */
INT WINAPI ImageList_AddMasked (HIMAGELIST hImage, HBITMAP hBitmap, COLORREF crMask)
{
  return -1;
}


/* ImageList_BeginDrag ordinal = 42, argument = 16 */
BOOL WINAPI ImageList_BeginDrag (HIMAGELIST hImage, INT iTrack, INT dxHotspot, INT dyHotspot)
{
  return FALSE;
}


/* ImageList_Copy ordinal = 43, argument = 20 */
BOOL WINAPI ImageList_Copy (HIMAGELIST hImageDst, INT iDst, HIMAGELIST hImageSrc, INT iSrc, UINT uFlags)
{
  return FALSE;
}


/* ImageList_Create ordinal = 44, argument = 20 */
HIMAGELIST WINAPI ImageList_Create (INT cx, INT cy, UINT flags, INT cInitial, INT cGrow)
{
  return NULL;
}


/* ImageList_Destroy ordinal = 45, argument = 4 */
BOOL WINAPI ImageList_Destroy (HIMAGELIST hImage)
{
  return TRUE;
}


/* ImageList_DragEnter ordinal = 46, argument = 12 */
BOOL WINAPI ImageList_DragEnter (HWND hWndLock, INT x, INT y)
{
  return FALSE;
}


/* ImageList_DragLeave ordinal = 47, argument = 4 */
BOOL WINAPI ImageList_DragLeave (HWND hWndLock)
{
  return FALSE;
}


/* ImageList_DragMove ordinal = 48, argument = 8 */
BOOL WINAPI ImageList_DragMove (INT x, INT y)
{
  return FALSE;
}


/* ImageList_DragShowNolock ordinal = 49, argument = 4 */
BOOL WINAPI ImageList_DragShowNolock (BOOL fShow)
{
  return FALSE;
}


/* ImageList_Draw ordinal = 50, argument = 24 */
BOOL WINAPI ImageList_Draw (HIMAGELIST hImage, INT i, HDC hdcDst, INT x, INT y, UINT fStyle)
{
  return FALSE;
}


/* ImageList_DrawEx ordinal = 51, argument = 40 */
BOOL WINAPI ImageList_DrawEx (HIMAGELIST hImage, INT i, HDC hdcDst, INT x, INT y, INT dx, INT dy, COLORREF rgbBk, COLORREF rgbFg, UINT fStyle)
{
  return FALSE;
}


/* ImageList_DrawIndirect ordinal = 52, argument = 4 */
BOOL WINAPI ImageList_DrawIndirect (LPIMAGELISTDRAWPARAMS lpImageListDrawIndirect)
{
  return FALSE;
}


/* ImageList_Duplicate ordinal = 53, argument = 4 */
HIMAGELIST WINAPI ImageList_Duplicate (HIMAGELIST hImage)
{
  return NULL;
}


/* ImageList_EndDrag ordinal = 54, argument = 0 */
VOID WINAPI ImageList_EndDrag (VOID)
{
}


/* ImageList_GetBkColor ordinal = 55, argument = 4 */
COLORREF WINAPI ImageList_GetBkColor (HIMAGELIST hImage)
{
  return CLR_NONE;
}


/* ImageList_GetDragImage ordinal = 56, argument = 8 */
HIMAGELIST ImageList_GetDragImage (LPPOINT lppt, LPPOINT lpptHotspot)
{
  return NULL;
}


/* ImageList_GetFlags ordinal = 57, argument = 0 temporary */
static DWORD WINAPI ImageList_GetFlags (VOID)
{
  return 0;
}


/* ImageList_GetIcon ordinal = 58, argument = 12 */
HICON WINAPI ImageList_GetIcon (HIMAGELIST hImage, INT i, UINT flags)
{
  return NULL;
}


/* ImageList_GetIconSize ordinal = 59, argument = 12 */
BOOL WINAPI ImageList_GetIconSize (HIMAGELIST hImage, INT *cx, INT *cy)
{
  if (cx)
    *cx = 32;
  if (cy)
    *cy = 32;
  return FALSE;
}


/* ImageList_GetImageCount ordinal = 60, argument = 4 */
INT WINAPI ImageList_GetImageCount (HIMAGELIST hImage)
{
  return 0;
}


/* ImageList_GetImageInfo ordinal = 61, argument = 12 */
BOOL WINAPI ImageList_GetImageInfo (HIMAGELIST hImage, INT i, LPIMAGEINFO lpImageInfo)
{
  return FALSE;
}


/* ImageList_GetImageRect ordinal = 62, argument = 12 temporary */
static DWORD WINAPI ImageList_GetImageRect (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ImageList_LoadImage ordinal = 63, argument = 28 */
/* HIMAGELIST WINAPI ImageList_LoadImage (HINSTANCE hInstance, LPCSTR lpszBitmap, INT cx, INT cGrow, COLORREF crMask, UINT uType, UINT uFlags) */


/* ImageList_LoadImageA ordinal = 64, argument = 28 */
HIMAGELIST WINAPI ImageList_LoadImageA (HINSTANCE hInstance, LPCSTR lpszBitmap, INT cx, INT cGrow, COLORREF crMask, UINT uType, UINT uFlags)
{
  return NULL;
}


/* ImageList_LoadImageW ordinal = 65, argument = 28 */
HIMAGELIST WINAPI ImageList_LoadImageW (HINSTANCE hInstance, LPCWSTR lpszBitmap, INT cx, INT cGrow, COLORREF crMask, UINT uType, UINT uFlags)
{
  return NULL;
}


/* ImageList_Merge ordinal = 66, argument = 24 */
HIMAGELIST WINAPI ImageList_Merge (HIMAGELIST hImage1, INT i1, HIMAGELIST hImage2, INT i2, INT dx, INT dy)
{
  return NULL;
}


/* ImageList_Read ordinal = 67, argument = 4 */
HIMAGELIST WINAPI ImageList_Read (LPSTREAM lpstm)
{
  return NULL;
}


/* ImageList_Remove ordinal = 68, argument = 8 */
BOOL WINAPI ImageList_Remove (HIMAGELIST hImage, INT i)
{
  return FALSE;
}


/* ImageList_Replace ordinal = 69, argument = 16 */
BOOL WINAPI ImageList_Replace (HIMAGELIST hImage, INT i, HBITMAP hBitmap, HBITMAP hBitmapMask)
{
  return FALSE;
}


/* ImageList_ReplaceIcon ordinal = 70, argument = 12 */
INT WINAPI ImageList_ReplaceIcon (HIMAGELIST hImage, INT i, HICON hIcon)
{
  return -1;
}


/* ImageList_SetBkColor ordinal = 75, argument = 8 */
COLORREF ImageList_SetBkColor (HIMAGELIST hImage, COLORREF clrBk)
{
  return CLR_NONE;
}


/* ImageList_SetDragCursorImage ordinal = 76, argument = 16 */
BOOL WINAPI ImageList_SetDragCursorImage (HIMAGELIST hImage, INT iDrag, INT dxHotspot, INT dyHotspot)
{
  return FALSE;
}


/* ImageList_SetFilter ordinal = 77, argument = 12 temporary */
static DWORD WINAPI ImageList_SetFilter (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ImageList_SetFlags ordinal = 78, argument = 8 temporary */
static DWORD WINAPI ImageList_SetFlags (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ImageList_SetIconSize ordinal = 79, argument = 12 */
BOOL WINAPI ImageList_SetIconSize (HIMAGELIST hImage, INT cx, INT cy)
{
  return FALSE;
}


/* ImageList_SetImageCount ordinal = 80, argument = 8 */
BOOL WINAPI ImageList_SetImageCount (HIMAGELIST hIMage, UINT uNewCount)
{
  return FALSE;
}


/* ImageList_SetOverlayImage ordinal = 81, argument = 12 */
BOOL WINAPI ImageList_SetOverlayImage (HIMAGELIST hIMage, INT iImage, INT iOverlay)
{
  return FALSE;
}


/* ImageList_Write ordinal = 82, argument = 8 */
BOOL WINAPI ImageList_Write (HIMAGELIST hImage, LPSTREAM lpstm)
{
  return FALSE;
}


/* InitCommonControls ordinal = 17, argument = 0 */
void WINAPI InitCommonControls (VOID)
{
  w32ldr_atom_add_name ("msctls_statusbar32");
  w32ldr_atom_add_name ("SysPropertySheet");
  w32ldr_atom_add_name ("SysListView32");
  w32ldr_atom_add_name ("SysTreeView32");
  w32ldr_atom_add_name ("msctls_progress32");
  w32ldr_atom_add_name ("msctls_updown32");
}


/* InitCommonControlsEx ordinal = 83, argument = 4 */
BOOL WINAPI InitCommonControlsEx (LPINITCOMMONCONTROLSEX pInitCtrls)
{
  InitCommonControls ();
  return TRUE;
}


/* InitMUILanguage ordinal = 84, argument = 4 temporary */
static DWORD WINAPI InitMUILanguage (DWORD dwArgv0)
{
  return 0;
}


/* InitializeFlatSB ordinal = 85, argument = 4 temporary */
static DWORD WINAPI InitializeFlatSB (DWORD dwArgv0)
{
  return 0;
}


/* LBItemFromPt ordinal = 14, argument = 0 temporary */
static DWORD WINAPI LBItemFromPt (VOID)
{
  return 0;
}


/* MakeDragList ordinal = 13, argument = 0 temporary */
static DWORD WINAPI MakeDragList (VOID)
{
  return 0;
}


/* MenuHelp ordinal = 2, argument = 0 temporary */
static DWORD WINAPI MenuHelp (VOID)
{
  return 0;
}


/* ja:リアライズ */
static void
w32prsht_realize (GtkWidget            *widget,
                  PFNPROPSHEETCALLBACK  pfnCallback)
{
  g_signal_handlers_disconnect_by_func (G_OBJECT (widget),
                                                w32prsht_realize, pfnCallback);
  pfnCallback (widget, PSCB_INITIALIZED, 0);
}


/* PropertySheet ordinal = 86, argument = 4 */
/* INT WINAPI PropertySheetA (LPCPROPSHEETHEADERA lppsph) */


/* PropertySheetA ordinal = 87, argument = 4 */
INT WINAPI PropertySheetA (LPCPROPSHEETHEADERA lppsph)
{
  gint i;
  HWND hWnd;

  if (!lppsph)
    return -1;
  hWnd = CreateWindowExA (0,
                WC_PROPSHEETA,
                lppsph->dwFlags & PSH_PROPTITLE ? lppsph->pszCaption : NULL,
                lppsph->dwFlags | WS_VISIBLE,
                CW_USEDEFAULT,
                CW_USEDEFAULT,
                CW_USEDEFAULT,
                CW_USEDEFAULT,
                lppsph->hwndParent,
                NULL,
                lppsph->hInstance,
                NULL);
  if (!hWnd)
    return lppsph->dwFlags & PSH_MODELESS ? GPOINTER_TO_INT (NULL) : -1;
  for (i = 0; i < lppsph->nPages; i++)
    {
      HPROPSHEETPAGE hPage;

      hPage = lppsph->dwFlags & PSH_PROPSHEETPAGE
            ? CreatePropertySheetPageA (&lppsph->ppsp[i]) : lppsph->phpage[i];
      if (hPage)
        PropSheet_AddPage (hWnd, hPage);
    }
  if (!(lppsph->dwFlags & PSH_USEPSTARTPAGE))
    PropSheet_SetCurSel (hWnd, NULL, lppsph->nStartPage);
  if ((lppsph->dwFlags & PSH_USECALLBACK) && lppsph->pfnCallback)
    g_signal_connect (G_OBJECT (hWnd), "realize",
                        G_CALLBACK (w32prsht_realize), lppsph->pfnCallback);
  if (lppsph->dwFlags & PSH_MODELESS)
    return GPOINTER_TO_INT (hWnd);

  gtk_dialog_run (GTK_DIALOG (hWnd));
  gtk_widget_destroy (hWnd);
  for (i = 1; i == ID_PSRESTARTWINDOWS || i == ID_PSREBOOTSYSTEM; i++);
  return i;
}


/* PropertySheetW ordinal = 88, argument = 4 */
INT WINAPI PropertySheetW (LPCPROPSHEETHEADERW lppsph)
{
  gint i;
  HWND hWnd;

  if (!lppsph)
    return -1;
  hWnd = CreateWindowExW (0,
                WC_PROPSHEETW,
                lppsph->dwFlags & PSH_PROPTITLE ? lppsph->pszCaption : NULL,
                lppsph->dwFlags | WS_VISIBLE,
                CW_USEDEFAULT,
                CW_USEDEFAULT,
                CW_USEDEFAULT,
                CW_USEDEFAULT,
                lppsph->hwndParent,
                NULL,
                lppsph->hInstance,
                NULL);
  if (!hWnd)
    return lppsph->dwFlags & PSH_MODELESS ? GPOINTER_TO_INT (NULL) : -1;
  for (i = 0; i < lppsph->nPages; i++)
    {
      HPROPSHEETPAGE hPage;

      hPage = lppsph->dwFlags & PSH_PROPSHEETPAGE
            ? CreatePropertySheetPageW (&lppsph->ppsp[i]) : lppsph->phpage[i];
      if (hPage)
        PropSheet_AddPage (hWnd, hPage);
    }
  if (!(lppsph->dwFlags & PSH_USEPSTARTPAGE))
    PropSheet_SetCurSel (hWnd, NULL, lppsph->nStartPage);
  if ((lppsph->dwFlags & PSH_USECALLBACK) && lppsph->pfnCallback)
    g_signal_connect (G_OBJECT (hWnd), "realize",
                        G_CALLBACK (w32prsht_realize), lppsph->pfnCallback);
  if (lppsph->dwFlags & PSH_MODELESS)
    return GPOINTER_TO_INT (hWnd);

  gtk_dialog_run (GTK_DIALOG (hWnd));
  gtk_widget_destroy (hWnd);
  for (i = 1; i == ID_PSRESTARTWINDOWS || i == ID_PSREBOOTSYSTEM; i++);
  return i;
}


/* ShowHideMenuCtl ordinal = 3, argument = 0 temporary */
static DWORD WINAPI ShowHideMenuCtl (VOID)
{
  return 0;
}


/* UninitializeFlatSB ordinal = 89, argument = 4 temporary */
static DWORD WINAPI UninitializeFlatSB (DWORD dwArgv0)
{
  return 0;
}


/* _TrackMouseEvent ordinal = 90, argument = 4 temporary */
static DWORD WINAPI _TrackMouseEvent (DWORD dwArgv0)
{
  return 0;
}


W32LdrExport w32ldr_commctrl_exports[] = {
{-1,  8, "CreateMappedBitmap",           CreateMappedBitmap},
{ 0, 12, "CreatePropertySheetPage",      CreatePropertySheetPageA},
{ 0, 18, "CreatePropertySheetPageA",     CreatePropertySheetPageA},
{ 0, 19, "CreatePropertySheetPageW",     CreatePropertySheetPageW},
{ 0, 20, "CreateStatusWindow",           CreateStatusWindowA},
{ 0,  6, "CreateStatusWindowA",          CreateStatusWindowA},
{ 0, 21, "CreateStatusWindowW",          CreateStatusWindowW},
{-1,  7, "CreateToolbar",                CreateToolbar},
{ 0, 22, "CreateToolbarEx",              CreateToolbarEx},
{ 0, 16, "CreateUpDownControl",          CreateUpDownControl},
{ 0, 23, "DestroyPropertySheetPage",     DestroyPropertySheetPage},
{-1, 24, "DllGetVersion",                commctrl_DllGetVersion},
{-1, 25, "DllInstall",                   commctrl_DllInstall},
{-1, 15, "DrawInsert",                   DrawInsert},
{-1, 26, "DrawStatusText",               DrawStatusTextA},
{-1,  5, "DrawStatusTextA",              DrawStatusTextA},
{-1, 27, "DrawStatusTextW",              DrawStatusTextW},
{-1, 28, "FlatSB_EnableScrollBar",       FlatSB_EnableScrollBar},
{-1, 29, "FlatSB_GetScrollInfo",         FlatSB_GetScrollInfo},
{-1, 30, "FlatSB_GetScrollPos",          FlatSB_GetScrollPos},
{-1, 31, "FlatSB_GetScrollProp",         FlatSB_GetScrollProp},
{-1, 32, "FlatSB_GetScrollRange",        FlatSB_GetScrollRange},
{-1, 33, "FlatSB_SetScrollInfo",         FlatSB_SetScrollInfo},
{-1, 34, "FlatSB_SetScrollPos",          FlatSB_SetScrollPos},
{-1, 35, "FlatSB_SetScrollProp",         FlatSB_SetScrollProp},
{-1, 36, "FlatSB_SetScrollRange",        FlatSB_SetScrollRange},
{-1, 37, "FlatSB_ShowScrollBar",         FlatSB_ShowScrollBar},
{-1,  4, "GetEffectiveClientRect",       GetEffectiveClientRect},
{-1, 38, "GetMUILanguage",               GetMUILanguage},
{ 0, 39, "ImageList_Add",                ImageList_Add},
{ 0, 40, "ImageList_AddIcon",            ImageList_AddIcon},
{ 0, 41, "ImageList_AddMasked",          ImageList_AddMasked},
{ 0, 42, "ImageList_BeginDrag",          ImageList_BeginDrag},
{ 0, 43, "ImageList_Copy",               ImageList_Copy},
{ 0, 44, "ImageList_Create",             ImageList_Create},
{ 0, 45, "ImageList_Destroy",            ImageList_Destroy},
{ 0, 46, "ImageList_DragEnter",          ImageList_DragEnter},
{ 0, 47, "ImageList_DragLeave",          ImageList_DragLeave},
{ 0, 48, "ImageList_DragMove",           ImageList_DragMove},
{ 0, 49, "ImageList_DragShowNolock",     ImageList_DragShowNolock},
{ 0, 50, "ImageList_Draw",               ImageList_Draw},
{ 0, 51, "ImageList_DrawEx",             ImageList_DrawEx},
{ 0, 52, "ImageList_DrawIndirect",       ImageList_DrawIndirect},
{ 0, 53, "ImageList_Duplicate",          ImageList_Duplicate},
{ 0, 54, "ImageList_EndDrag",            ImageList_EndDrag},
{ 0, 55, "ImageList_GetBkColor",         ImageList_GetBkColor},
{ 0, 56, "ImageList_GetDragImage",       ImageList_GetDragImage},
{-1, 57, "ImageList_GetFlags",           ImageList_GetFlags},
{ 0, 58, "ImageList_GetIcon",            ImageList_GetIcon},
{ 0, 59, "ImageList_GetIconSize",        ImageList_GetIconSize},
{ 0, 60, "ImageList_GetImageCount",      ImageList_GetImageCount},
{ 0, 61, "ImageList_GetImageInfo",       ImageList_GetImageInfo},
{-1, 62, "ImageList_GetImageRect",       ImageList_GetImageRect},
{ 0, 63, "ImageList_LoadImage",          ImageList_LoadImageA},
{ 0, 64, "ImageList_LoadImageA",         ImageList_LoadImageA},
{ 0, 65, "ImageList_LoadImageW",         ImageList_LoadImageW},
{ 0, 66, "ImageList_Merge",              ImageList_Merge},
{ 0, 67, "ImageList_Read",               ImageList_Read},
{ 0, 68, "ImageList_Remove",             ImageList_Remove},
{ 0, 69, "ImageList_Replace",            ImageList_Replace},
{ 0, 70, "ImageList_ReplaceIcon",        ImageList_ReplaceIcon},
{ 0, 75, "ImageList_SetBkColor",         ImageList_SetBkColor},
{ 0, 76, "ImageList_SetDragCursorImage", ImageList_SetDragCursorImage},
{-1, 77, "ImageList_SetFilter",          ImageList_SetFilter},
{-1, 78, "ImageList_SetFlags",           ImageList_SetFlags},
{ 0, 79, "ImageList_SetIconSize",        ImageList_SetIconSize},
{ 0, 80, "ImageList_SetImageCount",      ImageList_SetImageCount},
{ 0, 81, "ImageList_SetOverlayImage",    ImageList_SetOverlayImage},
{ 0, 82, "ImageList_Write",              ImageList_Write},
{ 0, 17, "InitCommonControls",           InitCommonControls},
{ 0, 83, "InitCommonControlsEx",         InitCommonControlsEx},
{-1, 84, "InitMUILanguage",              InitMUILanguage},
{-1, 85, "InitializeFlatSB",             InitializeFlatSB},
{-1, 14, "LBItemFromPt",                 LBItemFromPt},
{-1, 13, "MakeDragList",                 MakeDragList},
{-1,  2, "MenuHelp",                     MenuHelp},
{ 0, 86, "PropertySheet",                PropertySheetA},
{ 0, 87, "PropertySheetA",               PropertySheetA},
{ 0, 88, "PropertySheetW",               PropertySheetW},
{-1,  3, "ShowHideMenuCtl",              ShowHideMenuCtl},
{-1, 89, "UninitializeFlatSB",           UninitializeFlatSB},
{-1, 90, "_TrackMouseEvent",             _TrackMouseEvent},
{-1,  0, NULL,                           NULL}};
