/*
    Video maid
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "icons.h"


/******************************************************************************
*                                                                             *
* ja:アイコン                                                                 *
*                                                                             *
******************************************************************************/
/* XPM */
const gchar *vmaid16_xpm[] = {
"16 16 3 1",
"   c None",
".  c #000000",
"+  c #800000",
"                ",
"++++++++++++++++",
"+  +  +  +  +  +",
"++++++++++++++++",
". + . . . . .+. ",
" .+. . . . . + .",
". + . . . . .+. ",
" .+. . . . . + .",
". + . . . . .+. ",
" .+. . . . . + .",
". + . . . . .+. ",
" .+. . . . . + .",
"++++++++++++++++",
"+  +  +  +  +  +",
"++++++++++++++++",
"                "};


/* XPM */
const gchar *vmaid24_xpm[] = {
"24 24 3 1",
"   c None",
".  c #000000",
"+  c #800000",
"                        ",
"                        ",
"++++++++++++++++++++++++",
"  +   +   +   +   +   + ",
"  +   +   +   +   +   + ",
"++++++++++++++++++++++++",
". .+. . . . . . . . + . ",
" . + . . . . . . . .+. .",
". .+. . . . . . . . + . ",
" . + . . . . . . . .+. .",
". .+. . . . . . . . + . ",
" . + . . . . . . . .+. .",
". .+. . . . . . . . + . ",
" . + . . . . . . . .+. .",
". .+. . . . . . . . + . ",
" . + . . . . . . . .+. .",
". .+. . . . . . . . + . ",
" . + . . . . . . . .+. .",
"++++++++++++++++++++++++",
"  +   +   +   +   +   + ",
"  +   +   +   +   +   + ",
"++++++++++++++++++++++++",
"                        ",
"                        "};


/* XPM */
const gchar *vmaid32_xpm[] = {
"32 32 9 1",
"   c None",
".  c #000000",
"+  c #0000FF",
"@  c #800000",
"#  c #FF0000",
"$  c #FF00FF",
"%  c #00FF00",
"&  c #00FFFF",
"*  c #FFFF00",
"                                ",
"                                ",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
" @@   @@   @@   @@   @@   @@   @",
" @@   @@   @@   @@   @@   @@   @",
" @@   @@   @@   @@   @@   @@   @",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
". . @ . . . . . . . . . . .@. . ",
" . .@. . . . . $ . . . . . @ . .",
". . @ . . . . $$  . . . . .@. . ",
" . .@. . . . $$$ . . . . . @ . .",
". . @ . . .  $$$      . . .@. . ",
" . .@. . #  $$$$++++++ . . @ . .",
". . @ .  ###$$$$+++++ . . .@. . ",
" . .@. .  ####$$+++& . . . @ . .",
". . @ . . #####$+&&&  . . .@. . ",
" . .@. . . ###*%&&&&&  . . @ . .",
". . @ . .  #***%%&&&& . . .@. . ",
" . .@. .  *****%%%%&&& . . @ . .",
". . @ .  ******%%%%  &  . .@. . ",
" . .@. .       %%% .   . . @ . .",
". . @ . . . .  %%%  . . . .@. . ",
" . .@. . . . . %%  . . . . @ . .",
". . @ . . . .  %  . . . . .@. . ",
" . .@. . . . .   . . . . . @ . .",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
" @@   @@   @@   @@   @@   @@   @",
" @@   @@   @@   @@   @@   @@   @",
" @@   @@   @@   @@   @@   @@   @",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"                                ",
"                                "};


/* XPM */
const gchar *vmaid48_xpm[] = {
"48 48 9 1",
"   c None",
".  c #000000",
"+  c #0000FF",
"@  c #800000",
"#  c #FF0000",
"$  c #FF00FF",
"%  c #00FF00",
"&  c #00FFFF",
"*  c #FFFF00",
"                                                ",
"                                                ",
"                                                ",
"                                                ",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"   @@      @@      @@      @@      @@      @@   ",
"   @@      @@      @@      @@      @@      @@   ",
"   @@      @@      @@      @@      @@      @@   ",
"   @@      @@      @@      @@      @@      @@   ",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
". . . @@. . . . . . . . $ . . . . . . . @@. . . ",
" . . .@@ . . . . . . . $$  . . . . . . .@@ . . .",
". . . @@. . . . . . .  $$ . . . . . . . @@. . . ",
" . . .@@ . . . . . .  $$$  . . . . . . .@@ . . .",
". . . @@. . .   . .  $$$$         . . . @@. . . ",
" . . .@@ . . .#  .  $$$$$+++++++++ . . .@@ . . .",
". . . @@. . . ### . $$$$$++++++++ . . . @@. . . ",
" . . .@@ . . . ### $$$$$$++++++  . . . .@@ . . .",
". . . @@. . .  #####$$$$$+++++  . . . . @@. . . ",
" . . .@@ . . .  #####$$$$+++&& . . . . .@@ . . .",
". . . @@. . . . #######$$++&&&& . . . . @@. . . ",
" . . .@@ . . .  ########$&&&&&&  . . . .@@ . . .",
". . . @@. . . .  ######%&&&&&&&&  . . . @@. . . ",
" . . .@@ . . . . ####**%%&&&&&&& . . . .@@ . . .",
". . . @@. . . . . ##***%%%%&&&&&  . . . @@. . . ",
" . . .@@ . . . .  *****%%%%%%&&&&  . . .@@ . . .",
". . . @@. . . .  ******%%%%%% &&& . . . @@. . . ",
" . . .@@ . . . ********%%%%% . &&& . . .@@ . . .",
". . . @@. . . *********%%%%%  .  &  . . @@. . . ",
" . . .@@ . . .         %%%%  . .   . . .@@ . . .",
". . . @@. . . . . . .  %%%  . . . . . . @@. . . ",
" . . .@@ . . . . . . . %%  . . . . . . .@@ . . .",
". . . @@. . . . . . .  %% . . . . . . . @@. . . ",
" . . .@@ . . . . . . . % . . . . . . . .@@ . . .",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"   @@      @@      @@      @@      @@      @@   ",
"   @@      @@      @@      @@      @@      @@   ",
"   @@      @@      @@      @@      @@      @@   ",
"   @@      @@      @@      @@      @@      @@   ",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"                                                ",
"                                                ",
"                                                ",
"                                                "};


/* XPM */
const gchar *preview16_xpm[] = {
"16 16 72 1",
"   c None",
".  c #000000",
"+  c #FEFEFE",
"@  c #979797",
"#  c #CBCBCB",
"$  c #FDFDFD",
"%  c #E0E0E0",
"&  c #C1C1C1",
"*  c #8F8F8F",
"=  c #C0C0C0",
"-  c #F1F1F1",
";  c #C3C3C3",
">  c #FBFBFB",
",  c #A8A8A8",
"'  c #727170",
")  c #ADADAD",
"!  c #767676",
"~  c #5D5D5D",
"{  c #404040",
"]  c #7B7B7A",
"^  c #6C6B6A",
"/  c #E2E2E2",
"(  c #858585",
"_  c #4B4B49",
":  c #161616",
"<  c #7F7E7D",
"[  c #999996",
"}  c #7D7C7B",
"|  c #BFBFBF",
"1  c #EEEEEE",
"2  c #C5C5C5",
"3  c #8E8E8E",
"4  c #828180",
"5  c #9D9C9A",
"6  c #B0AFAC",
"7  c #908F8D",
"8  c #BEBEBE",
"9  c #ECECEC",
"0  c #C4C4C4",
"a  c #8D8D8D",
"b  c #8C8B89",
"c  c #A9A8A5",
"d  c #BDBCB9",
"e  c #C5C3C0",
"f  c #D0CECC",
"g  c #FFFFFF",
"h  c #8F8E8C",
"i  c #B5B3B1",
"j  c #C7C6C3",
"k  c #D2D1CE",
"l  c #EAEAEA",
"m  c #8C8C8C",
"n  c #B9B6B4",
"o  c #D8D7D5",
"p  c #E8E8E8",
"q  c #8B8B8B",
"r  c #A19F9D",
"s  c #C7C6C4",
"t  c #E7E7E7",
"u  c #8A8A8A",
"v  c #A7A6A3",
"w  c #E6E6E6",
"x  c #E5E5E5",
"y  c #898989",
"z  c #E4E4E4",
"A  c #BDBDBD",
"B  c #7F7F7F",
"C  c #E3E3E3",
"D  c #BBBBBB",
"E  c #C2C2C2",
"F  c #BCBCBC",
"G  c #A0A0A0",
"  .........     ",
" .+@.#++$%&.    ",
" .+*..=--;>,.   ",
" .+*.'.=-)!~{.  ",
" .+*.]^.=/(_:.  ",
" .+*.<[}.|112.  ",
" .+3.4567.890.  ",
" .$a.bcdef.g;.  ",
" .$a.hijk.gl&.  ",
" .$m.5no.gpp=.  ",
" .$q.rs.gptt|.  ",
" .$u.v.gwwwx8.  ",
" .$y..gwxxzzA.  ",
" .$B.gxzzCCCD.  ",
" .E@gAFFDDDDG.  ",
"  ...........   "};


/* XPM */
const gchar *preview24_xpm[] = {
"24 24 173 2",
"   c None",
".  c #000000",
"+  c #D3D3D3",
"@  c #F6F6F6",
"#  c #FFFFFF",
"$  c #F9F9F9",
"%  c #DADADA",
"&  c #585858",
"*  c #C7C7C7",
"=  c #D1D1D1",
"-  c #D6D6D6",
";  c #B0B0B0",
">  c #CCCCCC",
",  c #FEFEFE",
"'  c #FDFDFD",
")  c #C0C0C0",
"!  c #E1E1E1",
"~  c #F0F0F0",
"{  c #9B9B9B",
"]  c #989898",
"^  c #CACACA",
"/  c #FCFCFB",
"(  c #FBFBFB",
"_  c #AFAFAE",
":  c #E9E9E9",
"<  c #DFDFDF",
"[  c #8F8F8F",
"}  c #969696",
"|  c #C8C8C7",
"1  c #FAFAF9",
"2  c #F9F9F8",
"3  c #A4A4A3",
"4  c #F4F4F4",
"5  c #CFCFCF",
"6  c #A2A2A2",
"7  c #959595",
"8  c #727170",
"9  c #C7C7C6",
"0  c #F8F8F7",
"a  c #F8F7F6",
"b  c #9E9E9E",
"c  c #949493",
"d  c #7B7B7A",
"e  c #6C6B6A",
"f  c #C5C4C4",
"g  c #F6F6F4",
"h  c #F4F3F2",
"i  c #DEDDDC",
"j  c #D3D2D0",
"k  c #B7B7B5",
"l  c #9F9E9D",
"m  c #706F6F",
"n  c #65625A",
"o  c #939392",
"p  c #7F7E7D",
"q  c #999996",
"r  c #7D7C7B",
"s  c #C3C2C1",
"t  c #F2F2F0",
"u  c #E4E4E2",
"v  c #DAD9D7",
"w  c #D8D8D6",
"x  c #CDCCCA",
"y  c #AFAEAC",
"z  c #88847B",
"A  c #F7F6F5",
"B  c #929291",
"C  c #828180",
"D  c #9D9C9A",
"E  c #B0AFAC",
"F  c #908F8D",
"G  c #BFBFBD",
"H  c #EEEDEB",
"I  c #EDECEA",
"J  c #E9E8E6",
"K  c #D5D4D3",
"L  c #C4C3C2",
"M  c #8F8A81",
"N  c #F6F5F4",
"O  c #F5F5F3",
"P  c #919090",
"Q  c #868583",
"R  c #A1A09E",
"S  c #B4B3B1",
"T  c #B6B4B2",
"U  c #A5A4A1",
"V  c #BCBCBA",
"W  c #EAE9E7",
"X  c #E5E4E2",
"Y  c #E4E3E0",
"Z  c #D2D1CE",
"`  c #8D887E",
" . c #F3F2F1",
".. c #8F8F8D",
"+. c #898886",
"@. c #B9B7B4",
"#. c #BAB9B6",
"$. c #BCBAB7",
"%. c #C3C2BF",
"&. c #E2E1DE",
"*. c #E1DFDC",
"=. c #979288",
"-. c #8C8B89",
";. c #A9A8A5",
">. c #BDBCB9",
",. c #C5C3C0",
"'. c #D0CECC",
"). c #E5E4E1",
"!. c #A49E93",
"~. c #F0F0EE",
"{. c #EFEFED",
"]. c #8E8D8C",
"^. c #8F8E8C",
"/. c #B5B3B1",
"(. c #C7C6C3",
"_. c #E7E6E3",
":. c #E3E2DF",
"<. c #E2E0DD",
"[. c #E1E0DC",
"}. c #E0DFDB",
"|. c #A19C90",
"1. c #EDEDEB",
"2. c #ECEBE9",
"3. c #8C8C8A",
"4. c #B9B6B4",
"5. c #D8D7D5",
"6. c #E6E4E1",
"7. c #E3E2DE",
"8. c #DFDEDA",
"9. c #DEDDD9",
"0. c #DDDCD8",
"a. c #A19B90",
"b. c #EBEAE8",
"c. c #8A8988",
"d. c #A19F9D",
"e. c #C7C6C4",
"f. c #E7E5E2",
"g. c #E4E3DF",
"h. c #DCDBD7",
"i. c #E6E5E2",
"j. c #A7A6A3",
"k. c #E5E4E0",
"l. c #E2E1DD",
"m. c #DBD9D5",
"n. c #D9D7D3",
"o. c #9F998D",
"p. c #878684",
"q. c #DDDBD7",
"r. c #DCDAD6",
"s. c #D8D6D2",
"t. c #9E988D",
"u. c #EDEDED",
"v. c #E1E0DD",
"w. c #7B7B79",
"x. c #E0DEDA",
"y. c #D8D6D1",
"z. c #D7D5D1",
"A. c #9D978B",
"B. c #E1DFDB",
"C. c #B1B0AD",
"D. c #DEDCD8",
"E. c #D7D6D1",
"F. c #D5D3CE",
"G. c #9B958A",
"H. c #999891",
"I. c #A39E92",
"J. c #A39D92",
"K. c #A39D91",
"L. c #A29C90",
"M. c #A19B8F",
"N. c #9D978C",
"O. c #9B968A",
"P. c #676359",
"                                                ",
"    . . . . . . . . . . . . . .                 ",
"    . + @ # # # # # # # # $ % & .               ",
"    . @ # # # # # # # # # # * = - .             ",
"    . # # # # ; > # , # , ' ) ! ~ { .           ",
"    . # # # # ] . ^ / ' / ( _ : # < [ .         ",
"    . # # # , } . . | ( 1 2 3 ~ # 4 5 6 .       ",
"    . # , ' / 7 . 8 . 9 0 a b . . . . . . .     ",
"    . # / ( 1 c . d e . f g h i j k l m n .     ",
"    . # 1 2 0 o . p q r . s t u v w x y z .     ",
"    . # 0 a A B . C D E F . G H I J K L M .     ",
"    . # N O h P . Q R S T U . V W X Y Z ` .     ",
"    . # h  .t ... +.U @.#.$.%.. # Y &.*.=..     ",
"    . # h  .t ... -.;.>.,.'.. # ).Y &.*.!..     ",
"    . # ~.{.{.].. ^./.(.Z . # _.:.<.[.}.|..     ",
"    . # 1.I 2.3.. D 4.5.. # ).6.7.8.9.0.a..     ",
"    . # b.J J c.. d.e.. # f.g.7.}.9.0.h.a..     ",
"    . # _.i.i.+.. j.. # k.g.l.}.9.h.m.n.o..     ",
"    . $ Y :.7.p.. . # l.7.[.[.9.q.r.n.s.t..     ",
"    . u.v.*.[.w.. # [.}.[.8.x.q.r.n.y.z.A..     ",
"    . = B.x.8.C.# 9.x.9.x.D.D.r.r.s.E.F.G..     ",
"    . H.I.!.J.K.J.|.L.|.L.M.a.o.o.N.N.O.P..     ",
"    . . . . . . . . . . . . . . . . . . . .     ",
"                                                "};


/* XPM */
const gchar *merge16_xpm[] = {
"16 16 70 1",
"   c None",
".  c #000000",
"+  c #FEFEFE",
"@  c #FDFDFD",
"#  c #E0E0E0",
"$  c #C1C1C1",
"%  c #F1F1F1",
"&  c #B6B6B6",
"*  c #B3B3B3",
"=  c #E7E7E7",
"-  c #8A8A8A",
";  c #171717",
">  c #989389",
",  c #807D74",
"'  c #C6C2BA",
")  c #919190",
"!  c #34332D",
"~  c #B7B3AA",
"{  c #C4C2BD",
"]  c #EAE8E3",
"^  c #EFEFEF",
"/  c #DFDFDF",
"(  c #E2E1DD",
"_  c #F0EFEC",
":  c #AAA7A0",
"<  c #F0EEEB",
"[  c #F2F0ED",
"}  c #EBEAE6",
"|  c #8A857B",
"1  c #ECEBE8",
"2  c #EEECEA",
"3  c #78756B",
"4  c #BEBBB5",
"5  c #B3B1AA",
"6  c #7D786E",
"7  c #E1DFDB",
"8  c #D1D0CC",
"9  c #010101",
"0  c #8C8981",
"a  c #A6A29B",
"b  c #726D63",
"c  c #CECAC3",
"d  c #A7A49E",
"e  c #EAEAEA",
"f  c #E9E9E9",
"g  c #BDBDBD",
"h  c #0F0F0D",
"i  c #E8E8E8",
"j  c #E6E6E6",
"k  c #6C6C6B",
"l  c #3C3933",
"m  c #8B877E",
"n  c #706C62",
"o  c #B1ADA4",
"p  c #6C685E",
"q  c #97938A",
"r  c #DEDEDE",
"s  c #909090",
"t  c #434342",
"u  c #646056",
"v  c #8B877D",
"w  c #E5E5E5",
"x  c #E4E4E4",
"y  c #CCCCCC",
"z  c #B8B8B8",
"A  c #020202",
"B  c #C2C2C2",
"C  c #BCBCBC",
"D  c #BBBBBB",
"E  c #A0A0A0",
"  .........     ",
" .++++++@#$.    ",
" .+%%%%%%&*.. ..",
" .+%%%%=-;.>,.',",
" .+%%%%)!~{],.],",
" .+%^^/.(_:],.<,",
".......,(_:],.<,",
"]]]]]]]][}|1,.2,",
",,,,,,3345673.8,",
"......930abc3.d,",
" .@eefgh0abc3.d,",
" .@ijjjklmnop.q,",
" .@==jjrsth>u.v,",
" .@jwwwxxyzhhAh.",
" .BgggCCDDDDE.  ",
"  ...........   "};


/* XPM */
const gchar *merge24_xpm[] = {
"24 24 161 2",
"   c None",
".  c #000000",
"+  c #D3D3D3",
"@  c #F6F6F6",
"#  c #FFFFFF",
"$  c #F9F9F9",
"%  c #DADADA",
"&  c #585858",
"*  c #C7C7C7",
"=  c #D1D1D1",
"-  c #D6D6D6",
";  c #FEFEFE",
">  c #FDFDFD",
",  c #C0C0C0",
"'  c #E1E1E1",
")  c #F0F0F0",
"!  c #9B9B9B",
"~  c #FCFCFB",
"{  c #FBFBFB",
"]  c #AFAFAE",
"^  c #E9E9E9",
"/  c #DFDFDF",
"(  c #8F8F8F",
"_  c #EBEBEA",
":  c #B3B3B3",
"<  c #DADAD9",
"[  c #AFAFAF",
"}  c #E5E5E5",
"|  c #F4F4F4",
"1  c #CFCFCF",
"2  c #A2A2A2",
"3  c #F1F1F0",
"4  c #909090",
"5  c #212121",
"6  c #989389",
"7  c #807D74",
"8  c #C6C2BA",
"9  c #010100",
"0  c #969695",
"a  c #34332D",
"b  c #B7B3AA",
"c  c #C4C2BD",
"d  c #EAE8E3",
"e  c #9C978D",
"f  c #BCB9B2",
"g  c #363433",
"h  c #515050",
"i  c #706F6F",
"j  c #65625A",
"k  c #FAFAF9",
"l  c #E8E8E7",
"m  c #E2E1DD",
"n  c #F0EFEC",
"o  c #AAA7A0",
"p  c #F0EEEB",
"q  c #B2B0AB",
"r  c #F9F9F8",
"s  c #C5C3BD",
"t  c #0F0F0D",
"u  c #9E9D9B",
"v  c #88847B",
"w  c #F2F0ED",
"x  c #EBEAE6",
"y  c #8A857B",
"z  c #ECEBE8",
"A  c #EEECEA",
"B  c #9F9C93",
"C  c #F3F2F0",
"D  c #E8E7E4",
"E  c #E3E1DD",
"F  c #78756B",
"G  c #BEBBB5",
"H  c #B3B1AA",
"I  c #7D786E",
"J  c #E1DFDB",
"K  c #D1D0CC",
"L  c #938E84",
"M  c #C8C5BF",
"N  c #A7A298",
"O  c #010101",
"P  c #8C8981",
"Q  c #A6A29B",
"R  c #726D63",
"S  c #CECAC3",
"T  c #A7A49E",
"U  c #7E7A70",
"V  c #A09D94",
"W  c #817D73",
"X  c #6C685E",
"Y  c #F0F0EE",
"Z  c #C2C2C0",
"`  c #C9C8C5",
" . c #A19C90",
".. c #EDEDEB",
"+. c #EDECEA",
"@. c #6F6E6C",
"#. c #3C3933",
"$. c #8B877E",
"%. c #706C62",
"&. c #B1ADA4",
"*. c #97938A",
"=. c #625E54",
"-. c #6A655B",
";. c #37342D",
">. c #60605E",
",. c #DDDCD8",
"'. c #A19B90",
"). c #EBEAE8",
"!. c #E9E8E6",
"~. c #E1E0DE",
"{. c #929190",
"]. c #444442",
"^. c #646056",
"/. c #8B877D",
"(. c #1D1D1D",
"_. c #8C8B89",
":. c #DCDBD7",
"<. c #E7E6E3",
"[. c #E6E5E2",
"}. c #CECDCA",
"|. c #BBB9B6",
"1. c #BBBAB6",
"2. c #949390",
"3. c #C8C7C3",
"4. c #DBD9D5",
"5. c #D9D7D3",
"6. c #9F998D",
"7. c #E4E3E0",
"8. c #E3E2DF",
"9. c #E3E2DE",
"0. c #E4E2DF",
"a. c #E4E3DF",
"b. c #E1E0DC",
"c. c #DEDDD9",
"d. c #DDDBD7",
"e. c #DCDAD6",
"f. c #D8D6D2",
"g. c #9E988D",
"h. c #EDEDED",
"i. c #E1E0DD",
"j. c #E1DFDC",
"k. c #E0DFDB",
"l. c #DFDEDA",
"m. c #E0DEDA",
"n. c #D8D6D1",
"o. c #D7D5D1",
"p. c #9D978B",
"q. c #DEDCD8",
"r. c #D7D6D1",
"s. c #D5D3CE",
"t. c #9B958A",
"u. c #999891",
"v. c #A39E92",
"w. c #A49E93",
"x. c #A39D92",
"y. c #A39D91",
"z. c #A29C90",
"A. c #A19B8F",
"B. c #9D978C",
"C. c #9B968A",
"D. c #676359",
"                                                ",
"      . . . . . . . . . . . . .                 ",
"    . + @ # # # # # # # # $ % & .               ",
"    . @ # # # # # # # # # # * = - .             ",
"    . # # # # # # # ; # ; > , ' ) ! .           ",
"    . # # # # # ; > ~ > ~ { ] ^ # / ( .         ",
"    . # # # ; > _ : . . < . . [ } | 1 2 .       ",
"    . # ; > 3 4 5 . 6 7 . 8 7 . . . 9 . . .     ",
"    . # ~ { 0 a b c d 7 . d 7 e f g h i j .     ",
"    . # k l . m n o d 7 . p 7 q r s t u v .     ",
". . . . . . 7 m n o d 7 . p 7 q r s 7 . . . . . ",
"d d d d d d d w x y z 7 . A 7 B C D E d d d d d ",
"7 7 7 7 7 F F G H I J F . K 7 L M N 7 7 7 7 7 7 ",
". . . . . O F P Q R S F . T 7 U V W X . . . . . ",
"    . # Y Z t P Q R S F . T 7 U V W t `  ..     ",
"    . # ..+.@.#.$.%.&.X . *.7 =.-.;.>.,.'..     ",
"    . # ).!.~.{.].t 6 ^.. /.7 . (._.K :.'..     ",
"    . # <.[.[.[.}.|.t t 1.t . 2.3.:.4.5.6..     ",
"    . $ 7.8.9.0.a.m 9.m 9.b.b.c.d.e.5.f.g..     ",
"    . h.i.j.b.k.m k.b.k.b.l.m.d.e.5.n.o.p..     ",
"    . = J m.l.c.k.c.m.c.m.q.q.e.e.f.r.s.t..     ",
"    . u.v.w.x.y.x. .z. .z.A.'.6.6.B.B.C.D..     ",
"      . . . . . . . . . . . . . . . . . .       ",
"                                                "};


/* XPM */
const gchar *change16_xpm[] = {
"16 16 94 2",
"   c None",
".  c #000000",
"+  c #B3B3B3",
"@  c #FFFFFF",
"#  c #CACACA",
"$  c #6C6C6C",
"%  c #B3B1B0",
"&  c #EEECEB",
"*  c #F0DCAA",
"=  c #E5C470",
"-  c #DFB84F",
";  c #8A681F",
">  c #100E09",
",  c #C6C6C6",
"'  c #3F3F3F",
")  c #EEECE9",
"!  c #E6D498",
"~  c #EED682",
"{  c #EED680",
"]  c #E3C15E",
"^  c #D29815",
"/  c #976E15",
"(  c #7F5B0A",
"_  c #1C190F",
":  c #FEFEFE",
"<  c #1E1E1E",
"[  c #EBE9E5",
"}  c #CBB771",
"|  c #735817",
"1  c #C6A546",
"2  c #E3C05D",
"3  c #BC8710",
"4  c #AD7C10",
"5  c #FDFDFD",
"6  c #AE9C5C",
"7  c #303030",
"8  c #CECDCA",
"9  c #D2D1CF",
"0  c #D4D3D1",
"a  c #9A9998",
"b  c #9C7E2B",
"c  c #AB7C12",
"d  c #242012",
"e  c #4C4C4B",
"f  c #484745",
"g  c #030201",
"h  c #020201",
"i  c #3D351F",
"j  c #A37819",
"k  c #231F13",
"l  c #090804",
"m  c #F5F5F5",
"n  c #E3E3E1",
"o  c #E2E2E1",
"p  c #0B0B06",
"q  c #A97C1A",
"r  c #E3E3E3",
"s  c #5A5A5A",
"t  c #4E4F4F",
"u  c #888887",
"v  c #010100",
"w  c #221E11",
"x  c #EAE8E3",
"y  c #C58F13",
"z  c #B68411",
"A  c #826321",
"B  c #302C19",
"C  c #F0F0F1",
"D  c #F1F1F0",
"E  c #363220",
"F  c #916F25",
"G  c #322F1E",
"H  c #D6D6D6",
"I  c #000101",
"J  c #F7F6F6",
"K  c #EAEAE9",
"L  c #2B2719",
"M  c #353120",
"N  c #070603",
"O  c #4F4F4E",
"P  c #484746",
"Q  c #937025",
"R  c #CDCAC1",
"S  c #050402",
"T  c #ECECEB",
"U  c #2F2C19",
"V  c #CCCBC8",
"W  c #D8D7D5",
"X  c #535353",
"Y  c #90908F",
"Z  c #F2F2F1",
"`  c #545453",
" . c #5D5D5B",
".. c #F3F3F2",
". . . . . . . . . . .           ",
". + @ # $ % & * = - ; . >       ",
". @ , ' ) ! ~ { { ] ^ / ( _     ",
". : < [ } . . . | 1 2 3 4 _     ",
". 5 . 6 7 8 9 0 a b { ^ c d     ",
". @ e . 0 f g h h i { ^ j k l   ",
". @ m n o h p . . . { ^ q . . . ",
". r s t u v w x { { { ^ y z A B ",
". @ @ @ C v D E x { { ^ ^ F G   ",
". H @ @ @ I J K L x { ^ F M N   ",
". . . . . . @ O P B x Q G R S   ",
"          . @ @ 5 T B U V W h   ",
"          . r s X Y Z `  ....   ",
"          . @ @ @ @ @ @ @ @ .   ",
"          . H @ @ @ @ @ @ H .   ",
"          . . . . . . . . .     "};


/* XPM */
const gchar *change24_xpm[] = {
"24 24 89 1",
"   c None",
".  c #000000",
"+  c #0A0A0A",
"@  c #B3B1B0",
"#  c #EEECEB",
"$  c #F0DCAA",
"%  c #E5C470",
"&  c #DFB84F",
"*  c #8A681F",
"=  c #100E09",
"-  c #202020",
";  c #EEECE9",
">  c #E6D498",
",  c #EED682",
"'  c #EED680",
")  c #E3C15E",
"!  c #D29815",
"~  c #976E15",
"{  c #7F5B0A",
"]  c #1C190F",
"^  c #EBE9E5",
"/  c #CBB771",
"(  c #735817",
"_  c #C6A546",
":  c #E3C05D",
"<  c #BC8710",
"[  c #AD7C10",
"}  c #AE9C5C",
"|  c #0C0A05",
"1  c #9C7E2B",
"2  c #AB7C12",
"3  c #242012",
"4  c #B4B4B4",
"5  c #F8F8F8",
"6  c #EFEFEE",
"7  c #A3A2A0",
"8  c #050402",
"9  c #3D351F",
"0  c #A37819",
"a  c #231F13",
"b  c #E9E9E9",
"c  c #E7E7E7",
"d  c #D6D5D4",
"e  c #CFCFCD",
"f  c #020201",
"g  c #0B0B06",
"h  c #A97C1A",
"i  c #989898",
"j  c #828282",
"k  c #8A8A8A",
"l  c #B2B2B2",
"m  c #E0E0DF",
"n  c #010100",
"o  c #221E11",
"p  c #EAE8E3",
"q  c #C58F13",
"r  c #B68411",
"s  c #826321",
"t  c #302C19",
"u  c #E8E8E8",
"v  c #363220",
"w  c #916F25",
"x  c #322F1E",
"y  c #636363",
"z  c #5A5A5A",
"A  c #6B6B6B",
"B  c #020101",
"C  c #2B2719",
"D  c #353120",
"E  c #B3B3B3",
"F  c #FFFFFF",
"G  c #F3F3F2",
"H  c #937025",
"I  c #19160D",
"J  c #818181",
"K  c #2F2C19",
"L  c #CCCBC8",
"M  c #A7A7A7",
"N  c #8F8F8F",
"O  c #C6C6C6",
"P  c #8B8A8A",
"Q  c #B6B6B4",
"R  c #E5E5E3",
"S  c #808080",
"T  c #6D6D6D",
"U  c #767676",
"V  c #F5F5F5",
"W  c #C3C3C3",
"X  c #D6D6D6",
"              .....     ",
"            +@#$%&*.=   ",
"           -;>,'')!~{]  ",
"          .^/...(_:<[]  ",
"...........}.|   1'!23  ",
".4555555556.78   9'!0a  ",
".5bbbbbbbbcdefg...'!h...",
".5ijjkb4jbjlmnop'''!qrst",
".5bbbbbbbbuuu. vp''!!wx ",
".5yzbAj4u......BCp'!wD  ",
".5bbbbbb.EFFFFFFGtpHxI  ",
".5ijjbjJ.FFFFFFFFGtKL8  ",
".5bbbbbu.FMNNiFONFPQRn  ",
".5yzzbAS.FFFFFFFFFFFF.  ",
".5bbbbbc.FTyFUNOFONFF.  ",
".5ijjbjJ.FFFFFFFFFFFF.  ",
".Vbbbbbu.FMNNFNNOFiNF.  ",
".Wbbbbbu.FFFFFFFFFFFF.  ",
" ........FTyyFUNOFONF.  ",
"        .FFFFFFFFFFFF.  ",
"        .FMNNFNNOFiNF.  ",
"        .FFFFFFFFFFFF.  ",
"        .XFFFFFFFFFFX.  ",
"        ..............  "};


/* XPM */
const gchar *reverse16_xpm[] = {
"16 16 40 1",
"   c None",
".  c #000000",
"+  c #CDDECB",
"@  c #77A16E",
"#  c #B1C9B0",
"$  c #ACC8A9",
"%  c #709867",
"&  c #B4CBB2",
"*  c #B5CEB5",
"=  c #B9CEB7",
"-  c #BAD1BA",
";  c #C2D7BE",
">  c #B2CBB0",
",  c #AAC7A8",
"'  c #0F1308",
")  c #B3CAB1",
"!  c #B0C9B0",
"~  c #AEC7AC",
"{  c #AAC5A8",
"]  c #AAC6A7",
"^  c #A8C6A5",
"/  c #ADC8AD",
"(  c #A8C7A8",
"_  c #A5C4A3",
":  c #7F9F76",
"<  c #2D2D2D",
"[  c #CFDFCC",
"}  c #ADC8AB",
"|  c #B0C7AE",
"1  c #ADC6AB",
"2  c #A9C7A6",
"3  c #ABC7A8",
"4  c #AFC8AD",
"5  c #A4C3A2",
"6  c #6B9060",
"7  c #3C5235",
"8  c #5B7950",
"9  c #445B2C",
"0  c #3B5035",
"a  c #506B46",
"                ",
"      .  .      ",
"     ..  ..     ",
"    .+.  .@.    ",
"   .+#....$%.   ",
"  .+&*=-;;>,%'  ",
" .+,)!~{]^/(_:. ",
"<[}|11,~23,3456.",
" .788888888889. ",
"  .78800aa889.  ",
"   .78....89.   ",
"    .7.  .9.    ",
"     ..  ..     ",
"      .  .      ",
"                ",
"                "};


/* XPM */
const gchar *reverse24_xpm[] = {
"24 24 59 1",
"   c None",
".  c #000000",
"+  c #B9D0B9",
"@  c #8CA782",
"#  c #CDDECB",
"$  c #B6C7B6",
"%  c #B1CDAE",
"&  c #77A16E",
"*  c #B1C9B0",
"=  c #B3C4B3",
"-  c #B4CEB1",
";  c #ACC8A9",
">  c #709867",
",  c #B4CBB2",
"'  c #B5CEB5",
")  c #B7CCB5",
"!  c #B9CEB7",
"~  c #BAD1BA",
"{  c #BBCFBA",
"]  c #C2D7BE",
"^  c #B0CAAD",
"/  c #B2CBB0",
"(  c #AAC7A8",
"_  c #0F1308",
":  c #B3CAB1",
"<  c #B0C9B0",
"[  c #B0C9AE",
"}  c #AEC7AC",
"|  c #AAC5A8",
"1  c #ABC7A8",
"2  c #AAC6A7",
"3  c #A8C6A5",
"4  c #ADC8AD",
"5  c #A8C7A8",
"6  c #A5C4A3",
"7  c #7F9F76",
"8  c #2D2D2D",
"9  c #CFDFCC",
"0  c #ADC8AB",
"a  c #B0C7AE",
"b  c #ADC6AB",
"c  c #A7C5A4",
"d  c #A9C7A6",
"e  c #AFC8AD",
"f  c #A4C3A2",
"g  c #6B9060",
"h  c #9BAD9A",
"i  c #85AE81",
"j  c #87AF84",
"k  c #87B083",
"l  c #88AF84",
"m  c #6B9063",
"n  c #698D60",
"o  c #445B2C",
"p  c #3C5235",
"q  c #5B7950",
"r  c #4A6342",
"s  c #3B5035",
"t  c #506B46",
"                        ",
"                        ",
"                        ",
"        .      .        ",
"       ..      ..       ",
"      .+.      .@.      ",
"     .#$.      .%&.     ",
"    .#*=........-;>.    ",
"   .#,')!~!{]]]]^/(>_   ",
"  .#(:<[}|||1123(4567.  ",
" 890abb0(}}ac3d1;(1efg. ",
".hijjjjjkljkmmmmmmmmmno.",
" .pqqqqqqqqqqqqqqqqqqo. ",
"  .pqqqqqqqqqqqqqqqqo.  ",
"   .pqqrssssttttqqqo.   ",
"    .pqr........tqo.    ",
"     .pr.      .to.     ",
"      .r.      .o.      ",
"       ..      ..       ",
"        .      .        ",
"                        ",
"                        ",
"                        ",
"                        "};


#if ! GTK_CHECK_VERSION(2,10,0)
/* XPM */
const gchar *select_all16_xpm[] = {
"16 16 42 1",
"   c None",
".  c #000000",
"+  c #FEFEFE",
"@  c #FDFDFD",
"#  c #E0E0E0",
"$  c #C1C1C1",
"%  c #F1F1F1",
"&  c #C3C3C3",
"*  c #FBFBFB",
"=  c #A8A8A8",
"-  c #494066",
";  c #ADADAD",
">  c #767676",
",  c #5D5D5D",
"'  c #404040",
")  c #FFFFFF",
"!  c #E2E2E2",
"~  c #858585",
"{  c #4B4B49",
"]  c #161616",
"^  c #EEEEEE",
"/  c #C5C5C5",
"(  c #EFEFEF",
"_  c #ECECEC",
":  c #C4C4C4",
"<  c #EBEBEB",
"[  c #EDEDED",
"}  c #EAEAEA",
"|  c #E8E8E8",
"1  c #C0C0C0",
"2  c #E7E7E7",
"3  c #BFBFBF",
"4  c #E5E5E5",
"5  c #BEBEBE",
"6  c #E6E6E6",
"7  c #E4E4E4",
"8  c #BDBDBD",
"9  c #E3E3E3",
"0  c #BBBBBB",
"a  c #C2C2C2",
"b  c #BCBCBC",
"c  c #A0A0A0",
"  .........     ",
" .++++++@#$.    ",
" .+%%%%%%&*=.   ",
" .+%-----;>,'.  ",
" .+%-)))-!~{].  ",
" .+%-------^/.  ",
" .+(-)-)))-_:.  ",
" .@^-------<&.  ",
" .@[-))-))-}$.  ",
" .@<-------|1.  ",
" .@}-)-)))-23.  ",
" .@|-------45.  ",
" .@2266644778.  ",
" .@6444779990.  ",
" .a888bb0000c.  ",
"  ...........   "};


/* XPM */
const gchar *select_all24_xpm[] = {
"24 24 91 1",
"   c None",
".  c #000000",
"+  c #0E0E0E",
"@  c #282828",
"#  c #616161",
"$  c #D3D3D3",
"%  c #F6F6F6",
"&  c #FFFFFF",
"*  c #F9F9F9",
"=  c #F9F9F8",
"-  c #E7E7E7",
";  c #E4E4E4",
">  c #CDCDCD",
",  c #1F1F1F",
"'  c #EFEFEE",
")  c #AFAFAE",
"!  c #E9E9E9",
"~  c #B3B3B3",
"{  c #383838",
"]  c #494066",
"^  c #EEEEEE",
"/  c #A4A4A3",
"(  c #F0F0F0",
"_  c #F4F4F4",
":  c #ABABAB",
"<  c #050505",
"[  c #F2F2F2",
"}  c #9E9E9E",
"|  c #D4D4D3",
"1  c #B9B7B6",
"2  c #838381",
"3  c #848381",
"4  c #6A6763",
"5  c #FEFEFE",
"6  c #F3F2F1",
"7  c #E0E0DF",
"8  c #DCDAD8",
"9  c #CACAC8",
"0  c #B6B6B4",
"a  c #72706C",
"b  c #FCFCFB",
"c  c #C4C3C0",
"d  c #817D74",
"e  c #FAFAF9",
"f  c #E1DFDC",
"g  c #8B867D",
"h  c #F8F8F7",
"i  c #A49E93",
"j  c #F6F5F4",
"k  c #F4F3F2",
"l  c #F0F0EE",
"m  c #E0DFDB",
"n  c #A19C90",
"o  c #EDEDEB",
"p  c #DDDCD8",
"q  c #A19B90",
"r  c #EBEAE8",
"s  c #DCDBD7",
"t  c #E7E6E3",
"u  c #D9D7D3",
"v  c #9F998D",
"w  c #E4E3E0",
"x  c #D8D6D2",
"y  c #9E988D",
"z  c #EDEDED",
"A  c #E1E0DD",
"B  c #E1E0DC",
"C  c #E2E1DD",
"D  c #DFDEDA",
"E  c #E0DEDA",
"F  c #DDDBD7",
"G  c #DCDAD6",
"H  c #D8D6D1",
"I  c #D7D5D1",
"J  c #9D978B",
"K  c #D1D1D1",
"L  c #E1DFDB",
"M  c #DEDDD9",
"N  c #DEDCD8",
"O  c #D7D6D1",
"P  c #D5D3CE",
"Q  c #9B958A",
"R  c #999891",
"S  c #A39E92",
"T  c #A39D92",
"U  c #A39D91",
"V  c #A29C90",
"W  c #A19B8F",
"X  c #9D978C",
"Y  c #9B968A",
"Z  c #676359",
"                        ",
"   .............+@#     ",
"  .$%&&&&&&&&*==-;>,    ",
"  .%&&&&&&&&&&=')!&~{   ",
"  .&&]]]]]]]]]=^/(&_:<  ",
"  .&&]&&]&&&&]=[}.....  ",
"  .&&]]]]]]]]]=_|1234.  ",
"  .&5]&&&&]&&]=67890a.  ",
"  .&b]]]]]]]]]]]]]]cd.  ",
"  .&e]&&&&&&]&&&]&]fg.  ",
"  .&h]]]]]]]]]]]]]]fi.  ",
"  .&j]&&&&&&&]&&&&]fi.  ",
"  .&k]]]]]]]]]]]]]]fi.  ",
"  .&k]&&&]&&]&&&&]]fi.  ",
"  .&l]]]]]]]]]]]]]]mn.  ",
"  .&o]&&&&&]&&&&]&]pq.  ",
"  .&r]]]]]]]]]]]]]]sq.  ",
"  .&t]&&&&&&]&&&&&]uv.  ",
"  .*w]]]]]]]]]]]]]]xy.  ",
"  .zAfBmCmBmBDEFGuHIJ.  ",
"  .KLEDMmMEMENNGGxOPQ.  ",
"  .RSiTUTnVnVWqvvXXYZ.  ",
"   ..................   ",
"                        "};
#endif /* not GTK_CHECK_VERSION(2,10,0) */


/* XPM */
const gchar *size16_xpm[] = {
"16 16 36 1",
"   c None",
".  c #000000",
"+  c #262626",
"@  c #C5C5C5",
"#  c #EEEEEE",
"$  c #EDEDED",
"%  c #ABABAB",
"&  c #464646",
"*  c #878787",
"=  c #F1F1F1",
"-  c #FEFEFE",
";  c #FDFDFD",
">  c #FCFCFC",
",  c #EAEAEA",
"'  c #707070",
")  c #FBFBFB",
"!  c #E8E8E8",
"~  c #B0B0B0",
"{  c #FAFAFA",
"]  c #A4A4A4",
"^  c #FFFFFF",
"/  c #E5E5E5",
"(  c #E4E4E4",
"_  c #F9F9F9",
":  c #BABABA",
"<  c #E7E7E7",
"[  c #858585",
"}  c #E3E3E3",
"|  c #6D6D6D",
"1  c #A1A1A1",
"2  c #202020",
"3  c #686868",
"4  c #343434",
"5  c #797979",
"6  c #3A3A3A",
"7  c #1F1F1F",
"    ....        ",
"  .+@#$%&.      ",
" .*=--;>,'.     ",
" &=--..;)!&     ",
".~--.--.>{].    ",
".#-.---^.{/.    ",
".$;.^^^^.{(.    ",
".%>;.;>.{_:.    ",
" &,)>..{_<&     ",
" .[!{{{_}|.     ",
"  .&]/(1&....   ",
"    ....  22..  ",
"          .34.. ",
"           .56..",
"            .37.",
"             .. "};


/* XPM */
const gchar *size24_xpm[] = {
"24 24 128 2",
"   c None",
".  c #343434",
"+  c #2D2D2D",
"@  c #292929",
"#  c #262626",
"$  c #2E2E2E",
"%  c #303030",
"&  c #737373",
"*  c #A1A1A1",
"=  c #B4B4B4",
"-  c #B2B2B2",
";  c #9D9D9D",
">  c #676767",
",  c #202020",
"'  c #1C1C1C",
")  c #272727",
"!  c #616161",
"~  c #CACACA",
"{  c #CFCFCF",
"]  c #D0D0D0",
"^  c #CECECE",
"/  c #C9C9C9",
"(  c #C1C1C1",
"_  c #A7A7A7",
":  c #4C4C4C",
"<  c #131313",
"[  c #222222",
"}  c #757575",
"|  c #D3D3D3",
"1  c #DBDBDB",
"2  c #E7E7E7",
"3  c #EFEFEF",
"4  c #F3F3F3",
"5  c #F1F1F1",
"6  c #E5E5E5",
"7  c #D2D2D2",
"8  c #BCBCBC",
"9  c #5E5E5E",
"0  c #101010",
"a  c #212121",
"b  c #5B5B5B",
"c  c #CCCCCC",
"d  c #D7D7D7",
"e  c #F5F5F5",
"f  c #000000",
"g  c #F0F0F0",
"h  c #E1E1E1",
"i  c #C2C2C2",
"j  c #434343",
"k  c #0F0F0F",
"l  c #1F1F1F",
"m  c #B9B9B9",
"n  c #D6D6D6",
"o  c #F9F9F9",
"p  c #FDFDFD",
"q  c #FCFCFC",
"r  c #FBFBFB",
"s  c #F2F2F2",
"t  c #ECECEC",
"u  c #E4E4E4",
"v  c #ABABAB",
"w  c #0E0E0E",
"x  c #1B1B1B",
"y  c #6D6D6D",
"z  c #FEFEFE",
"A  c #EEEEEE",
"B  c #E6E6E6",
"C  c #575757",
"D  c #090909",
"E  c #141414",
"F  c #A8A8A8",
"G  c #D8D8D8",
"H  c #F8F8F8",
"I  c #F4F4F4",
"J  c #DCDCDC",
"K  c #9B9B9B",
"L  c #060606",
"M  c #111111",
"N  c #C5C5C5",
"O  c #DFDFDF",
"P  c #FAFAFA",
"Q  c #F7F7F7",
"R  c #BFBFBF",
"S  c #C6C6C6",
"T  c #E3E3E3",
"U  c #E0E0E0",
"V  c #BABABA",
"W  c #050505",
"X  c #0B0B0B",
"Y  c #A5A5A5",
"Z  c #F6F6F6",
"`  c #D1D1D1",
" . c #939393",
".. c #020202",
"+. c #0A0A0A",
"@. c #5F5F5F",
"#. c #D9D9D9",
"$. c #EDEDED",
"%. c #E9E9E9",
"&. c #D4D4D4",
"*. c #E2E2E2",
"=. c #DADADA",
"-. c #CBCBCB",
";. c #3B3B3B",
">. c #D5D5D5",
",. c #C8C8C8",
"'. c #BDBDBD",
"). c #515151",
"!. c #C7C7C7",
"~. c #CDCDCD",
"{. c #B8B8B8",
"]. c #454545",
"^. c #030303",
"/. c #313131",
"(. c #999999",
"_. c #BBBBBB",
":. c #B6B6B6",
"<. c #909090",
"[. c #2B2B2B",
"}. c #010101",
"|. c #414141",
"1. c #7A7A7A",
"2. c #9A9A9A",
"3. c #777777",
"4. c #3C3C3C",
"5. c #686868",
"6. c #797979",
"7. c #3A3A3A",
"                                                ",
"              . + @ # # #                       ",
"          $ % & * = - ; > , '                   ",
"        ) ! = ~ { ] ^ / ( _ : <                 ",
"      [ } ~ | 1 2 3 4 5 6 7 8 9 0               ",
"    a b c d 6 e f f f f e g h i j k             ",
"    l m n 2 o f p p q r f s t u v w             ",
"  x y 7 h e f p z z p q o f A B 1 C D           ",
"  E F G A f o q z z p r H I f B J K L           ",
"  M N O 3 f H r p p q P Q s f 6 1 R L           ",
"  w S T t f e H P P P Q I g f U d V W           ",
"  X Y h 2 f 5 I Z Z e 4 3 t f 1 `  ...          ",
"  +.@.#.h B f A 3 3 A $.%.f 1 &.~ : f           ",
"    +.= G J *.f B B 2 T f =.&.-.* ..            ",
"    L ;.c 7 &.=.f f f f >.] ,.'.$ f             ",
"      W ).i !.-.c ~.-.-.,.i {.].f               ",
"        ^./.(._.'.8 8 8 :.<.[.f f f             ",
"          }.^.|.1.2.2.3.4.f f   f f f f         ",
"              f f f f f f         , , f f       ",
"                                  f 5.. f f     ",
"                                    f 6.7.f f   ",
"                                      f 5.l f   ",
"                                        f f     ",
"                                                "};


/* XPM */
const gchar *codec16_xpm[] = {
"16 16 87 1",
"   c None",
".  c #000000",
"+  c #FEFEFE",
"@  c #DADADA",
"#  c #CBCBCB",
"$  c #FDFDFD",
"%  c #E0E0E0",
"&  c #C1C1C1",
"*  c #F1F1F1",
"=  c #CAC8C1",
"-  c #BBBBBB",
";  c #C3C3C3",
">  c #FBFBFB",
",  c #A8A8A8",
"'  c #B1B1B1",
")  c #EBEBE8",
"!  c #EBEBEB",
"~  c #ADADAD",
"{  c #767676",
"]  c #5D5D5D",
"^  c #D8D8D8",
"/  c #F9F8F8",
"(  c #CCCCCC",
"_  c #E2E2E2",
":  c #858585",
"<  c #3D3D3C",
"[  c #D2D0CC",
"}  c #F7F7F7",
"|  c #DEDBD6",
"1  c #A9A9A9",
"2  c #EFEFEF",
"3  c #848484",
"4  c #737373",
"5  c #D3D2CF",
"6  c #E3E2E1",
"7  c #DFDEDC",
"8  c #DBDAD7",
"9  c #A4A19C",
"0  c #656565",
"a  c #292929",
"b  c #838383",
"c  c #C4C4C4",
"d  c #F3F3F3",
"e  c #1D1D1D",
"f  c #D2D1D0",
"g  c #50504F",
"h  c #EDEDED",
"i  c #ECECEC",
"j  c #111111",
"k  c #3D3D3D",
"l  c #494746",
"m  c #DEDEDE",
"n  c #BFBFBF",
"o  c #363636",
"p  c #C8C7C6",
"q  c #6C6967",
"r  c #708295",
"s  c #CFD6DD",
"t  c #7C91A7",
"u  c #E8E8E8",
"v  c #D6D5D5",
"w  c #8A8784",
"x  c #7D8C9C",
"y  c #788DA4",
"z  c #7F99B3",
"A  c #1F272F",
"B  c #E6E6E6",
"C  c #ECEBEA",
"D  c #72706D",
"E  c #8D99A5",
"F  c #748AA2",
"G  c #849EB9",
"H  c #4D5F73",
"I  c #E5E5E5",
"J  c #E4E4E4",
"K  c #D5D4D3",
"L  c #6B6A69",
"M  c #7D91A7",
"N  c #849EBA",
"O  c #D9D9D9",
"P  c #E3E3E3",
"Q  c #DCDCDC",
"R  c #525252",
"S  c #66798F",
"T  c #ACACAC",
"U  c #BCBCBC",
"V  c #A0A0A0",
"  .........     ",
" .++@.#+$%&.  . ",
" .+*.=.-*;>,..'.",
" .+**.).!~{].^. ",
" ..**./.(_:<..  ",
" .[..}|.123.4.  ",
" ..56789.0abc.  ",
" .d.e..fg.0!;.  ",
" .$hiiijkl.mn.  ",
" .$!...o.pq.'.  ",
" .$.rst.u.vw..  ",
" ..xsyzAB(.CD.  ",
" .EsFGH.IIJ.KL. ",
" .sMNH.OJPPQ.fR ",
" .MSH.TU----V.. ",
" ............   "};


/* XPM */
const gchar *codec24_xpm[] = {
"24 24 218 2",
"   c None",
".  c #000000",
"+  c #BAB5AB",
"@  c #D0CDC6",
"#  c #88857D",
"$  c #D2D2D2",
"%  c #ECECEC",
"&  c #DFDFDF",
"*  c #C9C6BE",
"=  c #CCC8C1",
"-  c #F8F8F8",
";  c #FEFEFE",
">  c #F9F9F9",
",  c #DADADA",
"'  c #585858",
")  c #F4F4F4",
"!  c #E9E9E9",
"~  c #D1D1D1",
"{  c #E5E3E0",
"]  c #D5D5D5",
"^  c #FDFDFD",
"/  c #FFFFFF",
"(  c #C7C7C7",
"_  c #D6D6D6",
":  c #757575",
"<  c #7B7B7B",
"[  c #F2F2F2",
"}  c #E1E1E1",
"|  c #2E2E2E",
"1  c #F6F5F5",
"2  c #929292",
"3  c #C0C0C0",
"4  c #EFEFEF",
"5  c #CCCCCC",
"6  c #AFAFAF",
"7  c #D3D1CB",
"8  c #909090",
"9  c #C1C0BF",
"0  c #F0EFED",
"a  c #9B9A96",
"b  c #5A5A5A",
"c  c #F3F3F2",
"d  c #FAFAFA",
"e  c #AFAFAE",
"f  c #DCDCDC",
"g  c #A5A19C",
"h  c #EAE9E5",
"i  c #F3F1F0",
"j  c #ECECEB",
"k  c #F7F7F6",
"l  c #A4A4A3",
"m  c #EDEDED",
"n  c #202020",
"o  c #A19D96",
"p  c #C1BDB4",
"q  c #DBD8D3",
"r  c #D9D6D1",
"s  c #89857E",
"t  c #F0EFEE",
"u  c #9C9C9C",
"v  c #EBEBEB",
"w  c #AAAAAA",
"x  c #636363",
"y  c #121212",
"z  c #EAE9E6",
"A  c #F5F4F3",
"B  c #C6C2BA",
"C  c #939391",
"D  c #848383",
"E  c #646363",
"F  c #5F5C54",
"G  c #EAEAEA",
"H  c #D7D7D6",
"I  c #CCCCCB",
"J  c #C7C7C6",
"K  c #C7C6C5",
"L  c #C2C1C1",
"M  c #F4F4F3",
"N  c #CBC7C0",
"O  c #AEADAC",
"P  c #B5B5B3",
"Q  c #BBBAB8",
"R  c #A9A8A6",
"S  c #86827A",
"T  c #EDEDEC",
"U  c #E8E7E6",
"V  c #E4E3E2",
"W  c #E2E2E0",
"X  c #DAD9D8",
"Y  c #A6A5A4",
"Z  c #D3D2D0",
"`  c #CFCECD",
" . c #C3C2C1",
".. c #8F8A81",
"+. c #F3F3F1",
"@. c #F2F1F0",
"#. c #E9E9E7",
"$. c #D9D9D7",
"%. c #C3C3C2",
"&. c #676560",
"*. c #54524D",
"=. c #C0BFBD",
"-. c #E1E0DD",
";. c #D2D1CE",
">. c #8D887E",
",. c #F4F3F2",
"'. c #F3F2F1",
"). c #F1F1EF",
"!. c #777676",
"~. c #797978",
"{. c #85827E",
"]. c #79756F",
"^. c #AFAEAC",
"/. c #DFDDDA",
"(. c #979288",
"_. c #7590AE",
":. c #A4BAD0",
"<. c #90A6BE",
"[. c #908F8E",
"}. c #9F9F9E",
"|. c #BEBDBC",
"1. c #B8B4AD",
"2. c #87837C",
"3. c #9C9A98",
"4. c #A29C91",
"5. c #EFEFED",
"6. c #D3DFEA",
"7. c #A2AEBC",
"8. c #9DB6CE",
"9. c #637B95",
"0. c #AAA9A7",
"a. c #A5A4A3",
"b. c #E2E2E2",
"c. c #EEEEED",
"d. c #636059",
"e. c #849CB6",
"f. c #D7E2ED",
"g. c #8D98A5",
"h. c #9DB8D2",
"i. c #607791",
"j. c #B7B6B4",
"k. c #C3C2C0",
"l. c #B9B9B6",
"m. c #99ADC3",
"n. c #DFE7F0",
"o. c #8193A9",
"p. c #586D84",
"q. c #5B7189",
"r. c #D0CECB",
"s. c #CCCBC8",
"t. c #BAB9B5",
"u. c #F1F1F1",
"v. c #EEEDEB",
"w. c #A7A6A5",
"x. c #726F6A",
"y. c #A1B4C8",
"z. c #EEF3F6",
"A. c #60768F",
"B. c #B1B0AD",
"C. c #C1C1BD",
"D. c #D6D5D1",
"E. c #DAD9D5",
"F. c #CACAC6",
"G. c #B5B5B1",
"H. c #DEDDDC",
"I. c #787776",
"J. c #4E4E4D",
"K. c #91A6BE",
"L. c #F0F4F7",
"M. c #97A5B6",
"N. c #898886",
"O. c #BAB9B6",
"P. c #CECDC9",
"Q. c #DBDAD6",
"R. c #DFDEDA",
"S. c #D7D6D3",
"T. c #C8C6C2",
"U. c #B4B2AF",
"V. c #BFBEBD",
"W. c #AAAAA9",
"X. c #ACACAB",
"Y. c #B0C6DB",
"Z. c #EDF2F6",
"`. c #818A95",
" + c #6B6A68",
".+ c #B6B5B2",
"++ c #C8C7C3",
"@+ c #D9D8D4",
"#+ c #DEDDD9",
"$+ c #E0DEDA",
"%+ c #DCDAD6",
"&+ c #D5D4D0",
"*+ c #C4C2BF",
"=+ c #B1AFAB",
"-+ c #6C85A1",
";+ c #C0D1E2",
">+ c #545352",
",+ c #B2B1AE",
"'+ c #C5C3C0",
")+ c #D3D2CE",
"!+ c #DEDCD8",
"~+ c #DBD9D5",
"{+ c #D2D0CC",
"]+ c #C3C2BE",
"^+ c #B2B1AC",
"/+ c #7D7870",
"(+ c #3D3B36",
"_+ c #827D74",
":+ c #8C887D",
"<+ c #999388",
"[+ c #9F9A8E",
"}+ c #A29C90",
"|+ c #A19B8F",
"1+ c #A19B90",
"2+ c #9F998D",
"3+ c #9C968B",
"4+ c #928D82",
"5+ c #5F5C52",
"            . .                                 ",
"      . . . + @ # . . . . . . .                 ",
"    . $ % & . * = + . - ; > , ' .     . .       ",
"    . ) - ! ~ . { * . ] ^ / ( ~ _ . . / : .     ",
"    . . < [ } | 1 * . 2 > ^ 3 } 4 . / 5 6 .     ",
"    . 7 8 . . 9 0 + a b c d e ! ^ . f 6 .       ",
"    . g = = h i + + + . j k l 4 . m . . .       ",
"    . n o p = * q r + s . t u . v . . . . .     ",
"    . w x . . . y z A B s . . 5 . C D E F .     ",
"    . G H I J K L . t M N . 6 . O P Q R S .     ",
"    . > T U V W X J . j . 6 . . Y Z `  ....     ",
"    . ; A +.@.t #.$.%.. 6 . &.*.. =.-.;.>..     ",
"    . / ,.'.).. . . . 6 . !.~.{.].. ^./.(..     ",
"    . / ,.@.. _.:.<.. . [.. }.|.1.2.. 3.4..     ",
"    . / 5.. _.6.7.8.9.. 0.a.. b.c.N s . d..     ",
"    . ; . e.f.g.9.h.i.. j.k.l.. T i * s . .     ",
"    . . m.n.o.p.h._.q.. Q r.s.t.. u.v.w.x.. .   ",
"    . y.z.o.A.h._.q.. B.C.D.E.F.G.. H.I.J.6 .   ",
"  . K.L.M.A.h._.q.. N.O.P.Q.R.S.T.U.. V.W.X..   ",
"  . Y.Z.`.h._.q..  +.+++@+#+$+%+&+*+=+. . .     ",
"  . -+h.;+K.q.. >+,+'+)+!+!+!+%+~+{+]+^+/+.     ",
"    . -+-+9.. (+_+:+<+[+}+|+1+2+2+3+<+4+5+.     ",
"    . . . . . . . . . . . . . . . . . . .       ",
"                                                "};


#if ! GTK_CHECK_VERSION(2,6,0)
/* XPM */
const gchar *about16_xpm[] = {
"16 16 15 1",
"   c None",
".  c #000000",
"+  c #EEF63E",
"@  c #EAF13D",
"#  c #F0F83F",
"$  c #CBD235",
"%  c #E9F03D",
"&  c #E5EC3C",
"*  c #E8F03D",
"=  c #ABB02D",
"-  c #ECF33E",
";  c #EFF73F",
">  c #CED636",
",  c #B4BA2F",
"'  c #CDD435",
"                ",
"                ",
"                ",
"                ",
"        .       ",
"       .+.      ",
"     ..@#$..    ",
"    .######%.   ",
"     .####&.    ",
"     .*###=.    ",
"     .#-.;>.    ",
"     .,. .'.    ",
"      .   .     ",
"                ",
"                ",
"                "};


/* XPM */
const gchar *about24_xpm[] = {
"24 24 15 1",
"   c None",
".  c #000000",
"+  c #EEF63E",
"@  c #EAF13D",
"#  c #F0F83F",
"$  c #C9D034",
"%  c #E9F03D",
"&  c #E5EC3C",
"*  c #E8F03D",
"=  c #A9AE2C",
"-  c #ECF33E",
";  c #EFF73F",
">  c #CED636",
",  c #B1B72E",
"'  c #CCD334",
"                        ",
"     .          .       ",
"    .+.        .+.      ",
"  ..@#$..    ..@#$..    ",
" .######%.  .######%.   ",
"  .####&.    .####&.    ",
"  .*###=.    .*###=.    ",
"  .#-.;>.    .#-.;>.    ",
"  .,. .'.    .,. .'.    ",
"   .   .      .   .     ",
"                        ",
"                        ",
"                        ",
"     .          .       ",
"    .+.        .+.      ",
"  ..@#$..    ..@#$..    ",
" .######%.  .######%.   ",
"  .####&.    .####&.    ",
"  .*###=.    .*###=.    ",
"  .#-.;>.    .#-.;>.    ",
"  .,. .'.    .,. .'.    ",
"   .   .      .   .     ",
"                        ",
"                        "};
#endif /* not GTK_CHECK_VERSION(2,6,0) */
