/*
    w32loader
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __VFW_H__
#define __VFW_H__


#include "windows.h"


G_BEGIN_DECLS


#define MAKEFOURCC(ch0,ch1,ch2,ch3)                                         \
    ((DWORD)(BYTE)(ch0)|((DWORD)(BYTE)(ch1)<<8)|                            \
    ((DWORD)(BYTE)(ch2)<<16)|((DWORD)(BYTE)(ch3)<<24))
#define mmioFOURCC(ch0,ch1,ch2,ch3) MAKEFOURCC(ch0,ch1,ch2,ch3)


typedef DWORD FOURCC;


/******************************************************************************
*                                                                             *
* en:ICM                                                                      *
*                                                                             *
******************************************************************************/
#define ICTYPE_VIDEO                mmioFOURCC('v','i','d','c')
#define ICTYPE_AUDIO                mmioFOURCC('a','u','d','c')
#define ICM_FRAMERATE               mmioFOURCC('F','r','m','R')
#define ICM_KEYFRAMERATE            mmioFOURCC('K','e','y','R')

#define ICM_USER                    (DRV_USER+0x0000)
#define ICM_RESERVED_LOW            (DRV_USER+0x1000)
#define ICM_RESERVED_HIGH           (DRV_USER+0x2000)
#define ICM_RESERVED                ICM_RESERVED_LOW

#define ICM_GETSTATE                (ICM_RESERVED+0)
#define ICM_SETSTATE                (ICM_RESERVED+1)
#define ICM_GETINFO                 (ICM_RESERVED+2)
#define ICM_CONFIGURE               (ICM_RESERVED+10)
#define ICM_ABOUT                   (ICM_RESERVED+11)
#define ICM_GETDEFAULTQUALITY       (ICM_RESERVED+30)
#define ICM_GETQUALITY              (ICM_RESERVED+31)
#define ICM_SETQUALITY              (ICM_RESERVED+32)
#define ICM_SET                     (ICM_RESERVED+40)
#define ICM_GET                     (ICM_RESERVED+41)

#define ICM_COMPRESS_GET_FORMAT     (ICM_USER+4)
#define ICM_COMPRESS_GET_SIZE       (ICM_USER+5)
#define ICM_COMPRESS_QUERY          (ICM_USER+6)
#define ICM_COMPRESS_BEGIN          (ICM_USER+7)
#define ICM_COMPRESS                (ICM_USER+8)
#define ICM_COMPRESS_END            (ICM_USER+9)
#define ICM_DECOMPRESS_GET_FORMAT   (ICM_USER+10)
#define ICM_DECOMPRESS_QUERY        (ICM_USER+11)
#define ICM_DECOMPRESS_BEGIN        (ICM_USER+12)
#define ICM_DECOMPRESS              (ICM_USER+13)
#define ICM_DECOMPRESS_END          (ICM_USER+14)
#define ICM_DECOMPRESS_SET_PALETTE  (ICM_USER+29)
#define ICM_DECOMPRESS_GET_PALETTE  (ICM_USER+30)
#define ICM_DRAW_QUERY              (ICM_USER+31)
#define ICM_DRAW_BEGIN              (ICM_USER+15)
#define ICM_DRAW_GET_PALETTE        (ICM_USER+16)
#define ICM_DRAW_START              (ICM_USER+18)
#define ICM_DRAW_STOP               (ICM_USER+19)
#define ICM_DRAW_END                (ICM_USER+21)
#define ICM_DRAW_GETTIME            (ICM_USER+32)
#define ICM_DRAW                    (ICM_USER+33)
#define ICM_DRAW_WINDOW             (ICM_USER+34)
#define ICM_DRAW_SETTIME            (ICM_USER+35)
#define ICM_DRAW_REALIZE            (ICM_USER+36)
#define ICM_DRAW_FLUSH              (ICM_USER+37)
#define ICM_DRAW_RENDERBUFFER       (ICM_USER+38)
#define ICM_DRAW_START_PLAY         (ICM_USER+39)
#define ICM_DRAW_STOP_PLAY          (ICM_USER+40)
#define ICM_DRAW_SUGGESTFORMAT      (ICM_USER+50)
#define ICM_DRAW_CHANGEPALETTE      (ICM_USER+51)
#define ICM_GETBUFFERSWANTED        (ICM_USER+41)
#define ICM_GETDEFAULTKEYFRAMERATE  (ICM_USER+42)
#define ICM_DECOMPRESSEX_BEGIN      (ICM_USER+60)
#define ICM_DECOMPRESSEX_QUERY      (ICM_USER+61)
#define ICM_DECOMPRESSEX            (ICM_USER+62)
#define ICM_DECOMPRESSEX_END        (ICM_USER+63)
#define ICM_COMPRESS_FRAMES_INFO    (ICM_USER+70)
#define ICM_SET_STATUS_PROC         (ICM_USER+72)

#define ICERR_OK                    0
#define ICERR_DONTDRAW              1
#define ICERR_NEWPALETTE            2
#define ICERR_GOTOKEYFRAME          3
#define ICERR_STOPDRAWING           4
#define ICERR_UNSUPPORTED           (-1)
#define ICERR_BADFORMAT             (-2)
#define ICERR_MEMORY                (-3)
#define ICERR_INTERNAL              (-4)
#define ICERR_BADFLAGS              (-5)
#define ICERR_BADPARAM              (-6)
#define ICERR_BADSIZE               (-7)
#define ICERR_BADHANDLE             (-8)
#define ICERR_CANTUPDATE            (-9)
#define ICERR_ABORT                 (-10)
#define ICERR_ERROR                 (-100)
#define ICERR_BADBITDEPTH           (-200)
#define ICERR_BADIMAGESIZE          (-201)
#define ICERR_CUSTOM                (-400)

#define ICCOMPRESS_KEYFRAME         0x00000001

#define ICMODE_COMPRESS             1
#define ICMODE_DECOMPRESS           2
#define ICMODE_FASTDECOMPRESS       3
#define ICMODE_QUERY                4
#define ICMODE_FASTCOMPRESS         5
#define ICMODE_DRAW                 8

#define ICQUALITY_LOW               0
#define ICQUALITY_HIGH              10000
#define ICQUALITY_DEFAULT           (-1)

#define VIDCF_QUALITY               0x0001
#define VIDCF_CRUNCH                0x0002
#define VIDCF_TEMPORAL              0x0004
#define VIDCF_COMPRESSFRAMES        0x0008
#define VIDCF_DRAW                  0x0010
#define VIDCF_FASTTEMPORALC         0x0020
#define VIDCF_FASTTEMPORALD         0x0080
#define VIDCF_QUALITYTIME           0x0040

#define ICDECOMPRESS_HURRYUP        0x80000000
#define ICDECOMPRESS_UPDATE         0x40000000
#define ICDECOMPRESS_PREROLL        0x20000000
#define ICDECOMPRESS_NULLFRAME      0x10000000
#define ICDECOMPRESS_NOTKEYFRAME    0x08000000

#define AVIIF_LIST                  0x00000001
#define AVIIF_TWOCC                 0x00000002
#define AVIIF_KEYFRAME              0x00000010
#define AVIIF_NOTIME                0x00000100
#define AVIIF_COMPUSE               0x0fff0000


#include "pshpack1.h"
typedef struct tagICOPEN
{
  DWORD   dwSize;
  DWORD   fccType;
  DWORD   fccHandler;
  DWORD   dwVersion;
  DWORD   dwFlags;
  LRESULT dwError;
  LPVOID  pV1Reserved;
  LPVOID  pV2Reserved;
  DWORD   dnDevNode;
} ICOPEN, *PICOPEN, *LPICOPEN;
typedef struct tagICINFO
{
  DWORD dwSize;
  DWORD fccType;
  DWORD fccHandler;
  DWORD dwFlags;
  DWORD dwVersion;
  DWORD dwVersionICM;
  WCHAR szName[16];
  WCHAR szDescription[128];
  WCHAR szDriver[128];
} ICINFO, *PICINFO, *LPICINFO;
typedef struct tagICCOMPRESSFRAMES
{
  DWORD              dwFlags;
  LPBITMAPINFOHEADER lpbiOutput;
  LPARAM             lOutput;
  LPBITMAPINFOHEADER lpbiInput;
  LPARAM             lInput;
  LONG               lStartFrame;
  LONG               lFrameCount;
  LONG               lQuality;
  LONG               lDataRate;
  LONG               lKeyRate;
  DWORD              dwRate;
  DWORD              dwScale;
  DWORD              dwOverheadPerFrame;
  DWORD              dwReserved2;
  LONG (CALLBACK *GetData)(LPARAM lInput,LONG lFrame,LPVOID lpBits,LONG len);
  LONG (CALLBACK *PutData)(LPARAM lOutput,LONG lFrame,LPVOID lpBits,LONG len);
} ICCOMPRESSFRAMES, *PICCOMPRESSFRAMES, *LPICCOMPRESSFRAMES;
typedef struct tagICCOMPRESS
{
  DWORD              dwFlags;
  LPBITMAPINFOHEADER lpbiOutput;
  LPVOID             lpOutput;
  LPBITMAPINFOHEADER lpbiInput;
  LPVOID             lpInput;
  LPDWORD            lpckid;
  LPDWORD            lpdwFlags;
  LONG               lFrameNum;
  DWORD              dwFrameSize;
  DWORD              dwQuality;
  LPBITMAPINFOHEADER lpbiPrev;
  LPVOID             lpPrev;
} ICCOMPRESS, *PICCOMPRESS, *LPICCOMPRESS;
typedef struct tagICDECOMPRESS
{
  DWORD              dwFlags;
  LPBITMAPINFOHEADER lpbiInput;
  LPVOID             lpInput;
  LPBITMAPINFOHEADER lpbiOutput;
  LPVOID             lpOutput;
  DWORD              ckid;
} ICDECOMPRESS, *PICDECOMPRESS, *LPICDECOMPRESS;
#include "poppack.h"


/******************************************************************************
*                                                                             *
* en:ACM                                                                      *
*                                                                             *
******************************************************************************/
#define MMSYSERR_NOERROR            0
#define MMSYSERR_NOTSUPPORTED       8


#define WAVE_FORMAT_PCM             1
#include "pshpack1.h"
typedef struct tagWAVEFILTER
{
  DWORD cbStruct;
  DWORD dwFilterTag;
  DWORD fdwFilter;
  DWORD dwReserved[5];
} WAVEFILTER, *PWAVEFILTER, *LPWAVEFILTER;
typedef struct tagWAVEFORMATEX
{
  WORD  wFormatTag;
  WORD  nChannels;
  DWORD nSamplesPerSec;
  DWORD nAvgBytesPerSec;
  WORD  nBlockAlign;
  WORD  wBitsPerSample;
  WORD  cbSize;
} WAVEFORMATEX, *PWAVEFORMATEX, *LPWAVEFORMATEX;
#include "poppack.h"


#define ACMDRIVERDETAILS_FCCTYPE_AUDIOCODEC mmioFOURCC('a', 'u', 'd', 'c')
#define ACMDRIVERDETAILS_FCCCOMP_UNDEFINED  mmioFOURCC('\0', '\0', '\0', '\0')

#define ACMDM_USER                  (DRV_USER+0x0000)
#define ACMDM_RESERVED_LOW          (DRV_USER+0x2000)
#define ACMDM_RESERVED_HIGH         (DRV_USER+0x2fff)

#define ACMDM_BASE                  ACMDM_RESERVED_LOW

#define ACMDM_DRIVER_ABOUT          (ACMDM_BASE+11)

#define ACMDRIVERDETAILS_SUPPORTF_CODEC     0x00000001
#define ACMDRIVERDETAILS_SUPPORTF_CONVERTER 0x00000002
#define ACMDRIVERDETAILS_SUPPORTF_FILTER    0x00000004
#define ACMDRIVERDETAILS_SUPPORTF_HARDWARE  0x00000008
#define ACMDRIVERDETAILS_SUPPORTF_ASYNC     0x00000010
#define ACMDRIVERDETAILS_SUPPORTF_LOCAL     0x40000000
#define ACMDRIVERDETAILS_SUPPORTF_DISABLED  0x80000000

#define ACM_FORMATTAGDETAILSF_INDEX         0x00000000
#define ACM_FORMATTAGDETAILSF_FORMATTAG     0x00000001
#define ACM_FORMATTAGDETAILSF_LARGESTSIZE   0x00000002
#define ACM_FORMATTAGDETAILSF_QUERYMASK     0x0000000f

#define ACM_FORMATDETAILSF_INDEX            0x00000000L
#define ACM_FORMATDETAILSF_FORMAT           0x00000001L
#define ACM_FORMATDETAILSF_QUERYMASK        0x0000000fL

#define ACM_FORMATSUGGESTF_WFORMATTAG       0x00010000
#define ACM_FORMATSUGGESTF_NCHANNELS        0x00020000
#define ACM_FORMATSUGGESTF_NSAMPLESPERSEC   0x00040000
#define ACM_FORMATSUGGESTF_WBITSPERSAMPLE   0x00080000
#define ACM_FORMATSUGGESTF_TYPEMASK         0x00ff0000

#define ACM_STREAMOPENF_QUERY               0x00000001
#define ACM_STREAMOPENF_ASYNC               0x00000002
#define ACM_STREAMOPENF_NONREALTIME         0x00000004

#define ACM_STREAMSIZEF_SOURCE              0x00000000
#define ACM_STREAMSIZEF_DESTINATION         0x00000001
#define ACM_STREAMSIZEF_QUERYMASK           0x0000000f

#define ACM_STREAMCONVERTF_BLOCKALIGN       0x00000004
#define ACM_STREAMCONVERTF_START            0x00000010
#define ACM_STREAMCONVERTF_END              0x00000020

#define ACMSTREAMHEADER_STATUSF_DONE     0x00010000L
#define ACMSTREAMHEADER_STATUSF_PREPARED 0x00020000L
#define ACMSTREAMHEADER_STATUSF_INQUEUE  0x00100000L


typedef LPVOID HACMSTREAM;


#include "pshpack1.h"
#define ACMDRIVERDETAILS_SHORTNAME_CHARS    32
#define ACMDRIVERDETAILS_LONGNAME_CHARS     128
#define ACMDRIVERDETAILS_COPYRIGHT_CHARS    80
#define ACMDRIVERDETAILS_LICENSING_CHARS    128
#define ACMDRIVERDETAILS_FEATURES_CHARS     512
typedef struct tagACMDRIVERDETAILSA
{
  DWORD  cbStruct;
  FOURCC fccType;
  FOURCC fccComp;
  WORD   wMid;
  WORD   wPid;
  DWORD  vdwACM;
  DWORD  vdwDriver;
  DWORD  fdwSupport;
  DWORD  cFormatTags;
  DWORD  cFilterTags;
  HICON  hicon;
  CHAR   szShortName[ACMDRIVERDETAILS_SHORTNAME_CHARS];
  CHAR   szLongName[ACMDRIVERDETAILS_LONGNAME_CHARS];
  CHAR   szCopyright[ACMDRIVERDETAILS_COPYRIGHT_CHARS];
  CHAR   szLicensing[ACMDRIVERDETAILS_LICENSING_CHARS];
  CHAR   szFeatures[ACMDRIVERDETAILS_FEATURES_CHARS];
} ACMDRIVERDETAILSA, *PACMDRIVERDETAILSA, *LPACMDRIVERDETAILSA;
typedef struct tagACMDRIVERDETAILSW
{
  DWORD  cbStruct;
  FOURCC fccType;
  FOURCC fccComp;
  WORD   wMid;
  WORD   wPid;
  DWORD  vdwACM;
  DWORD  vdwDriver;
  DWORD  fdwSupport;
  DWORD  cFormatTags;
  DWORD  cFilterTags;
  HICON  hicon;
  WCHAR  szShortName[ACMDRIVERDETAILS_SHORTNAME_CHARS];
  WCHAR  szLongName[ACMDRIVERDETAILS_LONGNAME_CHARS];
  WCHAR  szCopyright[ACMDRIVERDETAILS_COPYRIGHT_CHARS];
  WCHAR  szLicensing[ACMDRIVERDETAILS_LICENSING_CHARS];
  WCHAR  szFeatures[ACMDRIVERDETAILS_FEATURES_CHARS];
} ACMDRIVERDETAILSW, *PACMDRIVERDETAILSW, *LPACMDRIVERDETAILSW;
#ifdef UNICODE
# define ACMDRIVERDETAILS ACMDRIVERDETAILSW
# define PACMDRIVERDETAILS PACMDRIVERDETAILSW
# define LPACMDRIVERDETAILS LPACMDRIVERDETAILSW
#else /* not UNICODE */
# define ACMDRIVERDETAILS ACMDRIVERDETAILSA
# define PACMDRIVERDETAILS PACMDRIVERDETAILSA
# define LPACMDRIVERDETAILS LPACMDRIVERDETAILSA
#endif /* not UNICODE */
#define ACMFORMATTAGDETAILS_FORMATTAG_CHARS 48
typedef struct tagACMFORMATTAGDETAILSA
{
  DWORD cbStruct;
  DWORD dwFormatTagIndex;
  DWORD dwFormatTag;
  DWORD cbFormatSize;
  DWORD fdwSupport;
  DWORD cStandardFormats;
  CHAR  szFormatTag[ACMFORMATTAGDETAILS_FORMATTAG_CHARS];
} ACMFORMATTAGDETAILSA, *PACMFORMATTAGDETAILSA, *LPACMFORMATTAGDETAILSA;
typedef struct tagACMFORMATTAGDETAILSW
{
  DWORD cbStruct;
  DWORD dwFormatTagIndex;
  DWORD dwFormatTag;
  DWORD cbFormatSize;
  DWORD fdwSupport;
  DWORD cStandardFormats;
  WCHAR szFormatTag[ACMFORMATTAGDETAILS_FORMATTAG_CHARS];
} ACMFORMATTAGDETAILSW, *PACMFORMATTAGDETAILSW, *LPACMFORMATTAGDETAILSW;
#ifdef UNICODE
# define ACMFORMATTAGDETAILS ACMFORMATTAGDETAILSW
# define PACMFORMATTAGDETAILS PACMFORMATTAGDETAILSW
# define LPACMFORMATTAGDETAILS LPACMFORMATTAGDETAILSW
#else /* not UNICODE */
# define ACMFORMATTAGDETAILS ACMFORMATTAGDETAILSA
# define PACMFORMATTAGDETAILS PACMFORMATTAGDETAILSA
# define LPACMFORMATTAGDETAILS LPACMFORMATTAGDETAILSA
#endif /* not UNICODE */
#define ACMFORMATDETAILS_FORMAT_CHARS       128
typedef struct tagACMFORMATDETAILSA
{
  DWORD          cbStruct;
  DWORD          dwFormatIndex;
  DWORD          dwFormatTag;
  DWORD          fdwSupport;
  LPWAVEFORMATEX pwfx;
  DWORD          cbwfx;
  CHAR           szFormat[ACMFORMATDETAILS_FORMAT_CHARS];
} ACMFORMATDETAILSA, *PACMFORMATDETAILSA, *LPACMFORMATDETAILSA;
typedef struct tagACMFORMATDETAILSW
{
  DWORD          cbStruct;
  DWORD          dwFormatIndex;
  DWORD          dwFormatTag;
  DWORD          fdwSupport;
  LPWAVEFORMATEX pwfx;
  DWORD          cbwfx;
  WCHAR          szFormat[ACMFORMATDETAILS_FORMAT_CHARS];
} ACMFORMATDETAILSW, *PACMFORMATDETAILSW, *LPACMFORMATDETAILSW;
#ifdef UNICODE
# define ACMFORMATDETAILS ACMFORMATDETAILSW
# define PACMFORMATDETAILS PACMFORMATDETAILSW
# define LPACMFORMATDETAILS LPACMFORMATDETAILSW
#else /* not UNICODE */
# define ACMFORMATDETAILS ACMFORMATDETAILSA
# define PACMFORMATDETAILS PACMFORMATDETAILSA
# define LPACMFORMATDETAILS LPACMFORMATDETAILSA
#endif /* not UNICODE */

#include "poppack.h"


G_END_DECLS


#endif /* __VFW_H__ */
