/*
    w32loader
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __TCHAR_H__
#define __TCHAR_H__


#include "windef.h"


G_BEGIN_DECLS


/* ja:基本 */
#ifdef UNICODE
# define _TEXT(x) L ## x
# define _T(utf8str) w32ldr_tchar_to_wc(utf8str)
typedef WCHAR  TCHAR,  *TPCHAR,  *TLPCHAR,  *TCHAR_PTR;
typedef WUCHAR TUCHAR, *TPUCHAR, *TLPUCHAR, *TUCHAR_PTR;
#else /* not UNICODE */
# define _TEXT(x) x
# define _T(utf8str) w32ldr_tchar_to_mb(utf8str)
typedef CHAR   TCHAR,  *TPCHAR,  *TLPCHAR,  *TCHAR_PTR;
typedef UCHAR  TUCHAR, *TPUCHAR, *TLPUCHAR, *TUCHAR_PTR;
#endif /* not UNICODE */
# define TEXT(x) _TEXT(x)
# define T(x) _T(x)
/* ja:文字列 */
typedef TCHAR          *PTSTR,   *LPTSTR;
typedef CONST TCHAR    *PCTSTR,  *LPCTSTR;


/*  ja:ソースコード文字列をMultiByteに変換する
    str,ソースコード文字列
    RET,MultiByte                                                           */
gchar *
w32ldr_tchar_to_mb (gchar *str);


/*  ja:ソースコード文字列をUTF-16に変換する
    str,ソースコード文字列
    RET,UTF-16                                                              */
gunichar2 *
w32ldr_tchar_to_wc (gchar *str);


G_END_DECLS


#endif /* __TCHAR_H__ */
