/*
    w32loader
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __GDI32_H__
#define __GDI32_H__


#include "w32ldr.h"


G_BEGIN_DECLS


#define RGB(r,g,b) ((COLORREF)((BYTE)(r)|((BYTE)(g)<<8)|((BYTE)(b)<<16)))
#define GetRValue(rgb) ((BYTE)(rgb))
#define GetGValue(rgb) ((BYTE)((rgb)>>8))
#define GetBValue(rgb) ((BYTE)((rgb)>>16))
#define TRANSPARENT 1
#define OPAQUE      2
typedef LPVOID HGDIOBJ;
typedef DWORD COLORREF, *PCOLORREF, *LPCOLORREF;
#include <pshpack1.h>
typedef struct _SIZE
{
  LONG cx;
  LONG cy;
} SIZE, *PSIZE, *LPSIZE;
#include "poppack.h"
/* ja:ラスタオペレーションコード */
#define SRCCOPY     0xcc0020
#define SRCPAINT    0xee0086
#define SRCAND      0x8800c6
#define SRCINVERT   0x660046
#define SRCERASE    0x440328
#define NOTSRCCOPY  0x330008
#define NOTSRCERASE 0x1100a6
#define MERGECOPY   0xc000ca
#define MERGEPAINT  0xbb0226
#define PATCOPY     0xf00021
#define PATPAINT    0xfb0a09
#define PATINVERT   0x5a0049
#define DSTINVERT   0x550009
#define BLACKNESS   0x000042
#define WHITENESS   0xff0062
/* ja:ビットマップ */
#include <pshpack1.h>
typedef struct _BITMAP
{
  LONG bmType;
  LONG bmWidth;
  LONG bmHeight;
  LONG bmWidthBytes;
  WORD bmPlanes;
  WORD bmBitsPixel;
  LPVOID bmBits;
} BITMAP, *PBITMAP, *LPBITMAP;
typedef struct _PALETTEENTRY
{
  BYTE peRed;
  BYTE peGreen;
  BYTE peBlue;
  BYTE peFlags;
} PALETTEENTRY, *PPALETTEENTRY, *LPPALETTEENTRY;
#include "poppack.h"
/* ja:ブラシ */
typedef W32LdrBrush *HBRUSH;
/* ja:ペン */
typedef W32LdrPen *HPEN;
/* ja:フォント */
typedef W32LdrFont *HFONT;
#define FW_DONTCARE   0
#define FW_THIN       100
#define FW_EXTRALIGHT 200
#define FW_LIGHT      300
#define FW_NORMAL     400
#define FW_MEDIUM     500
#define FW_SEMIBOLD   600
#define FW_BOLD       700
#define FW_EXTRABOLD  800
#define FW_HEAVY      900
#define ANSI_CHARSET        0
#define DEFAULT_CHARSET     1
#define SYMBOL_CHARSET      2
#define SHIFTJIS_CHARSET    128
#define HANGEUL_CHARSET     129
#define GB2312_CHARSET      134
#define CHINESEBIG5_CHARSET 136
#define GREEK_CHARSET       161
#define TURKISH_CHARSET     162
#define HEBREW_CHARSET      177
#define ARABIC_CHARSET      178
#define BALTIC_CHARSET      186
#define RUSSIAN_CHARSET     204
#define EASTEUROPE_CHARSET  238
#define THAI_CHARSET        222
#define JOHAB_CHARSET       130
#define MAC_CHARSET         77
#define OEM_CHARSET         255
#define OUT_DEFAULT_PRECIS   0
#define OUT_STRING_PRECIS    1
#define OUT_CHARACTER_PRECIS 2
#define OUT_STROKE_PRECIS    3
#define OUT_TT_PRECIS        4
#define OUT_DEVICE_PRECIS    5
#define OUT_RASTER_PRECIS    6
#define OUT_TT_ONLY_PRECIS   7
#define OUT_OUTLINE_PRECIS   8
#define CLIP_DEFAULT_PRECIS   0x00
#define CLIP_CHARACTER_PRECIS 0x01
#define CLIP_STROKE_PRECIS    0x02
#define CLIP_MASK             0x0f
#define CLIP_LH_ANGLES        0x10
#define CLIP_TT_ALWAYS        0x20
#define CLIP_EMBEDDED         0x80
#define DEFAULT_QUALITY 0
#define DRAFT_QUALITY   1
#define PROOF_QUALITY   2
#define DEFAULT_PITCH  0x00
#define FIXED_PITCH    0x01
#define VARIABLE_PITCH 0x02
#define FF_DONTCARE   0x00
#define FF_ROMAN      0x10
#define FF_SWISS      0x20
#define FF_MODERN     0x30
#define FF_SCRIPT     0x40
#define FF_DECORATIVE 0x50
#define LF_FACESIZE 32
#include <pshpack1.h>
typedef struct _LOGFONTA
{
  LONG lfHeight;
  LONG lfWidth;
  LONG lfEscapement;
  LONG lfOrientation;
  LONG lfWeight;
  BYTE lfItalic;
  BYTE lfUnderline;
  BYTE lfStrikeOut;
  BYTE lfCharSet;
  BYTE lfOutPrecision;
  BYTE lfClipPrecision;
  BYTE lfQuality;
  BYTE lfPitchAndFamily;
  CHAR lfFaceName[LF_FACESIZE];
} LOGFONTA, *PLOGFONTA, *LPLOGFONTA;
typedef struct _LOGFONTW
{
  LONG lfHeight;
  LONG lfWidth;
  LONG lfEscapement;
  LONG lfOrientation;
  LONG lfWeight;
  BYTE lfItalic;
  BYTE lfUnderline;
  BYTE lfStrikeOut;
  BYTE lfCharSet;
  BYTE lfOutPrecision;
  BYTE lfClipPrecision;
  BYTE lfQuality;
  BYTE lfPitchAndFamily;
  WCHAR lfFaceName[LF_FACESIZE];
} LOGFONTW, *PLOGFONTW, *LPLOGFONTW;
#include "poppack.h"
#ifdef UNICODE
# define LOGFONT LOGFONTW
# define PLOGFONT PLOGFONTW
# define LPLOGFONT LPLOGFONTW
#else /* not UNICODE */
# define LOGFONT LOGFONTA
# define PLOGFONT PLOGFONTA
# define LPLOGFONT LPLOGFONTA
#endif /* not UNICODE */


extern W32LdrExport gdi32_exports[];


BOOL WINAPI BitBlt (HDC hdcDest, INT nXDest, INT nYDest, INT nWidth, INT nHeight, HDC hdcSrc, INT nXSrc, INT nYSrc, DWORD dwRop);
HDC WINAPI CreateCompatibleDC (HDC hDC);
HFONT WINAPI CreateFontA (INT nHeight, INT nWidth, INT nEscapement, INT nOrientation, INT nWeight, DWORD dwItalic, DWORD dwUnderline, DWORD dwStrikeOut, DWORD dwCharSet, DWORD dwOutPrecision, DWORD dwClipPrecision, DWORD dwQuality, DWORD dwPitchAndFamily, LPCSTR lpszFaceName);
HFONT WINAPI CreateFontIndirectA (CONST LOGFONTA *lplf);
HFONT WINAPI CreateFontIndirectW (CONST LOGFONTW *lplf);
HFONT WINAPI CreateFontW (INT nHeight, INT nWidth, INT nEscapement, INT nOrientation, INT nWeight, DWORD dwItalic, DWORD dwUnderline, DWORD dwStrikeOut, DWORD dwCharSet, DWORD dwOutPrecision, DWORD dwClipPrecision, DWORD dwQuality, DWORD dwPitchAndFamily, LPCWSTR lpszFaceName);
HBRUSH WINAPI CreateSolidBrush (COLORREF crColor);
BOOL WINAPI DeleteDC (HDC hDC);
BOOL WINAPI DeleteObject (HGDIOBJ hObject);
COLORREF WINAPI GetBkColor (HDC hDC);
INT WINAPI GetBkMode (HDC hDC);
INT WINAPI GetDeviceCaps (HDC hDC, INT nIndex);
COLORREF WINAPI GetNearestColor (HDC hDC, COLORREF crColor);
INT WINAPI GetObjectA (HGDIOBJ hObject, INT cbBuffer, LPVOID lpvObject);
INT WINAPI GetObjectW (HGDIOBJ hObject, INT cbBuffer, LPVOID lpvObject);
UINT WINAPI GetSystemPaletteEntries (HDC hDC, UINT iStartIndex, UINT nEntries, LPPALETTEENTRY lppe);
COLORREF WINAPI GetTextColor (HDC hDC);
BOOL WINAPI GetTextExtentPoint32A (HDC hDC, LPCSTR lpString, INT cbString, LPSIZE lpSize);
BOOL WINAPI GetTextExtentPoint32W (HDC hDC, LPCWSTR lpString, INT cbString, LPSIZE lpSize);
HGDIOBJ WINAPI SelectObject (HDC hDC, HGDIOBJ hObject);
COLORREF WINAPI SetBkColor (HDC hDC, COLORREF crColor);
INT WINAPI SetBkMode (HDC hDC, INT iBkMode);
COLORREF WINAPI SetTextColor (HDC hDC, COLORREF crColor);
BOOL WINAPI TextOutA (HDC hDC, INT nXStart, INT nYStart, LPCSTR lpString, INT cbString);
BOOL WINAPI TextOutW (HDC hDC, INT nXStart, INT nYStart, LPCWSTR lpString, INT cbString);


#ifdef UNICODE
# define CreateFont CreateFontW
# define CreateFontIndirect CreateFontIndirectW
# define GetObject GetObjectW
# define GetTextExtentPoint32 GetTextExtentPoint32W
# define TextOut TextOutW
#else /* not UNICODE*/
# define CreateFont CreateFontA
# define CreateFontIndirect CreateFontIndirectA
# define GetObject GetObjectA
# define GetTextExtentPoint32 GetTextExtentPoint32A
# define TextOut TextOutA
#endif /* not UNICODE */


G_END_DECLS


#endif /* __GDI32_H__ */
