/*
    Video maid
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __SIZE_H__
#define __SIZE_H__


#include "vmaid.h"


G_BEGIN_DECLS


typedef struct _SizeConfig
{
  gboolean ratio;           /* ja:TRUE:比率を保持する,FALSE:比率を保持しない */
  gint view, width, height, def_width, def_height;
} SizeConfig;


/******************************************************************************
*                                                                             *
* ja:サイズ変更関数群                                                         *
*                                                                             *
******************************************************************************/
/*  ja:フレームサイズの設定
          view,設定値
         width,幅
        height,高さ
     def_width,デフォルトの幅
    def_height,デフォルトの高さ                                             */
void
size_set_scale (const gint  view,
                gint       *width,
                gint       *height,
                const gint  def_width,
                const gint  def_height);


/******************************************************************************
*                                                                             *
* ja:サイズ変更ダイアログ関数群                                               *
*                                                                             *
******************************************************************************/
/*  ja:サイズ変更ダイアログ表示
    sizecfg,サイズ変更構造体
        RET,TRUE:OK,FALSE:Cancel                                            */
gboolean
size_dialog (SizeConfig *sizecfg);


G_END_DECLS


#endif /* __SIZE_H__ */
