/*
    Video maid
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "codec.h"
#include "avicore/acm.h"
#include "avicore/icm.h"
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* ja:Codec関数群                                                              *
*                                                                             *
******************************************************************************/
/* ja:ツリービュー変更 */
static void
codec_dialog_changed (GtkTreeSelection *select,
                      GtkWidget        *button)
{
  GtkTreeIter iter;
  GtkTreeModel *model;
  IcmObject *icm_object = NULL;
  AcmObject *acm_object = NULL;

  if (gtk_tree_selection_get_selected (select, &model, &iter))
    gtk_tree_model_get (model, &iter, 3, &icm_object, 4, &acm_object, -1);
  gtk_widget_set_sensitive (button, icm_object || acm_object);
}


/* ja:ツリービュー破棄 */
static void
codec_dialog_row_deleted (GtkTreeModel *model,
                          GtkTreePath  *path,
                          gpointer      user_data)
{
  GtkTreeIter iter;
  IcmObject *icm_object;
  AcmObject *acm_object;

  gtk_tree_model_get_iter (model, &iter, path);
  gtk_tree_model_get (model, &iter, 3, &icm_object, 4, &acm_object, -1);
  if (icm_object)
    icm_close (icm_object);
  if (acm_object)
    acm_close (acm_object);
}


/* ja:設定ボタンが押された */
static void
codec_dialog_clicked (GtkWidget        *widget,
                      GtkTreeSelection *select)
{
  GtkTreeIter iter;
  GtkTreeModel *model;

  if (gtk_tree_selection_get_selected (select, &model, &iter))
    {
      IcmObject *icm_object;
      AcmObject *acm_object;

      gtk_tree_model_get (model, &iter, 3, &icm_object, 4, &acm_object, -1);
      if (icm_object)
        icm_dialog_preference (icm_object, gtk_widget_get_toplevel (widget));
      else if (acm_object)
        acm_dialog_preference (acm_object, gtk_widget_get_toplevel (widget));
    }
}


/* ja:ダブルクリックされたとき */
static gboolean
codec_dialog_button_press (GtkWidget      *widget,
                           GdkEventButton *event,
                           GtkWidget      *button)
{
  gboolean result = FALSE;

  if (event->type == GDK_2BUTTON_PRESS && event->button == 1)
    {
      GtkTreePath *path;

      if (gtk_tree_view_get_path_at_pos (GTK_TREE_VIEW (widget),
                    (gint)event->x, (gint)event->y, &path, NULL, NULL, NULL))
        {
          GtkTreeIter iter;

          if (gtk_tree_model_get_iter (gtk_tree_view_get_model
                                        (GTK_TREE_VIEW (widget)), &iter, path))
            {
              gtk_button_clicked (GTK_BUTTON (button));
              result = TRUE;
            }
          gtk_tree_path_free (path);
        }
    }
  return result;
}


void
codec_dialog (void)
{
  gint i;
  GList *glist;
  GtkTreeIter iter_parent;
  GtkTreeSelection *select;
  GtkTreeStore *store;
  GtkTreeViewColumn *column;
  GtkWidget *dialog, *button, *tview, *scroll, *hbox, *vbox;
  const static gchar *str[3] = {N_("Name"), N_("Code"), N_("Attribute")};

  /* ja:メインウインドウ */
  dialog = gtk_dialog_new_with_buttons
                            (_("Codec"),
                            GTK_WINDOW (window),
                            GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                            GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE,
                            NULL);
  gtk_dialog_set_default_response (GTK_DIALOG (dialog), GTK_RESPONSE_CLOSE);
  gtk_window_set_default_size (GTK_WINDOW (dialog),
                    gdk_screen_width () * 2 / 3, gdk_screen_height () * 2 / 3);
  g_signal_connect (G_OBJECT (dialog), "key-press-event",
                                    G_CALLBACK (misc_dialog_key_press), NULL);

  /* ja:プラグイン */
  /* ja:ボタン */
  button = gtk_button_new_from_stock (GTK_STOCK_PREFERENCES);
  /* ja:ツリービュー */
  store = gtk_tree_store_new (5, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
                                            G_TYPE_POINTER, G_TYPE_POINTER);
  gtk_tree_store_append (store, &iter_parent, NULL);
  gtk_tree_store_set (store, &iter_parent,  0, _("Video Compressor"),
                                            1, NULL,
                                            2, NULL,
                                            3, NULL,
                                            4, NULL,
                                            -1);
  glist = icm_get_handler_list ();
  if (glist)
    {
      gint length;

      length = g_list_length (glist);
      for (i = 0; i < length; i++)
        {
          IcmObject *icm_object;

          icm_object = icm_open (GPOINTER_TO_UINT (g_list_nth_data (glist, i)),
                                                            ICM_MODE_QUERY);
          if (icm_object)
            {
              gchar *handler;
              const gchar *name, *attribute;

              name = icm_get_name (icm_object);
              handler = icm_handler_to_string (icm_get_handler (icm_object));
              switch (icm_get_attribute (icm_object))
                {
                  case ICM_ATTR_NATIVE:
                    attribute = _("Video maid Native");
                    break;
                  case ICM_ATTR_WIN32:
#ifdef G_OS_WIN32
                    attribute = _("Win32 Native");
#else /* not G_OS_WIN32 */
                    attribute = _("Win32 Emulation");
#endif /* not G_OS_WIN32 */
                    break;
                  default:
                    attribute = _("Unknown");
                }
              if (name && handler)
                {
                  GtkTreeIter iter;

                  gtk_tree_store_append (store, &iter, &iter_parent);
                  gtk_tree_store_set (store, &iter, 0, name,
                                                    1, handler,
                                                    2, attribute,
                                                    3, NULL,
                                                    4, NULL,
                                                    -1);
                  if (icm_is_dialog_preference (icm_object))
                    {
                      gtk_tree_store_set (store, &iter, 3, icm_object, -1);
                      icm_object = NULL;
                    }
                }
              g_free (handler);
              if (icm_object)
                icm_close (icm_object);
            }
        }
      g_list_free (glist);
    }
  gtk_tree_store_append (store, &iter_parent, NULL);
  gtk_tree_store_set (store, &iter_parent,  0, _("Audio Compressor"),
                                            1, NULL,
                                            2, NULL,
                                            3, NULL,
                                            4, NULL,
                                            -1);
  glist = acm_get_tag_list ();
  if (glist)
    {
      gint length;

      length = g_list_length (glist);
      for (i = 0; i < length; i++)
        {
          AcmObject *acm_object;

          acm_object = acm_open
                    ((guint16)GPOINTER_TO_UINT (g_list_nth_data (glist, i)));
          if (acm_object)
            {
              gchar *handler;
              const gchar *name, *attribute;

              name = acm_get_name (acm_object);
              handler = g_strdup_printf ("%04X", acm_get_tag (acm_object));
              switch (acm_get_attribute (acm_object))
                {
                  case ACM_ATTR_NATIVE:
                    attribute = _("Video maid Native");
                    break;
                  case ACM_ATTR_WIN32:
#ifdef G_OS_WIN32
                    attribute = _("Win32 Native");
#else /* not G_OS_WIN32 */
                    attribute = _("Win32 Emulation");
#endif /* not G_OS_WIN32 */
                    break;
                  default:
                    attribute = _("Unknown");
                }
              if (name && handler)
                {
                  GtkTreeIter iter;

                  gtk_tree_store_append (store, &iter, &iter_parent);
                  gtk_tree_store_set (store, &iter, 0, name,
                                                    1, handler,
                                                    2, attribute,
                                                    3, NULL,
                                                    4, NULL,
                                                    -1);
                  if (acm_is_dialog_preference (acm_object))
                    {
                      gtk_tree_store_set (store, &iter, 4, acm_object, -1);
                      acm_object = NULL;
                    }
                }
              g_free (handler);
              if (acm_object)
                acm_close (acm_object);
            }
        }
      g_list_free (glist);
    }
  tview = gtk_tree_view_new_with_model (GTK_TREE_MODEL (store));
  gtk_tree_view_set_enable_search (GTK_TREE_VIEW (tview), FALSE);
  str[0] = _("Name");
  str[1] = _("Code");
  str[2] = _("Attribute");
  for (i = 0; i < 3; i++)
    {
      column = gtk_tree_view_column_new_with_attributes (str[i],
                            gtk_cell_renderer_text_new (), "text", i, NULL);
      gtk_tree_view_column_set_resizable (column, TRUE);
      gtk_tree_view_append_column (GTK_TREE_VIEW (tview), column);
    }
  select = gtk_tree_view_get_selection (GTK_TREE_VIEW (tview));
  gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
  g_signal_connect (G_OBJECT (select), "changed",
                            G_CALLBACK (codec_dialog_changed), button);
  g_signal_connect (G_OBJECT (store), "row-deleted",
                            G_CALLBACK (codec_dialog_row_deleted), NULL);
  g_signal_connect (G_OBJECT (tview), "button-press-event",
                            G_CALLBACK (codec_dialog_button_press), button);
  gtk_widget_add_events (tview, GDK_BUTTON_PRESS_MASK);
  g_object_unref (G_OBJECT (store));
  /* ja:スクロールウインドウ */
  scroll = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll),
                                GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_container_add (GTK_CONTAINER (scroll), tview);
  /* ja:ボタン */
  g_signal_connect (G_OBJECT (button), "clicked",
                                    G_CALLBACK (codec_dialog_clicked), select);
  gtk_widget_set_sensitive (button, FALSE);
  /* ja:フレームとボックス */
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  gtk_box_set_spacing (GTK_BOX (vbox), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox), scroll, TRUE, TRUE, 0);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), button, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), vbox);

  /* ja:表示 */
  gtk_widget_show_all (vbox);

  gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
}
