/*
    avicore
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __AVI_PLAY_H__
#define __AVI_PLAY_H__


#include "avicore.h"


G_BEGIN_DECLS


#define AVI_TYPE_PLAY            (avi_play_get_type ())
#define AVI_PLAY(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), AVI_TYPE_PLAY, AviPlay))
#define AVI_PLAY_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), AVI_TYPE_PLAY, AviPlayClass))
#define AVI_IS_PLAY(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AVI_TYPE_PLAY))
#define AVI_IS_PLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AVI_TYPE_PLAY))
#define AVI_PLAY_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), AVI_TYPE_PLAY, AviPlayClass))


typedef struct _AviPlay      AviPlay;
typedef struct _AviPlayClass AviPlayClass;


#if defined (G_OS_WIN32) && defined (USE_LIBAO)
# undef USE_LIBAO
#endif /* defined (G_OS_WIN32) && defined (USE_LIBAO) */
#if (defined (G_OS_WIN32) || defined (USE_LIBAO)) && defined (USE_ALSA)
# undef USE_ALSA
#endif /* (defined (G_OS_WIN32) || defined (USE_LIBAO)) && defined (USE_ALSA) */
#if defined (G_OS_WIN32) || defined (USE_LIBAO) || defined (USE_ALSA)
# define AVI_PCM_BUFFER_NUM 4
#endif /* defined (G_OS_WIN32) || defined (USE_LIBAO) || defined (USE_ALSA) */
struct _AviPlay
{
  /*< private >*/
  GtkVBox parent_instance;

  gboolean shrink;              /* ja:TRUE:小さくなる,FALSE:小さくならない */
  gboolean panel;               /* ja:TRUE:パネル表示,TRUE:パネル非表示 */
  gboolean playing;
  gboolean gap;
  gint length;                  /* ja:長さ */
  gint position;                /* ja:現在の位置 */
  gint pos;                     /* ja:オーディオの再生位置 */
  gint start;                   /* ja:再生をはじめた位置 */
  guint timer_id;
  guint16 block_align;
  guint32 rate, scale;
  GdkColor color;
  GtkWidget *drawing;
  GtkWidget *play_button;       /* ja:再生 */
  GtkWidget *stop_button;       /* ja:停止 */
  GtkWidget *previous_button;   /* ja:先頭 */
  GtkWidget *rewind_button;     /* ja:前 */
  GtkWidget *forward_button;    /* ja:次 */
  GtkWidget *next_button;       /* ja:最後 */
  GtkWidget *hscale;
  GtkWidget *label;
  GtkWidget *hbox;
  AviEdit *avi_edit[2];         /* ja:AVI編集構造体 */
  AviFrame *avi_frame;
  AviPcm *avi_pcm;
#ifdef USE_LIBAO
  int driver_id;
#endif /* USE_LIBAO */
#ifdef USE_ALSA
  gchar *err;
#endif /* USE_ALSA */
#if defined (USE_LIBAO) || defined (USE_ALSA)
  GThread *thread;
#endif /* defined (USE_LIBAO) || defined (USE_ALSA) */
#ifdef G_OS_WIN32
  DWORD dwTime;
  HWND hWnd;
  HWAVEOUT hWaveOut;
  WAVEHDR whrOut[AVI_PCM_BUFFER_NUM];
#else /* not G_OS_WIN32 */
  GTimer *gtimer;
#endif /* not G_OS_WIN32 */
};

struct _AviPlayClass
{
  GtkVBoxClass parent_class;

  /* -- signals -- */
  void (*status) (AviPlay *play);
};


/******************************************************************************
*                                                                             *
******************************************************************************/
GType
avi_play_get_type (void) G_GNUC_CONST;


/******************************************************************************
*                                                                             *
* ja:ダイアログ関数                                                           *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    RET,ウィジェット                                                        */
GtkWidget *
avi_play_new (void);


/*  ja:パネルを表示する
    play,ウィジェット                                                       */
void
avi_play_show_panel (AviPlay *play);


/*  ja:パネルを表示しない
    play,ウィジェット                                                       */
void
avi_play_hide_panel (AviPlay *play);


/*  ja:ウィジェットの縮小を取得する
    play,ウィジェット
     RET,TRUE:小さくなる,FALSE:小さくならない                               */
gboolean
avi_play_get_shrink (AviPlay *play);


/*  ja:ウィジェットの縮小を設定する
      play,ウィジェット
    shrink,TRUE:小さくなる,FALSE:小さくならない                             */
void
avi_play_set_shrink (AviPlay        *play,
                     const gboolean  shrink);


/*  ja:AVI編集ハンドルを設定する
        play,ウィジェット
    avi_edit,AVI編集ハンドル,NULL:設定なし                                  */
void
avi_play_set_handle (AviPlay  *play,
                     AviEdit **avi_edit);


/*  ja:AVIの長さを取得する
    play,ウィジェット
     RET,長さ                                                               */
gint
avi_play_get_length (AviPlay *play);


/*  ja:AVIを再生する
    play,ウィジェット
     RET,TRUE:正常終了,FALSE:エラー                                         */
void
avi_play_play (AviPlay *play);


/*  ja:AVIを停止する
    play,ウィジェット
     RET,TRUE:正常終了,FALSE:エラー                                         */
void
avi_play_stop (AviPlay *play);


/*  ja:AVIの状態を取得する
    play,ウィジェット
     RET,TRUE:再生中,FALSE:停止                                             */
gboolean
avi_play_is_playing (AviPlay *play);


/*  ja:AVIの位置を取得する
    play,ウィジェット
     RET,位置                                                               */
gint
avi_play_get_position (AviPlay *play);


/*  ja:AVIの位置を設定する
        play,ウィジェット
    position,位置(-1:最後)
         RET,TRUE:正常終了,FALSE:エラー                                     */
gboolean
avi_play_set_position (AviPlay    *play,
                       const gint  position);


G_END_DECLS


#endif /* __AVI_PLAY_H__ */
