#  Created by frsyuki on 2007-03-13.
#  Copyright (c) 2007. All rights reserved.


class InvalidParameterError < RuntimeError
	def initialize(param, msg = "Invalid parameter")
		@param = param
		@msg = msg
	end
	def to_s
		return "#{@msg}: #{@param}"
	end
end


class BootParameter
	VIVER_PARAMETER_NS = "VIVER"
	GLOBAL_NS = "GLOBAL"
	DEFAULT_VIVERCONF_FILE_NAME = "viver.conf"
	VIVERCONF_RELATIVE_DIR = ["", "etc", "viver", "VIVER"]

	def initialize
		@entries = Hash.new
	end

	def parse(path, rewrite = false)
		if !rewrite && !@entries.empty?
			return
		end
		$log.debug "loading #{path}"
		File.open(path) {|file|
			last_ns = GLOBAL_NS

			# XXX: fileがからだとgetsの返り値はnil
			file.gets.split(" ").each {|cmd|
				if cmd =~ /\:$/
					# 最後が: (名前空間指定)
					last_ns = cmd[0, cmd.length - 1]
				else
					key, val = cmd.split("=", 2)
					if val === nil; val = ""; end
					@entries[ [last_ns, key] ] = val
					$log.debug "parameter: #{last_ns}::#{key} = #{val}"
				end
			}

		}
	end

	def set?(key)
		return ( @entries.key?([GLOBAL_NS, key]) || @entries.key?([VIVER_PARAMETER_NS, key]) )
	end

	def getValue(key, default)
		val = @entries[ [VIVER_PARAMETER_NS, key] ] || @entries[ [GLOBAL_NS, key] ]
		if val === nil
			return default
		else
			return val
		end
	end

	def getValueBool(key, default)
		val = @entries[ [VIVER_PARAMETER_NS, key] ] || @entries[ [GLOBAL_NS, key] ]
		if val === nil
			return default
		elsif val.downcase =~ /false|no|n|off|0/
			return false
		else
			return true
		end
	end


	def getFileAndHints(key, default_file, default_hints)
		# key=file
		# key=:hint,hint
		# key=file:hint,hint,hint
		# key=hint,hint

		if (line = getValue(key, nil)) == nil
			return default_file, default_hints
		end

		file, hints = line.split(":", 2)

		if file.include?(",") && hints == nil
			# key=hint,hint
			hints = file
			file = default_file
		elsif (file === nil || file.empty?)
			# key=:hint,hint
			file = default_file
		end

		if hints === nil
			return file, default_hints
		else
			return file, hints.split(",")
		end
	end


	def loadViverConfFile(path)
		$log.info "loading VIVER configuration file: #{path}"
		# XXX: 暫定: loadViverConfFile
		begin
			parse(path, true)
			$log.success "VIVER configurration file #{path} loaded."
		rescue
			$log.warn $!
		end
	end
	private :loadViverConfFile

	def loadViverConf(disks)
		file_name = getValue("viverconf", DEFAULT_VIVERCONF_FILE_NAME)

		rdirs = Array.new
		if set?("viverconfdir")
			rdirs = getValue("viverconfdir", "").split(",")
		else
			rdirs = VIVERCONF_RELATIVE_DIR
		end

		rdirs.each {|p|
			relative = "/#{p}/#{file_name}"
			volumes = disks.getAllVolume(relative)
			volumes.each {|v|
				loadViverConfFile(v.point + relative)
			}
		}
	end

	def loadUserShellParameter(path)
		$log.info "loading shell parameters: #{path}"
		# XXX: 暫定: loadUserShellParameter
		begin
			parse(path, true)
			$log.success "VIVER configurration file #{path} loaded."
		rescue
			$log.debugError $!
		end
	end

	def outputToFile(path)
=begin
		# RUNES 0.3 互換フォーマット
		File.open(path, "w") {|file|
			file << "#!/bin/sh\n"
			@entries.each {|k, v|
				file << "param_#{k[0]}_#{k[1]}=\"#{v}\"\n"
			}

			file << "system_MP_ARK=\"#{arkfs.point}\"\n"
		}
=end
		# XXX: 未実装: パラメータの書き出し
	end
end


$log.debug "#{File.basename(__FILE__, ".*")} loaded"
