require "log"


class DynamicPath
	def initialize(mp = nil, pr = "")
		@mp = mp
		@pr = pr
	end

	def +(other)
		return DynamicPath.new(self, other)
	end

	def to_s
		return (@mp.to_s + @pr.to_s).squeeze("/")
	end
	alias :to_str :to_s

	def inspect
		return "(#{@mp.inspect}, #{@pr.inspect})"
	end

	def move(mp)
		@mp = mp
		@pr = ""
	end
end


$log.debug "#{File.basename(__FILE__, ".*")} loaded"

