require "log"
require "fallback"

class BreakPoint
	def initialize
		@points = Hash.new
	end
	def setParameter
		line = $param.getValue("breakpoint", "")
		@points = line.split(",")
	end
	def breakpoint(point)
		$log.debug "break point \"#{point}\""
		if @points.include?(point)
			$log.error "Entring debug shell"
			Fallback.invokeShell
		end
	end
	def key?(point)
		return @points.include?(point)
	end
end


$log.debug "#{File.basename(__FILE__, ".*")} loaded"
