#ifndef VFIELD_VTABLE_H__
#define VFIELD_VTABLE_H__

#include "node.h"
#include "datarange.h"
#include "exception.h"
#include <netinet/in.h>
#include <vector>
#include <deque>
#include <boost/thread.hpp>
#include <boost/scoped_ptr.hpp>

namespace VFIELD {


////
// VTable
//
// findとcalcDuplex以外の処理は長くブロックする可能性があるので、ThreadPoolを使うこと
class RPCClient;
class DuplexRange;
class VTableMatch;
class VTableIMPL;
class StreamManager;
class AutoSock;
class StrippedNodeIdentity;
class VTable {
public:
	explicit VTable(RPCClient& rpcc);
	~VTable();
public:
	//XXX typedef std::deque<VTableMatch>  matches_type;		// sorted by CompareStartGreater
	//XXX typedef std::vector<VTableMatch>  matches_type;		// sorted by StartLessIfSameEndLess
	typedef std::vector<VTableMatch>  matches_type;		// sorted by CompareStartLess
	typedef std::vector<DuplexRange> duplex_type;		// not sorted
	void find(const DataRange& range, matches_type& result_nodes) const;
	void calcDuplex(pos_type image_size, duplex_type& result) const;
public:
	void strippedNodeDownDetect(const StrippedNodeIdentity& down_node);
public:  // 応答処理
	void rpcNotifyUp(const NodeIdentity& up_node, const DataRange& up_range);
	void rpcNotifyDown(const NodeIdentity& down_node, StreamManager& smgr);
	void rpcPing(const NodeIdentity& up_node);
public:
	void setImageSize(pos_type size);
	void streamJoin(AutoSock& asock, uint16_t image_id, uint64_t image_size);
public:
	boost::scoped_ptr<VTableIMPL> impl;
private:
	VTable();
};


////
// VTableMatch
//
class VTableMatch {
public:
	VTableMatch(const std::pair<DataRange, NodeIdentity>& inserter);
	void operator= (const std::pair<DataRange, NodeIdentity>& inserter);
	~VTableMatch();
public:
	inline const DataRange&    range(void) const { return m_range; }
	inline const NodeIdentity& node(void)  const { return m_node;  }
private:
	DataRange m_range;
	NodeIdentity m_node;
};

class DuplexRange : public DataRange {
public:
	typedef unsigned short duplex_type;
	DuplexRange(pos_type start, pos_type end, duplex_type duplex);
	~DuplexRange() throw();
public:
	unsigned short duplex(void) const { return m_duplex; }
friend std::ostream& operator << (std::ostream& stream, const DuplexRange& rhl)
	{ return stream << rhl.m_duplex << ": " << static_cast<DataRange>(rhl); }
private:
	duplex_type m_duplex;
};


struct MatchesNoOverlapLess {
	inline bool operator() (const DataRange& lhl,   const DataRange&   rhl) const
		{ return NoOverlapLess()(lhl, rhl); }
	inline bool operator() (const DataRange& lhl,   const VTableMatch& rhl) const
		{ return NoOverlapLess()(lhl, rhl.range()); }
	inline bool operator() (const VTableMatch& lhl, const DataRange&   rhl) const
		{ return NoOverlapLess()(lhl.range(), rhl); }
	inline bool operator() (const VTableMatch& lhl, const VTableMatch& rhl) const
		{ return NoOverlapLess()(lhl.range(), rhl.range()); }
};


}  // namespace VFIELD

#endif /* vtable.h */
