#include "vtable.h"
#include "datarange.h"
#include <iostream>
#include <iterator>
#include <algorithm>

using namespace VFIELD;

struct DuplexLess {
	inline bool operator() (const DuplexRange& lhl, const DuplexRange& rhl) const
		{ return lhl.duplex() < rhl.duplex(); }
};

int main(void)
{
	VTable vtable;

	vtable.rpcNotifyUp( NodeIdentity("123456789012345a"), DataRange(  0,  20) );
	vtable.rpcNotifyUp( NodeIdentity("123456789012345b"), DataRange( 10,  20) );
	vtable.rpcNotifyUp( NodeIdentity("123456789012345c"), DataRange( 20,  25) );
	vtable.rpcNotifyUp( NodeIdentity("123456789012345d"), DataRange( 50, 120) );
	vtable.rpcNotifyUp( NodeIdentity("123456789012345e"), DataRange( 50, 120) );
	vtable.rpcNotifyUp( NodeIdentity("123456789012345f"), DataRange(100, 110) );

	typedef std::vector<DuplexRange> dmap_type;
	dmap_type duplex;
	vtable.calcDuplex(300, duplex);

	std::copy(duplex.begin(), duplex.end(), std::ostream_iterator<DuplexRange>(std::cout, "\n") );

	std::sort(duplex.begin(), duplex.end(), DuplexLess());

	dmap_type::iterator lower( duplex.begin() );
	while( lower != duplex.end() ) {
		dmap_type::iterator upper( std::upper_bound(lower, duplex.end(), *lower, DuplexLess()) );
		std::vector<DuplexRange> dx(lower, upper);

		std::cout << "d" << lower->duplex() << ": " << std::endl;
		std::copy(dx.begin(), dx.end(), std::ostream_iterator<DuplexRange>(std::cout, "\n") );

		lower = upper;
	}
}
