#include "vtable/vtable.h"
#include "datarange.h"
#include "node.h"
#include "exception.h"
#include <iostream>
#include <iterator>
#include <algorithm>

using namespace VFIELD;

struct DuplexLess {
	inline bool operator() (const DuplexRange& lhl, const DuplexRange& rhl) const
		{ return lhl.duplex() < rhl.duplex(); }
};

namespace {
struct LengthGreater {
	LengthGreater(DataRange::size_type t1) : m_t1(t1) {}
	bool operator() (const DataRange& range)
		{ return m_t1 < range.length(); }
private:
	DataRange::size_type m_t1;
};
}  // noname namespace

int main(void)
{
	VTable vtable;

	// テスト用データ
	vtable.rpcNotifyUp( NodeIdentity("123456789012345a"), DataRange(  0,  20) );
	vtable.rpcNotifyUp( NodeIdentity("123456789012345b"), DataRange( 10,  20) );
	vtable.rpcNotifyUp( NodeIdentity("123456789012345c"), DataRange( 20,  25) );
	vtable.rpcNotifyUp( NodeIdentity("123456789012345d"), DataRange( 50, 120) );
	vtable.rpcNotifyUp( NodeIdentity("123456789012345e"), DataRange( 50, 120) );
	vtable.rpcNotifyUp( NodeIdentity("123456789012345f"), DataRange(100, 110) );
	vtable.rpcNotifyUp( NodeIdentity("123456789012345g"), DataRange(250, 250) );

	// 多重化度を計算
	typedef std::vector<DuplexRange> dmap_type;
	dmap_type duplex;
	vtable.calcDuplex(400, duplex);
	std::sort(duplex.begin(), duplex.end(), DuplexLess());

	// 多重化度が最小の範囲群を取り出す
	dmap_type::iterator lower( duplex.begin() );
	if( lower == duplex.end() ) {
		throw std::runtime_error("error");
	}
	dmap_type::iterator upper( std::upper_bound(lower, duplex.end(), *lower, DuplexLess()) );


	std::copy(lower, upper, std::ostream_iterator<DuplexRange>(std::cout, "\n") );


	// 持てるデータ量
	pos_type limit = 80;
	NodeIdentity self("192.168.0.6", "60000");

	// すべてシーケンシャルに持てるRangeが存在する場合
	{
		std::vector<DataRange> candidates;
		for( dmap_type::iterator more( std::find_if(lower, upper, LengthGreater(limit)) );
				more != upper;
				more = std::find_if( (more+1), upper, LengthGreater(limit)) ) {
			std::cout << "more: " << *more << std::endl;
			for(pos_type cur_end( more->start() + limit - 1 ); cur_end < more->end(); cur_end += limit) {
				candidates.push_back( DataRange(cur_end - limit + 1, cur_end) );
			}
			// 後ろに吸着する範囲を追加
			candidates.push_back( DataRange(1 + more->end() - limit, more->end()) );

		}
		if( !candidates.empty() ) {
			for(std::vector<DataRange>::const_iterator cd(candidates.begin()), cd_end(candidates.end());
					cd != cd_end;
					++cd ) {
				std::cout << "candidate: " << *cd << std::endl;
			}
			// IPアドレスの最下位ビットから分散
			uint16_t rseed( *((uint16_t*)(&self.getNetRaw()[16])) );
			std::cout << "rseed: " << rseed << std::endl;
			std::cout << "DATA: " << candidates[rseed % candidates.size()] << std::endl;
		}
	}
}

