#ifndef VFIELD_RPCCLIENT_H__
#define VFIELD_RPCCLINNT_H__

#include "node.h"
#include "datarange.h"
#include "ip46.h"
#include "exception.h"
#include <stdint.h>

namespace VFIELD {


class RPCClient {
public:
	RPCClient(	const char* bcast_udp_port,
			const NodeIdentity& self_identity
			);	// throw( InvalidAddressException )
	~RPCClient();
public:
	void ucastNotifySelfUp(const addr46_t& to);
	void ucastNotifySelfDown(const addr46_t& to);
	void ucastNotifyOtherUp(const addr46_t& to, const NodeIdentity& target, const DataRange& target_range);
	void ucastNotifyOtherDown(const addr46_t& to, const NodeIdentity& target);
	void ucastFind(const addr46_t& to, const DataRange& range);
	void ucastPing(const addr46_t& to);
	void bcastNotifySelfUp(void);
	void bcastNotifySelfDown(void);
	void bcastNotifyOtherUp(const NodeIdentity& target, const DataRange& target_range);
	void bcastNotifyOtherDown(const NodeIdentity& target);
	void bcastFind(const DataRange& range);
public:
	// for Storage
	void setSelfRange(const DataRange& range);
	void setImageId(uint16_t image_id);
public:
	// for VTable
	const NodeIdentity& getSelfIdentity(void) const
		{ return m_self_identity; }
private:
	addr46_t m_bcast_addr;
	NodeIdentity m_self_identity;
	DataRange m_self_range;
	uint16_t m_image_id;
	int m_send_socks4[4];
	int m_send_socks6[4];
private:
	inline void makeNotifyUp(char* buf, const NodeIdentity& target, const DataRange& target_range) const throw();
	inline void makeNotifyDown(char* buf, const NodeIdentity& target) const throw();
	inline void makeFind(char* buf, const DataRange& range) const throw();
	inline void makePing(char* buf, const NodeIdentity& self, const DataRange& self_range) const throw();
	inline void sendUcast(const addr46_t& to, const char* buf, size_t len);
	inline void sendBcast(const char* buf, size_t len);
	inline int getSocket(const addr46_t& to, const char* buf, size_t len);
private:
	RPCClient();
};


////
// Exception
//
struct RPCSendException : public SystemCallException {
	RPCSendException(int errno_, const std::string& message) :
		SystemCallException(errno_, message) {}
};


}  // namespace VFIELD

#endif /* rpcclient.h */
