#ifndef VFIELD_PROTOCOL_H__
#define VFIELD_PROTOCOL_H__

#include <cstdlib>
#include <stdint.h>

namespace VFIELD {


// ================================================================ //
// Node Identity Flasg                                              //
// ================================================================ //
const uint8_t          NODE_IDENTITY_FLAG_IPV6         = 0x01;


// ================================================================ //
// RPC Commands (UDP Packet)                                        //
// ================================================================ //
// ----------------------- //
// RPC Common Header       //
// ----------------------- //
const size_t		RPC_COMMON_HEADER_SIZE		= 3;
/**
 *  +---------+---------------------+
 *   MagicNum       Image ID
 *     [0]       [1]   -    [2]
*/


// ----------------------- //
// RPC Notify Up           //
// ----------------------- //
const uint8_t		RPC_NOTIFY_UP_MAGIC		= 1;
const size_t		RPC_NOTIFY_UP_SIZE		= 35;
/**
 * +------+----------------+---------------+
 *  Common   NodeIdentity      DataRange
 *           [0]  -  [18]    [19]  -  [34]
*/


// ----------------------- //
// RPC Notify Down         //
// ----------------------- //
const uint8_t		RPC_NOTIFY_DOWN_MAGIC		= 2;
const size_t		RPC_NOTIFY_DOWN_SIZE		= 19;
/**
 * +------+----------------+
 *   Common  NodeIdentity
 *           [0]  -  [18]
*/


// ----------------------- //
// RPC Find                //
// ----------------------- //
const uint8_t		RPC_FIND_MAGIC			= 4;
const size_t		RPC_FIND_SIZE			= 53;
/**
 *                      +--------- Notify UP ----------+
 * +------+-------------+----------------+-------------+
 *  Common   DataRange     NodeIdentity     DataRange
 *          [0]  -  [15]  [16]  -  [36]    [37] - [52]
*/


// ----------------------- //
// RPC Ping                //
// ----------------------- //
const uint8_t		RPC_PING_MAGIC			= 8;
const size_t		RPC_PING_SIZE			= 35;
/**
 *        +--------- Notify UP ----------+
 * +------+--------------+---------------+
 *  Common  NodeIdentity     DataRange
 *          [0]  -  [18]   [19]  -  [34]
*/


const size_t		RPC_MAX_BODY_SIZE		= RPC_FIND_SIZE;



// ================================================================ //
// Stream Commands (TCP Packet)                                     //
// ================================================================ //
// ----------------------- //
// Stream Header           //
// ----------------------- //
const size_t		STREAM_HEADER_SIZE		= 1;
/**
 * +---------+
 *  MagicNum
 *     [0]
*/


// ----------------------- //
// Stream Get Data         //
// ----------------------- //
const uint8_t		STREAM_GET_DATA_MAGIC		= 1;
const uint8_t		STREAM_GET_DATA_ACK_MAGIC	= 4;
const size_t		STREAM_GET_DATA_SIZE		= 16;
const size_t		STREAM_GET_DATA_ACK_SIZE	= 0;
/**
 * +---------+-------------+
 *  MagicNum    DataRange
 *             [0]  -  [15]
*/

/** Ack
 * +---------+-------- .... ---------+
 *  MagicNum           Data
*/


// ----------------------- //
// Stream Join             //
// ----------------------- //
const uint8_t		STREAM_JOIN_MAGIC		= 8;
const uint8_t		STREAM_JOIN_ACK_MAGIC		= 16;
const uint8_t		STREAM_JOIN_SIZE		= 0;
const uint8_t		STREAM_JOIN_ACK_SIZE		= 0;
const uint8_t		STREAM_JOIN_ACK_HEADER_SIZE	= 15;
/**
 * +---------+
 *  MagicNum
*/

/** Ack
 * +---------+-----------+--------------+-------------------+--------------- ... -----------------+
 *  MagicNum   Image ID     Image Size     Size of V-Table                V-Table
 *            [0] - [1]   [2]   -   [9]  [10]    -    [14]   (Size of V-Table * RPC_NOTIFY_UP_SIZE)
 *           +-------------------------------+
 *              Stream Join Ack Header
 *
 ** V-Table
 * +----------------+---------------+
 *    NodeIdentity     DataRange
 *    [0]  -  [18]    [19]  -  [34]
*/


// ----------------------- //
// Stream Close            //
// ----------------------- //
const uint8_t		STREAM_CLOSE_MAGIC		= 32;
const uint8_t		STREAM_CLOSE_SIZE		= 0;
			// Stream CloseにACKは無い
/**
 * +---------+
 *  MagicNum
*/


const size_t		STREAM_MAX_BODY_SIZE		= STREAM_GET_DATA_SIZE;


}  // namespace VFIELD

#endif /* protocol.h */
