#ifndef VFIELD_RW_LOCK_H__
#define VFIELD_RW_LOCK_H__

#include <boost/thread.hpp>
#include <boost/utility.hpp>

namespace VFIELD {


class scoped_read_lock;
class scoped_write_lock;

class rw_mutex : private boost::noncopyable {
friend class scoped_read_lock;
friend class scoped_write_lock;
public:
	rw_mutex() : m_ref(0) {}
	~rw_mutex() {}
public:
	unsigned short read_count(void) const { return m_ref; }
	bool noreader(void) const { return m_ref == 0; }
private:
	boost::mutex m_read;
	boost::mutex m_access;
	boost::condition m_final;
	unsigned short m_ref;
};


// 書き込みを禁止するロック
class scoped_read_lock : private boost::noncopyable {
friend class scoped_write_lock;
public:
	explicit scoped_read_lock(rw_mutex& mutex) :
		m_mutex(mutex)
	{
		// readをロック
		boost::mutex::scoped_lock lk_read(m_mutex.m_read);
		{
			// accessをロック
			boost::mutex::scoped_lock lk_access(m_mutex.m_access);
			m_mutex.m_ref++;
			// accessをロック解除
		}
		// readをロック解除
	}

	~scoped_read_lock()
	{
		// accessをロック
		boost::mutex::scoped_lock lock(m_mutex.m_access);
		m_mutex.m_ref--;
		m_mutex.m_final.notify_all();
		// accessをロック解除
	}


private:
	rw_mutex& m_mutex;
private:
	scoped_read_lock();
};

// 書き込みと、新たな読み込みを禁止するロック
class scoped_write_lock : private boost::noncopyable {
public:
	explicit scoped_write_lock(rw_mutex& mutex) :
		m_lock(mutex.m_read)			// readをロック
	{
		// accessでfinalを待つ
		boost::mutex::scoped_lock lk_access(mutex.m_access);
		while( mutex.m_ref > 0 ) {
			mutex.m_final.wait(lk_access);
		}
	}

	//explicit scoped_write_lock(scoped_read_lock& read_lock);	// readロックからwriteロックに移行する
	//		// 同時に2つのスレッドがreadロックからwriteロックに移行しようとするとデッドロックする

	~scoped_write_lock() {}	// readをロック解除
public:
	void unlock(void) { m_lock.unlock(); }
private:
	boost::mutex::scoped_lock m_lock;
private:
	scoped_write_lock();
};

/*
scoped_write_lock::scoped_write_lock(scoped_read_lock& read_lock) :
	m_lock(read_lock.m_mutex.m_read)	// readをロック
{
	// accessでfinalを待つ
	boost::mutex::scoped_lock lk_access(mutex.m_access);
	while( mutex.m_ref > 1 ) {	// 1つはコンストラクタに渡されたread_lock
		mutex.m_final.wait(lk_access);
	}
}
*/


}  // namespace VFIELD

#endif /* rw_lock.h */
