#ifndef VFIELD_BUFFEREDREQ_H__
#define VFIELD_BUFFEREDREQ_H__

#include "vfield.h"
#include "datarange.h"
#include "notify.h"
#include <boost/shared_array.hpp>


namespace VFIELD {


// TODO: メモリを一度に確保できなかったら、内部データ構造を分割して確保する？

////
// BufferedRequest
//
class DataReceptor;
class DataRequest;
class BufferedRequest : public DataRange {
public:
	explicit BufferedRequest(DataRequest& request);		// throw()
	explicit BufferedRequest(char* buffer, pos_type start, pos_type end);	// throw(InvalidDataRange);
	explicit BufferedRequest(char* buffer, const DataRange& range);		// throw();
	~BufferedRequest() throw();
public:
	typedef enum {
		FAILED = 1,
		SUCCESS = 4,
	} status_type;
public:
	NotifyClient<status_type> getClient(void) const { return NotifyClient<status_type>(m_triger); }
	char* data(void) { return m_data; }
	const char* data(void) const { return m_data; }
	void notifyTriger(status_type message);
private:
	char* m_data;
	NotifyTriger<status_type> m_triger;
};



}  // namespace VFIELD

#endif /* bufferredreq.h */
