#include "active_cache.h"
#include "bufferedreq.h"
#include "request.h"
#include "search/request_queue.h"
#include "storage.h"
#include "stream/stream.h"
#include "vtable/vtable.h"
#include "node.h"
#include "rpc/rpcserver.h"
#include "rpc/rpcclient.h"
#include "log.h"
#include <iostream>

using namespace VFIELD;

void submit(ActiveCache& ac, uint64_t start, uint64_t end)
{
	std::vector<DataReceptor> reps;
	char buf[100];

	LogWarn( Log::format("Request %1%") % DataRange(start, end) );
	DataRequest req(buf, start,  end);
	ac.setRequest(req, reps);

	LogWarn("Waiting request...");
	std::for_each(reps.begin(), reps.end(), std::mem_fun_ref(&DataReceptor::waitAndCopy));

	buf[req.length()] = '\0';
	LogWarn( Log::format("Get data: %1%") % buf );
}


int main(void)
{
	ThreadPool threadpool(8);
	NodeIdentity self("127.0.0.1", "12345");

	RPCClient rpcc("12345", 10, self);
	RootStorage rstorage("test.img", rpcc);
	StreamManager smgr("12345", rstorage, threadpool);
	VTable vtable;

	RequestQueue rqueue(smgr, rpcc, vtable, threadpool);

	RPCServer rpcs("12345", vtable, rstorage, rqueue.requestAckMapper(), self, threadpool);

	ActiveCache cache(5, 15, rqueue);
 
	sleep(1);
	submit(cache, 0, 4);
	submit(cache, 0, 10);
	submit(cache, 5, 20);
}
