#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>  /* PATH_MAX */
#include <unistd.h>  /* getcwd() */

#include "viverrc.h"
#include "paclist.h"
#include "fbcolors.h"
#include "getpaclist.h"  /* getpaclist() */
#include "inrole.h"  /* find_paclist_in_role() */
#include "parseinfo.h" /* parse_pacinfo(), clean_pacinfo() */
#include "dependency.h" /* resolve_dependency() */
#include "applypaclist.h" /* apply_paclist() */

#define SMALLER(x,y) (x<y ? x:y)
#define BIGGER(x,y)  (x>y ? x:y)

static void parse_args(int argc, char *argv[], char* rcdir_path, char preset_role[ROLE_PRESET_AMOUNT_MAX][ROLE_NAME_MAX], char optional_role[ROLE_OPTIONAL_AMOUNT_MAX][ROLE_NAME_MAX]);

/**
 * argv[1] = MTRC
 * argv[2] = ֡ȥ (disk|net|phycow|ramcow)CSV
 * argv[3...] = ŬѤrole
 */

int main(int argc, char *argv[])
{
	pac *cue;
	char rcdir_path[PATH_MAX+1];
	char pacdir_path[PATH_MAX+1];
	char roledir_path[PATH_MAX+1];
	char preset_role[ROLE_PRESET_AMOUNT_MAX][ROLE_NAME_MAX];
	char optional_role[ROLE_OPTIONAL_AMOUNT_MAX][ROLE_NAME_MAX];

#ifndef NDEBUG
	int i;
	pac *current;
#endif


	printf("%sStart viverrc %s%s\n", FB_INFO, VIVERRC_VERSION, FB_NORMAL);


	parse_args(argc, argv, rcdir_path, preset_role, optional_role);
	strcpy(pacdir_path, rcdir_path);
	strcat(pacdir_path, "/packages");
	strcpy(roledir_path, rcdir_path);
	strcat(roledir_path, "/roles");
#ifndef NDEBUG
	printf("%sparse_args:\n", FB_DEBUG);
	printf("  rcdir_path = %s;\n", rcdir_path);
	printf("  pacdir_path = %s;\n", pacdir_path);
	printf("  roledir_path = %s;\n", roledir_path);
	for (i=0; preset_role[i][0] != '\0'; i++) {
		printf("  preset_role[%d] = %s;\n", i, preset_role[i]);
	}
	for (i=0; optional_role[i][0] != '\0'; i++) {
		printf("  optional_role[%d] = %s;\n", i, optional_role[i]);
	}
	printf("%s\n", FB_NORMAL);
#endif

	/* 󥯥ꥹȽ */
	if ( (cue = paclist_initialize()) == NULL ) {
		fprintf(stderr, "%sCan't allocate memory for first pac.%s\n", FB_ERROR, FB_NORMAL);
		exit(3);
	}

	get_paclist(cue, pacdir_path);
#ifndef NDEBUG
	printf("%sget_paclist:\n", FB_DEBUG);
	current = cue;
	do {
		printf("  %s;\n", current->dirname);
		current = current->next;
	} while (current != cue);
	printf("%s\n", FB_NORMAL);
#endif


	parse_pacinfo(cue, pacdir_path);
#ifndef NDEBUG
	printf("%sparse_pacinfo:\n", FB_DEBUG);
	current = cue;
	do {
		printf("  %s:\n", current->info.name);
		printf("    version: %f\n", current->info.version);
		for (i=0; i < current->info.num_needs; i++) {
			printf("    need[%d]: %s;\n", i, current->info.needs[i]->name);
		}
		current = current->next;
	} while (current != cue);
	printf("%s\n", FB_NORMAL);
#endif


	find_paclist_in_role(cue, roledir_path, preset_role, optional_role);
#ifndef NDEBUG
	printf("%sfind_paclist_in_role:\n", FB_DEBUG);
	current = cue;
	do {
		printf("  %s:\n", current->info.name);
		printf("    in_role_path: %s\n", current->in_role_path);
		printf("    use: %s\n", (current->use ? "yes" : "no") );
		current = current->next;
	} while (current != cue);
	printf("%s\n", FB_NORMAL);
#endif

	resolve_dependency(cue);
#ifndef NDEBUG
	printf("%sresolve_dependency:\n", FB_DEBUG);
	printf("  resolve_need_pointers depending:\n");
	current = cue;
	do {
		printf("    %s:", current->info.name);
		for (i=0; i < current->info.num_needs; i++) {
			printf(" %s", current->need[i]->info.name);
		}
		current = current->next;
		printf("\n");
	} while (current != cue);
	printf("  resolved use flags:\n");
	current = cue;
	do {
		printf("    %s: ", current->info.name);
		switch (current->use) {
		case No:
			printf("No\n");
			break;
		case Yes:
			printf("Yes\n");
			break;
		case YesButNotInRole:
			printf("YesButNotInRole\n");
			break;
		case Special:
			printf("Special\n");
			break;
		}
		current = current->next;
	} while (current != cue);
	printf("%s\n", FB_NORMAL);
#endif

	apply_paclist(cue, rcdir_path, pacdir_path);
#ifndef NDEBUG
	printf("%sapply_paclist: ok.%s\n", FB_DEBUG, FB_NORMAL);
#endif

	clean_pacinfo(cue);
#ifndef NDEBUG
	printf("%sclean_pacinfo: ok.%s\n", FB_DEBUG, FB_NORMAL);
#endif

	paclist_clean(cue);
#ifndef NDEBUG
	printf("%spaclist_clean: ok.%s\n", FB_DEBUG, FB_NORMAL);
#endif

	return 0;
}


static void parse_args(int argc, char *argv[], char* rcdir_path, char preset_role[ROLE_PRESET_AMOUNT_MAX][ROLE_NAME_MAX], char optional_role[ROLE_OPTIONAL_AMOUNT_MAX][ROLE_NAME_MAX])
{
	char preset_parse_tmp[ROLE_PRESET_AMOUNT_MAX*ROLE_NAME_MAX];
	char *pos_parse_head;
	char *pos_comma;
	char *pos_parse_end;
	int num_optional;
	int i,j;

	/* rcdir_pathargv[1]DEFAULT_RCDIR_PATH */
	if (argc <= 1) {
		fprintf(stderr, "%srcdir path is not specified. Using default rcdir path.\n%s", FB_WARN, FB_NORMAL);
		strcpy(rcdir_path, DEFAULT_RCDIR_PATH);
	} else {
		strcpy(rcdir_path, argv[1]);
	}
	if (rcdir_path[ strlen(rcdir_path)-1 ] == '/' ) {
		rcdir_path[ strlen(rcdir_path)-1 ] = '\0'; 
	}
	if (rcdir_path[0] != '/') {
		/* rcdir_pathХѥʤΤǡХѥѴ */
		char real_path[PATH_MAX+1];
		if (getcwd(real_path, PATH_MAX) == NULL) {
			fprintf(stderr, "%sFirst arguments is relative path, and can't get current working directory name.%s\n", FB_ERROR, FB_NORMAL);
			exit(5);
		}
		strcat(real_path, "/");
		strcat(real_path, rcdir_path);
		strcpy(rcdir_path, real_path);
	}

	/* preset_roleˡ"all"argv[2]CSVγͤ缡Ǽ */
	/* ü'\0' */
	strcpy(preset_role[0], "all");
	i = 1;
	if (argc >= 2) {
		strcpy(preset_parse_tmp, argv[2]);

		/* preset_parse_tmpü ","ɲä */
		pos_parse_end = &preset_parse_tmp[ SMALLER( strlen(preset_parse_tmp), ROLE_PRESET_AMOUNT_MAX*ROLE_NAME_MAX-1 ) ];
		*pos_parse_end = ',';
		pos_parse_end++;

		pos_parse_head = preset_parse_tmp;
		while ( pos_parse_head != pos_parse_end && i < ROLE_PRESET_AMOUNT_MAX  ) {
			pos_comma = strchr(pos_parse_head, ',');
			*pos_comma = '\0';
			strcpy(preset_role[i], pos_parse_head);  /* *pos_parse_head == *pos_comma == '\0' */
			pos_parse_head = pos_comma + 1;
			i++;
		}

	}
	preset_role[i][0] = '\0';  /* ü */


	/* role */
	num_optional = SMALLER(argc-3,ROLE_OPTIONAL_AMOUNT_MAX);
	j = 0;
	while (j < num_optional) {
		strcpy(optional_role[j], argv[j+3]);
		j++;
	}
	optional_role[j][0] = '\0';
}

