#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>
#include <pthread.h>

#include "paclist.h"

void initialize_pac(pac *pac)
{
	static pthread_mutex_t init_mutex = PTHREAD_MUTEX_INITIALIZER;
	static pthread_cond_t init_cond = PTHREAD_COND_INITIALIZER;
	pac->next = NULL;
	pac->prev = NULL;
	pac->info.name[0] = '\0';
	pac->info.needs[0] = NULL;
	pac->info.num_needs = 0;
	pac->info.version = 0;
	pac->dirname[0] = '\0';
	pac->need[0] = NULL;
	pac->in_role_path[0] = '\0';
	pac->use = No;
	pac->resolved = false;
	pac->resolve_count = -1;
	pac->applied = false;
	pac->applied_mutex = init_mutex;
	pac->applied_cond = init_cond;
}

pac* paclist_initialize(void)
{
	/* 󥯥ꥹȽ */
	/* ǽΥΡɤüpac "_LAST" */
	pac *cue_last;

	if ( (cue_last = malloc(sizeof(pac))) == NULL ) {
		return NULL;
	}
	initialize_pac(cue_last);
	cue_last->next = cue_last;
	cue_last->prev = cue_last;
#ifndef NDEBUG
	strcpy(cue_last->info.name, "_LAST");
#endif
	cue_last->resolved = true;
	cue_last->use = Special;

	return cue_last;
}

void paclist_clean(pac *cue)
{
	pac *current = cue->next;
	while (current != cue) {
		current = current->next;
		free(current->prev);
	}
	free(cue);
}

int paclist_count(const pac *cue)
{
	const pac *current;
	int count = 1;  /* cueʬ */
	for (current=cue->next; current != cue; current=current->next) {
		count++;
	}
	return count;
}

void paclist_addpac(pac *cue, pac *new_pac)
{
	new_pac->next = cue->next;
	new_pac->prev = cue;
	cue->next->prev = new_pac;
	cue->next = new_pac;
}

void paclist_delpac(pac *del_pac)
{
	del_pac->prev->next = del_pac->next;
	del_pac->next->prev = del_pac->prev;
	free(del_pac);
}

pac* paclist_search_by_dirname(pac *cue, const char *key)
{
	/*  */
	pac *searching = cue;
	do {
		if ( strcmp(searching->dirname, key) == 0) {
			return searching;
		}
		searching = searching->next;
	} while (searching != cue);
	return NULL;
}

pac* paclist_search_by_name(pac *cue, const char *key)
{
	/*  */
	pac *searching = cue;
	do {
		if ( strcmp(searching->info.name, key) == 0) {
			return searching;
		}
		searching = searching->next;
	} while (searching != cue);
	return NULL;
}

