#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>
#include <limits.h>  /* PATH_MAX */

#include "paclist.h"
#include "fbcolors.h"
#include "dependency.h"


static void add_needing(pac* need, pac* needed)
{
	int i;
	for (i=0; need->need[i] != NULL; i++) { ; }
	need->need[i] = needed;
	need->need[i+1] = NULL;
}
static void del_needing(pac* need, pac* needed)
{
	int i,j;
	for (i=0; need->need[i] != NULL; i++) {
		if (need->need[i] == needed) {
			for (j=i; need->need[j+1] != NULL; j++) { ; }
			need->need[i] = need->need[j];  /* needΤȤǸpacˤơ */
			need->need[j] = NULL;           /* ǸpacΤȤNULLѤ */
			break;
		}
	}
}

static void set_need_pointer(pac* cue_last, pac *current)
{
	pac* need_tmp;
	int i;
	bool need_last = false;
	for (i=0; i < current->info.num_needs; i++) {
		need_tmp = paclist_search_by_name(cue_last->next, current->info.needs[i]->name);
		if (need_tmp == NULL) {
			fprintf(stderr, "%s\"%s\" that \"%s\" needs doesn't found.%s\n", FB_WARN, need_tmp->info.name, current->info.name, FB_NORMAL);
			need_tmp = cue_last;
			need_last = true;
		}
		add_needing(current, need_tmp);
		if (current->need[i]->use == No) {
			current->need[i]->use = YesButNotInRole;
			set_need_pointer(cue_last, current->need[i]);
		}
	}
	if (!need_last) {
		add_needing(cue_last, current);  /* _LAST_LAST˰¸pacʳΤ٤Ƥpac˰¸ */
	}
	/* ü */
	current->need[i+1] = NULL;
}
static void resolve_need_pointers(pac *cue_last)
{
	pac *current = cue_last->next;
	for (current=cue_last->next; current != cue_last; current=current->next) {
		if (current->use == Yes) {
			set_need_pointer(cue_last, current);
		}
	}
}

static void commit_needing(pac* receiver, pac* committer)
{ /* committerneed򤹤٤receiver˰(receiver¸Ƥ뤳Ȥˤ) */
	int i;
	for (i=0; committer->need[i] != NULL; i++) {
		add_needing(receiver, committer->need[i]);
	}
	committer->need[0] = NULL;
}
static pac* resolve(pac *current)
{
/* Ĥpacΰ¸ط褹
 * currentˤpac˰¸Ƥ硢pacȤƤδؿƵƤӽФ
 * ֤ͤϡ褬λNULLľ¸򸡽Фϡľ¸ϢȤʤäƤpacؤΥݥ
 */
	pac *loop_origin;
	int i;

	if (current->resolved) { return NULL; }
	if (current->resolve_count != -1) {
		/* resolve_countꤵƤ -> ľ¸ */
		/* currentϴľ¸ϢǤ뤳ȤȽ */
		/* dummypaclistɲä¸طϢpacؤΥݥ(current)֤ */
		/* ľ¸μpacʳneeddummyloop_origin->need[0]ˤ˰ */
		/* Ѥ顢currentϿneed[0]ݥ󥿡dummy˰¸ */
		pac *dummy_tmp;  /* ѿ */
		if ( (dummy_tmp = malloc(sizeof(pac))) == NULL ) {
			fprintf(stderr, "%sCan't allocate memory for resolving looped dependency.%s\n", FB_ERROR, FB_NORMAL);
			exit(4);
		}
		initialize_pac(dummy_tmp);
#ifndef NDEBUG
		strcpy(dummy_tmp->info.name, "_DUMMY_");
		strcat(dummy_tmp->info.name, current->info.name);
#endif
		dummy_tmp->use = Special;
		del_needing(current, current->need[current->resolve_count]);
		commit_needing(dummy_tmp, current);
		add_needing(current, dummy_tmp);  /* current->need[0] = dummy_tmp */
		paclist_addpac(current, dummy_tmp);
		return current;
	}
	for (i=0; current->need[i] != NULL; i++) {
		current->resolve_count = i;
		if ( (loop_origin = resolve(current->need[i])) != NULL ) {
			/* ľ¸ */
			/* loop_originϴľ¸Ϣ */
			if ( loop_origin != current ) {
				/* currentϴľ¸ϢǤϤʤ */
				/* ľ¸μpacʳneeddummyloop_origin->need[0]ˤ˰ */
				/* Ѥ顢currentϿdummy˰¸ */
				/* resolve_count-1ˤٿƴؿ(resolve_dependency)ƤӽФΤԤ */
				del_needing(current, current->need[i]);
				commit_needing(loop_origin->need[0], current);
				add_needing(current, loop_origin->need[0]);
				current->resolve_count = -1;
				return loop_origin;
			} else {
				/* ¸طϢäƤ */
				/* dummy(current->need[0])¸طβƳ */
				i = 0;
			}
		}
	}
	current->resolved = true;
	current->resolve_count = -1;
	return NULL;
}

static bool is_resolved_all(pac *cue)
{
	pac *current;
	current = cue;
	do {
		if (current->use && current->resolved == false) {
			return false;
		}
		current = current->next;
	} while (current != cue);
	return true;
}
void resolve_dependency(pac *cue_last)
{
	pac *current;
	resolve_need_pointers(cue_last);

	do {
		for (current=cue_last->next; current != cue_last; current=current->next) {
			resolve(current);
		}
	} while (is_resolved_all(cue_last->next) == false);
}

