require 'vikiwikiattach'
require 'diffcvs'

module VikiWiki
	class Themes
		include Enumerable
		def initialize(sys)
			@sys = sys
		end
		def [](name)
			name = @sys['THEMECSS'] unless name
			if @sys['SAFE'] > 2 then
				name = @sys['THEMECSS'] unless RE_IDENT === name
			end
			Theme::new(@sys, name, @sys['THEMEDIR'], @sys['THEMEURI'], @sys.encoding)
		end
		def each
			arr = Array::new
			Dir::glob([@sys['THEMEDIR'].first, '*'].path){|path|
				next unless File::directory?(path.untaint)
				arr << Theme::new(@sys, File::basename(path), @sys['THEMEDIR'], @sys['THEMEURI'], @sys.encoding)
			}
			arr.sort.each{|theme|
				yield theme
			}
		end
	end
	class Theme
		attr_reader :name, :elms
		def initialize(sys, name, basedir, baseuri, code)
			@sys, @name, @basedir, @baseuri, @code = sys, name, basedir.to_a, baseuri.to_a, code
		end
		def [](name)
			self.load unless @elms
			idx = @elms.index(name)
			return idx ? @elms[idx] : nil
		end
		def local?
			RE_IDENT === @name
		end
		def exist?
			return false unless self.local?
			return false unless File::exist?(self.path)
			return true
		end
		def uri(pos=0)
			return @name if @name.include?('/')
			dir = @baseuri[pos]
			if @sys.static? then
				if dir[0].chr != '/' and not /:/ === dir then
					dots = @sys.page.name.split('/').size - 1
					dir = [['..'] * dots, @sys['THEMEURI']].path
				end
			end
			return [dir, @name, "#{@name}.css"].path
		end
		def path(pos=0)
			raise Message::new(:FUNC_LINK_GEN_ERROR) unless self.local?
			return [@basedir[pos], @name, "#{@name}.css"].path
		end
		def <=>(other)
			self.name <=> other.name
		end
		def img
			return Image::new(@name, @basedir, @baseuri, true)
		end
		def update(elm, pos)
			load unless @elms
			if pos then
				elms = Array::new
				@elms.each{|welm|
					elms << elm if welm.name == pos
					elms << welm if welm.name != elm.name
				}
				@elms = elms
			else
				@elms.delete_if{|welm| welm.name == elm.name}
				@elms << elm
			end
		end
		THEME_STAG = "/* Start ==== VikiWiki Theme Description"
		THEME_ETAG = "End ==== VikiWiki Theme Description */"
		def load
			@elms = Array::new
			return @elms unless File::exist?(self.path)
			elm = nil
			text = Array::new
			File::foreach(self.path){|line|
				line.chomp!
				elm = ThemeElm::new unless elm
				if /^\@charset/ === line then
					next
				elsif line == THEME_STAG then
					unless text.empty? then
						css = text.join("\n")
						css = $` while /\n+\z/ === css
						elm.css = css
						@elms << elm
						elm = nil
						text.clear
					end
					next
				elsif @elms.empty? then
					text << line
					next
				end
				case line
				when /^Name: / then
					elm.name = $'
				when /^Author: / then
					elm.author = $'
				when /^Time: / then
					elm.time = $'
				when /^Comment: / then
					elm.comment = $'
				when /^Sample: / then
					elm.style = $'
					text.clear
				when THEME_ETAG then
					sample = text.join("\n")
					sample = $` while /\n+\z/ === sample
					elm.sample = sample
					text.clear
				else
					text << line
				end
			}
			return unless elm
			css = text.join("\n")
			css = $` while /\n+\z/ === css
			elm.css = css
			@elms << elm
		end
		def write
			text = ''
			text << "@charset \"#{@code}\";\n"
			@elms.each{|elm|
				unless elm.name.empty? then
					text << THEME_STAG+"\n"
					text << "Name: #{elm.name}\n"
					text << "Author: #{elm.author}\n"
					text << "Time: #{elm.time}\n"
					text << "Comment: #{elm.comment}\n"
					text << "Sample: #{elm.style}\n#{elm.sample}\n"
					text << THEME_ETAG+"\n"
				end
				text << elm.css
				text << "\n\n"
			}
			cvs = DiffCVS::new(0644, @sys['BACKUP'])
			cvs.writeFile(self.path, text)
			1.upto(@basedir.size-1){|i|
				File::copyp(self.path, self.path(i))
			}
		end
		def delete(name)
			self.load
			n = @elms.index(name)
			raise Message::new(:FUNC_THEME_ELM_NOT_FOUND) unless n
			@elms.delete_at(n)
			self.write
		end
	end
	class ThemeElm
		attr_accessor \
			:name,
			:author,
			:comment,
			:style,
			:sample,
			:css,
			:time
		def initialize(name='', author='', comment='', style='', sample='', css='', time=nil)
			@name, @author, @comment, @style, @sample, @css, @time =
			 name,  author,  comment,  style,  sample,  css,  time
		end
		def ==(other)
			if self.class == other.class then
				self.name == other.name
			else
				self.name == other
			end
		end
	end
end
