require 'ftools'
require 'extension/cgi'
require 'useconv'

module VikiWiki
	class Attach
		attr_reader :parent, :object_path
		attr_accessor :name
		include Enumerable
		def initialize(object_path, basedir, baseuri, directory=nil, objcode=$KCODE, oscode=nil)
			@my = self.class
			@object_path = object_path.to_s
			@basedir = [basedir].flatten
			@baseuri = [baseuri].flatten
			@objcode = objcode
			@oscode = oscode
			raise Message::new(:FILE_INVALID_NAME, '..') if @object_path['/../'] or /\/\.\.$/ === @object_path or /^\.\.\// === @object_path or @object_path == '..'
			raise Message::new(:FILE_FULL_PATH_DENIED) if /^(\/|[A-Za-z]\:)/ === @object_path

			@to_file_path = CGI.method(:escapePATH)
			@to_object_path = CGI.method(:unescapePATH)
			if /^file:/ === @baseuri[0] then
				if USEconv::eql?(@objcode, @oscode) then
					@to_file_path = nil
					@to_object_path = nil
				elsif USEconv::cnvmethod(@objcode, @oscode) then
					@to_file_path = USEconv::cnvmethod(@objcodde, @oscode)
					@to_object_path = USEconv::cnvmethod(@oscode, @objcode)
				end
			end
			@file_path = @to_file_path.call(@object_path).untaint

			if @object_path.empty? then
				@parent = nil
			elsif not @object_path.include?('/') then
				@parent = ''
			else
				@parent = File::dirname(@object_path)
			end
			file_parent = File::dirname([@basedir[0], @file_path].path)
			raise Message::new(:FILE_NOT_FOUND, @parent) if file_parent and file_parent != '' and not File::exist?(file_parent)

			if File::directory?(@file_path) then
				raise Message::new(:NOT_A_FILE, @object_path) if directory == false
				@directory = true
			elsif File::exist?(@file_path) then
				raise Message::new(:NOT_A_DIRECTORY, @object_path) if directory == true
				@directory = false
			else
				@directory = directory ? true : false
			end
			@name = File::basename(@object_path)
		end
		def link
			CGI::element('a', {'href'=>self.uri}, self.name)
		end
		def [](name)
			raise Message::new(:NOT_A_DIRECTORY, @object_path) unless @directory
			@my::new([@object_path, name].path, @basedir, @baseuri, nil, @oscode)
		end
		def write(data)
			path = self.path
			File::open(path, "wb"){|fout|
				fout.write(data)
			}
			1.upto(@basedir.size-1){|i|
				File::copyp(path, self.path(i))
			}
		end
		def put(file, fnam=nil)
			orgpath = file.original_filename
			fnam = File::basename(orgpath.gsub(/\\/, '/')) unless fnam
			self[fnam].write(file.read)
		end
		def directory?
			@directory
		end
		def exist?
			File::exist?(self.path)
		end
		def create
			@basedir.each_index do |i|
				path = self.path(i)
				unless File::exist?(path) then
					if @directory then
						Dir::mkdir(path)
					else
						File::open(path, "w").close
					end
				end
			end
		end
		def drop
			if @directory then
				@basedir.each_index do |i|
					dir = self.path(i)
					File::rm_rf(dir) if File::exist?(dir)
					path = self.path(i)
					if File::exist?(path) then
						if @directory then
							File::rm_rf(path)
						else
							File::unlink(path)
						end
					end
				end
			else
				File::unlink(self.path)
			end
		end
		def each(pattern=nil)
			raise Message::new(:NOT_A_DIRECTORY, @object_path) unless @directory
			pattern = '*' unless pattern
			Dir::glob([self.path, pattern].path){|path|
				path = path.untaint
				directory = File::directory?(path)
				file = File::basename(path)
				file = @to_object_path.call(file) if @to_object_path
				begin
					yield @my::new([@object_path, file].path, @basedir, @baseuri, directory, @oscode)
				rescue Message
				end
			}
		end
		def each_dir(pattern=nil)
			self.each{|file|
				next unless file.directory?
				yield file
			}
		end
		def each_file(pattern=nil)
			self.each{|file|
				next if file.directory?
				yield file
			}
		end
		def uri(pos=0)
			return @uri if @uri
			if /^file:/ === @baseuri[pos] then
				@uri = [@baseuri[pos], @object_path].path
			else
				@uri = [@baseuri[pos], @file_path].path
			end
			@uri = CGI::escapeURI(@uri)
			return @uri
		end
		def path(pos=0)
			# path on file system
			return @path if @path
			@path = [@basedir[pos], @file_path].path
			@path = [Dir::pwd, @path].path unless /^(\/|[A-Za-z]\:)/ === @path
			return @path
		end
	end
	class Image < Attach
		def initialize(object_path, basedir, baseuri, directory, objcode=$KCODE, oscode=nil)
			raise Message::new(:FILE_INVALID_EXTENTION) unless directory or RE_IMG_EXT === object_path
			super
		end
		def view(attr)
			wattr = {'src'=>self.uri}
			wattr.update(attr)
			CGI::element('img', wattr)
		end
	end
end
