require 'vikiwikiplugin'

module VikiWiki
	module Plugins
		class Visualflow
			include BaseModule
			def ondesc; <<DSC; end
The system plugin can visually show the refering links and the refered links.
If the ''page'' parameter is specified, it is the starting page.
The ''back-mark'' and ''fore-mark'' parameter are marks to move among the visualflow.
{{{
#visualflow [page] [back-mark] [fore-mark]
}}}
DSC
			LBL = Hash::new
			LBL['BAK_REF'] = 'backward'
			LBL['CUR_REF'] = 'current'
			LBL['FOR_REF'] = 'forward'
			LBL['BAK_MAK'] = '<<'
			LBL['FOR_MAK'] = '>>'

			def safe; 5 ; end
			def onview
				def_p, fore, back = @prms
				def_p = @sys.pages[def_p].name if def_p
				fore = LBL['BAK_MAK'] unless fore
				back = LBL['FOR_MAK'] unless back
				vf_p = @sys.cgi.params['visualflow_p'][0] || def_p || @sys.page.name
				flinks = @sys.links[vf_p] || []
				tlinks = Array::new
				@sys.links.datas.each{|p,q|
					next unless q
					next unless Array === q
					next unless q.include?(vf_p)
					tlinks << p
				}
				flist = Parser::trans_html(@sys,
					flinks.uniq.sort.compact.map{|p|
						"* [[#{p}]] [#{uri4get({'visualflow_p'=>p})} #{fore}]"
					}.join("\n"),
					'VikiWikiStyle')
				tlist = Parser::trans_html(@sys,
					tlinks.uniq.sort.compact.map{|p|
						"* [#{uri4get({'visualflow_p'=>p})} #{back}] [[#{p}]]"
					}.join("\n"),
					'VikiWikiStyle')
				mypage = Parser::trans_html(@sys,
					"* [[#{vf_p}]]",
					'VikiWikiStyle')
				to_table([
					[LBL['BAK_REF'], LBL['CUR_REF'], LBL['FOR_REF']],
					[flist, mypage, tlist]
				], 'visualflow', 'top')
			end
		end
	end
end
