require 'vikiwikiplugin'

module VikiWiki
	module Plugins
		class Sys
			include BaseModule
			def ondesc; <<DSC; end
The system plugin can show the system information.
{{{
#sys name
}}}
The name is following,
:user:user name
:page:current page name
:alias:alias name of current page
:code:u or s or e
:encoding:utf-8 or Shift_JIS or euc-jp
:version:version of current page
:style:Wiki style
:counter:number of access
:theme:theme name
:lang:ja or en ...
:mtime:last modified time
:wikiengine:#{$WIKIENGINE}
:wikiversion:#{$WIKIVERSION}
DSC
			LBL = Hash::new unless defined? LBL
			LBL['UNK_VAL'] = 'Unknown'

			def safe; 5 ; end
			def onview
				begin
					method = self.method("plugin_sys_"+@prms[0])
					res = method.call
				rescue Exception
					Log.rescue(__FILE__, __LINE__, $!.to_s, $@.to_a.join("\n")) if @sys['DEBUG']
					res = nil
				end
				return LBL['UNK_VAL'] unless res
				return res.to_s
			end
		private
			def plugin_sys_user
				begin
					@sys.sec.user
				rescue AuthorizationRequired
					nil
				end
			end
			def plugin_sys_page; @sys.page.name; end
			def plugin_sys_alias; @sys.page.alias; end
			def plugin_sys_code; @sys.code; end
			def plugin_sys_encoding; @sys.encoding; end
			def plugin_sys_version
				@sys.version or @sys.cvs.getVersions(@sys.page.path).last.to_i
			end
			def plugin_sys_style; @sys.page.style; end
			def plugin_sys_counter; @sys.counter[@sys.page.name]; end
			def plugin_sys_theme; @sys.theme.name; end
			def plugin_sys_lang; @sys.lang; end
			def plugin_sys_mtime; File::mtime(@sys.page.path).tms; end
			def plugin_sys_wikiengine; $WIKIENGINE; end
			def plugin_sys_wikiversion; $WIKIVERSION; end
		end
	end
end
