module VikiWiki
	module Plugins
		class Listschedule
			def ondesc; <<DSC; end
チェックリストからガントチャートを生成するためのプラグインです。
以下の形式で記述します。
終了日と進捗度は省略できます。
マークには■(完了)、□(未着手)、▲(実施中)、×(削除)が利用できます。
{{{
* ＜マーク＞ ＜内容＞ ＜開始日＞ ～ ＜終了日＞ ＜名前＞ ＜進捗度＞%
* □ 内容．．． YYYY-MM-DD ～ YYYY-MM-DD 名前 nn%
}}}
プラグインの指定形式は以下のようになります。
{{{
#listschedule [{short|now|all} [pages ... ]]
}}}
DSC
			LBL['SCD_PAG'] = 'ページ'
			LBL['SCD_TIT'] = 'タイトル'
			LBL['SCD_PSN'] = '担当'
			def getRate(mark, rate)
				case mark
				when '■' then
					return 100
				when '□' then
					return 0
				when '▲' then
					return rate.to_i if rate
					return 50
				when '×' then
					return -1
				end
				return 0
			end
		end
	end
end
