require 'vikiwikiplugin'

module VikiWiki
	module Plugins
		class Interwiki
			include BaseModule
			def ondesc; <<DSC; end
The system plugin can regist the InterWikiName.
DSC
			HED = Hash::new unless defined? HED
			HED['DEL_IWK'] = 'DeleteInterWiki'
			HED['REG_IWK'] = 'Regist and alter InterWiki'
			HED['SYS_IWK'] = 'SystemInterWiki'
			LBL = Hash::new unless defined? LBL
			LBL['DEL_IWK'] = 'DeleteInterWiki'
			LBL['ENC_NAM'] = 'Encoding'
			LBL['NAM_NAM'] = 'Name'
			LBL['REG_IWK'] = 'RegistInterWiki'
			LBL['URI_NAM'] = 'URI'

			def safe; 3 ; end
			def onpost
				case @sys.cgi.params['interwiki_mode'][0]
				when 'add' then
					@sys.interwikis[@sys.cgi.params['interwiki_name'][0]] =
					{
						'uri' => @sys.cgi.params['interwiki_uri'][0],
						'code' => @sys.cgi.params['interwiki_code'][0]
					}
				when 'del' then
					@sys.interwikis.delete(@sys.cgi.params['interwiki_name'][0])
				end
				@sys.interwikis.update
				@sys.static_update
			end
			def onview
				res = Array::new
				res << CGI::element('h2', nil, HED['REG_IWK'])
				res << addform
				res << CGI::element('h2', nil, HED['DEL_IWK'])
				res << delform
				res << CGI::element('h2', nil, HED['SYS_IWK'])
				res << syslist
				return res
			end
			def addform
				codes = [
					USEconv::encoding('u'),
					USEconv::encoding('e'),
					USEconv::encoding('s')
				]
				plugin_form({'interwiki_mode'=>'add'}) {|recv|
					recv << [LBL['NAM_NAM'], text('interwiki_name', '')]
					recv << [LBL['ENC_NAM'], select('interwiki_code', nil, codes)]
					recv << [LBL['URI_NAM'], text('interwiki_uri', '', 40)]
					recv << [submit('exec', LBL['REG_IWK']), nil]
				}
			end
			def delform
				plugin_form({'interwiki_mode'=>'del'}) {|recv|
					@sys.interwikis.each{|name, inf|
						recv << [
							radio('interwiki_name', name),
							CGI::element('a', {'href'=>inf['uri']}, name),
							inf['code']
						]
					}
					recv << [submit('exec', LBL['DEL_IWK']), nil, nil]
				}
			end
			def syslist
				li = Array::new
				@sys.interwikis.each_system{|name, inf|
					uri = inf['uri']
					if inf['opt'] then
						opts = inf['opt'].to_a.map{|x|
							x.join('=')
						}.join('&')
						uri << '?'
						uri << opts
					end
					uri.gsub(/\$\d+/,'')
					li <<
					[
						CGI::element('a', {'href'=>uri}, name),
						inf['code']
					]
				}
				CGI::element('ul'){|recv|
					li.each{|text|
						recv << CGI::element('li'){text}
					}
				}
			end
		end
	end
end
