require 'vikiwikiplugin'

module VikiWiki
	module Plugins
		class History
			include BaseModule
			def ondesc; <<DSC; end
The system plugin can show the history of the page.
DSC
			LBL = Hash::new unless defined? LBL
			LBL['SHW_PAG'] = 'ShowPage'
			LBL['SHW_SRC'] = 'ShowSource'
			LBL['SHW_LBL'] = 'show'
			LBL['EDT_TIM'] = 'UpdateTime'
			LBL['EDT_USR'] = 'Updater'
			LBL['VER_LVL'] = 'Version'

			def safe; 5 ; end
			def onview
				res = Array::new
				res << [
					LBL['VER_LVL'],
					LBL['SHW_PAG'],
					LBL['SHW_SRC'],
					LBL['EDT_USR'],
					LBL['EDT_TIM']
				].map{|label| "''#{label}''"}
				vers = @sys.cvs.getHistory(@sys.page.path).reverse
				vers.each{|ver, user, mtime|
					pag = @sys.page.uri({'v'=>ver.to_s})
					src = @sys.page.uri({'v'=>ver.to_s, 'r'=>SourcePage})
					res << [
						ver,
						"[#{pag} #{LBL['SHW_LBL']}]",
						"[#{src} #{LBL['SHW_LBL']}]",
						user,
						mtime.tms
					]
				}
				res = res.map{|x| '||'+x.join('||')}.join("\n")
				Parser::trans_html(@sys, res, 'VikiWikiStyle')
			end
		end
	end
end
