require 'vikiwikiplugin'

module VikiWiki
	module Plugins
		class Footer
			include BaseModule
			def ondesc; <<DSC; end
The system plugin can show the footer.
{{{
#footer
}}}
DSC

			def safe; 5 ; end
			def onview
				res = Array::new
				res << %Q[<address>]
				res << %Q[Wiki Engine #{$WIKIENGINE} version #{$WIKIVERSION}<br />]
				res << %Q[Powered by <a href="http://www.ruby-lang.org/">Ruby</a> version #{RUBY_VERSION}<br />]
				if @sys['FOOTER'] then
					res << @sys['FOOTER']
				elsif @sys['ADDRESS'] then
					res << %Q[Inquiry <a href="mailto:#{@sys['ADDRESS']}">#{@sys['AUTHOR']}</a><br />]
				else
					res << %Q[#{@sys['AUTHOR']}<br />]
				end
				res << %Q[</address>]
				return res.join("\n")
			end
		end
	end
end
