require 'vikiwikiplugin'

module VikiWiki
	module Plugins
		class Farmlist
			include BaseModule
			FARMLIST_ITEM = ['name','page','alias','time','date','count']
			def ondesc; <<DSC; end
The system plugin can show the list of the WikiFarm sites.
||rows  ||Specify the number of rows. It shows all of the case of zero or less.
||grpfmt||Specify the format of the group item. It is the empty string "" when the group is not used.
||format||Specify the format of list item.
||group ||Specify the grouping item.
||order ||Specify the sorting item.
||asc   ||Specify "asc" or "desc". Default is "desc".
The following can be used for the format, or the item of grouping and sorting.

#{FARMLIST_ITEM.join(',')}
DSC
			LBL = Hash::new unless defined? LBL
			LBL['NON_FAM'] = 'WikiFarm not found'

			def safe; 3 ; end
			def onview
				rows, grpfmt, format, group, order, asc = @prms
				rows = rows.to_i
				grpfmt = grpfmt.to_s
				format = "+ time [[WikiFarm:name name - toppage]] ([mailto:address author])" if format.to_s.empty?
				group = '' unless FARMLIST_ITEM.include?(group)
				order = 'time' unless FARMLIST_ITEM.include?(order)
				asc = asc=='asc' ? +1 : -1

				arr = Array::new
				@sys.farms.each{|name, inf|
					path = [@sys.farms.path(name), @sys['RSSFILE']].path
					next unless File::exist?(path)
					ftime = File::mtime(path)
					arr << {
						'name' => name,
						'author' => inf.author,
						'address' => inf.address,
						'toppage' => inf.toppage,
						'purpose' => inf.purpose,
						'time' => ftime.tms,
						'date' => ftime.ymd,
					}
				}
				return Parser::trans_html(@sys, LBL['NON_FAM'], 'VikiWikiStyle') if arr.empty?

				arr.sort!{|a,b|
					(a[order].nil? ? -1 : b[order].nil? ? +1 : a[order] <=> b[order]) * asc
				}
				arr = arr[0,rows] if rows > 0

				has = Hash::new
				arr.each{|x|
					k = x[group]
					has[k] = Array::new unless has.key?(k)
					has[k] << x
				}

				res = Array::new
				grp = has.to_a.sort{|a,b|
					(a[0] <=> b[0]) * asc
				}.each{|k,v|
					res << grpfmt.replace_words(v[0]) unless grpfmt.empty?
					v.each{|x|
						res << format.replace_words(x)
					}
				}
				return Parser::trans_html(@sys, res.join("\n"), 'VikiWikiStyle')
			end
		end
	end
end
