require 'vikiwikiplugin'
require 'difftool'

module VikiWiki
	module Plugins
		class Edit
			include BaseModule
			def ondesc; <<DSC; end
The system plugin can edit the page.
DSC
			ERR = Hash::new unless defined? ERR
			ERR['EDT_SYS'] = 'You can not edit the system page.'
			ERR['ALR_EXT'] = 'Page already exists.'
			LBL = Hash::new unless defined? LBL
			LBL['ADD_MOD'] = 'AppendMode'
			LBL['DSC_STY'] = 'Writing style is %1.'
			LBL['PAG_NAM'] = 'PageName'
			LBL['ALS_NAM'] = 'AliasName'
			LBL['PRV_PAG'] = 'PreviewPage'
			LBL['RPL_MOD'] = 'ReplaceMode'
			LBL['SAV_PAG'] = 'SavePage'
			LBL['STA_OUT'] = 'OutputStatic'
			LBL['SAV_MTD'] = 'SaveMethod'
			LBL['SAV_AS_'] = 'SaveAs'
			LBL['ALT_NAM'] = 'AlterPageName'
			LBL['SEL_STY'] = 'SelectStyle'
			LBL['REG_PAG'] = 'RegexpPage'
			LBL['UPD_REF'] = 'UpdateReferer'

			def safe; 4 ; end
			def onpost
				return if preview_mode?
				page = @sys.page
				newname = @sys.cgi.params['edit_p'][0]
				re = @sys.cgi.params['edit_re_p'][0]
				als = @sys.cgi.params['edit_alias'][0]
				newname = nil if newname and newname.empty?
				re = nil if re and re.empty?
				als = nil if als and als.empty?
				old_re, _ = @sys.aliases.regexp(@sys.page.name)
				old_re = old_re.inspect if old_re
				begin
					@sys.aliases.delete(old_re || page.name)
					@sys.aliases[re || newname || page.name] = als if als
					@sys.aliases.update
					if page.name == newname then
						save(page)
					else
						case @sys.cgi.params['exec'][0]
						when LBL['ALT_NAM'] then
							save(page)
							altname(page, newname)
						else
							page = @sys.pages[newname] if page.name != newname
							raise ERR['ALR_EXT'] if page.exist?
							save(page)
						end
						@sys.page = page
					end
				rescue AuthorizationRequired, AccessDenied
					raise
				rescue StandardError, ScriptError
					@sys.set_error
					Log.rescue(__FILE__, __LINE__, $!.to_s, $@.to_a.join("\n")) if @sys['DEBUG']
					return
				end
				raise Location
			end
			def save(page)
				return unless @sys.cgi.params['t'][0]
				page.write(newtext, curtime, write_static?)
				@sys.links.update(page, @sys.pages.names)
				if @sys.cgi.params['edit_updref'][0] == 'on' then
					@sys.links[@sys.page.name].each do |refname|
						refpage = @sys.pages[refname]
						next unless refpage.static and refpage.static.exist?
						refpage.static.write
					end
				end
			end
			def altname(oldpage, newname)
				oldname = oldpage.name
				oldals = oldpage.alias
				links = @sys.links[oldname]
				oldpage.rename(newname)
				oldpage.update_ref(oldname, newname)
				if links then
					links.each{|name|
						@sys.pages[name].update_ref(oldname, newname)
					}
					@sys.links[newname] = links
					@sys.links.delete(oldname)
				end
			end
			def newtext
				tnew = @sys.cgi.params['t'][0]
				tnew << "\n" unless /\n\z/ === tnew
				return tnew unless add_mode?
				told = @sys.page.load
				return DiffTool::mergeText(told, tnew)
			end
			def curtime
				return nil if add_mode?
				return Time::parse(@sys.cgi.params['d'][0])
			end
			def preview_mode?; @sys.cgi.params['exec'][0] == LBL['PRV_PAG']; end
			def add_mode?; @sys.cgi.params['u'][0] == LBL['ADD_MOD']; end
			def write_static?; @sys.cgi.params['w'][0] == 'on'; end
			def onview
				cols, rows = @prms
				cols, rows = 80, 20 unless cols and rows
				cols = cols.to_i
				rows = rows.to_i
				res = Array::new
				text = nil
				sty = nil
				als = nil
				if preview_mode? then
					text = newtext
					reptext = text.replace_words(@sys['REPLACE_WORDS']) if defined?(@sys['REPLACE_WORDS'])
					als = @sys.cgi.params['edit_alias'][0]
					sty = @sys.style
					res << CGI::element('div', {'class'=>'preview'}){
						Parser::trans_html(@sys, reptext, sty)
					}
				elsif @sys.page.exist? then
					text = @sys.page.load
					sty = @sys.style
					ftms = File::mtime(@sys.page.path)
				else
					template_name = TemplatePage
					@sys.pages.names.each{|name|
						next unless /^Template([A-Za-z0-9]+)$/ === name
						next unless /^#{$1}/ === @sys.page.name
						template_name = name
					}
					template = @sys.pages[template_name]
					if template.exist? then
						text = template.load
						sty = template.style
					end
					if text.nil? or text.empty? then
						text = ''
						if @sys.cgi.params['s'][0] then
							sty = @sys.style
						else
							sty = nil
						end
					end
					ftms = Time::now
				end
				text.chomp!
				ftms = Time::parse(@sys.cgi.params['d'][0]) if @sys.cgi.params['d'][0]
				mode = @sys.cgi.params['u'][0] || LBL['RPL_MOD']
				static = @sys.page.static.exist? if @sys.page.static
				static = true if @sys['STATICWIKI']
				hids = {
					'e' => @sys.cgi.params['e'][0],
					'd' => ftms.tms
				}
				if sty then
					hids['s'] = sty
					desc_style = LBL['DSC_STY'].emb(sty)
					res << CGI::element('p', nil, desc_style)
				end
				als = @sys.aliases[@sys.page.name] unless als
				re, als = @sys.aliases.regexp(@sys.page.name) unless als
				als = @sys.cgi.params['new_alias'][0] unless als
				options = Array::new
				options << radio('u', mode, [LBL['RPL_MOD'], LBL['ADD_MOD']]) if @sys.page.exist?
				options << checkbox('w', 'on', static, LBL['STA_OUT']) if @sys.staticable?
				options << checkbox('edit_updref', 'on', false, LBL['UPD_REF']) if @sys.staticable?
				submits = Array::new
				submits << submit('exec', LBL['SAV_AS_'])
				submits << submit('exec', LBL['ALT_NAM']) if @sys.page.exist?
				submits << submit('exec', LBL['PRV_PAG'])
				res << plugin_form(hids) {|recv|
					recv << [LBL['PAG_NAM'], text('edit_p', @sys.page.name, cols/2)]
					recv << [LBL['REG_PAG'], text('edit_re_p', re.inspect, cols/2)] if re
					recv << [LBL['ALS_NAM'], text('edit_alias', als, cols/2)] if @sys.lang != 'en'
					recv << [LBL['SEL_STY'], select('s', nil, @sys['WIKISTYLES'])] unless sty
					recv << [textarea('t', text, cols, rows, {}), nil]
					recv << [options.join("\n"), nil]
					recv << [submits.join("\n"), nil]
				}
				return res
			end
		end
	end
end
