class UniqueFie
	@@tmpnum = 0
	def UniqueFie::tmpnam(base)
		dir = UniqueFie::tmpdir
		loop do
			file = "#{dir}/#{base}.#{$$}.#{Time::now.to_i}.#{@@tmpnum}".untaint
			@@tmpnum += 1
			return file unless File::exist?(file)
		end
	end
	def UniqueFie::tmpdir
		ENV['TMPDIR'] || ENV['TMP'] || ENV['TEMP'] || '/tmp'
	end
	def UniqueFie::clean(base=nil, timeout=nil)
		Dir::glob("#{UniqueFie::tmpdir}/#{base}*".untaint) do |file|
			next unless /\/#{base}\.(\d+).(\d+)$/ === file
			dtime = Time::now - Time::at($2.to_i)
			File::unlink(file.untaint) if timeout.nil? or dtime > timeout
		end
	end
end
