require 'wiki/wikistyle'

module Wiki
	class VikiWikiStyle < WikiStyle
		#*******************************************************************
		# Format Rule
		#*******************************************************************
		#-------------------------------------------------------------------
		# Block
		#-------------------------------------------------------------------

		# <pre>
		FM_PRE_S         = '{{{'
		FM_PRE_E         = '}}}'
		RE_PRE_S         = /^\{{3}$/
		RE_PRE_E         = /^\}{3}$/

		# <h1> to <h6>
		FM_H1            = nil
		FM_H2            = '!%s'
		FM_H3            = '!!%s'
		FM_H4            = '!!!%s'
		FM_H5            = '!!!!%s'
		FM_H6            = '!!!!!%s'
		RE_H1            = nil
		RE_H2            = /^!{1}([^!].*)$/
		RE_H3            = /^!{2}([^!].*)$/
		RE_H4            = /^!{3}([^!].*)$/
		RE_H5            = /^!{4}([^!].*)$/
		RE_H6            = /^!{5}([^!].*)$/

		# <hr />
		FM_HR            = '----'
		RE_HR            = /^----+$/

		# <div class="">
		FM_DIV_S         = '<<<%s'
		FM_DIV_E         = '>>>'
		RE_DIV_S         = /^<<<([A-Za-z]\w*)?$/
		RE_DIV_E         = /^>>>$/

		# <ul>
		FM_UL            = '*%s'
		RE_UL            = /^[\*-](.*)$/

		# <ol>
		FM_OL            = '+%s'
		RE_OL            = /^(?:\+|\d\.\s)(.*)$/

		# <dl>
		FM_DL            = ':%s:%s'
		RE_DL            = /^:([^:]+):(.*)$/
		FM_DL2           = '::%s::%s'
		RE_DL2           = /^::(.+)::(.*)$/

		# <blockquote>
		FM_BLOCKQUOTE    = '>%s'
		RE_BLOCKQUOTE    = /^>(.+)$/

		# <table border="1">
		TX_TABLE         = '||'
		RE_TABLE         = /^\|\|(.+)$/

		# <table>
		TX_TABLE_N       = '|'
		RE_TABLE_N       = /^\|([^\|].*)$/

		# <td>
		FM_TD_LEFT       = '%s '
		FM_TD_CENTER     = ' %s '
		FM_TD_RIGHT      = ' %s'
		RE_TD_LEFT       = /^(.+)\s$/
		RE_TD_CENTER     = /^\s(.+)\s$/
		RE_TD_RIGHT      = /^\s(.+)$/

		# <!-- -->
		FM_COMMENT       = '//%s'
		RE_COMMENT       = /^\/\/(.+)$/

		#-------------------------------------------------------------------
		# Inline
		#-------------------------------------------------------------------

		# WikiName
		FM_WIKINAME      = '%s'
		RE_WIKINAME      = /^(#{TX_WRIT})/

		# BracketName
		FM_BRACKETNAME   = '[[%s]]'
		RE_BRACKETNAME   = /^\[\[(#{TX_WRIX})\]\]/

		# AliasName
		FM_ALIASNAME     = '[[%s %s]]'
		RE_ALIASNAME     = /^\[\[(#{TX_WRIX})\s+(#{TX_NOPARE_L})\]\]/

		# <em>
		FM_EM            = "'''%s'''"
		RE_EM            = /^\'{3}(#{TX_NOQUOTE})\'{3}/

		# <strong>
		FM_STRONG        = "''%s''"
		RE_STRONG        = /^\'{2}(#{TX_NOQUOTE})\'{2}/

		# <del>
		FM_DEL           = '==%s=='
		RE_DEL           = /^={2}([^=]+)={2}/

		# <a>
		FM_A             = '[%s %s]'
		RE_A             = /^\[(#{TX_NOBLANK})\s+(#{TX_NOPARE_L})\]/

		# URL
		FM_URL           = '%s'
		RE_URL           = /^(#{TX_URL})/

		# escape
		FM_ESCAPE        = '{{%s}}'
		RE_ESCAPE        = /^\{{2}(#{TX_NOPARE_M})\}{2}/

		# <img>
		FM_IMG           = '[%s %s]'
		RE_IMG           = /^\[(#{TX_NOBLANK}#{TX_IMGEXT})\s+(#{TX_NOPARE_L})\]/

		#-------------------------------------------------------------------
		# Plugin
		#-------------------------------------------------------------------

		# plugin
		FM_PLUGIN        = '#%s%s%s'
		RE_PLUGIN        = /^\#\s*(#{TX_IDENT})(?:\#(\S+))?(?:\s+(.+))?$/

		# plugin (inline)
		FM_INPLUGIN      = '#{%s%s%s}'
		RE_INPLUGIN      = /^\#\{(#{TX_IDENT})(?:\#(\S+))?(?:\s+(#{TX_NOPARE_M}))?\}/

		# plugin parameters
		FM_PLUGIN_PRM    = " %s"
		RE_PLUGIN_PRM    = /^(?:"(?:[^\\]*\\.)*(?:[^"]*)"|'(?:[^\\]*\\.)*(?:[^']*)')/
		FM_PLUGIN_HDC    = "<<%s"
		RE_PLUGIN_HDC    = /^<<(#{TX_IDENT})/
		FM_PLUGIN_SEP    = " "
		RE_PLUGIN_SEP    = /\s+/

		#*******************************************************************
		# Definitions
		#*******************************************************************
		BLOCK_PARSING_ORDER = [
			'plugin','div','pre','blockquote','comment',
			'h6','h5','h4','h3','h2',
			'hr','ul','ol','dl2','dl','table','table_n','p'
		]
		INLINE_PARSING_ORDER = [
			'wikiname','url','inplugin','em','strong','del',
			'escape','aliasname','bracketname','img','a'
		]
		ELEMENT_GENERATING_TAGS = [
			'wikiname', 'plugin', 'escape', 'del', 'strong',
			'em', 'img', 'a',
			'pre', 'h2', 'h3', 'h4', 'h5', 'h6', 'hr',
			'div', 'li', 'dl', 'blockquote',
			'table', 'tr', 'p'
		]
		INDENT_STYLE = true
		ALIAS_FORWARD = false
	end
end
