require 'vikiwikisys'

module VikiWiki
	class Web
		DEFAULT_LAYOUTPAGE = <<EOS
#import SelfPage
#edit
EOS
		def initialize(sys)
			@sys = sys
			begin
				header, body = nil, nil
				begin
					@sys.setup
					@sys.plugin_onpost
					@sys.counter.update(@sys.page.name)

					body = @sys.getHTTPbody

				rescue AuthorizationRequired
					@sys.print @sys.authorization_required
					return

				rescue AccessDenied
					@sys.print @sys.access_denied
					return

				rescue Location
					if /^(?:https?\:\/\/|\/)/ === $!.to_s then
						uri = $!.to_s
					elsif @sys['STATICWIKI'] and @sys.page.static and @sys.page.static.exist? then
						uri = @sys.page.static.uri
					else
						uri = @sys.page.uri
					end
					@sys.print @sys.location(uri, true)
					return

				rescue StandardError, ScriptError
					@sys.set_error($!, $@) if @sys.setuped?
					Log.rescue(__FILE__, __LINE__, $!.to_s, $@.to_a.join("\n")) if @sys['DEBUG']
					raise unless @sys.setuped?
					body = @sys.getHTTPbody unless body
				end

				@sys.print @sys.getHTTPheader
				@sys.print body

			rescue Exception
				Log.rescue(__FILE__, __LINE__, $!.to_s, $@.to_a.join("\n")) if @sys['DEBUG']
				@sys.print <<EOS
Content-Type: text/html

<html>
<head><title>Internal Error</title></head>
<body>
<h1>Internal Error</h1>
<p>#{CGI::escapeHTML($!.to_s)}</p>
<!--
#{CGI::escapeHTML($@.to_a.join("\n")) if @sys['DEBUG']}
-->
</body>
</html>
EOS
			end
		end
	end
end
