require 'vikiwikiplugin'

module VikiWiki
	module Plugins
		class Plugin
			include BaseModule
			def ondesc; <<DSC; end
The system plugin can show the describes of each plugin.
Specify the plugin name when the specific plugins are necessary.
More than one can be specified by blank pause.
{{{
#plugin
#plugin pi1 pi2 ...
}}}
DSC

			PLUGINWC = "#{PLUGINNAM}/*.rb"
			def safe; 5 ; end
			def onview
				plugins = @prms
				if plugins.empty? then
					[@sys.basedir, $VIKIWIKIDIR+'/'].each{|dir|
						cur = Array::new
						Dir::glob(dir+PLUGINWC){|f|
							next if f.nil? or f.blank?
							cur << File::basename(f, ".rb")
						}
						plugins << cur.sort!
					}
				end
				res = Array::new
				plugins.flatten.uniq.compact.each{|name|
					res << CGI::element('h2', nil, name)
					begin
						desc = @sys.plugin.ondesc(name)
						res << Parser::trans_html(@sys, desc, 'VikiWikiStyle')
					rescue StandardError, ScriptError
						Log.rescue(__FILE__, __LINE__, $!.to_s, $@.to_a.join("\n")) if @sys['DEBUG']
						res << @sys.error_onview($!, $@)
					end
				}
				return res
			end
		end
	end
end
