require 'vikiwikiplugin'

module VikiWiki
	module Plugins
		class Navi
			include BaseModule
			def ondesc; <<DSC; end
The plugin can show the navigation.
{{{
#navi
}}}
DSC

			def safe; 5 ; end

			def onview
				pagename = @sys.page.name.split("/")
				reps = Array::new
				pagenum = 0
				for page in pagename
					if pagenum >= 1
						page = "/" + page
						reps << reps.slice(pagenum-1) + page
					else
						reps << page
					end
					pagenum += 1
				end

				res = Array::new
				work = 1
				res << "[[#{@sys['TOPPAGE']} " + @sys.aliases.get(@sys['TOPPAGE']) + "]] >"
				for page in reps
					if work == pagenum
						res << "[[" + page + " " + @sys.aliases.get(page) + "]]"
					else
						res << "[[" + page + " " + @sys.aliases.get(page) + "]] >"
					end
					work += 1
				end
				Parser::trans_html(@sys, res.join("\n"), 'VikiWikiStyle') if @sys['TOPPAGE'] != @sys.page.name
			end
		end
	end
end
