require 'vikiwikiplugin'
require 'vikiwikiattach'

module VikiWiki
	module Plugins
		class Img
			include BaseModule
			def ondesc; <<DSC; end
The system plugin can upload the image file.
{{{
#img form
#img link [pattern]
#img view [pattern] [width] [height]
}}}
The following is the method to embed an image file.
If the file exists, img tag is generated.
If not, the form to upload a file is displayed.
{{{
#img file alt width height
#\{img file alt width height\}
}}}
DSC
			LBL = Hash::new unless defined? LBL
			LBL['CUR_DIR'] = 'CurrentDirectory'
			LBL['DEL_DIR'] = 'RemoveDirectory'
			LBL['DEL_IMG'] = 'DeleteImage'
			LBL['MAK_DIR'] = 'MakeDirectory'
			LBL['REG_IMG'] = 'RegistImage'
			LBL['SUB_DIR'] = 'SubDirectories'
			LBL['FIL_NAM'] = 'FileName'
			LBL['PAR_DIR'] = '[ParentDirectory]'

			def safe; 3 ; end
			def getimgs
				parent = @sys.cgi.params['img_parent'][0]
				parent = nil if parent and parent.empty?
				subdir = @sys.cgi.params['img_subdir'][0]
				subdir = nil if subdir and subdir.empty?
				return Image::new([parent, subdir].path, @sys['IMGDIR'], @sys['IMGURI'], true)
			end
			def onpost
				imgs = getimgs
				case @sys.cgi.params['img_mode'][0]
				when 'add' then
					imgs.put(@sys.cgi.params['img_file'][0], @sys.cgi.params['img_name'][0])
				when 'del' then
					imgs[@sys.cgi.params['img_file'][0]].drop
				when 'mkdir' then
					imgs.create
					return
				when 'rmdir' then
					imgs.drop
					@sys.cgi.params['img_subdir'][0] = nil
				end
				@sys.static_update if @sys.cgi.params['img_parent'][0].to_s.empty?
			end
			def onview
				imgs = getimgs
				case @prms[0]
				when RE_IMG_EXT then
					img = Image::new(@prms[0], @sys['IMGDIR'], @sys['IMGURI'], false)
					if img.exist? then
						attr = Hash::new
						attr['src'] = img.uri
						attr['alt'] = @prms[1] if @prms[1]
						attr['width'] = @prms[2] if @prms[2]
						attr['height'] = @prms[3] if @prms[3]
						return CGI::element('img', attr)
					else
						return addform(@prms[0])
					end
				when 'view' then
					return imgview(imgs)
				when 'link' then
					return imglink(imgs)
				else
					return imgform(imgs)
				end
			end
			def imgview(imgs)
				pattern = @prms[1]
				width = @prms[2].to_i
				height = @prms[3].to_i
				attr = Hash::new
				attr['width'] = width if width > 0
				attr['height'] = height if width > 0
				res = Array::new
				imgs.each_file(pattern){|img|
					res << [img.link, img.view(attr)]
				}
				to_table(res)
			end
			def imglink(imgs)
				pattern = @prms[1]
				CGI::element('ul'){|recv|
					imgs.each_file(pattern){|img|
						recv << CGI::element('li'){img.link}
					}
				}
			end
			def imgform(imgs)
				res = Array::new
				res << CGI::element('h2', nil, LBL['CUR_DIR'])
				res << imgs.object_path
				res << CGI::element('h2', nil, LBL['SUB_DIR'])
				res << dirlist(imgs)
				res << CGI::element('h2', nil, LBL['MAK_DIR'])
				res << adddirform(imgs)
				res << CGI::element('h2', nil, LBL['DEL_DIR'])
				res << deldirform(imgs)
				res << CGI::element('h2', nil, LBL['REG_IMG'])
				res << addform(imgs)
				res << CGI::element('h2', nil, LBL['DEL_IMG'])
				res << delform(imgs)
				return res
			end
			def dirlist(imgs)
				res = Array::new
				if imgs.parent then
					res << CGI::element('a',
						{'href'=>uri4get({'img_subdir'=>imgs.parent})},
						LBL['PAR_DIR'])
				end
				imgs.each_dir{|img|
					res << CGI::element('a',
						{'href'=>uri4get({'img_subdir'=>img.object_path})},
						img.name)
				}
				return res.join("\n")
			end
			def adddirform(imgs)
				plugin_form({'img_parent'=>imgs.object_path, 'img_mode'=>'mkdir'}, {}, false) {|recv|
					recv << LBL['DIR_NAM']
					recv << text('img_subdir')
					recv << submit('exec', LBL['MAK_DIR'])
				}
			end
			def deldirform(imgs)
				subdir = Array::new
				imgs.each_dir{|img|
					subdir << img.name
				}
				unless subdir.empty? then
					plugin_form({'img_parent'=>imgs.object_path, 'img_mode'=>'rmdir'}, {}, false) {|recv|
						recv << select('img_subdir', nil, subdir)
				 		recv << submit('exec', LBL['DEL_DIR'])
					}
				end
			end
			def addform(imgs)
				if Image === imgs then
					label = LBL['FIL_NAM']
					attr = {'img_subdir'=>imgs.object_path}
				else
					label = LBL['FIL_NAM']+'('+imgs+')'
					subdir, name = File::split(imgs)
					attr = {
						'img_subdir' => subdir,
						'img_name' => name,
					}
				end
				attr['img_mode'] = 'add'
				multipart_plugin_form(attr, {}, false) {|recv|
					recv << CGI::escapeHTML(label)
					recv << file('img_file')
					recv << submit('exec', LBL['REG_IMG'])
				}
			end
			def delform(imgs)
				files = Array::new
				imgs.each_file {|img|
					files << [
						radio('img_file', img.name),
						img.link
					]
				}
				unless files.empty? then
					plugin_form({'img_subdir'=>imgs.object_path, 'img_mode'=>'del'}) {|recv|
						recv += files.sort
						recv << [submit('exec', LBL['DEL_IMG']), nil]
					}
				end
			end
		end
	end
end
