require 'vikiwikiplugin'

module VikiWiki
	module Plugins
		class Diary
			include BaseModule
			def ondesc; <<DSC; end
The plugin shows the diary.
DSC
			def safe; 5 ; end
			def onview
				return nil unless @sys['TDIARY_CONF']
				unless defined?(TDiary) then
					$: << File::dirname(@sys['TDIARY_CONF'])
					require 'extension/tdiary'
				end
				pwd = Dir::pwd.untaint
				kcode = $KCODE
				$KCODE = @sys['TDIARY_CODE'] || 'e'
				begin
					Dir::chdir(File::dirname(@sys['TDIARY_CONF']).untaint)
					cgi = CGI::new
					conf = ::TDiary::Config::new
					tdiary = ::TDiary::TDiaryUnit::new( cgi, 'unit.rhtml', conf )
					body = tdiary.eval_rhtml_body
					cnv = USEconv::cnvmethod($KCODE, kcode)
					body = cnv.call(body) if cnv
					@body = body
				ensure
					Dir::chdir(pwd)
					$KCODE = kcode
				end
			end
		end
	end
end
