require 'vikiwikiplugin'

module VikiWiki
	module Plugins
		class Copy
			include BaseModule
			def ondesc; <<DSC; end
The plugin can copy the block in the page.
The class is the class name of div block (<<<class).
The div block of any page is copied when page is specified.
{{{
#copy class [page]
}}}
The plugin shows the lines matched with the regular expression.
{{{
#copy regexp [page]
}}}
The buttons to expand the blocks are shown when the id is 'expand'.
{{{
#copy#expand
}}}
DSC
			LBL = Hash::new unless defined? LBL
			LBL['CPY_EXP'] = "Expand"
			MSG = Hash::new unless defined? MSG
			MSG['INV_CLS'] = "Class not specified."
			MSG['NON_PAG'] = "The page [[%1]] not found."

			def safe; 4 ; end
			def onpost
				if @sys.cgi.params['copy_expand'][0] then
					res = Parser::new(@sys).to_text(loaddiv, @sys.page.style)
					insert(UPDATE){
						res.sub(/\n+\z/,'').chomp+"\n"
					}
				end
			end
			def onview
				@expands = Hash::new unless @expands
				if @id == 'expand' then
					res = @expands.values.sort.join("\n")
					@expands.clear
					return res
				end
				label = LBL['CPY_EXP']+' '+@plain
				@expands[label] = plugin_form{submit('copy_expand', label)}
				cls = @prms[0].to_s.to_any
				pages = @prms[1].to_s.split(/[,\s\n]/)
				fmt = @prms[2].to_s
				raise MSG['INV_CLS'] unless cls
				if pages.empty? then
					pages = [@sys.page]
				else
					pages = @sys.pages.glob(pages)
				end
				if Regexp === cls then
					root = Array::new
					pages.each{|page|
						page = @sys.pages[page] if String === page
						lines = page.load.to_a.select{|line|
							cls === line
						}
						unless lines.empty? then
							root << fmt.gsub('page', page.name)+"\n" if fmt
							root << lines
						end
					}
					return Parser::trans_html(@sys, root.join("\n"), @sys.page.style)
				else
					res = Array::new
					pages.each{|page|
						page = @sys.pages[page] if String === page
						page.node.each_node('div'){|div|
							next unless cls === div.getAttribute('class')
							res << Parser::new(@sys).to_html(div)
						}
					}
					return res
				end
			end
		end
	end
end
