require 'vikiwikiplugin'

module VikiWiki
	module Plugins
		class Altstyle
			include BaseModule
			def ondesc; <<DSC; end
The system plugin can alter the style.
DSC
			LBL = Hash::new unless defined? LBL
			LBL['ALT_STY'] = "AlterStyle"
			LBL['PAG_STY'] = "This page is written by <strong>%1</strong>."

			def safe; 3 ; end
			def onpost
				newstyle = @sys.cgi.params['altstyle_new'][0]
				@sys.page.altstyle(newstyle)
				raise Location
			end
			def onview
				return '' unless @sys.page.exist?
				style = @sys.page.style
				styles = @sys['WIKISTYLES']
				plugin_form {
					CGI::element('p'){|recv|
						recv << LBL['PAG_STY'].emb(style)
						recv << select('altstyle_new', style, styles)
						recv << submit('exec', LBL['ALT_STY'])
					}
				}
			end
		end
	end
end
