class Time
	# easy formater
	def ymd; strftime("%Y-%m-%d"); end	# YYYY-MM-DD
	def tms; strftime("%Y-%m-%d %H:%M:%S"); end	# YYYY-MM-DD HH:MM:SS
	def md; "%d/%d" % [mon, mday]; end	# M/D
	def upto(to, step=1, level='day')
		cnt = self
		to = self.add(to, level) if Numeric === to
		while cnt <= to do
			yield cnt
			cnt = cnt.add(step, level)
		end
	end
	def add(cnt, level='day')
		case level
		when 'sec' then
			self + cnt
		when 'min' then
			self + cnt * 60
		when 'hour' then
			self + cnt * 360
		when 'day' then
			self + cnt * 24*60*60
		when 'mon' then
			y, m = self.year, self.mon+cnt
			y, m = y+1, m-12 while m > 12
			y, m = y-1, m+12 while m < 1
			Time::local(y, m)
		when 'year' then
			Time::local(self.year+1)
		end
	end
	begin
		require 'time'
	rescue LoadError
		def Time::parse(date, now=Time::now)
			Time::local(*date.scan(/\d+/))
		end
		def xmlschema
			ltime = self.dup.localtime
			gtime = self.dup.utc
			date = ltime.strftime('%Y-%m-%dT%H:%M:%S')
			date << (ltime < gtime ? Time::at(gtime-ltime).strftime('-%H:%M') : Time::at(ltime-gtime).strftime('+%H:%M'))
			return date
		end
	end
end
