require 'ftools'

class File
	# cp -p
	def File::copyp(from, to)
		File::writable(to) if File::exist?(to)
		text = File::readall(from)
		File::open(to, "wb"){|f|
			f.write(text)
		}
		stat = File.stat(from)
		File::utime(stat.atime, stat.mtime, to)
		File::chmod(stat.mode, to)
	end
	# touch
	def File::touch(file)
		File::open(file,"w").close unless FileTest::exist?(file)
	end
	# chmod a+w
	def File::writable(file)
		File::chmod(File::stat(file).mode|0222, file)
	end
	# chmod a-w
	def File::readonly(file)
		File::chmod(File::stat(file).mode&0555, file)
	end
	# chmod a+x
	def File::executable(file)
		File::chmod(File::stat(file).mode|0111, file)
	end
	def File::find(files)
		files.each{|file|
			Dir::glob(file){|f|
				return f.untaint
			}
		}
		return nil
	end
	def File::readall(path, mode="rb")
		File::open(path, mode){|f| return f.read}
	end
	def File::fwrite(file, text, bak='.bak', clear=true)
		dir = File::dirname(file)
		File::mkpath(dir)
		bakfile = file+bak
		File::open(bakfile, "w"){|f|
			if text.class == String then
				f.write(text)
			elsif text.class == Array then
				text.each{|line| f.write(line)}
			else
				raise "invalid class"
			end
		}
		File::copyp(bakfile, file)
		File::unlink(bakfile) if clear
	end
	def File::fullpath?(path)
		return true if /^\// === path
		# Windows
		return true if /^[A-Za-z]\:\// === path
		# URI
		return true if /^(?:http|https|ftp|mailto|file)\:/ === path
		return false
	end
	def File::normalize(path)
		prefix, path = $1, $2 if /^((?:[A-Za-z]+\:\/*)?)\/(.+)$/ === path
		dir, file = File::split(path)
		resdir = Array::new
		dir.split('/').each do |d|
			case d
			when '.' then
			when '..' then
				if resdir.empty? or resdir.last == '..' then
					resdir << d
				else
					resdir.pop
				end
			else
				resdir << d
			end
		end
		resdir.unshift(prefix) if prefix
		resdir << file
		resdir = resdir.join('/')
		resdir = '' if resdir == '.'
		return resdir
	end
	def File::relative(path, basedir='.')
		return '' if path.nil? or path.empty?
		return path if /^\#/ === path
		basedir = File::normalize(basedir)
		checkfull_path = File::fullpath?(path)
		checkfull_base = File::fullpath?(basedir)
		return path if checkfull_path and not checkfull_base
		return "#{basedir}/#{path}" if not checkfull_path and checkfull_base
		tdir, tfile = File::split(path)
		tdir = File::normalize(tdir)
		return tfile if tdir == basedir
		fdirs = basedir.split('/')
		tdirs = tdir.split('/')
		return path if checkfull_path and checkfull_base and fdirs[1] != tdirs[1]
		0.upto([fdirs.size, tdirs.size].min) do
			break if fdirs.first != tdirs.first
			fdirs.shift
			tdirs.shift
		end
		path = '../' * fdirs.size
		path << tdirs.join('/')+'/' unless tdirs.empty?
		path << tfile
		return path
	end
	def File::rm_rf(*files)
		files = files.map{|file| Dir::glob(file.untaint)}.flatten
		files.each do |file|
			file.untaint
			if /^\.+$/ === file then
				next
			elsif File::directory?(file) then
				Dir::foreach(file) do |ent|
					next if /^\.+$/ === ent
					File::rm_rf("#{file}/#{ent}")
				end
				Dir::unlink(file)
			else
				File::writable(file)
				File::unlink(file)
			end
		end
	end
end

class Dir
	# cp -r
	def Dir::copy(from, to, subdir=true)
		raise "No such file or directory." unless FileTest::exist?(from)
		File::mkpath(to)
		Dir::foreach(from){|f|
			next if /^\.+$/ === f
			t = (to+'/'+f).untaint
			f = (from+'/'+f).untaint
			if FileTest::directory?(f) then
				Dir::copy(f, t) if subdir
			else
				File::copyp(f, t)
			end
		}
	end
	# copy and convert
	def Dir::copycnv(cnv, fpath, tpath=nil)
		if FileTest::directory?(fpath) then
			File::mkpath(tpath) if tpath
			Dir::open(fpath){|d|
				d.each{|n|
					next if n.nil? or n.empty? or /^\.+$/ === n
					fp = fpath+'/'+n
					tp = tpath+'/'+n if tpath
					Dir::copycnv(cnv, fp, tp)
				}
			}
		else
			tpath = fpath unless tpath
			text = File::readall(fpath)
			return if text.include?(0)
			text = cnv.call(text) if cnv
			File::writable(tpath) if FileTest::exist?(tpath)
			File::open(tpath, "wb"){|f| f.write(text)}
		end
	end
end

class Array
	def path
		map{|elm|
			Array === elm ? elm.file : elm
		}.fjoin('/')
	end
	def file; fjoin('.'); end
	def fjoin(chr)
		arr = self.dup.delete_if{|elm| elm.nil? or elm.empty?}
		arr.map!{|elm| elm.sub(/\/$/, '')}
		arr.join(chr).untaint
	end
end
