require 'cgi'

module CGIForm
	def outputField(name, attr=nil, text=nil)
		if iterator? then
			text = yield
			text = text.join("\n") if Array === text
		elsif text then
			text = CGI::escapeHTML(text.to_s)
		end
		res = "<#{name}"
		if attr then
			attr.sort.each do |var, val|
				res << %Q[ #{var}="#{CGI::escapeHTML(val.to_s)}"]
			end
		end
		if text then
			res << ">"
			res << "\n" if text.include?("\n")
			res << text.chomp
			res << "\n" if text.include?("\n")
			res << "</#{name}>"
		else
			res << " />"
		end
		return res
	end
	def form(hiddens, attr, tableview=true)
		recv = Array::new
		body = yield recv
		body = recv unless recv.empty?
		body = to_table(body) if Array === body and tableview
		body << "\n" if String === body
		hidden_fileds = Array::new
		hiddens.each do |name, value|
			hidden_fileds << hidden(name, value) if value and String === value
		end
		body << outputField('div') do
			hidden_fileds.join("\n")
		end
		outputField('form', attr) do
			CGI::element('div', {'class'=>'form'}){body}
		end
	end
	def to_table(table, cls=nil, th=nil)
		return table.include?('<') ? table : CGI::escapeHTML(table) unless Array === table
		attr = {'summary'=>'table view form'}
		attr['class'] = cls if cls
		outputField('table', attr) do
			r = 0
			table.map do |tr|
				r += 1
				t = 'th' if th == 'top' and r == 1
				outputField('tr') do
					tr = [tr] if tr.class != Array
					tds = Array::new
					tr.each do |td|
						if td or tds.last.nil? then
							tds << [td, 1]
						else
							tds.last[1] += 1
						end
					end
					c = 0
					tds.map do |td, colspan|
						c += 1
						t = 'th' if th == 'side' and c == 1
						t = 'td' unless t
						has = colspan == 1 ? {} : {'colspan'=>colspan}
						outputField(t, has) do
							to_table(td)
						end
					end
				end
			end
		end
	end
	def hidden(name, value)
		outputField('input',
			{'type'=>'hidden', 'name'=>name, 'value'=>value})
	end
	def text(name, value='', size=20)
		outputField('input',
			{'type'=>'text', 'name'=>name, 'value'=>value,
			 'size'=>size, 'class'=>'text'})
	end
	def file(name, value='', size=40)
		outputField('input',
			{'type'=>'file', 'name'=>name, 'value'=>value,
			 'size'=>size, 'class'=>'file'})
	end
	def submit(name='submit', value='OK')
		outputField('input',
			{'type'=>'submit', 'name'=>name, 'value'=>value,
			 'class'=>'submit'})
	end
	def textarea(name, value='', cols=20, rows=5, attr={})
		wattr = {'name'=>name, 'cols'=>cols, 'rows'=>rows}
		outputField('textarea', wattr.update(attr), value.to_s)
	end
	def select(name, value=nil, options=['true','false'], size=1, multiple=false)
		value = boolvalue(value)
		attr = {'name'=>name, 'size'=>size}
		attr['multiple'] = 'multiple' if multiple
		outputField('select', attr) do
			options.map do |oval|
				if oval.class == Array and oval[1].class == Array then
					outputField('optgroup', {'label'=>oval[0]}) do
						oval[1].map do |ov|
							option(ov, value)
						end
					end
				else
					option(oval, value)
				end
			end
		end
	end
	def option(oval, value=nil)
		otext = oval
		oval, otext = oval[0], oval[1] if oval.class == Array
		attr = {'value'=>oval}
		attr['selected'] = 'selected' if
			value.class == String and value == oval or
			value.class == Array and value.include?(oval)
		outputField('option', attr, otext.to_s)
	end
	def radio(name, value, values=nil, text=nil, escaped=false)
		if Array === values then
			values.map do |oval|
				otext = oval
				oval, otext = oval[0], oval[1] if oval.class == Array
				attr = {'name'=>name, 'type'=>'radio', 'value'=>oval, 'class'=>'radio'}
				attr['checked'] = 'checked' if value and value == oval
				field = outputField('input', attr)
				field += escaped ? otext : CGI::escapeHTML(otext) if otext
				outputField('label'){field}
			end
		else
			attr = {'name'=>name, 'type'=>'radio', 'value'=>value}
			attr['checked'] = 'checked' if values == true
			field = outputField('input', attr)
			field += escaped ? text : CGI::escapeHTML(text) if text
			outputField('label'){field}
		end
	end
	def password(name, size=20)
		outputField('input', {'type'=>'password', 'name'=>name, 'size'=>size, 'class'=>'password'})
	end
	def checkbox(name, value='on', checked=false, text='', escaped=false)
		attr = {'type'=>'checkbox', 'name'=>name, 'class'=>'checkbox'}
		attr['value'] = value if value
		attr['checked'] = 'checked' if checked
		field = outputField('input', attr)
		field += escaped ? text : CGI::escapeHTML(text) if text
		outputField('label'){field}
	end
	def reset(name, value)
		outputField('input', {'type'=>'reset', 'name'=>name, 'value'=>value, 'class'=>'reset'})
	end
	def button(name, value, attr)
		attr.update({'type'=>'button', 'name'=>name, 'value'=>value, 'class'=>'button'})
		outputField('input', attr)
	end
	def image(name, src)
		outputField('input', {'type'=>'image', 'name'=>name, 'src'=>src, 'class'=>'image'})
	end
	def boolvalue(val)
		return 'true' if val == true
		return 'false' if val == false
		return true if val == 'true'
		return false if val == 'false'
		return val
	end
end
