=begin

	The lf.rb is a script to convert CR/LF into LF.

	% ruby tool/lf.rb file1 file2 ...
	% ruby tool/lf.rb wild-card

=end

ARGV.each do |file|
	begin
		next if File::directory?(file)
		str = nil
		File::open(file, "rb") do |fin|
			str = fin.read
		end
		next if str.include?("\0")
		next unless str.include?("\r")
		str.gsub!("\r", "")
		tms = File::mtime(file)
		puts file
		File::open(file, "wb") do |fout|
			fout.write(str)
		end
		File::utime(tms, tms, file)
	rescue Exception
		puts $!
	end
end
